/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.Interfaces.FocusAcceleratable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityFocusCrystal
extends TileEntityChromaticBase
implements NBTTile,
BreakAction {
    private static ColorBlendList turboBlend;
    private FocusConnection connection;
    private CrystalTier tier = CrystalTier.FLAWED;

    public static float getSummedFocusFactorDirect(FocusAcceleratable f, Collection<Coordinate> locations) {
        TileEntity te = (TileEntity)f;
        return TileEntityFocusCrystal.getSummedFocusFactorDirect(f, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, locations);
    }

    public static float getSummedFocusFactor(FocusAcceleratable f, Collection<FocusLocation> locations) {
        TileEntity te = (TileEntity)f;
        return TileEntityFocusCrystal.getSummedFocusFactor(f, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, locations);
    }

    public static float getSummedFocusFactorDirect(FocusAcceleratable acc, World world, int x, int y, int z, Collection<Coordinate> locations) {
        float sum = 1.0f;
        for (Coordinate c : locations) {
            c = c.offset(x, y, z);
            if (ChromaTiles.getTile((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) != ChromaTiles.FOCUSCRYSTAL) continue;
            TileEntityFocusCrystal te = (TileEntityFocusCrystal)c.getTileEntity((IBlockAccess)world);
            sum += te.getTier().efficiencyFactor;
            te.addConnection(acc, true);
        }
        return sum;
    }

    public static float getSummedFocusFactor(FocusAcceleratable acc, World world, int x, int y, int z, Collection<FocusLocation> locations) {
        float sum = 1.0f;
        for (FocusLocation f : locations) {
            Coordinate c = f.relativeLocation().offset(x, y, z);
            if (ChromaTiles.getTile((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) != ChromaTiles.FOCUSCRYSTAL) continue;
            TileEntityFocusCrystal te = (TileEntityFocusCrystal)c.getTileEntity((IBlockAccess)world);
            sum += te.getTier().efficiencyFactor;
            te.addConnection(acc, true);
        }
        return sum;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FOCUSCRYSTAL;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        if (world.func_147439_a(x, y - 1, z) == ChromaBlocks.PYLONSTRUCT.getBlockInstance()) {
            BlockPylonStructure.triggerAddCheck(world, x, y - 1, z);
        }
    }

    public void addConnection(FocusAcceleratable src, boolean sync) {
        this.connection = new FocusConnection(new SimpleFocusLocation(src, this), (TileEntity)src);
        if (sync) {
            this.syncAllData(true);
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.getTier().isMaxPower() && world.field_72995_K) {
            this.doParticles(world, x, y, z);
        }
        if (this.connection != null && this.getTicksExisted() % 8 == 0 && !(this.getConnection().target.getTileEntity((IBlockAccess)world) instanceof FocusAcceleratable)) {
            this.connection = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        if (rand.nextInt(2 + Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            double hr = 0.825;
            double vr = 0.375;
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)(hr / 2.0));
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)(hr / 2.0));
            double py = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.375), (double)(vr / 2.0));
            int l = 6 + rand.nextInt(6);
            int c = this.getTier().getRenderColor((float)this.getTicksExisted() + ReikaRenderHelper.getPartialTickTime() + (float)System.identityHashCode(this));
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.FLARE).setLife(l).setColor(c);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public CrystalTier getTier() {
        return this.tier;
    }

    public FocusConnection getConnection() {
        return this.connection;
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
        NBT.func_74768_a("tier", this.tier.ordinal());
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
        this.tier = is != null && is.field_77990_d != null ? CrystalTier.tierList[is.field_77990_d.func_74762_e("tier")] : CrystalTier.FLAWED;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("tier", this.getTier().ordinal());
        if (this.connection != null) {
            this.connection.target.writeToNBT("connection", NBT);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        Coordinate c;
        TileEntity te;
        super.func_145839_a(NBT);
        this.tier = CrystalTier.tierList[NBT.func_74762_e("tier")];
        if (NBT.func_74764_b("connection") && this.field_145850_b != null && (te = (c = Coordinate.readFromNBT((String)"connection", (NBTTagCompound)NBT)).getTileEntity((IBlockAccess)this.field_145850_b)) instanceof FocusAcceleratable) {
            this.addConnection((FocusAcceleratable)te, false);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(4.0, 2.0, 4.0);
    }

    public void breakBlock() {
        TileEntity tgt;
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == ChromaBlocks.PYLONSTRUCT.getBlockInstance()) {
            BlockPylonStructure.triggerAddCheck(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        }
        if (this.connection != null && (tgt = this.connection.target.getTileEntity((IBlockAccess)this.field_145850_b)) instanceof FocusAcceleratable) {
            ((FocusAcceleratable)tgt).recountFocusCrystals();
        }
    }

    static {
        int i;
        turboBlend = new ColorBlendList(70.0f);
        int n = 3;
        for (i = 0; i < n; ++i) {
            turboBlend.addColor(CrystalTier.EXQUISITE.getRenderColor(0.0f));
        }
        turboBlend.addColor(7344383);
        turboBlend.addColor(7344383);
        for (i = 0; i < n; ++i) {
            turboBlend.addColor(CrystalTier.EXQUISITE.getRenderColor(0.0f));
        }
    }

    public static class FocusConnection {
        public final FocusLocation relativeLocation;
        public final Coordinate target;
        public final Class tileClass;

        private FocusConnection(FocusLocation loc, TileEntity te) {
            this.relativeLocation = loc;
            this.target = new Coordinate(te);
            this.tileClass = te.getClass();
        }
    }

    private static class SimpleFocusLocation
    implements FocusLocation {
        public final Coordinate offset;

        private SimpleFocusLocation(FocusAcceleratable src, TileEntityFocusCrystal te) {
            this.offset = new Coordinate((TileEntity)te).offset(new Coordinate((TileEntity)src).negate());
        }

        @Override
        public Coordinate relativeLocation() {
            return this.offset;
        }
    }

    public static interface FocusLocation {
        public Coordinate relativeLocation();
    }

    public static enum CrystalTier {
        FLAWED(0.0625f),
        DEFAULT(0.125f),
        REFINED(0.375f),
        EXQUISITE(0.875f),
        TURBOCHARGED(1.375f);

        public final float efficiencyFactor;
        public static final CrystalTier[] tierList;

        private CrystalTier(float f) {
            this.efficiencyFactor = f;
        }

        public String getTextureSuffix() {
            switch (this) {
                case FLAWED: {
                    return "_cracked";
                }
                case EXQUISITE: 
                case TURBOCHARGED: {
                    return "_sparkle";
                }
            }
            return "";
        }

        public boolean useOrganizedModel() {
            return this.ordinal() >= REFINED.ordinal();
        }

        public int getRenderColor(float tick) {
            switch (this) {
                case FLAWED: {
                    return 3203136;
                }
                case DEFAULT: 
                case REFINED: {
                    return 0xE06060;
                }
                case EXQUISITE: {
                    return 0x22AAFF;
                }
                case TURBOCHARGED: {
                    return turboBlend.getColor((double)tick);
                }
            }
            return 0xFFFFFF;
        }

        public ItemStack getCraftedItem() {
            ItemStack is = ChromaTiles.FOCUSCRYSTAL.getCraftedProduct();
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("tier", this.ordinal());
            return is;
        }

        public String getDisplayName() {
            switch (this) {
                case DEFAULT: {
                    return "";
                }
                case TURBOCHARGED: {
                    return EXQUISITE.getDisplayName();
                }
            }
            return ReikaStringParser.capFirstChar((String)this.name());
        }

        public boolean isMaxPower() {
            return this.ordinal() >= EXQUISITE.ordinal();
        }

        public int getEffectiveOrdinal() {
            return this == TURBOCHARGED ? EXQUISITE.getEffectiveOrdinal() : this.ordinal();
        }

        static {
            tierList = CrystalTier.values();
        }
    }
}

