/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaOverlays;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityPylonEnhancer;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.ChromatiCraft.Render.Particle.EntitySparkleFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityFloatingSeedsFX;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityPylonTurboCharger
extends TileEntityPylonEnhancer {
    public static final int EFFECT_RANGE = 256;
    public static final int RITUAL_LENGTH = 2400;
    private int revTick = 0;
    private int ritualTick = 0;
    private Location location;
    private int jetTick = 0;
    private int groundTick;
    private int skyTick = 0;
    private boolean isComplete;
    private EntityPlayer turboPlayer;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.PYLONTURBO;
    }

    public int getPacketDelay() {
        return this.revTick > 0 ? 1 : super.getPacketDelay();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            if (this.location == null && this.ritualTick > 0) {
                if (this.revTick > 0) {
                    EntityPlayer ep = world.func_72977_a((double)x, (double)y, (double)z, 6.0);
                    if (ep == null) {
                        --this.revTick;
                    }
                    if (this.revTick < 16) {
                        Location loc = Location.list[this.revTick / 2];
                        Coordinate c = loc.position.offset(x, y, z);
                        ChromaTiles t = ChromaTiles.getTileFromIDandMetadata(c.getBlock((IBlockAccess)world), c.getBlockMetadata((IBlockAccess)world));
                        if (t != ChromaTiles.PYLONTURBO) {
                            this.failRitual(world, x, y, z);
                            return;
                        }
                        TileEntityPylonTurboCharger te = (TileEntityPylonTurboCharger)c.getTileEntity((IBlockAccess)world);
                        te.ritualTick = this.ritualTick;
                    }
                    if (this.revTick == 0) {
                        this.triggerStartFX(world, x, y, z);
                    }
                    ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this, 1.0f, 0.5f);
                } else {
                    this.doRitualTick(world, x, y, z);
                    --this.ritualTick;
                    if (this.ritualTick == 0) {
                        this.completeRitual(world, x, y, z);
                    }
                }
            }
        } else {
            this.doParticles(world, x, y, z);
        }
        if (world.field_72995_K && this.revTick > 0) {
            this.doRevEffects(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doRevEffects(World world, int x, int y, int z) {
        TileEntityCrystalPylon te = this.getPylon(world, x, y, z);
        for (int i = 0; i < Location.list.length; ++i) {
            Location loc = Location.list[i];
            Coordinate c = loc.position.offset(x, y, z);
            double px = (double)c.xCoord + 0.5;
            double py = (double)c.yCoord + 0.5;
            double pz = (double)c.zCoord + 0.5;
            double dx = px - (double)this.field_145851_c - 0.5;
            double dy = py - (double)this.field_145848_d - 0.5;
            double dz = pz - (double)this.field_145849_e - 0.5;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            double v = -ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125);
            double vx = dx / dd * v;
            double vy = dy / dd * v;
            double vz = dz / dd * v;
            float s = ReikaRandomHelper.getRandomBetween((int)6, (int)9);
            EntityCenterBlurFX fx = new EntityCenterBlurFX(te.getColor(), world, px, py, pz, vx, vy, vz).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        double px = (double)x + 0.5;
        double py = (double)y + 0.4375;
        double pz = (double)z + 0.5;
        px = ReikaRandomHelper.getRandomPlusMinus((double)px, (double)0.03125);
        py = ReikaRandomHelper.getRandomPlusMinus((double)py, (double)0.03125);
        pz = ReikaRandomHelper.getRandomPlusMinus((double)pz, (double)0.03125);
        int l = 5 + rand.nextInt(35);
        float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.5);
        int r = 192 + rand.nextInt(64);
        int g = 192 + rand.nextInt(64);
        int b = 192 + rand.nextInt(64);
        EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setColor(r, g, b).setScale(s).setGravity(0.0f).setLife(l);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.ritualTick = 0;
        this.skyTick = 0;
        this.groundTick = 0;
        this.jetTick = 0;
        this.findLocation(world, x, y, z);
    }

    private void findLocation(World world, int x, int y, int z) {
        TileEntity te;
        Coordinate c;
        Location loc;
        int i;
        for (i = 0; i < Location.list.length; ++i) {
            loc = Location.list[i];
            c = loc.getRelativePylonLocation().offset(x, y, z);
            te = c.getTileEntity((IBlockAccess)world);
            if (!(te instanceof TileEntityCrystalPylon) || !((TileEntityCrystalPylon)te).canConduct()) continue;
            this.location = loc;
            return;
        }
        if (this.location == null && this.getPylon(world, x, y, z) != null) {
            for (i = 0; i < Location.list.length; ++i) {
                loc = Location.list[i];
                c = loc.position.offset(x, y, z);
                te = c.getTileEntity((IBlockAccess)world);
                if (!(te instanceof TileEntityPylonTurboCharger)) continue;
                ((TileEntityPylonTurboCharger)te).location = loc;
            }
        }
    }

    private void doRitualTick(World world, int x, int y, int z) {
        TileEntityCrystalPylon te = this.getPylon(world, x, y, z);
        if (te == null) {
            this.failRitual(world, x, y, z);
        } else {
            for (int i = 0; i < Location.list.length; ++i) {
                Coordinate c = Location.list[i].position.offset(x, y, z);
                ChromaTiles t = ChromaTiles.getTileFromIDandMetadata(c.getBlock((IBlockAccess)world), c.getBlockMetadata((IBlockAccess)world));
                if (t != ChromaTiles.PYLONTURBO) {
                    this.failRitual(world, x, y, z);
                    return;
                }
                TileEntityPylonTurboCharger tile = (TileEntityPylonTurboCharger)c.getTileEntity((IBlockAccess)world);
                tile.ritualTick = this.ritualTick;
            }
            if ((2400 - this.ritualTick) % 200 == 0) {
                ChromaSounds.PYLONBOOSTRITUAL.playSoundAtBlockNoAttenuation((TileEntity)this, 0.75f, 1.0f, 256);
            }
            if (rand.nextInt(20) == 0) {
                int rx = ReikaRandomHelper.getRandomPlusMinus((int)te.field_145851_c, (int)12);
                int rz = ReikaRandomHelper.getRandomPlusMinus((int)te.field_145849_e, (int)12);
                int ry = ReikaRandomHelper.getRandomPlusMinus((int)te.field_145848_d, (int)6);
                ReikaWorldHelper.ignite((World)world, (int)rx, (int)ry, (int)rz);
            }
            if (this.skyTick > 0) {
                this.doEvent(world, x, y, z, EventType.SKY);
                --this.skyTick;
            }
            if (this.groundTick > 0) {
                this.doEvent(world, x, y, z, EventType.PARTICLEBURST);
                --this.groundTick;
            }
            if (this.jetTick > 0) {
                this.doEvent(world, x, y, z, EventType.JETS);
                --this.jetTick;
            }
            if (this.triggerEffect(120, 1.5, 0)) {
                this.doEvent(world, x, y, z, EventType.FLASH);
            }
            if (this.triggerEffect(20, 0.25, 600)) {
                this.doEvent(world, x, y, z, EventType.BEAM);
            }
            if (this.groundTick == 0 && this.triggerEffect(200, 0.75, 1200)) {
                this.groundTick = 5 + rand.nextInt(10);
                this.doEvent(world, x, y, z, EventType.PARTICLEBURST);
            }
            if (this.skyTick == 0 && this.triggerEffect(100, 1.5, 0)) {
                this.skyTick = 20 + rand.nextInt(80);
                this.doEvent(world, x, y, z, EventType.SKY);
            }
            if (this.jetTick == 0 && this.triggerEffect(80, 1.0, 1200)) {
                this.jetTick = 40 + rand.nextInt(120);
                this.doEvent(world, x, y, z, EventType.JETS);
            }
            if (this.triggerEffect(240, 4.0, 600)) {
                this.doEvent(world, x, y, z, EventType.LIGHTNING);
            }
            if (this.triggerEffect(160, 2.0, 0)) {
                this.doEvent(world, x, y, z, EventType.POTIONS);
            }
        }
    }

    private boolean triggerEffect(int min, double factor, int sub) {
        if (this.ritualTick < min || 2400 - this.ritualTick < min) {
            return false;
        }
        return this.ritualTick % (int)(2.0 * Math.max((double)min, (double)min * factor)) == 0 || rand.nextInt(Math.max(min, (int)((double)this.ritualTick * factor) - sub)) == 0;
    }

    private void completeRitual(World world, int x, int y, int z) {
        this.doCompleteParticles();
        this.ritualTick = 0;
        this.skyTick = 0;
        this.jetTick = 0;
        ChromaSounds.PYLONTURBO.playSoundAtBlockNoAttenuation((TileEntity)this, 2.0f, 1.0f, 256);
        ChromaSounds.PYLONTURBO.playSoundAtBlockNoAttenuation((TileEntity)this, 2.0f, 1.0f, 256);
        TileEntityCrystalPylon te = this.getPylon(world, x, y, z);
        te.enhance();
        for (int i = 0; i < Location.list.length; ++i) {
            Coordinate c = Location.list[i].position.offset(x, y, z);
            ChromaTiles t = ChromaTiles.getTileFromIDandMetadata(c.getBlock((IBlockAccess)world), c.getBlockMetadata((IBlockAccess)world));
            if (t != ChromaTiles.PYLONTURBO) {
                this.failRitual(world, x, y, z);
                return;
            }
            TileEntityPylonTurboCharger tile = (TileEntityPylonTurboCharger)c.getTileEntity((IBlockAccess)world);
            tile.ritualTick = 0;
            tile.isComplete = true;
            tile.syncAllData(true);
        }
        this.isComplete = true;
        ProgressStage.TURBOCHARGE.stepPlayerTo(this.turboPlayer);
        this.syncAllData(true);
    }

    private void failRitual(World world, int x, int y, int z) {
        TileEntityCrystalPylon te = this.getPylon(world, x, y, z);
        if (te != null) {
            te.disenhance();
            te.drain(te.getColor(), te.getEnergy(te.getColor()) * 4 / 5);
            te.enhancing = false;
            te.destroyPowerCrystals(1 + ReikaRandomHelper.getInverseLinearRandom((int)4));
        }
        this.doFailParticles(te != null);
        for (int i = 0; i < Location.list.length; ++i) {
            Coordinate c = Location.list[i].position.offset(x, y, z);
            ChromaTiles t = ChromaTiles.getTileFromIDandMetadata(c.getBlock((IBlockAccess)world), c.getBlockMetadata((IBlockAccess)world));
            if (t != ChromaTiles.PYLONTURBO) continue;
            TileEntityPylonTurboCharger tile = (TileEntityPylonTurboCharger)c.getTileEntity((IBlockAccess)world);
            tile.ritualTick = 0;
        }
        ChromaSounds.DISCHARGE.playSoundAtBlockNoAttenuation((TileEntity)this, 1.0f, 1.0f, 256);
        this.isComplete = false;
        this.ritualTick = 0;
        this.revTick = 0;
        this.skyTick = 0;
        this.jetTick = 0;
        this.groundTick = 0;
        this.turboPlayer = null;
        this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(world, (double)x + 0.5, (double)y + 8.5, (double)z + 0.5));
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)(y + 8), (int)z).func_72314_b(24.0, 16.0, 24.0);
        List li = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            if (e instanceof EntityPlayer) {
                if (((EntityPlayer)e).field_71075_bZ.field_75098_d) continue;
                float amt = Math.max(5.0f, Math.min(e.func_110143_aJ() - 4.0f, e.func_110138_aP() * 0.75f));
                ChromaAux.doPylonAttack(te.getColor(), e, amt);
                ChromaSounds.DISCHARGE.playSound(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, 1.0f, 1.0f);
                continue;
            }
            e.func_70097_a(DamageSource.field_76376_m, 0.0f);
        }
        this.syncAllData(true);
    }

    private void doCompleteParticles() {
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.PYLONTURBOCOMPLETE.ordinal(), (TileEntity)this, (int)256, (int[])new int[0]);
    }

    private void doEvent(World world, int x, int y, int z, EventType type) {
        TileEntityCrystalPylon te = this.getPylon(world, x, y, z);
        int dat = 0;
        switch (type) {
            case FLASH: {
                dat = te.getColor().ordinal();
                if (rand.nextBoolean()) {
                    CrystalNetworker.instance.overloadColorConnectedTo(te, te.getColor(), 1 + rand.nextInt(1), true);
                    break;
                }
                te.sendRandomShock(world, false, 1);
                break;
            }
            case BEAM: {
                break;
            }
            case JETS: {
                if (this.jetTick % 4 != 0) break;
                ChromaSounds.INFUSE.playSoundAtBlockNoAttenuation((TileEntity)this.getPylon(world, x, y, z), 0.5f, 0.5f, 256);
                break;
            }
            case PARTICLEBURST: {
                break;
            }
            case SKY: {
                dat = this.skyTick;
                break;
            }
            case LIGHTNING: {
                double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)8.0);
                double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)8.0);
                this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(world, dx, (double)y, dz));
                break;
            }
            case POTIONS: {
                AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - 12), (double)(y - 2), (double)(z - 12), (double)(x + 1 + 12), (double)(y + 1 + 24), (double)(z + 1 + 12));
                List li = world.func_72872_a(EntityLivingBase.class, box);
                for (EntityLivingBase e : li) {
                    PotionEffect eff = CrystalPotionController.instance.getEffectFromColor(te.getColor(), 200, 4, false);
                    if (eff == null) continue;
                    e.func_70690_d(eff);
                }
                break;
            }
        }
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.PYLONTURBOEVENT.ordinal(), (TileEntity)this, (int)256, (int[])new int[]{type.ordinal(), dat});
    }

    private void doFailParticles(boolean hasPylon) {
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.PYLONTURBOFAIL.ordinal(), (TileEntity)this, (int)256, (int[])new int[]{hasPylon ? 1 : 0});
    }

    @SideOnly(value=Side.CLIENT)
    public void doFailParticlesClient(World world, int x, int y, int z, boolean hasPylon) {
        this.rockScreenClient(15);
        int n = 12;
        int da = 360 / n;
        double r = 16.0;
        double dd = 0.125;
        for (int a = 0; a < 360; a += da) {
            for (double d = 0.5; d <= r; d += dd) {
                double dx = (double)x + 0.5 + d * Math.cos(Math.toRadians(a));
                double dz = (double)z + 0.5 + d * Math.sin(Math.toRadians(a));
                double dy = (double)y + 0.5 + 8.0;
                float s = 5.0f * (float)(1.0 - d / r);
                EntitySparkleFX fx = new EntitySparkleFX(world, dx, dy, dz, 0.0, 0.0, 0.0).setScale(s);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        if (hasPylon) {
            TileEntityCrystalPylon te = this.getPylon(world, x, y, z);
            n = 32 + rand.nextInt(96);
            for (int i = 0; i < n; ++i) {
                double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)4.0);
                double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)4.0);
                double py = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5 + 8.0), (double)2.0);
                double dx = px - (double)x - 0.5;
                double dz = pz - (double)z - 0.5;
                double dy = py - (double)y - 0.5 - 8.0;
                dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
                double v = -ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.25);
                double vx = v * dx / dd;
                double vy = v * dy / dd;
                double vz = v * dz / dd;
                int l = 10 + rand.nextInt(10);
                float s = (float)ReikaRandomHelper.getRandomBetween((double)2.0, (double)7.5);
                EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz, vx, vy, vz).fadeColors(0xFFFFFF, te.getColor().getColor()).setScale(s).setLife(l).setRapidExpand();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doCompleteParticlesClient(World world, int x, int y, int z) {
        double da = 5.0;
        for (double a1 = 0.0; a1 < 360.0; a1 += da) {
            for (double a2 = -90.0 + da; a2 < 90.0 - da; a2 += da) {
                double v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
                double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)v, (double)a2, (double)a1);
                float s = (float)ReikaRandomHelper.getRandomBetween((double)2.0, (double)3.0);
                int c1 = this.getPylon(world, x, y, z).getColor().getColor();
                int l = 30 + rand.nextInt(20);
                EntityCCBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.5 + 8.0, (double)z + 0.5, xyz[0], xyz[1], xyz[2]);
                fx.setRapidExpand().setScale(s).setLife(l).setGravity(0.0f).fadeColors(0xFFFFFF, c1);
                IIcon ico = null;
                switch (rand.nextInt(4)) {
                    case 0: {
                        ico = ChromaIcons.FADE.getIcon();
                        break;
                    }
                    case 1: {
                        ico = ChromaIcons.BIGFLARE.getIcon();
                        break;
                    }
                    case 2: {
                        ico = ChromaIcons.SPARKLEPARTICLE.getIcon();
                        fx.setBasicBlend();
                        break;
                    }
                    case 3: {
                        ico = ChromaIcons.CENTER.getIcon();
                    }
                }
                fx.func_110125_a(ico);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        float s = (float)ReikaRandomHelper.getRandomBetween((double)2.0, (double)3.0);
        double v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
        int c1 = this.getPylon(world, x, y, z).getColor().getColor();
        int l = 30 + rand.nextInt(20);
        EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.5 + 8.0, (double)z + 0.5, 0.0, v, 0.0).setRapidExpand().setScale(s).setLife(l).setGravity(0.0f).fadeColors(0xFFFFFF, c1);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        s = (float)ReikaRandomHelper.getRandomBetween((double)2.0, (double)3.0);
        l = 30 + rand.nextInt(20);
        v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
        fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.5 + 8.0, (double)z + 0.5, 0.0, -v, 0.0).setRapidExpand().setScale(s).setLife(l).setGravity(0.0f).fadeColors(0xFFFFFF, c1);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @SideOnly(value=Side.CLIENT)
    public void doEventClient(World world, int x, int y, int z, int type, int data) {
        EventType evt = EventType.list[type];
        TileEntityCrystalPylon te = this.getPylon(world, x, y, z);
        switch (evt) {
            case FLASH: {
                this.rockScreenClient(40);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.PYLONFLASH, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)1.0f, (boolean)false);
                ChromaOverlays.instance.triggerWashout(CrystalElement.elements[data]);
                for (int i = 0; i < 6; ++i) {
                    double v = ReikaRandomHelper.getRandomBetween((double)0.05, (double)0.1);
                    int n = 16 + rand.nextInt(32);
                    double theta = rand.nextInt(360);
                    double phi = rand.nextInt(360);
                    for (int k = 0; k < n; ++k) {
                        double rtheta = ReikaRandomHelper.getRandomPlusMinus((double)theta, (double)15.0);
                        double rphi = ReikaRandomHelper.getRandomPlusMinus((double)phi, (double)15.0);
                        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)v, (double)rtheta, (double)rphi);
                        float s = (float)ReikaRandomHelper.getRandomBetween((double)2.0, (double)4.0);
                        int l = 40 + rand.nextInt(120);
                        int c1 = te.getColor().getColor();
                        EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.5 + 8.0, (double)z + 0.5, xyz[0], xyz[1], xyz[2]).setRapidExpand().setScale(s).setLife(l).setGravity(0.0f).fadeColors(0xFFFFFF, c1);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                }
                break;
            }
            case PARTICLEBURST: {
                this.rockScreenClient(6);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.CAST, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)1.0f, (boolean)false);
                for (int a = 0; a < 360; a += 2) {
                    int n = 1;
                    for (int i = 0; i < n; ++i) {
                        double r = 7.0;
                        double dx = (double)x + 0.5 + r * Math.cos(Math.toRadians(a));
                        double dz = (double)z + 0.5 + r * Math.sin(Math.toRadians(a));
                        dx = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)0.125);
                        dz = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)0.125);
                        double dy = y;
                        int c = te.getColor().getColor();
                        float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)3.0, (double)1.0);
                        int l = 40 + rand.nextInt(120);
                        float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125));
                        EntityBlurFX fx = new EntityCCFloatingSeedsFX(world, dx, dy, dz, 0.0, 90.0).setLife(l).setScale(s).setColor(c).setGravity(g);
                        ((EntityFloatingSeedsFX)fx).freedom = 40.0;
                        ((EntityFloatingSeedsFX)fx).angleVelocity = 1.25;
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                }
                break;
            }
            case BEAM: {
                Location loc = Location.list[rand.nextInt(Location.list.length)];
                Coordinate c = loc.position.offset(x, y, z);
                int n = 6 + rand.nextInt(6);
                double px = (double)c.xCoord + 0.5;
                double py = (double)c.yCoord + 0.5;
                double pz = (double)c.zCoord + 0.5;
                double dx = px - (double)this.field_145851_c - 0.5;
                double dy = py - (double)this.field_145848_d - 0.5;
                double dz = pz - (double)this.field_145849_e - 0.5;
                double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
                for (int i = 0; i < n; ++i) {
                    double v = ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125);
                    double vx = dx / dd * v;
                    double vy = dy / dd * v;
                    double vz = dz / dd * v;
                    float s = ReikaRandomHelper.getRandomBetween((int)3, (int)6);
                    EntityLaserFX fx = new EntityLaserFX(te.getColor(), world, px, py, pz, vx, vy, vz).setScale(s);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    fx = new EntityLaserFX(te.getColor(), world, px, py, pz, -vx, -vy, -vz).setScale(s);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
                break;
            }
            case JETS: {
                int n = 6;
                int da = 360 / n;
                double a = Math.toRadians(this.getTicksExisted() % 360);
                double v = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.25);
                if (rand.nextInt(4) == 0) {
                    v *= 2.0;
                }
                for (int i = 0; i < n; ++i) {
                    double a1 = a + (double)(i * da);
                    float s = (float)ReikaRandomHelper.getRandomBetween((double)1.5, (double)3.0);
                    double th = 60.0 * Math.sin(a + (double)i * Math.PI / 6.0);
                    int l = 40;
                    EntityBlurFX fx = new EntityCCFloatingSeedsFX(world, (double)x + 0.5, (double)y + 8.5, (double)z + 0.5, a1, th).setRapidExpand().setLife(l).setScale(s).fadeColors(0xFFFFFF, te.getColor().getColor());
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
                break;
            }
            case SKY: {
                this.skyTick = data;
                break;
            }
            case LIGHTNING: {
                this.rockScreenClient(20);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DISCHARGE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)1.0f, (boolean)false);
                break;
            }
            case POTIONS: {
                this.rockScreenClient(16);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.POWERDOWN, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)1.0f, (boolean)false);
                int r = 16;
                int n = 16 + rand.nextInt(32);
                HashSet<Coordinate> coords = new HashSet<Coordinate>();
                for (int i = 0; i < n; ++i) {
                    double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)r);
                    double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)r);
                    Coordinate c = new Coordinate(dx, (double)y, dz);
                    while (coords.contains(c)) {
                        dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)r);
                        dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)r);
                        c = new Coordinate(dx, (double)y, dz);
                    }
                    coords.add(c);
                    int l = 10 + rand.nextInt(50);
                    float s = ReikaRandomHelper.getRandomBetween((int)2, (int)6);
                    float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625));
                    EntityRuneFX fx = new EntityRuneFX(world, dx, (float)(y - 1) - s / 4.0f, dz, 0.0, 0.125, 0.0, te.getColor()).setGravity(g).setLife(l).setScale(s);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
                break;
            }
        }
    }

    private void triggerStartFX(World world, int x, int y, int z) {
        for (int i = 0; i < Location.list.length; ++i) {
            Location loc = Location.list[i];
            Coordinate c = loc.position.offset(x, y, z);
            world.func_72942_c((Entity)new EntityLightningBolt(world, (double)c.xCoord, (double)c.yCoord, (double)c.zCoord));
        }
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - 64), (double)(y - 64), (double)(z - 64), (double)(x + 1 + 64), (double)(y + 1 + 64), (double)(z + 1 + 64));
        List li = world.func_72872_a(EntityPlayer.class, box);
        for (EntityPlayer ep : li) {
            ep.func_70097_a(new DamageSource("fx").func_76348_h().func_151518_m().func_76359_i(), 1.0E-5f);
        }
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.PYLONTURBOSTART.ordinal(), (TileEntity)this, (int)256, (int[])new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void doStartFXClient(World world, int x, int y, int z) {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.PYLONBOOSTSTART, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.0f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.PYLONBOOSTSTART, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.0f, (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    private void rockScreenClient(int ticks) {
        Minecraft.func_71410_x().field_71451_h.field_70737_aN = Math.max(Minecraft.func_71410_x().field_71451_h.field_70737_aN, ticks);
    }

    public int getSkyTick() {
        return this.skyTick;
    }

    public int getTick() {
        return this.ritualTick;
    }

    public Location getLocation() {
        return this.location;
    }

    public TileEntityCrystalPylon getPylon(World world, int x, int y, int z) {
        int d = 8;
        for (int i = 1; i < d; ++i) {
            int dy = y + i;
            if (world.func_147439_a(x, dy, z).isAir((IBlockAccess)world, x, dy, z)) continue;
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y + d, z);
        return tile instanceof TileEntityCrystalPylon ? (TileEntityCrystalPylon)tile : null;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean trigger(EntityPlayer ep) {
        boolean hasAuxiliaries;
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        if (this.checkPylon(world, x, y, z) && this.canPlayerTurbocharge(world, x, y, z, ep) && (hasAuxiliaries = this.checkForArrangement(world, x, y, z))) {
            this.startRitual(world, x, y, z, ep);
            ChromaSounds.PYLONBOOSTSTART.playSoundAtBlockNoAttenuation((TileEntity)this, 1.0f, 1.0f, 256);
            return true;
        }
        ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
        return false;
    }

    private boolean canPlayerTurbocharge(World world, int x, int y, int z, EntityPlayer ep) {
        TileEntityCrystalPylon te = this.getPylon(world, x, y, z);
        return ProgressionManager.instance.hasPlayerCompletedStructureColor(ep, te.getColor());
    }

    private boolean checkPylon(World world, int x, int y, int z) {
        TileEntityCrystalPylon te = this.getPylon(world, x, y, z);
        if (te != null) {
            return !te.isEnhanced() && te.getEnergy(te.getColor()) >= 135000 && te.canConduct() && te.getBoosterCrystals(world, x, y + 8, z, true).size() == 8 && te.field_145850_b.func_72937_j(te.field_145851_c, te.field_145848_d + 1, te.field_145849_e);
        }
        return false;
    }

    private boolean checkForArrangement(World world, int x, int y, int z) {
        for (int i = 0; i < Location.list.length; ++i) {
            Location loc = Location.list[i];
            Coordinate c = loc.position.offset(x, y, z);
            ChromaTiles t = ChromaTiles.getTileFromIDandMetadata(c.getBlock((IBlockAccess)world), c.getBlockMetadata((IBlockAccess)world));
            if (t != ChromaTiles.PYLONTURBO) {
                return false;
            }
            TileEntityPylonTurboCharger te = (TileEntityPylonTurboCharger)c.getTileEntity((IBlockAccess)world);
            if (te.canFunction(world, c.xCoord, c.yCoord, c.zCoord)) continue;
            return false;
        }
        return true;
    }

    private boolean canFunction(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) == ChromaBlocks.PYLONSTRUCT.getBlockInstance() && world.func_72805_g(x, y - 1, z) == 5 && world.func_147439_a(x, y - 2, z) == ChromaBlocks.PYLONSTRUCT.getBlockInstance() && world.func_72805_g(x, y - 2, z) == 2 && world.func_72937_j(x, y + 1, z)) {
            for (int i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    int dx = x + i;
                    int dy = y + 1;
                    int dz = z + k;
                    if (world.func_147439_a(dx, dy, dz).isAir((IBlockAccess)world, dx, dy, dz)) continue;
                    return false;
                }
            }
            if (this.location == null) {
                return false;
            }
            Location l = this.location.getNext();
            Coordinate end = l.position.offset(this.location.position.negate()).offset(x, y, z);
            return end.getTileEntity((IBlockAccess)world) instanceof TileEntityPylonTurboCharger && PylonFinder.lineOfSight((World)world, (int)x, (int)y, (int)z, (int)end.xCoord, (int)end.yCoord, (int)end.zCoord, (Block[])new Block[]{ChromaBlocks.ENCRUSTED.getBlockInstance()}).hasLineOfSight;
        }
        return false;
    }

    private void startRitual(World world, int x, int y, int z, EntityPlayer ep) {
        this.ritualTick = 2400;
        this.revTick = 40;
        this.turboPlayer = ep;
        this.getPylon((World)world, (int)x, (int)y, (int)z).enhancing = true;
        for (int i = 0; i < Location.list.length; ++i) {
            Location loc = Location.list[i];
            Coordinate c = loc.position.offset(x, y, z);
            ChromaTiles t = ChromaTiles.getTileFromIDandMetadata(c.getBlock((IBlockAccess)world), c.getBlockMetadata((IBlockAccess)world));
            if (t != ChromaTiles.PYLONTURBO) {
                this.failRitual(world, x, y, z);
                return;
            }
            TileEntityPylonTurboCharger tile = (TileEntityPylonTurboCharger)c.getTileEntity((IBlockAccess)world);
            tile.location = loc;
        }
        world.func_72912_H().func_76084_b(false);
        this.syncAllData(true);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("rtick", this.ritualTick);
        NBT.func_74768_a("rvtick", this.revTick);
        NBT.func_74768_a("sky", this.skyTick);
        NBT.func_74757_a("complete", this.isComplete);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.ritualTick = NBT.func_74762_e("rtick");
        this.revTick = NBT.func_74762_e("rvtick");
        this.skyTick = NBT.func_74762_e("sky");
        this.isComplete = NBT.func_74767_n("complete");
    }

    public void breakBlock() {
        if (this.isComplete || this.ritualTick > 0) {
            if (this.location != null) {
                TileEntityPylonTurboCharger tc;
                TileEntityCrystalPylon tp;
                Coordinate c = this.location.position.negate().offset(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                TileEntity te = c.getTileEntity((IBlockAccess)this.field_145850_b);
                if (te instanceof TileEntityPylonTurboCharger && ((tp = (tc = (TileEntityPylonTurboCharger)te).getPylon(tc.field_145850_b, tc.field_145851_c, tc.field_145848_d, tc.field_145849_e)) == null || tp.isEnhanced())) {
                    tc.failRitual(this.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
                }
            } else {
                this.failRitual(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(12.0, 12.0, 12.0);
    }

    public double func_145833_n() {
        return 16384.0;
    }

    public static enum Location {
        N(0, -7),
        NE(5, -5),
        E(7, 0),
        SE(5, 5),
        S(0, 7),
        SW(-5, 5),
        W(-7, 0),
        NW(-5, -5);

        public final Coordinate position;
        public static final Location[] list;

        private Location(int x, int z) {
            this.position = new Coordinate(x, 2, z);
        }

        public Location getNext() {
            return this.ordinal() == list.length - 1 ? list[0] : list[this.ordinal() + 1];
        }

        public Coordinate getRelativePylonLocation() {
            return this.position.negate().offset(0, 8, 0);
        }

        static {
            list = Location.values();
        }
    }

    public static enum EventType {
        FLASH,
        BEAM,
        SKY,
        JETS,
        PARTICLEBURST,
        LIGHTNING,
        POTIONS;

        private static final EventType[] list;

        static {
            list = EventType.values();
        }
    }
}

