/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Decoration;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Rendering.MutableStructureRenderer;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.world.World;

public class TileEntityAreaHologram
extends TileEntityChromaticBase {
    private static final int RANGE = 16;
    private int readX = -16;
    private int readY = -16;
    private int readZ = -16;
    @SideOnly(value=Side.CLIENT)
    private StructureRenderer renderer;

    protected void onFirstTick(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            this.initRenderer();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initRenderer() {
        this.renderer = new MutableStructureRenderer(this.field_145850_b, 16);
        this.renderer.resetRotation();
        this.renderer.rotate(30.0, -45.0, 0.0);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.HOLOGRAM;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            int n = 66;
            for (int i = 0; i < n; ++i) {
                if (this.readY + this.field_145848_d < 0) {
                    this.readY = -this.field_145848_d;
                }
                int dx = x + this.readX;
                int dy = y + this.readY;
                int dz = z + this.readZ;
                this.addBlock(this.readX, this.readY, this.readZ, world, dx, dy, dz);
                this.updateReadPosition();
                if (this.readY <= 16) continue;
                this.readZ = -16;
                this.readY = -16;
                this.readX = -16;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlock(int dx, int dy, int dz, World world, int x, int y, int z) {
        ((MutableStructureRenderer)this.renderer).addBlock(dx, dy, dz, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), world.func_147438_o(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStructure(float ptick) {
        this.renderer.draw3D(0, 0, ptick, false);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    private void updateReadPosition() {
        boolean flag1 = false;
        boolean flag2 = false;
        ++this.readX;
        if (this.readX > 16) {
            this.readX = -16;
            flag1 = true;
        }
        if (flag1) {
            ++this.readZ;
            if (this.readZ > 16) {
                this.readZ = -16;
                flag2 = true;
            }
            if (flag2) {
                ++this.readY;
            }
        }
    }
}

