/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Decoration;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaSound;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.TemporaryCrystalReceiver;
import Reika.ChromatiCraft.Base.CrystalBlock;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.CrystalMusicTemple;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.IO.MIDIInterface;
import Reika.DragonAPI.Instantiable.MusicScore;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.TriggerableAction;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityCrystalMusic
extends TileEntityChromaticBase
implements MultiBlockChromaTile,
GuiController,
TriggerableAction,
BreakAction {
    private static final int BROADCAST_RANGE = 96;
    private boolean isPlaying;
    private int playTick;
    private MusicScore track = new MusicScore(16);
    private TemporaryCrystalReceiver receiver;
    private final CrystalPath[] networkConnections = new CrystalPath[16];
    private CrystalMusicTemple temple = new CrystalMusicTemple();
    private static final MusicScore demoTrack;
    private static final EnumMap<CrystalElement, Coordinate> colorPositions;

    public void addNote(int channel, ReikaMusicHelper.MusicKey key, int length, boolean rest) {
        this.addNote(this.getTime(channel), channel, key, length, rest);
    }

    public void addNote(int time, int channel, ReikaMusicHelper.MusicKey key, int length, boolean rest) {
        this.track.addNote(time, channel, key, rest ? -1 : 0, 100, length, false);
    }

    private int getTime(int channel) {
        int pos;
        Collection n = this.track.getNotes(channel, pos = this.track.getLatestPos(channel));
        return pos + (n != null && !n.isEmpty() ? ((MusicScore.Note)n.iterator().next()).length : 0);
    }

    public void clearChannel(int channel) {
        this.track.clearChannel(channel);
    }

    public void backspace(int channel) {
        this.track.backspace(channel);
    }

    public void clearMusic() {
        this.track = new MusicScore(16);
        this.isPlaying = false;
        this.playTick = 0;
        for (int i = 0; i < this.networkConnections.length; ++i) {
            if (this.networkConnections[i] == null) continue;
            this.networkConnections[i].endBlink();
        }
    }

    public boolean hasTemple() {
        return this.temple.isComplete();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasTempleRender() {
        return this.temple.isRendering();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawTemple(float ptick) {
        this.temple.render(ptick);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.MUSIC;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K && this.track != null) {
            if (world.func_147439_a(x, y + 1, z) == Blocks.field_150357_h) {
                this.isPlaying = false;
            }
            if (this.isPlaying) {
                this.play(world, x, y, z);
            }
        }
        if (DragonAPICore.debugtest) {
            for (CrystalElement e : colorPositions.keySet()) {
                colorPositions.get(e).offset(x, y, z).setBlock(world, ChromaBlocks.LAMP.getBlockInstance(), e.ordinal());
            }
        }
    }

    protected void onPositiveRedstoneEdge() {
        this.triggerPlay();
    }

    public void triggerPlay() {
        if (this.isPlaying) {
            return;
        }
        this.calcPaths(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.playTick = 0;
        this.isPlaying = true;
        this.temple.onMusicStart(this.field_145850_b, this.track.getTrack(0));
        this.syncAllData(false);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.calcPaths(world, x, y, z);
            this.temple.setCore(this);
            this.temple.checkStructure(world);
        }
    }

    private void calcPaths(World world, int x, int y, int z) {
        block4: {
            if (world.field_72995_K) break block4;
            if (this.playRepeaters(world, x, y, z)) {
                this.receiver = this.createTemporaryReceiver();
                for (int i = 0; i < 16; ++i) {
                    this.networkConnections[i] = CrystalNetworker.instance.getConnectivity(CrystalElement.elements[i], this.receiver);
                }
            } else {
                this.receiver = null;
                for (int i = 0; i < 16; ++i) {
                    this.networkConnections[i] = null;
                }
            }
        }
    }

    private boolean playRepeaters(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        return b == Blocks.field_150371_ca || b == ChromaBlocks.PYLONSTRUCT.getBlockInstance();
    }

    private void play(World world, int x, int y, int z) {
        for (int i = 0; i < 16; ++i) {
            Collection li = this.track.getNotes(i, this.playTick);
            if (li == null) continue;
            for (MusicScore.Note n : li) {
                if (n.voice != -1 && !this.playNote(world, x, y, z, n, i)) continue;
            }
        }
        ++this.playTick;
        if (this.playTick > this.track.getLatestPos()) {
            this.isPlaying = false;
            this.temple.onMusicEnd(world);
        }
    }

    private boolean playNote(World world, int x, int y, int z, MusicScore.Note n, int track) {
        Set<CrystalElement> set = CrystalMusicManager.instance.getColorsWithKeyAnyOctave(n.key);
        boolean canPlay = false;
        if (!set.isEmpty()) {
            for (CrystalElement e : set) {
                canPlay |= this.playCrystal(world, x, y, z, e, n.length, n.key);
            }
            if (canPlay) {
                // empty if block
            }
        } else {
            canPlay = true;
            this.generateParticles(world, x, y + 2, z, CrystalElement.randomElement(), 20, n.key);
        }
        if (canPlay) {
            this.temple.onNote(world, n.key, track, this.playTick);
            ChromaSound s = this.getVoice(track, n);
            float f = (float)CrystalMusicManager.instance.getPitchFactor(n.key);
            float v = (float)n.volume / 100.0f;
            if (this.attentuate(world, x, y, z)) {
                s.playSoundAtBlock((TileEntity)this, v, f);
            } else {
                s.playSoundAtBlockNoAttenuation((TileEntity)this, v, f, 96);
            }
            return true;
        }
        ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.CRYSTALMUSERROR.ordinal(), (TileEntity)this, (int)96, (int[])new int[0]);
        return false;
    }

    private ChromaSound getVoice(int channel, MusicScore.Note n) {
        return ChromaSounds.DING;
    }

    private boolean attentuate(World world, int x, int y, int z) {
        return !this.temple.isComplete() && world.func_147439_a(x, y - 1, z) != Blocks.field_150371_ca;
    }

    public boolean playCrystal(World world, int x, int y, int z, CrystalElement e, int length, ReikaMusicHelper.MusicKey note) {
        if (this.temple.isComplete() && this.temple.isPlayingMelody()) {
            return true;
        }
        Coordinate c = colorPositions.get(e).offset(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Block b = c.getBlock((IBlockAccess)world);
        if (DragonAPICore.debugtest) {
            c.setBlock(world, ChromaBlocks.LAMP.getBlockInstance(), e.ordinal());
        }
        if (b instanceof CrystalBlock && c.getBlockMetadata((IBlockAccess)world) == e.ordinal()) {
            this.generateParticles(world, c.xCoord, c.yCoord, c.zCoord, e, length, note);
            if (this.networkConnections[e.ordinal()] != null && this.networkConnections[e.ordinal()].stillValid().canConduct()) {
                this.networkConnections[e.ordinal()].blink(MathHelper.func_76125_a((int)(length / 2), (int)1, (int)40), this.receiver);
            }
            return true;
        }
        return false;
    }

    public TemporaryCrystalReceiver createTemporaryReceiver() {
        return new TemporaryCrystalReceiver((TileEntity)this, 0, 32, 0.35, ResearchLevel.BASICCRAFT);
    }

    private void generateParticles(World world, int x, int y, int z, CrystalElement e, int length, ReikaMusicHelper.MusicKey note) {
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z, e, length, note);
        } else {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.CRYSTALMUS.ordinal(), (TileEntity)this, (int)96, (int[])new int[]{x, y, z, e.ordinal(), length, note.ordinal()});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doErrorParticles(World world, int x, int y, int z) {
        int n = 12 + rand.nextInt(12);
        for (int i = 0; i < n; ++i) {
            double dx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double dy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double dz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            int l = 5 + rand.nextInt(15);
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.25, (double)0.125);
            int c = CrystalElement.randomElement().getColor();
            EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5 + dx, (double)y + 0.5 + dy, (double)z + 0.5 + dz, -dx * v, -dy * v, -dz * v).setLife(l).setColor(c).setGravity(0.0f);
            fx.field_70145_X = false;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doParticles(World world, int x, int y, int z, CrystalElement e, int length, ReikaMusicHelper.MusicKey note) {
        int n = 3 + rand.nextInt(6);
        for (int i = 0; i < n; ++i) {
            double px = (double)x + rand.nextDouble();
            double py = (double)y + rand.nextDouble();
            double pz = (double)z + rand.nextDouble();
            int l = 10 + rand.nextInt(40);
            float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.015125, (double)0.125));
            EntityBlurFX fx = new EntityCCFloatingSeedsFX(world, px, py, pz, 0.0, 90.0).setLife(l).setColor(e.getColor()).setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        if (x != this.field_145851_c || y != this.field_145848_d || z != this.field_145849_e) {
            double dx = x - this.field_145851_c;
            double dy = y - this.field_145848_d;
            double dz = z - this.field_145849_e;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            for (double p = 0.0; p <= dd; p += 0.125) {
                double f = p / dd;
                float s = 1.0f + 1.5f * (float)Math.sin(f * Math.PI);
                int l = Math.max(8, length / 6);
                double px = (double)this.field_145851_c + 0.5 + f * dx;
                double py = (double)this.field_145848_d + 0.5 + f * dy;
                double pz = (double)this.field_145849_e + 0.5 + f * dz;
                int clr = e.getColor();
                EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setLife(l).setNoSlowdown().setScale(s).setColor(clr);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onTempleStart(NBTTagCompound tag) {
        this.temple.onStart(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onTempleNote(ReikaMusicHelper.MusicKey mk, int track, int tick) {
        this.temple.onNote(this.field_145850_b, mk, track, tick);
    }

    @SideOnly(value=Side.CLIENT)
    public void onTempleEnd() {
        this.temple.onEnd();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void loadDemo() {
        if (demoTrack != null && demoTrack.getLatestPos() > 0) {
            this.setTrack(demoTrack.copy());
        }
        this.triggerPlay();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean loadLocalMIDI(String file, int quarterTicks) {
        File f = new File(file);
        if (!f.exists() || f.isDirectory()) {
            ChromatiCraft.logger.logError((Object)"Could not load local MIDI: file is not a MIDI file!");
            return false;
        }
        if (f.length() > (long)(1024 * ChromaOptions.MIDISIZE.getValue()) && !DragonAPICore.isSinglePlayerFromClient()) {
            ChromatiCraft.logger.logError((Object)("Could not load local MIDI: file is too large (" + f.length() + " bytes) and cannot be safely used!"));
            return false;
        }
        try {
            float speed = 99.0f / (float)quarterTicks;
            MusicScore mus = new MIDIInterface(f).fillToScore(false).scaleSpeed(speed, true);
            mus.normalizeToRange(ReikaMusicHelper.MusicKey.C4, ReikaMusicHelper.MusicKey.C6);
            this.dispatchTrack(mus);
            ChromatiCraft.logger.log((Object)("Loaded MIDI with " + mus.noteCount() + " notes in " + mus.getActiveTracks().size() + " tracks with a speed of " + quarterTicks + " ticks/beat"));
            return true;
        }
        catch (Exception e) {
            ChromatiCraft.logger.logError((Object)e.toString());
            e.printStackTrace();
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void dispatchDemo() {
        this.dispatchTrack(demoTrack);
    }

    private void dispatchTrack(MusicScore mus) {
        ReikaPacketHelper.sendPacketToServer((String)"ChromaData", (int)ChromaPackets.MUSICCLEAR.ordinal(), (TileEntity)this, (int[])new int[0]);
        for (int i = 0; i < mus.countTracks(); ++i) {
            MusicScore.ScoreTrack track = mus.getTrack(i);
            if (track == null) continue;
            for (Map.Entry e : track.entryView()) {
                int time = (Integer)e.getKey();
                MusicScore.NoteData c = (MusicScore.NoteData)e.getValue();
                for (MusicScore.Note n : c.notes()) {
                    if (n == null || n.key == null) continue;
                    ReikaPacketHelper.sendPacketToServer((String)"ChromaData", (int)ChromaPackets.FIXEDMUSICNOTE.ordinal(), (TileEntity)this, (int[])new int[]{i, n.key.ordinal(), n.length, n.voice == -1 ? 1 : 0, time});
                }
            }
        }
    }

    public void setTrack(MusicScore music) {
        this.isPlaying = false;
        this.track = music;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        if (this.track != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.track.writeToNBT(tag);
            NBT.func_74782_a("track", (NBTBase)tag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        if (NBT.func_74764_b("track")) {
            NBTTagCompound tag = NBT.func_74775_l("track");
            this.track = MusicScore.readFromNBT((NBTTagCompound)tag);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBTTagCompound tag = new NBTTagCompound();
        this.temple.writeSyncData(tag);
        NBT.func_74782_a("structure", (NBTBase)tag);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.temple.readSyncData(NBT.func_74775_l("structure"));
        }
    }

    public boolean trigger() {
        if (this.track == null) {
            return false;
        }
        this.triggerPlay();
        return true;
    }

    public void breakBlock() {
        if (this.receiver != null) {
            CrystalNetworker.instance.breakPaths(this.receiver);
            CrystalNetworker.instance.removeTile(this.receiver);
            this.receiver.destroy();
        }
        for (int i = 0; i < this.networkConnections.length; ++i) {
            if (this.networkConnections[i] == null) continue;
            this.networkConnections[i].endBlink();
        }
    }

    @Override
    public void validateStructure() {
        if (this.isPlaying) {
            return;
        }
        this.temple.checkStructure(this.field_145850_b);
        this.syncAllData(false);
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        return null;
    }

    @Override
    public Coordinate getStructureOffset() {
        return null;
    }

    @Override
    public boolean canStructureBeInspected() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.temple.isRendering() ? ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(9.0, 6.0, 9.0) : super.getRenderBoundingBox();
    }

    static {
        MusicScore mus = null;
        try {
            mus = new MIDIInterface(ChromatiCraft.class, "Resources/music-demo.mid").fillToScore(false).scaleSpeed(11.0f, false);
            ChromatiCraft.logger.log((Object)("Loaded demo track " + mus));
        }
        catch (Exception e) {
            e.printStackTrace();
            ChromatiCraft.logger.logError((Object)"Could not load demo track!");
            mus = new MusicScore(16);
        }
        demoTrack = mus;
        colorPositions = new EnumMap(CrystalElement.class);
        colorPositions.put(CrystalElement.BLACK, new Coordinate(0, 0, -3));
        colorPositions.put(CrystalElement.RED, new Coordinate(1, 0, -3));
        colorPositions.put(CrystalElement.GREEN, new Coordinate(2, 0, -2));
        colorPositions.put(CrystalElement.BROWN, new Coordinate(3, 0, -1));
        colorPositions.put(CrystalElement.BLUE, new Coordinate(3, 0, 0));
        colorPositions.put(CrystalElement.PURPLE, new Coordinate(3, 0, 1));
        colorPositions.put(CrystalElement.CYAN, new Coordinate(2, 0, 2));
        colorPositions.put(CrystalElement.LIGHTGRAY, new Coordinate(1, 0, 3));
        colorPositions.put(CrystalElement.GRAY, new Coordinate(0, 0, 3));
        colorPositions.put(CrystalElement.PINK, new Coordinate(-1, 0, 3));
        colorPositions.put(CrystalElement.LIME, new Coordinate(-2, 0, 2));
        colorPositions.put(CrystalElement.YELLOW, new Coordinate(-3, 0, 1));
        colorPositions.put(CrystalElement.LIGHTBLUE, new Coordinate(-3, 0, 0));
        colorPositions.put(CrystalElement.MAGENTA, new Coordinate(-3, 0, -1));
        colorPositions.put(CrystalElement.ORANGE, new Coordinate(-2, 0, -2));
        colorPositions.put(CrystalElement.WHITE, new Coordinate(-1, 0, -3));
    }
}

