/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Base.TileEntity.CrystalTransmitterBase;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.PylonConnector;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityAtmosphericRelay
extends CrystalTransmitterBase
implements CrystalRepeater,
SneakPop,
OwnedTile,
PylonConnector {
    private int depth;
    private boolean hasStructure = true;

    @Override
    public int receiveElement(CrystalSource src, CrystalElement e, int amt) {
        return 1;
    }

    @Override
    public int getReceiveRange() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return this.hasStructure;
    }

    @Override
    public int maxThroughput() {
        return 40000;
    }

    @Override
    public int getSignalDegradation(boolean point) {
        return point ? 1000 : 20000;
    }

    @Override
    public boolean canConduct() {
        return this.hasStructure;
    }

    @Override
    public DecimalPosition getTargetRenderOffset(CrystalElement e) {
        return null;
    }

    @Override
    public int getSendRange() {
        return 16;
    }

    @Override
    public boolean needsLineOfSightToReceiver(CrystalReceiver r) {
        return true;
    }

    @Override
    public boolean canTransmitTo(CrystalReceiver r) {
        return true;
    }

    @Override
    public boolean canReceiveFrom(CrystalTransmitter r) {
        return r instanceof TileEntityCrystalPylon && ((TileEntityCrystalPylon)r).hasBroadcastUpgrade();
    }

    @Override
    public final void drop() {
        ItemStack is = this.getTile().getCraftedProduct();
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        this.delete();
    }

    @Override
    public final boolean canDrop(EntityPlayer ep) {
        return ep.func_110124_au().equals(this.placerUUID);
    }

    @Override
    public boolean allowMining(EntityPlayer ep) {
        return this.canDrop(ep);
    }

    @Override
    public int getSignalDepth(CrystalElement e) {
        return this.depth;
    }

    @Override
    public void setSignalDepth(CrystalElement e, int d) {
        this.depth = d;
    }

    @Override
    public boolean checkConnectivity() {
        return false;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.IONOSPHERIC;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("multi");
        this.depth = NBT.func_74762_e("depth");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("multi", this.hasStructure);
        NBT.func_74768_a("depth", this.depth);
    }

    @Override
    public int getPathPriority() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean needsLineOfSightFromTransmitter(CrystalTransmitter r) {
        return false;
    }

    @Override
    public double getPylonRange() {
        return 8192.0;
    }

    @Override
    public int getThoughputBonus(boolean point) {
        return 0;
    }

    @Override
    public int getThoughputInsurance() {
        return 1000;
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
    }

    @Override
    public boolean canBeSuppliedBy(CrystalSource te, CrystalElement e) {
        return true;
    }
}

