/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Structure.BroadcasterStructure;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Magic.Interfaces.ConnectivityAction;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.NotifiedNetworkTile;
import Reika.ChromatiCraft.Magic.Network.CrystalLink;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalRepeater;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrystalBroadcaster
extends TileEntityCrystalRepeater
implements NotifiedNetworkTile,
ConnectivityAction,
MultiBlockChromaTile,
BreakAction {
    public static final int INTERFERENCE_RANGE = 384;
    public static final int MIN_RANGE = 512;
    public static final int BROADCAST_RANGE = 4096;
    public static final int GLASS_RANGE_H = 4;
    public static final int GLASS_RANGE_V = 2;
    private static final int AIR_SEARCH = 24;
    private static final int AIR_SEARCH_Y = 4;
    private WorldLocation interference;
    private FilledBlockArray structure;
    private boolean clearAir;
    private int glassPotential;
    private int glassBlocks;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.BROADCAST;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.validateStructure();
        this.checkInterfere();
        this.clearAir = !world.field_72995_K && this.testAirClear();
    }

    @Override
    public boolean needsLineOfSightToReceiver(CrystalReceiver r) {
        return !(r instanceof TileEntityCrystalBroadcaster);
    }

    @Override
    public boolean needsLineOfSightFromTransmitter(CrystalTransmitter r) {
        return !(r instanceof TileEntityCrystalBroadcaster);
    }

    @Override
    public int getSendRange() {
        return 4096;
    }

    @Override
    public int getReceiveRange() {
        return 4096;
    }

    @Override
    protected boolean checkForStructure() {
        ChromaStructures.BROADCAST.getStructure().resetToDefaults();
        this.structure = ChromaStructures.BROADCAST.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.glassPotential = ((BroadcasterStructure)ChromaStructures.BROADCAST.getStructure()).getGlassCount();
        return this.structure.matchInWorld();
    }

    @Override
    public boolean canConduct() {
        if (!super.canConduct()) {
            return false;
        }
        return this.interference == null && this.clearAir;
    }

    private boolean testAirClear() {
        int r = 8;
        int dd = 1;
        int c = 4;
        block0: for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            for (int d = 1; d <= r; d += dd) {
                int dx = this.field_145851_c + d * dir.offsetX;
                int dz = this.field_145849_e + d * dir.offsetZ;
                if (this.isAir(this.field_145850_b, dx, this.field_145848_d, dz)) continue;
                --c;
                continue block0;
            }
        }
        if (c < 2) {
            return false;
        }
        this.glassBlocks = 0;
        r = 24;
        int ry = 4;
        int c1 = 0;
        int c2 = 0;
        for (int i = -r; i <= r; ++i) {
            for (int j = -ry; j <= ry; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int dz;
                    int dy;
                    int dx;
                    if (Math.abs(i) <= 1 && Math.abs(k) <= 1 || this.structure.hasBlock(dx = this.field_145851_c + i, dy = this.field_145848_d + j, dz = this.field_145849_e + k)) continue;
                    ++c2;
                    if (!this.isAir(this.field_145850_b, dx, dy, dz)) continue;
                    ++c1;
                }
            }
        }
        return (double)((float)c1 / (float)c2) > 0.8;
    }

    private boolean isAir(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (b == ChromaBlocks.DIMGEN.getBlockInstance() && world.func_72805_g(x, y, z) == BlockDimensionDeco.DimDecoTypes.CLIFFGLASS.ordinal() && Math.abs(x - this.field_145851_c) <= 4 && Math.abs(y - this.field_145848_d) <= 2 && Math.abs(z - this.field_145849_e) <= 4) {
            ++this.glassBlocks;
            return true;
        }
        return false;
    }

    private void checkInterfere() {
        TileEntityCrystalBroadcaster te = (TileEntityCrystalBroadcaster)CrystalNetworker.instance.getNearestTileOfType(this, this.getClass(), 384.0);
        if (te != null) {
            this.interference = new WorldLocation((TileEntity)te);
            te.interference = new WorldLocation((TileEntity)this);
        } else {
            this.interference = null;
        }
    }

    public static void updateAirCaches(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            return;
        }
        Collection<TileEntityCrystalBroadcaster> c = CrystalNetworker.instance.getNearTilesOfType(world, x, y, z, TileEntityCrystalBroadcaster.class, 24);
        for (TileEntityCrystalBroadcaster te : c) {
            if (Math.abs(te.field_145848_d - y) > 4 || Math.abs(te.field_145851_c - x) > 24 || Math.abs(te.field_145849_e - z) > 24) continue;
            te.clearAir = te.testAirClear();
            te.syncAllData(true);
        }
    }

    @Override
    public void redirect(int side) {
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null;
    }

    @Override
    public int maxThroughput() {
        return this.isTurbocharged() ? 250000 : 100000;
    }

    @Override
    public int getSignalDegradation(boolean point) {
        int base;
        int n = base = this.isTurbocharged() ? 1500 : 3000;
        if (point) {
            base = (int)((double)base * 0.25);
        } else if (this.field_145850_b.func_72896_J()) {
            base *= 4;
        }
        return base;
    }

    @Override
    public void onPathConnected(CrystalPath p) {
    }

    @Override
    public boolean canTransmitTo(CrystalReceiver r) {
        if (r instanceof TileEntityCrystalBroadcaster) {
            return r.getDistanceSqTo(this.field_145851_c, this.field_145848_d, this.field_145849_e) >= 262144.0;
        }
        return true;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.interference = WorldLocation.readFromNBT((String)"interfere", (NBTTagCompound)NBT);
        this.clearAir = NBT.func_74767_n("air");
        this.glassBlocks = NBT.func_74762_e("glass");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.interference != null) {
            this.interference.writeToNBT("interfere", NBT);
        }
        NBT.func_74757_a("air", this.clearAir);
        NBT.func_74768_a("glass", this.glassBlocks);
    }

    @Override
    public void onTileNetworkTopologyChange(CrystalNetworkTile te, boolean remove) {
        if (te instanceof TileEntityCrystalBroadcaster) {
            this.checkInterfere();
        }
    }

    @Override
    public float getFailureWeight(CrystalElement e) {
        return 1.125f;
    }

    @Override
    public int getPathPriority() {
        return -50;
    }

    @Override
    public int getThoughputInsurance() {
        return this.isTurbocharged() ? 1000 : 500;
    }

    public void breakBlock() {
        TileEntity te;
        if (this.interference != null && (te = this.interference.getTileEntity()) instanceof TileEntityCrystalBroadcaster) {
            TileEntityCrystalBroadcaster tb = (TileEntityCrystalBroadcaster)te;
            if (tb.interference != null && tb.interference.equals(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                tb.interference = null;
            }
        }
    }

    @Override
    public void notifySendingTo(CrystalPath p, CrystalReceiver r) {
        this.onConnected(p.element);
    }

    @Override
    public void notifyReceivingFrom(CrystalPath p, CrystalTransmitter t) {
        this.onConnected(p.element);
    }

    private void onConnected(CrystalElement e) {
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.BROADCASTLINK.ordinal(), (TileEntity)this, (int)512, (int[])new int[]{e.ordinal()});
    }

    @SideOnly(value=Side.CLIENT)
    public void onConnectedParticles(CrystalElement e) {
        double soundDist = Math.max(8.0, 512.0 / Math.pow(1.05, this.glassBlocks));
        double dd = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)this.field_145851_c + 0.5, Minecraft.func_71410_x().field_71439_g.field_70163_u, (double)this.field_145849_e + 0.5);
        if (dd <= soundDist * soundDist) {
            double d = Math.sqrt(dd);
            float f = d < soundDist * 0.5 ? 1.0f : (float)(2.0 * (1.0 - d / soundDist));
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.REPEATERRING, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (float)f, (float)((float)CrystalMusicManager.instance.getDingPitchScale(e)), (boolean)false);
        }
        for (int i = 0; i < 128; ++i) {
            double r = ReikaRandomHelper.getRandomBetween((double)4.0, (double)8.0);
            double v = ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.75);
            double ang = rand.nextDouble() * 360.0;
            double px = (double)this.field_145851_c + 0.5 * r * Math.cos(Math.toRadians(ang));
            double py = (double)this.field_145848_d + rand.nextDouble();
            double pz = (double)this.field_145849_e + 0.5 * r * Math.sin(Math.toRadians(ang));
            double vx = v * Math.cos(Math.toRadians(ang));
            double vz = v * Math.sin(Math.toRadians(ang));
            float g = (float)ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.5);
            int l = ReikaRandomHelper.getRandomBetween((int)100, (int)400);
            float s = 2.0f + rand.nextFloat() * 2.0f;
            int c = ReikaColorAPI.mixColors((int)e.getColor(), (int)0xFFFFFF, (float)(0.5f + rand.nextFloat() * 0.5f));
            EntityCCBlurFX fx = new EntityCCBlurFX(this.field_145850_b, px, py, pz, vx, 0.0, vz);
            fx.setColor(c).setScale(s).setLife(l);
            switch (rand.nextInt(8)) {
                case 0: {
                    fx.setIcon(ChromaIcons.BIGFLARE);
                    break;
                }
                case 1: {
                    fx.setIcon(ChromaIcons.CENTER);
                    break;
                }
                case 2: {
                    fx.setIcon(ChromaIcons.SPINFLARE);
                    break;
                }
                case 3: {
                    fx.setIcon(ChromaIcons.FLARE);
                    break;
                }
                case 4: {
                    fx.setIcon(ChromaIcons.FLARE7);
                    break;
                }
                case 5: {
                    fx.setIcon(ChromaIcons.RINGFLARE);
                    break;
                }
                case 6: {
                    fx.setIcon(ChromaIcons.STARFLARE);
                    break;
                }
                case 7: {
                    fx.setIcon(ChromaIcons.BLURFLARE);
                }
            }
            fx.setGravity(g).setAlphaFading().setColliding().setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    protected boolean canBeRainAffected(CrystalLink l) {
        return false;
    }
}

