/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.Event.PylonEvents;
import Reika.ChromatiCraft.Base.TileEntity.CrystalTransmitterBase;
import Reika.ChromatiCraft.Block.BlockEncrustedCrystal;
import Reika.ChromatiCraft.Entity.EntityBallLightning;
import Reika.ChromatiCraft.Entity.EntityGlowCloud;
import Reika.ChromatiCraft.Entity.EntityOverloadingPylonShock;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.ChargingPoint;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.NaturalCrystalSource;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.ModInterface.MystPages;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBallLightningFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.ChromatiCraft.Render.Particle.EntityFlareFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityChromaCrystal;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityPylonTurboCharger;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCreativeSource;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityPylonLink;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityEMP;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.wands.IWandable;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;

@APIStripper.Strippable(value={"thaumcraft.api.nodes.INode", "thaumcraft.api.wands.IWandable"})
public class TileEntityCrystalPylon
extends CrystalTransmitterBase
implements NaturalCrystalSource,
ChargingPoint,
ChunkLoadingTile,
INode,
IWandable {
    private FilledBlockArray structure;
    private boolean hasMultiblock = false;
    private boolean enhanced = false;
    private boolean broadcast = false;
    private CrystalElement color = CrystalElement.WHITE;
    public int randomOffset = rand.nextInt(360);
    public static final int MAX_ENERGY = 180000;
    private static final Collection<Coordinate> crystalPositions = new HashSet<Coordinate>();
    private static Class node;
    private static HashMap<String, ArrayList<Integer>> nodeCache;
    public static final int MAX_ENERGY_ENHANCED = 900000;
    private int energy = 180000;
    private int energyStep = 1;
    private long lastWorldTick;
    private boolean forceLoad;
    private boolean placedByHand = false;
    public static final int RANGE = 48;
    public static final boolean TUNED_PYLONS = true;
    public boolean enhancing = false;
    private boolean destabilized = false;
    public static final int MAX_ATTACK_DELAY = 80;
    public static final int MIN_ATTACK_DELAY = 12;
    private long lastAttackTime = -1L;
    private int minTicksBetweenAttack = 80;
    private WorldLocation linkTile;
    private final HashSet<Coordinate> encrustedBlocks = new HashSet();

    public static Collection<Coordinate> getPowerCrystalLocations() {
        return Collections.unmodifiableCollection(crystalPositions);
    }

    public void destabilize() {
        this.destabilized = true;
    }

    public boolean isUnstable() {
        return this.destabilized;
    }

    public void link(TileEntityPylonLink te) {
        this.linkTile = te == null ? null : new WorldLocation((TileEntity)te);
        this.syncAllData(true);
        if (te != null) {
            PylonGenerator.instance.cachePylon(this);
        }
    }

    public void markPlaced() {
        this.placedByHand = true;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.PYLON;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e == this.color;
    }

    @Override
    public boolean needsLineOfSightToReceiver(CrystalReceiver r) {
        return !this.hasBroadcastUpgrade();
    }

    public CrystalElement getColor() {
        return this.color;
    }

    @Override
    public int getEnergy(CrystalElement e) {
        return e == this.color ? this.energy : 0;
    }

    public int getRenderColor() {
        return ReikaColorAPI.mixColors((int)this.color.getColor(), (int)0x888888, (float)((float)this.energy / (float)this.getCapacity()));
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        PylonGenerator.instance.cachePylon(this);
        if (ChromaOptions.PYLONLOAD.getState()) {
            if (this.forceLoad && this.getEnergy(this.color) < this.getMaxStorage(this.color) && this.hasStructure()) {
                ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
            } else {
                this.forceLoad = false;
                this.unload();
            }
        } else {
            this.forceLoad = false;
            this.unload();
        }
        if (ModList.THAUMCRAFT.isLoaded() && nodeCache != null) {
            ArrayList<Integer> li = new ArrayList<Integer>();
            li.add(world.field_73011_w.field_76574_g);
            li.add(x);
            li.add(y);
            li.add(z);
            nodeCache.put(this.getId(), li);
        }
    }

    private void reloadEncrusted(World world, int x, int y, int z) {
        for (Coordinate c : this.structure.keySet()) {
            for (Coordinate c2 : c.getAdjacentCoordinates()) {
                if (this.structure.hasBlock(c2) || c2.getBlock((IBlockAccess)world) != ChromaBlocks.ENCRUSTED.getBlockInstance()) continue;
                this.encrustedBlocks.add(c2);
            }
        }
    }

    private void updateLinkColor(World world, int x, int y, int z) {
        if (this.linkTile != null) {
            TileEntityPylonLink te = (TileEntityPylonLink)this.linkTile.getTileEntity((IBlockAccess)world);
            if (te == null) {
                world.func_147465_d(this.linkTile.xCoord, this.linkTile.yCoord, this.linkTile.zCoord, ChromaTiles.PYLONLINK.getBlock(), ChromaTiles.PYLONLINK.getBlockMetadata(), 2);
            }
            te = (TileEntityPylonLink)this.linkTile.getTileEntity((IBlockAccess)world);
            te.link();
        }
    }

    private void forceLoading() {
        if (!this.forceLoad && ChromaOptions.PYLONLOAD.getState()) {
            this.forceLoad = true;
            ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
        }
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.hasMultiblock && this.structure == null) {
            this.structure = ChromaStructures.PYLON.getArray(world, x, y, z, this.getColor());
        }
        if (this.structure != null && this.getTicksExisted() == 0) {
            this.reloadEncrusted(world, x, y, z);
            this.updateLinkColor(world, x, y, z);
        }
        if (DragonAPICore.debugtest && !this.hasMultiblock) {
            CrystalElement e = CrystalElement.randomElement();
            FilledBlockArray b = ChromaStructures.PYLON.getArray(world, x, y, z, e);
            b.place();
            this.color = e;
            this.hasMultiblock = true;
            this.syncAllData(true);
        }
        if (!world.func_147439_a(x, y - 1, z).isAir((IBlockAccess)world, x, y - 1, z) && ReikaWorldHelper.isBlockEncased((World)world, (int)x, (int)y, (int)z, null)) {
            this.doJarRejection(world, x, y, z);
        }
        if (this.isUnstable() && !world.field_72995_K) {
            this.doDestabilizedTick(world, x, y, z);
        }
        long diff = world.func_82737_E() - this.lastWorldTick;
        this.lastWorldTick = world.func_82737_E();
        if (this.hasMultiblock) {
            int n;
            int max = this.getCapacity();
            if (diff > 0L) {
                TileEntityPylonLink te;
                if (this.energy >= max / 2 && (te = this.getLinkTile()) != null) {
                    Collection<WorldLocation> c = te.getLinkedPylons();
                    for (WorldLocation loc : c) {
                        TileEntity tile2;
                        if (loc.equals(world, x, y, z) || !((tile2 = loc.getTileEntity()) instanceof TileEntityCrystalPylon)) continue;
                        TileEntityCrystalPylon tp = (TileEntityCrystalPylon)tile2;
                        if (tp.color != this.color) continue;
                        int amt = Math.min(this.getDonatedRecharge(), tp.getCapacity() - tp.energy);
                        tp.energy += amt;
                        this.energy -= amt;
                    }
                }
                this.charge(world, x, y, z, max, Math.max(1, (int)diff));
            }
            if (world.field_72995_K) {
                this.spawnParticle(world, x, y, z);
            }
            if (!world.field_72995_K && ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && MystPages.Pages.UNSTABLEPYLONS.existsInWorld(world) && rand.nextInt(2000) == 0) {
                this.destabilize();
            }
            if (!world.field_72995_K) {
                int rate = this.getAttackRate(world);
                if (rand.nextInt(rate) == 0) {
                    boolean canAttack;
                    boolean bl = canAttack = world.func_82737_E() - this.lastAttackTime >= (long)this.minTicksBetweenAttack;
                    if (canAttack) {
                        int r = this.getAttackRange();
                        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b((double)r, (double)r, (double)r);
                        this.attackEntitiesInBox(world, x, y, z, box);
                    }
                }
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(1.0, 6.0, 1.0);
                box = box.func_72321_a(0.0, 32.0, 0.0);
                for (EntityPlayer ep : world.field_73010_i) {
                    int d;
                    if (ep.field_71075_bZ.field_75098_d || Chromabilities.PYLON.enabledOn(ep) || ep.field_70172_ad > rand.nextInt(11 - (d = (int)MathHelper.func_151237_a((double)(Math.abs(ep.field_70163_u - (double)y - 0.5) / 6.0), (double)1.0, (double)10.0))) || !ep.field_70121_D.func_72326_a(box) || !PylonFinder.lineOfSight((World)world, (int)x, (int)y, (int)z, (Entity)ep, (Block[])new Block[0]).hasLineOfSight) continue;
                    this.attackEntity((EntityLivingBase)ep, false);
                    ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FIREDUMPSHOCK.ordinal(), (World)world, (int)x, (int)y, (int)z, (int)64, (int[])new int[]{this.color.ordinal(), ep.func_145782_y(), Float.floatToRawIntBits(1.5f)});
                    if (!(ep instanceof EntityPlayerMP)) continue;
                    ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.PYLONATTACKRECEIVE.ordinal(), (TileEntity)this, (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{this.getColor().ordinal()});
                }
                this.minTicksBetweenAttack = Math.min(this.minTicksBetweenAttack + 1, 80);
            }
            float f = this.isEnhanced() ? 1.125f : 1.0f;
            f = (float)((double)f * CrystalMusicManager.instance.getDingPitchScale(this.color));
            if (this.getTicksExisted() % (int)(72.0f / f) == 0) {
                ChromaSounds.POWER.playSoundAtBlock((TileEntity)this, 1.0f, f);
            }
            int n2 = this.isUnstable() ? 12 : (n = this.isEnhanced() ? 24 : 36);
            if (world.field_72995_K && rand.nextInt(n) == 0) {
                this.spawnLightning(world, x, y, z);
            }
            if (!world.field_72995_K && ChromaOptions.BALLLIGHTNING.getState() && this.energy >= this.getCapacity() / 2 && rand.nextInt(1000) == 0 && ReikaWorldHelper.isRadiusLoaded((World)world, (int)x, (int)z, (int)2) && EntityBallLightning.canSpawnHere(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) {
                world.func_72838_d((Entity)new EntityBallLightning(world, this.color, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5).setPylon().setNoDrops());
            }
            this.energy = Math.max(0, Math.min(this.energy, max));
            if (!world.field_72995_K && this.hasMultiblock && this.energy == this.getCapacity() && !this.isEnhanced() && !this.isEnhancing() && !this.isUnstable() && this.getBoosterCrystals(world, max, y, z, false).isEmpty()) {
                if (rand.nextInt(120) == 0) {
                    this.tryGrowEncrusted(world, x, y, z);
                }
                int r = 12;
                Coordinate c1 = new Coordinate((TileEntity)this).offset(0, -9, 0);
                Coordinate c = c1.offset(ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r), ReikaRandomHelper.getRandomPlusMinus((int)0, (int)2), ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r));
                if (c.getTaxicabDistanceTo(c1) >= 4 && !this.structure.hasBlock(c) && c.getBlock((IBlockAccess)world) == ChromaBlocks.PYLONSTRUCT.getBlockInstance()) {
                    Coordinate c2 = c.offset(ReikaDirectionHelper.getRandomDirection((boolean)true, (Random)rand), 1);
                    this.tryGrowEncrustedAt(world, c, c2, false);
                }
            }
        }
    }

    private void attackEntitiesInBox(World world, int x, int y, int z, AxisAlignedBB box) {
        List li = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            boolean attack;
            boolean bl = attack = !e.field_70128_L && e.func_110143_aJ() > 0.0f;
            if (e instanceof EntityPlayer) {
                EntityPlayer ep = (EntityPlayer)e;
                attack = attack && !ep.field_71075_bZ.field_75098_d && !Chromabilities.PYLON.enabledOn(ep);
            } else if (e instanceof EntityBallLightning) {
                attack = ((EntityBallLightning)e).getElement() != this.color;
            } else if (e.getClass().getName().equals("openblocks.common.entity.EntityLuggage")) {
                attack = false;
            }
            if (!attack) continue;
            this.attackEntity(e, true);
            this.sendClientAttack(this, e);
        }
    }

    private void tryGrowEncrusted(World world, int x, int y, int z) {
        Coordinate c = this.structure.getRandomBlock();
        Coordinate c2 = c.offset(ReikaDirectionHelper.getRandomDirection((boolean)true, (Random)rand), 1);
        this.tryGrowEncrustedAt(world, c, c2, c.getBlock((IBlockAccess)world) != ChromaBlocks.RUNE.getBlockInstance());
    }

    private void tryGrowEncrustedAt(World world, Coordinate from, Coordinate c, boolean addToCount) {
        if (!this.structure.hasBlock(c)) {
            Block b = c.getBlock((IBlockAccess)world);
            if (this.isEncrustedGrowable(world, c, b) && (!addToCount || this.encrustedBlocks.size() < 6)) {
                this.growEncrustedAt(world, from, c.xCoord, c.yCoord, c.zCoord, true, addToCount);
            } else if (b == ChromaBlocks.ENCRUSTED.getBlockInstance() && c.getBlockMetadata((IBlockAccess)world) == this.getColor().ordinal()) {
                this.growEncrustedAt(world, from, c.xCoord, c.yCoord, c.zCoord, false, addToCount);
            }
        }
    }

    private boolean isEncrustedGrowable(World world, Coordinate c, Block b) {
        return b.isAir((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) || b == Blocks.field_150431_aC;
    }

    private void growEncrustedAt(World world, Coordinate from, int x, int y, int z, boolean place, boolean addToCount) {
        BlockEncrustedCrystal.TileCrystalEncrusted te;
        boolean special = x == this.field_145851_c && y == this.field_145848_d - 8 && z == this.field_145849_e;
        int growth = 1;
        if (place) {
            world.func_147465_d(x, y, z, ChromaBlocks.ENCRUSTED.getBlockInstance(), this.getColor().ordinal(), 3);
            for (Coordinate c : crystalPositions) {
                if (!c.equals(x - this.field_145851_c, y - this.field_145848_d, z - this.field_145849_e)) continue;
                special = true;
                growth = 4;
                break;
            }
            if (from.getBlock((IBlockAccess)world) == ChromaBlocks.RUNE.getBlockInstance()) {
                growth = 2;
            }
            if (addToCount) {
                this.encrustedBlocks.add(new Coordinate(x, y, z));
            }
        }
        if ((te = (BlockEncrustedCrystal.TileCrystalEncrusted)world.func_147438_o(x, y, z)) == null) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            this.encrustedBlocks.remove(new Coordinate(x, y, z));
            return;
        }
        te.markReady();
        if (special) {
            te.makeSpecial();
        }
        if (!te.grow(world, x, y, z) && te.getGrowths().isEmpty()) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            if (addToCount) {
                this.encrustedBlocks.remove(new Coordinate((TileEntity)te));
            }
        }
    }

    private TileEntityPylonLink getLinkTile() {
        if (this.linkTile != null) {
            TileEntity tile = this.linkTile.getTileEntity();
            return tile instanceof TileEntityPylonLink ? (TileEntityPylonLink)tile : null;
        }
        return null;
    }

    public UUID getLinkTileUUID() {
        TileEntityPylonLink te = this.getLinkTile();
        return te != null ? te.getUUID() : null;
    }

    private int getAttackRate(World world) {
        int base = 80;
        if (this.isUnstable()) {
            base /= 8;
        }
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && MystPages.Pages.VIOLENTPYLONS.existsInWorld(world)) {
            base /= 4;
        }
        return base;
    }

    private void doDestabilizedTick(World world, int x, int y, int z) {
        if (rand.nextInt(40) == 0) {
            this.sendRandomShock(world, true, 8);
        }
        if (rand.nextInt(120) == 0) {
            ArrayList<TileEntityCrystalPylon> li = CrystalNetworker.instance.getAllNearbyPylons(this, 128.0, true);
            while (!li.isEmpty()) {
                int idx = rand.nextInt(li.size());
                TileEntityCrystalPylon te = li.remove(idx);
                if (!te.hasStructure() || te.isUnstable()) continue;
                this.shortCircuitWith(world, x, y, z, te);
                break;
            }
        }
        if (rand.nextInt(1000) == 0) {
            this.destabilized = false;
            this.destroyPowerCrystals(1 + rand.nextInt(8));
            world.func_72885_a(null, (double)x + 0.5 - 1.0 + (double)rand.nextInt(3), (double)y + 0.5 - 1.0, (double)z + 0.5 - 1.0 + (double)rand.nextInt(3), 4.0f, true, true);
        }
    }

    public void sendRandomShock(World world, boolean canJumpColors, int dmg) {
        LinkedList<CrystalNetworkTile> li = CrystalNetworker.instance.findPathToRandomReceiverFromSource(this, (CrystalElement)(canJumpColors && rand.nextInt(2) == 0 ? null : this.color), false);
        if (li.size() > 1) {
            ArrayList<Coordinate> li2 = new ArrayList<Coordinate>();
            for (CrystalNetworkTile te : li) {
                li2.add(new Coordinate(te.getX(), te.getY(), te.getZ()));
            }
            CrystalReceiver r = (CrystalReceiver)li.getLast();
            Collections.reverse(li);
            CrystalPath p = PylonFinder.convertTileListToPath(li, this.color);
            double sp = EntityOverloadingPylonShock.getRandomSpeed();
            int l = (int)(sp * (double)li.size());
            p.blink(l, r);
            world.func_72838_d((Entity)new EntityOverloadingPylonShock(world, this, li2, sp, dmg));
        }
    }

    private void shortCircuitWith(World world, int x, int y, int z, TileEntityCrystalPylon te) {
        double sp = EntityOverloadingPylonShock.getRandomSpeed();
        int l = (int)sp;
        this.addSelfTickingTarget(new WorldLocation((TileEntity)te), this.color, 0.0, 0.0, 0.0, this.getOutgoingBeamRadius() * 2.5, Double.POSITIVE_INFINITY, l);
        ArrayList li = ReikaJavaLibrary.makeListFrom((Object[])new Coordinate[]{new Coordinate((TileEntity)this), new Coordinate((TileEntity)te)});
        world.func_72838_d((Entity)new EntityOverloadingPylonShock(world, this, li, sp, 1));
        if (te.getColor() != this.color) {
            this.addSelfTickingTarget(new WorldLocation((TileEntity)te), te.getColor(), 0.0, 0.0, 0.0, te.getOutgoingBeamRadius() * 2.5, Double.POSITIVE_INFINITY, l);
            if (rand.nextInt(8) == 0) {
                te.destabilize();
            }
        }
    }

    private int getDonatedRecharge() {
        return Math.min(this.energy / 2, this.isEnhanced() ? 500 : 100);
    }

    private int getAttackRange() {
        return (this.isEnhancing() ? 16 : (this.isEnhanced() ? 12 : 8)) + rand.nextInt(this.isEnhancing() ? 16 : 8);
    }

    private float getAttackDensity() {
        return 1.0f - (float)(this.minTicksBetweenAttack - 12) / 68.0f;
    }

    private boolean isEnhancing() {
        if (ChromaTiles.getTile((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 8, this.field_145849_e) == ChromaTiles.PYLONTURBO) {
            TileEntityPylonTurboCharger te = (TileEntityPylonTurboCharger)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 8, this.field_145849_e);
            return te.getTick() > 0;
        }
        return false;
    }

    private void doJarRejection(World world, int x, int y, int z) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)dy, (int)dz, (Block)world.func_147439_a(dx, dy, dz));
                    world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                }
            }
        }
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)2.0f, (float)0.5f);
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)2.0f, (float)1.0f);
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)2.0f, (float)2.0f);
        ChromaSounds.DISCHARGE.playSoundAtBlockNoAttenuation((TileEntity)this, 2.0f, 0.5f, 64);
        ChromaSounds.DISCHARGE.playSoundAtBlockNoAttenuation((TileEntity)this, 2.0f, 1.0f, 64);
        ChromaSounds.DISCHARGE.playSoundAtBlockNoAttenuation((TileEntity)this, 2.0f, 2.0f, 64);
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(16.0, 16.0, 16.0);
        List li = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            double dx = e.field_70165_t - (double)x - 0.5;
            double dy = e.field_70163_u - (double)y - 0.5;
            double dz = e.field_70161_v - (double)z - 0.5;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            double v = 10.0;
            double vy = 3.0;
            e.func_70024_g(v * dx / dd, vy + 0.0 * Math.max(v * dy / dd, vy), v * dz / dd);
            e.field_70143_R = 250.0f;
            if (!(e instanceof EntityPlayer)) continue;
            ((EntityPlayer)e).field_71075_bZ.field_75101_c = false;
            ((EntityPlayer)e).field_71075_bZ.field_75100_b = false;
        }
        if (!world.field_72995_K) {
            int n = 8 + rand.nextInt(12);
            for (int i = 0; i < n; ++i) {
                int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)12);
                int ry = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)4);
                int rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)12);
                ReikaWorldHelper.ignite((World)world, (int)rx, (int)ry, (int)rz);
            }
            if (rand.nextBoolean()) {
                this.destroyPowerCrystals(1);
            }
        } else {
            this.doJarRejectionParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doJarRejectionParticles(World world, int x, int y, int z) {
        int i;
        ReikaParticleHelper.EXPLODE.spawnAroundBlockWithOutset(world, x, y, z, 0.0, 0.0, 0.0, 16, 0.25);
        for (i = 0; i < 256; ++i) {
            EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, rand.nextDouble() * 360.0, -90.0 + rand.nextDouble() * 180.0);
            fx.setColor(this.color.getColor()).setScale(2.0f + rand.nextFloat() * 8.0f).setLife(40 + rand.nextInt(120));
            fx.particleVelocity = 0.5;
            fx.angleVelocity *= 2.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < 16; ++i) {
            this.spawnLightning(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnLightning(World world, int x, int y, int z) {
        EntityBallLightningFX e = new EntityBallLightningFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.color);
        e.setVelocity(0.125, rand.nextInt(360), 0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)e);
    }

    public void destroyPowerCrystals(int n) {
        ArrayList<TileEntityChromaCrystal> crys = this.getBoosterCrystals(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        for (int i = 0; i < n && !crys.isEmpty(); ++i) {
            int idx = rand.nextInt(crys.size());
            crys.get(idx).destroy();
            crys.remove(idx);
        }
    }

    private void charge(World world, int x, int y, int z, int max, int ticks) {
        int laste = this.energy;
        boolean lastconn = this.canConduct();
        if (this.energy < max) {
            this.energy += this.energyStep * ticks;
        }
        int a = ticks;
        if (this.energy < max) {
            ArrayList<TileEntityChromaCrystal> blocks = this.getBoosterCrystals(world, x, y, z, true);
            int c = this.isEnhanced() ? 3 : 2;
            for (int i = 0; i < blocks.size(); ++i) {
                this.energy += a * this.energyStep;
                a *= c;
                if (i == 7) {
                    this.energy += a * 2 * this.energyStep;
                }
                if (this.energy >= max) break;
            }
            if (blocks.size() == 8) {
                ProgressStage.POWERCRYSTAL.stepPlayerTo(blocks.get(0).getPlacer());
            }
            if (world.field_72995_K && !blocks.isEmpty()) {
                this.spawnRechargeParticles(world, x, y, z, blocks);
            }
        }
        if (this.energyStep > 1) {
            --this.energyStep;
        }
        this.energy = Math.min(this.energy, this.getCapacity());
        if (this.energy == this.getCapacity() && laste != this.getCapacity()) {
            MinecraftForge.EVENT_BUS.post((Event)new PylonEvents.PylonFullyChargedEvent(this));
            this.unload();
        }
        if (this.canConduct() && !lastconn) {
            MinecraftForge.EVENT_BUS.post((Event)new PylonEvents.PylonRechargedEvent(this));
        }
    }

    public void speedRegenShortly(int power) {
        this.energyStep = power;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnRechargeParticles(World world, int x, int y, int z, ArrayList<TileEntityChromaCrystal> blocks) {
        int i = 0;
        for (TileEntityChromaCrystal te : blocks) {
            int dx = te.field_145851_c;
            int dy = te.field_145848_d;
            int dz = te.field_145849_e;
            double ddx = dx - x;
            double ddy = (double)(dy - y) - 0.25;
            double ddz = dz - z;
            double dd = ReikaMathLibrary.py3d((double)ddx, (double)ddy, (double)ddz);
            double v = 0.125;
            double vx = -v * ddx / dd;
            double vy = -v * ddy / dd;
            double vz = -v * ddz / dd;
            double px = (double)dx + 0.5;
            double py = (double)dy + 0.125;
            double pz = (double)dz + 0.5;
            float sc = (float)(2.0 + Math.sin(4.0 * Math.toRadians(this.getTicksExisted() + i * 90 / blocks.size())));
            EntityBlurFX fx = new EntityCCBlurFX(this.color, world, px, py, pz, vx, vy, vz).setScale(sc).setLife(38).setNoSlowdown();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            ++i;
        }
    }

    public BlockArray getRuneLocations(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        blocks.addBlockCoordinate(x - 3, y - 4, z - 1);
        blocks.addBlockCoordinate(x - 1, y - 4, z - 3);
        blocks.addBlockCoordinate(x + 3, y - 4, z - 1);
        blocks.addBlockCoordinate(x + 1, y - 4, z - 3);
        blocks.addBlockCoordinate(x - 3, y - 4, z + 1);
        blocks.addBlockCoordinate(x - 1, y - 4, z + 3);
        blocks.addBlockCoordinate(x + 3, y - 4, z + 1);
        blocks.addBlockCoordinate(x + 1, y - 4, z + 3);
        return blocks;
    }

    public ArrayList<TileEntityChromaCrystal> getBoosterCrystals(World world, int x, int y, int z, boolean matchOwner) {
        ArrayList<TileEntityChromaCrystal> li = new ArrayList<TileEntityChromaCrystal>();
        EntityPlayer owner = null;
        for (Coordinate c : crystalPositions) {
            if (!world.func_72904_c(c.xCoord + x, c.yCoord + y, c.zCoord + z, c.xCoord + x, c.yCoord + y, c.zCoord + z) || ChromaTiles.getTile((IBlockAccess)world, x + c.xCoord, y + c.yCoord, z + c.zCoord) != ChromaTiles.CRYSTAL) continue;
            TileEntityChromaCrystal te = (TileEntityChromaCrystal)world.func_147438_o(x + c.xCoord, y + c.yCoord, z + c.zCoord);
            EntityPlayer ep = te.getPlacer();
            if (matchOwner && (ep == null || owner != null && ep != owner)) continue;
            if (owner == null) {
                owner = ep;
            }
            li.add(te);
        }
        return li;
    }

    public boolean isValidPowerCrystal(TileEntityChromaCrystal te) {
        return crystalPositions.contains(new Coordinate((TileEntity)te).offset(-this.field_145851_c, -this.field_145848_d, -this.field_145849_e));
    }

    public void onPowerCrystalBreak(TileEntityChromaCrystal te) {
        this.disenhance();
        this.drain(this.color, this.energy / 4);
        this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5));
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(24.0, 16.0, 24.0);
        List li = this.field_145850_b.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            if (e instanceof EntityPlayer) {
                if (((EntityPlayer)e).field_71075_bZ.field_75098_d) {
                    e.func_70097_a(DamageSource.field_76380_i, 0.001f);
                    continue;
                }
                float amt = Math.max(5.0f, Math.min(e.func_110143_aJ() - 4.0f, e.func_110138_aP() * 0.75f));
                ChromaAux.doPylonAttack(this.color, e, amt);
                ChromaSounds.DISCHARGE.playSound(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, 1.0f, 1.0f);
                continue;
            }
            e.func_70097_a(DamageSource.field_76376_m, 0.0f);
        }
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.PYLONCRYSTALBREAK.ordinal(), (TileEntity)this, (int)64, (int[])new int[0]);
        this.syncAllData(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void doPowerCrystalBreakFX(World world, int x, int y, int z) {
        int n = 24 + rand.nextInt(32);
        for (int i = 0; i < n; ++i) {
            float s = 1.0f + rand.nextFloat() * 2.0f;
            int l = 30 + rand.nextInt(50);
            EntityBlurFX fx = new EntityCCFloatingSeedsFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, rand.nextDouble() * 360.0, rand.nextDouble() * 360.0, ChromaIcons.NODE2).setColor(this.color.getColor()).setScale(s).setLife(l);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DISCHARGE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)1.0f, (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    public void particleAttack(int sx, int sy, int sz, int x, int y, int z) {
        int n = 8 + rand.nextInt(24);
        for (int i = 0; i < n; ++i) {
            float rx = (float)sx + rand.nextFloat();
            float ry = (float)sy + rand.nextFloat();
            float rz = (float)sz + rand.nextFloat();
            double dx = x - sx;
            double dy = y - sy;
            double dz = z - sz;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            double vx = 2.0 * dx / dd;
            double vy = 2.0 * dy / dd;
            double vz = 2.0 * dz / dd;
            EntityFlareFX f = new EntityFlareFX(this.color, this.field_145850_b, rx, ry, rz, vx, vy, vz).setNoGravity();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)f);
        }
    }

    void attackEntity(EntityLivingBase e, boolean sound) {
        if (sound) {
            ChromaSounds.DISCHARGE.playSoundAtBlock((TileEntity)this);
            ChromaSounds.DISCHARGE.playSound((Entity)e);
        }
        ChromaAux.doPylonAttack(this.color, e, Math.max(this.isEnhanced() ? 10.0f : 5.0f, e.func_110143_aJ() / 4.0f), true, 0, true);
        PotionEffect eff = CrystalPotionController.instance.getEffectFromColor(this.color, 200, 2, false);
        if (eff != null) {
            e.func_70690_d(eff);
        }
        if (e instanceof EntityPlayer) {
            this.minTicksBetweenAttack = Math.max(this.minTicksBetweenAttack - ReikaRandomHelper.getRandomBetween((int)18, (int)60), 12);
        } else if (e instanceof EntityGlowCloud) {
            ((EntityGlowCloud)e).aimAwayFrom(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25);
        }
    }

    private void sendClientAttack(CrystalTransmitter te, EntityLivingBase e) {
        int tx = te.getX();
        int ty = te.getY();
        int tz = te.getZ();
        int x = MathHelper.func_76128_c((double)e.field_70165_t);
        int y = MathHelper.func_76128_c((double)e.field_70163_u) + 1;
        int z = MathHelper.func_76128_c((double)e.field_70161_v);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.PYLONATTACK.ordinal(), (World)te.getWorld(), (int)tx, (int)ty, (int)tz, (int)128, (int[])new int[]{tx, ty, tz, x, y, z});
        if (e instanceof EntityPlayerMP) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.PYLONATTACKRECEIVE.ordinal(), (TileEntity)this, (EntityPlayerMP)((EntityPlayerMP)e), (int[])new int[]{this.getColor().ordinal()});
        }
    }

    public void invalidateMultiblock() {
        if (this.hasMultiblock) {
            ChromaSounds.POWERDOWN.playSoundAtBlock((TileEntity)this);
            ChromaSounds.POWERDOWN.playSound(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 2.0f);
            ChromaSounds.POWERDOWN.playSound(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 0.5f);
            if (this.field_145850_b.field_72995_K) {
                this.invalidatationParticles();
            }
        }
        this.structure = null;
        this.hasMultiblock = false;
        this.unload();
        this.clearTargets(false);
        this.energy = 0;
        this.syncAllData(true);
        PylonGenerator.instance.cachePylon(this);
    }

    @SideOnly(value=Side.CLIENT)
    private void invalidatationParticles() {
        double d = 1.25;
        int n = 64 + rand.nextInt(64);
        for (int i = 0; i < n; ++i) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145851_c + 0.5), (double)d);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145848_d + 0.5), (double)d);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145849_e + 0.5), (double)d);
            double vx = rand.nextDouble() - 0.5;
            double vy = rand.nextDouble() - 0.5;
            double vz = rand.nextDouble() - 0.5;
            EntityRuneFX fx = new EntityRuneFX(this.field_145850_b, rx, ry, rz, vx, vy, vz, this.color);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public void validateMultiblock(FilledBlockArray struct) {
        this.hasMultiblock = true;
        this.structure = struct;
        this.broadcast = !this.field_145850_b.field_72995_K && ChromaStructures.PYLONBROADCAST.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.color).matchInWorld();
        this.syncAllData(true);
        PylonGenerator.instance.cachePylon(this);
    }

    public boolean hasStructure() {
        return this.hasMultiblock;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticle(World world, int x, int y, int z) {
        int p = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (rand.nextInt(1 + p / 2) == 0) {
            float dt = this.getAttackDensity();
            for (float n = 1.0f + dt * 2.0f; n > 0.0f && !(rand.nextFloat() > n); n -= 1.0f) {
                double d = 1.25;
                double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)d);
                double ry = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5), (double)d);
                double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)d);
                EntityFlareFX fx = new EntityFlareFX(this.color, world, rx, ry, rz, 0.6f + dt * 0.15f);
                fx.setScale(3.0f + dt * 1.5f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        if (this.isEnhanced()) {
            int n = 2 + (int)Math.sin(Math.toRadians(this.getTicksExisted()));
            for (int i = 0; i < n; ++i) {
                float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)2.0, (double)1.0);
                int l = 10 + rand.nextInt(50);
                EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, rand.nextInt(360), ReikaRandomHelper.getRandomPlusMinus((int)0, (int)90));
                fx.fadeColors(ReikaColorAPI.mixColors((int)this.color.getColor(), (int)0xFFFFFF, (float)0.375f), this.color.getColor()).setScale(s).setLife(l).setRapidExpand();
                fx.freedom *= 3.0;
                fx.angleVelocity *= 3.0;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.color = CrystalElement.elements[NBT.func_74762_e("color")];
        this.hasMultiblock = NBT.func_74767_n("multi");
        this.energy = NBT.func_74762_e("energy");
        this.enhanced = NBT.func_74767_n("enhance");
        this.broadcast = NBT.func_74767_n("broadcast");
        this.destabilized = NBT.func_74767_n("unstable");
        this.minTicksBetweenAttack = NBT.func_74762_e("attackDelay");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("color", this.color.ordinal());
        NBT.func_74757_a("multi", this.hasMultiblock);
        NBT.func_74768_a("energy", this.energy);
        NBT.func_74757_a("enhance", this.enhanced);
        NBT.func_74757_a("broadcast", this.broadcast);
        NBT.func_74757_a("unstable", this.destabilized);
        NBT.func_74768_a("attackDelay", this.minTicksBetweenAttack);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74757_a("load", this.forceLoad);
        NBT.func_74757_a("placed", this.placedByHand);
        if (this.linkTile != null) {
            this.linkTile.writeToNBT("link", NBT);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.forceLoad = NBT.func_74767_n("load");
        this.placedByHand = NBT.func_74767_n("placed");
        if (NBT.func_74764_b("link")) {
            this.linkTile = WorldLocation.readFromNBT((String)"link", (NBTTagCompound)NBT);
        }
    }

    @Override
    public int getSendRange() {
        return 48;
    }

    @Override
    public boolean canConduct() {
        return this.hasMultiblock && (this.energy >= 5000 || this.energy > 10 && !this.getTargets().isEmpty());
    }

    @Override
    public int maxThroughput() {
        int base = this.getBaseThroughput();
        int thresh = this.getCapacity() / 4;
        return this.energy >= thresh ? this.getLinkedThroughput(base) : this.getReducedThroughput(thresh, base);
    }

    private int getBaseThroughput() {
        return this.isEnhanced() ? 18000 : 6000;
    }

    private int getLinkedThroughput(int base) {
        TileEntityPylonLink te = this.getLinkTile();
        if (te != null) {
            Collection<WorldLocation> c = te.getLinkedPylons();
            for (WorldLocation loc : c) {
                TileEntity tile2;
                if (loc.equals(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) || !((tile2 = loc.getTileEntity()) instanceof TileEntityCrystalPylon)) continue;
                TileEntityCrystalPylon tp = (TileEntityCrystalPylon)tile2;
                if (tp.color != this.color) continue;
                base += tp.getBaseThroughput();
            }
        }
        return base;
    }

    private int getReducedThroughput(int thresh, int max) {
        if (this.energy == 0) {
            return 0;
        }
        int sigx = this.energy / (thresh / 12) - 6;
        int sig = (int)((double)max / (1.0 + Math.pow(Math.E, -sigx)));
        return Math.max(1, Math.min(this.energy - 1, sig - 10));
    }

    public void generateColor(CrystalElement e) {
        this.color = e;
    }

    public void setColor(CrystalElement e) {
        this.color = e;
        this.forceCrystalColorMatch();
    }

    public Set<Coordinate> getEncrustedCrystals() {
        return Collections.unmodifiableSet(this.encrustedBlocks);
    }

    public void forceCrystalColorMatch() {
        for (Coordinate c : this.encrustedBlocks) {
            if (c.getBlock((IBlockAccess)this.field_145850_b) != ChromaBlocks.ENCRUSTED.getBlockInstance()) continue;
            BlockEncrustedCrystal.setColor(this.field_145850_b, c.xCoord, c.yCoord, c.zCoord, this.color);
        }
    }

    @Override
    public boolean drain(CrystalElement e, int amt) {
        if (e == this.color && this.energy >= amt && amt > 0) {
            if (ModList.MYSTCRAFT.isLoaded() && MystPages.Pages.LOSSY.existsInWorld(this.field_145850_b)) {
                amt = amt * 3 / 2;
            }
            this.energy -= amt;
            this.energy = Math.max(this.energy, 0);
            if (this.energy <= 0) {
                MinecraftForge.EVENT_BUS.post((Event)new PylonEvents.PylonDrainedEvent(this));
            }
            return true;
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public AspectList getAspects() {
        AspectList as = new AspectList();
        int n = this.isEnhanced() ? 6000 : 400;
        as.add(Aspect.AURA, n);
        Collection<Aspect> li = ChromaAspectManager.instance.getAspects(this.getColor(), true);
        for (Aspect a : li) {
            as.add(a, n);
        }
        return as;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public void setAspects(AspectList aspects) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public boolean doesContainerAccept(Aspect tag) {
        return this.getAspects().getAmount(tag) > 0;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public boolean takeFromContainer(Aspect tag, int amount) {
        return this.doesContainerContainAmount(tag, amount);
    }

    @Deprecated
    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.getAspects().getAmount(tag) > amount;
    }

    @Deprecated
    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public int containerContains(Aspect tag) {
        return this.getAspects().getAmount(tag);
    }

    public String getId() {
        String s = "Pylon_" + this.color.toString();
        if (this.isEnhanced()) {
            s = s + "_E";
        }
        return s;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public AspectList getAspectsBase() {
        return this.getAspects();
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public NodeType getNodeType() {
        switch (this.color) {
            case BLACK: {
                return NodeType.DARK;
            }
            case GRAY: {
                return NodeType.UNSTABLE;
            }
            case WHITE: {
                return NodeType.PURE;
            }
        }
        return NodeType.NORMAL;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public void setNodeType(NodeType nodeType) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public void setNodeModifier(NodeModifier nodeModifier) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public NodeModifier getNodeModifier() {
        return NodeModifier.BRIGHT;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public int getNodeVisBase(Aspect aspect) {
        return this.containerContains(aspect);
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public void setNodeVisBase(Aspect aspect, short nodeVisBase) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int mode) {
        return -1;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        player.func_71008_a(wandstack, Integer.MAX_VALUE);
        ReikaThaumHelper.setWandInUse((ItemStack)wandstack, (TileEntity)this);
        this.forceLoading();
        return wandstack;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
        if (!this.field_145850_b.field_72995_K && this.canConduct() && player.field_70173_aa % 5 == 0 && this.canPlayerWandPylon(wandstack, player)) {
            AspectList al = ReikaThaumHelper.decompose((AspectList)this.getAspects());
            for (Aspect a : al.aspects.keySet()) {
                int ret;
                int amt = 1;
                int eff = 1800;
                if (ReikaThaumHelper.isResearchComplete((EntityPlayer)player, (String)"NODETAPPER1")) {
                    amt *= 2;
                    eff = (int)((double)eff * 0.9);
                }
                if (ReikaThaumHelper.isResearchComplete((EntityPlayer)player, (String)"NODETAPPER2")) {
                    amt *= 2;
                    eff = (int)((double)eff * 0.8);
                }
                if (ReikaThaumHelper.isResearchComplete((EntityPlayer)player, (String)"ROD_silverwood_staff")) {
                    amt = (int)((double)amt * 1.5);
                    eff = (int)((double)eff * 0.8);
                }
                if (ReikaThaumHelper.isResearchComplete((EntityPlayer)player, (String)"FOCUSPRIMAL")) {
                    amt = (int)((double)amt * 1.25);
                    eff = (int)((double)eff * 0.6);
                }
                if (ReikaThaumHelper.isResearchComplete((EntityPlayer)player, (String)"WARPPROOF")) {
                    eff = (int)((double)eff * 0.5);
                }
                if (ReikaThaumHelper.isResearchComplete((EntityPlayer)player, (String)"CRYSTALWAND")) {
                    amt *= 2;
                }
                if (!ProgressStage.ALLCOLORS.isPlayerAtStage(player)) {
                    eff = (int)((double)eff * 1.75);
                    amt = (int)((double)amt * 0.75);
                    amt = Math.max(1, amt);
                }
                if (ProgressStage.RUNEUSE.isPlayerAtStage(player)) {
                    eff = (int)((double)eff * 0.95);
                }
                if (ProgressStage.LINK.isPlayerAtStage(player)) {
                    eff = (int)((double)eff * 0.8);
                    amt = (int)((double)amt * 1.2);
                }
                if (ProgressStage.POWERCRYSTAL.isPlayerAtStage(player)) {
                    eff = (int)((double)eff * 0.7);
                    amt = (int)((double)amt * 1.8);
                }
                if (ProgressStage.TURBOCHARGE.isPlayerAtStage(player)) {
                    eff = (int)((double)eff * 0.6);
                    amt *= 2;
                }
                if (ProgressStage.CTM.isPlayerAtStage(player)) {
                    eff = (int)((double)eff * 0.5);
                    amt = (int)((double)amt * 2.5);
                }
                amt = Math.min(amt, al.getAmount(a));
                int added = (amt = Math.min(amt, ReikaThaumHelper.getWandSpaceFor((ItemStack)wandstack, (Aspect)a))) - (ret = ReikaThaumHelper.addVisToWand((ItemStack)wandstack, (Aspect)a, (int)amt));
                if (added <= 0) continue;
                this.drain(this.color, Math.min(this.energy, added * eff));
            }
        }
    }

    private boolean canPlayerWandPylon(ItemStack wandstack, EntityPlayer player) {
        if (!ReikaThaumHelper.isResearchComplete((EntityPlayer)player, (String)"PYLONWANDING")) {
            return false;
        }
        if (ChromaOptions.HARDTHAUM.getState()) {
            WandCap cap = ReikaThaumHelper.getWandCap((ItemStack)wandstack);
            WandRod rod = ReikaThaumHelper.getWandRod((ItemStack)wandstack);
            WandCap gold = (WandCap)WandCap.caps.get("gold");
            WandRod great = (WandRod)WandRod.rods.get("greatwood");
            if (cap.getBaseCostModifier() > gold.getBaseCostModifier() || rod.getCapacity() < great.getCapacity()) {
                return false;
            }
        }
        return (ChromaOptions.HARDTHAUM.getState() ? ProgressStage.ALLCOLORS : ProgressStage.PYLON).isPlayerAtStage(player);
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    @Override
    public final ElementTagCompound getEnergy() {
        ElementTagCompound tag = new ElementTagCompound();
        tag.setTag(this.color, this.energy);
        return tag;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return this.getCapacity();
    }

    private int getCapacity() {
        return this.isEnhanced() ? 900000 : 180000;
    }

    public boolean isEnhanced() {
        return this.enhanced && this.canConduct();
    }

    @Override
    public boolean canSupply(CrystalReceiver te, CrystalElement e) {
        if (!this.placedByHand) {
            return true;
        }
        return TileEntityCreativeSource.canSupply(this, te);
    }

    @Override
    public boolean canTransmitTo(CrystalReceiver te) {
        return true;
    }

    @Override
    public boolean regeneratesEnergy() {
        return true;
    }

    @DependentMethodStripper.ModDependent(value={ModList.ROTARYCRAFT})
    public void onEMP(TileEntityEMP te) {
        this.destabilize();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final double func_145833_n() {
        return 65536.0;
    }

    public void breakBlock() {
        this.unload();
    }

    private void unload() {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)1);
    }

    protected final void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        if (!world.field_72995_K && invalid) {
            this.unload();
        }
    }

    @Override
    public void onUsedBy(EntityPlayer ep, CrystalElement e) {
        this.forceLoading();
        MinecraftForge.EVENT_BUS.post((Event)new PylonEvents.PlayerChargedFromPylonEvent(this, ep));
    }

    @Override
    public boolean playerCanUse(EntityPlayer ep) {
        return true;
    }

    @Override
    public boolean allowCharging(EntityPlayer ep, CrystalElement e) {
        return true;
    }

    @Override
    public float getChargeRateMultiplier(EntityPlayer ep, CrystalElement e) {
        return 1.0f;
    }

    @Override
    public CrystalElement getDeliveredColor(EntityPlayer ep, World world, int clickX, int clickY, int clickZ) {
        return this.color;
    }

    public void enhance() {
        this.enhanced = true;
        this.enhancing = false;
        this.syncAllData(true);
        PylonGenerator.instance.cachePylon(this);
    }

    public void disenhance() {
        this.enhanced = false;
        this.enhancing = false;
        this.energy = Math.min(this.energy, this.getMaxStorage(this.color));
        this.syncAllData(true);
        PylonGenerator.instance.cachePylon(this);
    }

    @Override
    public Coordinate getChargeParticleOrigin(EntityPlayer ep, CrystalElement e) {
        return new Coordinate((TileEntity)this);
    }

    @Override
    public int getPathPriority() {
        return 0;
    }

    public boolean hasBroadcastUpgrade() {
        return this.broadcast;
    }

    @Override
    public double getMaximumBeamRadius() {
        return 0.35;
    }

    @Override
    public float getHeldToolChargingPower(EntityPlayer ep, CrystalElement e, ItemStack is) {
        return this.isEnhanced() ? 3.0f : 1.5f;
    }

    @Override
    public float getDroppedItemChargeRate(ItemStack is) {
        return this.isEnhanced() ? 2.0f : 1.0f;
    }

    static {
        if (ModList.THAUMCRAFT.isLoaded()) {
            try {
                node = Class.forName("thaumcraft.common.tiles.TileNode");
                Field f = node.getDeclaredField("locations");
                f.setAccessible(true);
                nodeCache = (HashMap)f.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        crystalPositions.add(new Coordinate(-3, -3, -1));
        crystalPositions.add(new Coordinate(-1, -3, -3));
        crystalPositions.add(new Coordinate(3, -3, -1));
        crystalPositions.add(new Coordinate(1, -3, -3));
        crystalPositions.add(new Coordinate(-3, -3, 1));
        crystalPositions.add(new Coordinate(-1, -3, 3));
        crystalPositions.add(new Coordinate(3, -3, 1));
        crystalPositions.add(new Coordinate(1, -3, 3));
    }
}

