/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityNetworkOptimizer
extends CrystalReceiverBase
implements MultiBlockChromaTile {
    public static final int REQUIRED_CHARGE = 12000;
    private final PathData[] data = new PathData[16];
    private int advanceDelay;
    private boolean isComplete;
    private boolean hasStructure;

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (world.field_72995_K) {
            return;
        }
        if (!this.hasStructure()) {
            return;
        }
        if (this.isComplete) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if (this.energy.getValue(e) >= 12000) continue;
            if (this.getCooldown() == 0 && this.checkTimer.checkCap()) {
                this.requestEnergy(e, 12000 - this.energy.getValue(e));
            }
            return;
        }
        if (this.advanceDelay > 0) {
            --this.advanceDelay;
            return;
        }
        boolean flag = true;
        for (int i = 0; i < 16; ++i) {
            if (this.data[i] == null) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.onOptimizationComplete(world, x, y, z);
            return;
        }
        int clr = (this.getTicksExisted() + System.identityHashCode(this)) % 16;
        if (this.data[clr] != null && this.runOptimizationStep(world, x, y, z, clr)) {
            this.data[clr] = null;
        }
    }

    @Override
    protected int getCooldownLength() {
        return 100;
    }

    @Override
    public void validateStructure() {
        ChromaStructures.OPTIMIZER.getStructure().resetToDefaults();
        this.hasStructure = ChromaStructures.OPTIMIZER.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
        this.syncAllData(false);
    }

    private boolean runOptimizationStep(World world, int x, int y, int z, int clr) {
        boolean ret = this.data[clr].optimizeStep();
        if (ret) {
            for (int i = 0; i < 24; ++i) {
                ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.OPTIMIZE.ordinal(), (TileEntity)this, (int)48, (int[])new int[]{clr});
                ChromaSounds.CAST.playSoundAtBlock(world, x, y, z, 1.0f, 0.5f);
            }
            this.advanceDelay = 60;
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public static void runOptimizationStepFX(World world, int x, int y, int z, int clr) {
        double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.0625);
        double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.0625);
        double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.0625);
        EntityCCBlurFX fx = new EntityCCBlurFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), vx, vy, vz);
        fx.setColor(CrystalElement.elements[clr].getColor()).setColliding();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void onOptimizationComplete(World world, int x, int y, int z) {
        this.isComplete = true;
        ChromaSounds.NETWORKOPT.playSoundAtBlockNoAttenuation((TileEntity)this, 1.0f, 1.0f, 256);
        this.syncAllData(true);
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.validateStructure();
        for (int i = 0; i < 16; ++i) {
            this.data[i] = new PathData();
            this.data[i].pathData.addAll(CrystalNetworker.instance.getAllCachedPaths(CrystalElement.elements[i]));
        }
    }

    @Override
    protected void onReceiveEnergy(CrystalElement e, int amt) {
        float f = CrystalMusicManager.instance.getScaledDing(e, 0);
        if (this.getTicksExisted() % Math.max(1, (int)(3.0f / (f * f))) == 0) {
            ChromaSounds.NETWORKOPTCHARGE.playSoundAtBlock((TileEntity)this, 1.0f, f);
        }
    }

    @Override
    public int getReceiveRange() {
        return 32;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return true;
    }

    @Override
    public int maxThroughput() {
        return 50;
    }

    @Override
    public boolean canConduct() {
        return this.hasStructure();
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 12000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.OPTIMIZER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
        this.isComplete = NBT.func_74767_n("complete");
        this.advanceDelay = NBT.func_74762_e("delay");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
        NBT.func_74757_a("complete", this.isComplete);
        NBT.func_74768_a("delay", this.advanceDelay);
    }

    public boolean hasStructure() {
        return this.hasStructure;
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        return ChromaStructures.OPTIMIZER;
    }

    @Override
    public Coordinate getStructureOffset() {
        return null;
    }

    @Override
    public boolean canStructureBeInspected() {
        return true;
    }

    private static class PathData {
        private final ArrayList<CrystalPath> pathData = new ArrayList();

        private PathData() {
        }

        public boolean optimizeStep() {
            if (this.pathData.isEmpty()) {
                return true;
            }
            CrystalPath p = this.pathData.get(0);
            CrystalPath p2 = p.optimize(1);
            if (p2 != null) {
                this.pathData.set(0, p2);
            }
            if (p2.isOptimized()) {
                CrystalNetworker.instance.replacePath(p2);
                this.pathData.remove(0);
            }
            return this.pathData.isEmpty();
        }
    }
}

