/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.Interfaces.VariableTexture;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Magic.Network.PylonLinkNetwork;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityPylonLink
extends TileEntityChromaticBase
implements LocationCached,
VariableTexture,
ChunkLoadingTile {
    private PylonLinkNetwork.PylonNode connection;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.PYLONLINK;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K && this.connection != null) {
            this.doFX(world, x, y, z);
        }
        if (!world.field_72995_K && this.connection == null && this.getTicksExisted() % 40 == 35) {
            this.syncAllData(true);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getIconState(int side) {
        return side == 1 && this.connection != null ? 1 : 0;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.link();
    }

    public void link() {
        if (this.placerUUID == null) {
            return;
        }
        TileEntityCrystalPylon te = this.getPylon();
        if (te != null) {
            this.connection = PylonLinkNetwork.instance.addLocation(this, te);
            ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
        }
    }

    protected final void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        if (!world.field_72995_K && invalid) {
            this.unload();
        }
    }

    private void unload() {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    @SideOnly(value=Side.CLIENT)
    private void doFX(World world, int x, int y, int z) {
        EntityBlurFX fx;
        float s;
        float g;
        double py;
        double pz;
        double px;
        double ang;
        double a;
        int c = this.connection.getColor().getColor();
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        double dd = ep.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        if (dd >= 256.0 && rand.nextInt(3) == 0) {
            return;
        }
        if (dd >= 1024.0 && rand.nextInt(2) == 0) {
            return;
        }
        if (dd >= 4096.0 && rand.nextInt(3) > 0) {
            return;
        }
        double t = (double)this.getTicksExisted() * 1.5;
        int n = dd >= 256.0 ? 3 : 6;
        double da = 360.0 / (double)n;
        double r = 0.4375;
        for (a = 0.0; a < 360.0; a += da) {
            ang = Math.toRadians(a + t);
            px = (double)x + 0.5 + r * Math.cos(ang);
            pz = (double)z + 0.5 + r * Math.sin(ang);
            py = (double)y + 1.05;
            g = -((float)ReikaRandomHelper.getRandomBetween((double)0.0078125, (double)0.03125));
            s = (float)ReikaRandomHelper.getRandomBetween((double)0.375, (double)0.5);
            fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setGravity(g).setScale(s).setRapidExpand().setAlphaFading();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        t = (double)(-this.getTicksExisted()) * 3.5;
        n = 3;
        da = 360.0 / (double)n;
        r = 0.1875;
        for (a = 0.0; a < 360.0; a += da) {
            ang = Math.toRadians(a + t);
            px = (double)x + 0.5 + r * Math.cos(ang);
            pz = (double)z + 0.5 + r * Math.sin(ang);
            py = (double)y + 1.05;
            g = -((float)ReikaRandomHelper.getRandomBetween((double)0.0078125, (double)0.03125));
            s = (float)ReikaRandomHelper.getRandomBetween((double)0.375, (double)0.5);
            fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setGravity(g).setScale(s).setRapidExpand().setAlphaFading();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (int i = 1; i <= 4; ++i) {
            double px2 = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.03125);
            double pz2 = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.03125);
            double py2 = (double)(y + 1) + 4.5 + 4.5 * Math.sin((double)this.getTicksExisted() / 64.0 * (1.0 + (double)i / 8.0) + (double)(i * 5));
            EntityBlurFX fx2 = new EntityCCBlurFX(world, px2, py2, pz2).setColor(c).setScale(1.25f).setRapidExpand().setAlphaFading().setLife(12);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    public Collection<WorldLocation> getLinkedPylons() {
        if (this.placerUUID == null || this.connection == null) {
            return new ArrayList<WorldLocation>();
        }
        return PylonLinkNetwork.instance.getLinkedPylons(this.field_145850_b, this.placerUUID, this.connection.getColor());
    }

    public TileEntityCrystalPylon getPylon() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int d = 9;
        for (int i = 1; i < d; ++i) {
            int dy = y + i;
            if (world.func_147439_a(x, dy, z).isAir((IBlockAccess)world, x, dy, z) || i == 1 && ChromaTiles.getTile((IBlockAccess)world, x, dy, z) == ChromaTiles.PYLONTURBO) continue;
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y + d, z);
        return tile instanceof TileEntityCrystalPylon ? (TileEntityCrystalPylon)tile : null;
    }

    public void breakBlock() {
        this.unlink();
    }

    private void unlink() {
        if (this.placerUUID == null || this.connection == null) {
            return;
        }
        PylonLinkNetwork.instance.removeLocation(this.field_145850_b, this.connection);
        this.connection = null;
        this.unload();
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("link")) {
            this.connection = PylonLinkNetwork.PylonNode.fromSync(NBT.func_74775_l("link"));
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.connection != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.connection.sync(tag);
            NBT.func_74782_a("link", (NBTBase)tag);
        }
    }

    public UUID getUUID() {
        return this.placerUUID;
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)1);
    }
}

