/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedCrystalReceiver;
import Reika.ChromatiCraft.Items.ItemStorageCrystal;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionCatchupHandling;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityChromaFluidFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityRelaySource
extends InventoriedCrystalReceiver
implements InertIInv,
ItemOnRightClick,
MultiBlockChromaTile {
    private static final int CAPACITY = 720000;
    private static final int CAPACITY_BOOSTED = 3600000;
    private int cooldown = 200;
    private int[] drainValue = new int[16];
    private boolean enhanced;
    private boolean hasEnhancedStructure;

    @Override
    protected int getCooldownLength() {
        return this.cooldown;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && this.checkTimer.checkCap()) {
            this.checkAndRequest();
        }
        if (world.field_72995_K && this.enhanced) {
            this.spawnParticles(world, x, y, z);
        }
        int maxDrain = 0;
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.drainValue[n] = (int)((double)this.drainValue[n] * 0.95);
            maxDrain += this.drainValue[i];
        }
        if (this.cooldown > 100 && (maxDrain /= 16) >= 720000 / this.cooldown) {
            --this.cooldown;
        } else if (this.cooldown < 200) {
            ++this.cooldown;
        }
        this.checkTimer.setCap(this.isEnhanced() ? this.cooldown / 2 : this.cooldown);
        if (this.inv[0] != null && ChromaItems.STORAGE.matchWith(this.inv[0])) {
            for (CrystalElement e : ItemStorageCrystal.getStoredTags(this.inv[0]).elementSet()) {
                int amt = ItemStorageCrystal.getStoredEnergy(this.inv[0], e);
                int add = Math.min(amt, Math.min(this.getMaxStorage(e) - this.energy.getValue(e), this.maxThroughput() * 4));
                if (add <= 0) continue;
                ItemStorageCrystal.removeEnergy(this.inv[0], e, add);
                this.energy.addValueToColor(e, add);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        double py;
        if (rand.nextInt(3) == 0) {
            int dx = rand.nextBoolean() ? x + 1 : x - 1;
            int dz = rand.nextBoolean() ? z + 1 : z - 1;
            int dy = y - 2;
            double px = (double)dx + rand.nextDouble();
            py = (double)dy + rand.nextDouble();
            double pz = (double)dz + rand.nextDouble();
            double v = 0.03125;
            double vx = ((double)x + 0.5 - px) * v;
            double vz = ((double)z + 0.5 - pz) * v;
            double vy = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.1875);
            EntityChromaFluidFX fx = new EntityChromaFluidFX(world, px, py, pz, vx, vy, vz).setGravity((float)vy * 0.75f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        if (rand.nextInt(2) == 0) {
            int color = CrystalElement.getBlendedColor(this.getTicksExisted(), 50);
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)2.25);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)2.25);
            py = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.25), (double)0.5) + 0.5;
            float g = (float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.1);
            int l = ReikaRandomHelper.getRandomPlusMinus((int)40, (int)100);
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.FADE_GENTLE).setColor(color).setGravity(g).setLife(l).setScale(1.25f).setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        EntityPlayer ep = this.getPlacer();
        if (ep != null && !ReikaPlayerAPI.isFake((EntityPlayer)ep) && !world.field_72995_K) {
            this.validateStructure();
            this.enhanced = ChromaResearchManager.instance.playerHasFragment(ep, ChromaResearch.RELAYSTRUCT) && this.hasEnhancedStructure;
        }
    }

    @Override
    public void validateStructure() {
        ChromaStructures.RELAY.getStructure().resetToDefaults();
        this.hasEnhancedStructure = ChromaStructures.RELAY.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
    }

    private void checkAndRequest() {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            float f2;
            CrystalElement e = CrystalElement.elements[i];
            float f = (float)this.getEnergy(e) / (float)this.getMaxStorage(e);
            float f3 = f2 = this.isEnhanced() ? 0.8f : 0.5f;
            if (!(f < f2)) continue;
            this.requestEnergy(e, this.getRemainingSpace(e));
        }
    }

    @Override
    public int getReceiveRange() {
        return this.enhanced ? 48 : 32;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null;
    }

    @Override
    public int maxThroughput() {
        return this.enhanced ? 30000 : 6000;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return this.enhanced ? 3600000 : 720000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.RELAYSOURCE;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.enhanced = NBT.func_74767_n("enhance");
        this.hasEnhancedStructure = NBT.func_74767_n("enstruct");
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("enhance", this.enhanced);
        NBT.func_74757_a("enstruct", this.hasEnhancedStructure);
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return side == 0;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return ChromaItems.STORAGE.matchWith(is) && ItemStorageCrystal.getTotalEnergy(is) > 0;
    }

    @Override
    public ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        this.dropItem(this.inv[0]);
        this.inv[0] = null;
        if (this.func_94041_b(0, item)) {
            this.inv[0] = item.func_77946_l();
            item = null;
        }
        return item;
    }

    private void dropItem(ItemStack is) {
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.75), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
    }

    public void onDrain(CrystalElement e, int amt) {
        int n = e.ordinal();
        this.drainValue[n] = this.drainValue[n] + amt;
        if (this.field_145850_b.field_72995_K) {
            ProgressionCatchupHandling.instance.attemptSync(this, 8.0, ProgressStage.RELAYS, true);
        }
    }

    public boolean isEnhanced() {
        return this.enhanced;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEnhanced(boolean en) {
        this.enhanced = en;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.enhanced ? ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(3.0, 2.0, 3.0) : ReikaAABBHelper.getBlockAABB((TileEntity)this);
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        return ChromaStructures.RELAY;
    }

    @Override
    public Coordinate getStructureOffset() {
        return null;
    }

    @Override
    public boolean canStructureBeInspected() {
        return true;
    }
}

