/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Block.BlockCrystalPylon;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.DynamicRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.ReactiveRepeater;
import Reika.ChromatiCraft.Magic.Network.CrystalLink;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBallLightningFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalRepeater;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityRelaySource;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityRitualTable;
import Reika.ChromatiCraft.TileEntity.TileEntityPersonalCharger;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWeakRepeater
extends TileEntityCrystalRepeater
implements DynamicRepeater,
ReactiveRepeater {
    private CrystalElement overloadColor;
    private int eolTicks;
    public static final int WEAK_RANGE = 16;
    public static final int WEAK_RECEIVE_RANGE = 24;
    private boolean ruptured;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.WEAKREPEATER;
    }

    public boolean isRuptured() {
        return this.ruptured;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.isRuptured()) {
            return;
        }
        if (world.field_72995_K) {
            this.doLifespanParticles(world, x, y, z);
        }
        if (this.eolTicks > 0) {
            ++this.eolTicks;
            world.func_147449_b(x, y + 1, z, (Block)Blocks.field_150480_ab);
            this.doDestroyFX(world, x, y, z);
        }
    }

    private void doDestroyFX(World world, int x, int y, int z) {
        if (this.eolTicks > 320) {
            RepeaterFailures r = (RepeaterFailures)((Object)RepeaterFailures.failureModes.getRandomEntry());
            r.doEffect(world, x, y, z, this);
            ProgressStage.BLOWREPEATER.stepPlayerTo(this.getPlacer());
            this.placerUUID = null;
            if (world.field_72995_K) {
                this.doDestroyFXClient(world, x, y, z);
            }
        } else if (ReikaRandomHelper.doWithChance((double)Math.pow((double)this.eolTicks / 320.0, 0.5)) && world.field_72995_K) {
            this.doDestroyingFXClient(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doDestroyingFXClient(World world, int x, int y, int z) {
        double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)1.0);
        double dy = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5), (double)1.0);
        double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)1.0);
        float s = 2.0f + rand.nextFloat() * 5.0f;
        CrystalElement e = CrystalElement.elements[this.getTicksExisted() / 16 % 16];
        int l = 10 + rand.nextInt(10);
        EntityBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz).setIcon(ChromaIcons.TURBO).setRapidExpand().setColor(e.getColor()).setScale(s).setLife(l);
        EntityBlurFX fxb = new EntityCCBlurFX(world, dx, dy, dz).setIcon(ChromaIcons.TURBO).setRapidExpand().setColor(e.getColor()).setScale(s / 1.125f).setLife(l);
        EntityBlurFX fx2 = new EntityCCBlurFX(world, dx, dy, dz).setIcon(ChromaIcons.TRANSFADE).setRapidExpand().setColor(0).setScale(s / 2.5f).setBasicBlend().setLife(l);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fxb);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
    }

    @SideOnly(value=Side.CLIENT)
    private void doDestroyFXClient(World world, int x, int y, int z) {
        int n = 32 + rand.nextInt(64);
        for (int i = 0; i < n; ++i) {
            double phi = rand.nextDouble() * 360.0;
            double theta = rand.nextDouble() * 360.0;
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.25, (double)0.125);
            double[] vel = ReikaPhysicsHelper.polarToCartesian((double)v, (double)theta, (double)phi);
            int c1 = this.overloadColor.getColor();
            int c2 = ReikaColorAPI.mixColors((int)c1, (int)0xFFFFFF, (float)0.25f);
            int c3 = ReikaColorAPI.mixColors((int)c1, (int)0, (float)0.25f);
            double dx = (double)x + rand.nextDouble();
            double dy = (double)y + rand.nextDouble();
            double dz = (double)z + rand.nextDouble();
            float s = 5.0f + 2.5f * rand.nextFloat();
            EntityBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz, vel[0], vel[1], vel[2]).setRapidExpand().setColor(c1).setScale(s);
            EntityBlurFX fx1 = new EntityCCBlurFX(world, dx, dy, dz, vel[0], vel[1], vel[2]).setRapidExpand().setColor(c2).setScale(s * 0.5f).lockTo((EntityFX)fx);
            EntityBlurFX fx2 = new EntityCCBlurFX(world, dx, dy, dz, vel[0], vel[1], vel[2]).setIcon(ChromaIcons.TRANSFADE).setRapidExpand().setColor(c3).setScale(s * 0.25f).setBasicBlend().lockTo((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.POWERDOWN, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)1.0f, (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    private void doLifespanParticles(World world, int x, int y, int z) {
        if (this.eolTicks > 0) {
            double frac = (double)this.eolTicks / 320.0;
            double f = 0.8 * (1.0 - Math.pow(frac, 0.16666666666666666));
            CrystalElement e = CrystalElement.elements[this.getTicksExisted() / 16 % 16];
            if (this.eolTicks == 0 && ReikaRandomHelper.doWithChance((double)f)) {
                EntityBallLightningFX fx = new EntityBallLightningFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, e);
                fx.setVelocity(0.125, rand.nextInt(360), rand.nextInt(45));
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            if (frac < 0.5 && ReikaRandomHelper.doWithChance((double)(0.125 * Math.pow(f, 2.0)))) {
                double dr = ReikaRandomHelper.getRandomPlusMinus((double)8.0, (double)2.0);
                double ex = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)dr);
                double ez = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)dr);
                double ey = ReikaRandomHelper.getRandomBetween((double)((double)y + 0.05), (double)(y + 6));
                LightningBolt b = new LightningBolt(new DecimalPosition((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), new DecimalPosition(ex, ey, ez), 4);
                b.setVariance(0.375);
                b.maximize();
                int l = 20 + rand.nextInt(20);
                for (int i = 0; i < b.nsteps; ++i) {
                    DecimalPosition pos1 = b.getPosition(i);
                    DecimalPosition pos2 = b.getPosition(i + 1);
                    for (double r = 0.0; r <= 1.0; r += 0.03125) {
                        float s = 2.0f;
                        int clr = e.getColor();
                        double dx = pos1.xCoord + r * (pos2.xCoord - pos1.xCoord);
                        double dy = pos1.yCoord + r * (pos2.yCoord - pos1.yCoord);
                        double dz = pos1.zCoord + r * (pos2.zCoord - pos1.zCoord);
                        EntityBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz).setScale(s).setColor(clr).setLife(l).setRapidExpand();
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                        EntityBlurFX fx2 = new EntityCCBlurFX(world, dx, dy, dz).setScale(s / 2.0f).setColor(0xFFFFFF).setLife(l).setRapidExpand();
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
                    }
                }
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DISCHARGE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)0.125f, (float)CrystalMusicManager.instance.getRandomScaledDing(e), (boolean)true);
            }
        }
    }

    private void destroy(CrystalElement e) {
        if (this.eolTicks > 0) {
            return;
        }
        this.overloadColor = e;
        this.eolTicks = 1 + rand.nextInt(40);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, (Block)Blocks.field_150480_ab);
        ChromaSounds.REPEATERSURGE_WEAK.playSoundAtBlock((TileEntity)this, 1.0f, 1.1035f);
        this.syncAllData(false);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.eolTicks = NBT.func_74762_e("eol");
        this.overloadColor = CrystalElement.elements[NBT.func_74762_e("overload")];
        this.ruptured = NBT.func_74767_n("rupture");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("eol", this.eolTicks);
        if (this.overloadColor != null) {
            NBT.func_74768_a("overload", this.overloadColor.ordinal());
        }
        NBT.func_74757_a("rupture", this.ruptured);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    @Override
    public void onTransfer(CrystalSource src, CrystalReceiver r, CrystalElement e, int amt) {
        if (!this.canSafelySupply(r) && rand.nextInt(8) == 0) {
            this.destroy(e);
        }
    }

    private boolean canSafelySupply(CrystalReceiver r) {
        return r instanceof TileEntityRelaySource || r instanceof TileEntityRitualTable || r instanceof TileEntityPersonalCharger;
    }

    @Override
    public int getSendRange() {
        return 16;
    }

    @Override
    public int getReceiveRange() {
        return 24;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean checkForStructure() {
        ForgeDirection dir = this.facing;
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Block b = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        int meta = world.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        ReikaTreeHelper tree = ReikaTreeHelper.getTree((Block)b, (int)meta);
        ModWoodList mod = ModWoodList.getModWood((Block)b, (int)meta);
        if (tree != null) return true;
        if (mod == null) return false;
        if (!TileEntityWeakRepeater.isValidWood(mod)) return false;
        if (mod.canBePlacedSideways()) return true;
        if (dir.offsetY == 0) return false;
        return true;
    }

    public static boolean isValidWood(ModWoodList mod) {
        switch (mod) {
            case BLOODWOOD: 
            case BAMBOO: 
            case SLIME: 
            case TAINTED: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canConduct() {
        return super.canConduct() && !this.isRuptured();
    }

    @Override
    public CrystalElement getActiveColor() {
        return null;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null;
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        super.getTagsToWriteToStack(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        super.setDataFromItemStackTag(is);
    }

    @Override
    protected void getSneakPopDrops(ArrayList<ItemStack> li) {
        if (this.eolTicks == 0 && !this.isRuptured()) {
            super.getSneakPopDrops(li);
        } else {
            li.addAll(((BlockCrystalPylon)this.func_145838_q()).getPieces(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    @Override
    public int maxThroughput() {
        return 120;
    }

    @Override
    public int getSignalDegradation(boolean point) {
        return 250;
    }

    @Override
    public double getIncomingBeamRadius() {
        return 0.125;
    }

    @Override
    public double getOutgoingBeamRadius() {
        return 0.125;
    }

    @Override
    public boolean canTransmitTo(CrystalReceiver r) {
        return super.canTransmitTo(r);
    }

    @Override
    public float getFailureWeight(CrystalElement e) {
        return 30.0f;
    }

    @Override
    public int getModifiedThoughput(int basethru, CrystalSource src, CrystalReceiver r) {
        return !this.canSafelySupply(r) ? 0 : basethru;
    }

    @Override
    protected boolean canBeRainAffected(CrystalLink l) {
        return false;
    }

    private static enum RepeaterFailures {
        EXPLOSION(50),
        BURN(20),
        RUPTURE(40);

        private static final WeightedRandom<RepeaterFailures> failureModes;
        public final int weight;

        private RepeaterFailures(int w) {
            this.weight = w;
        }

        private void doEffect(World world, int x, int y, int z, TileEntityWeakRepeater te) {
            switch (this) {
                case BURN: {
                    te.delete();
                    for (int i = 0; i < 6; ++i) {
                        ReikaWorldHelper.ignite((World)world, (int)(x + ((TileEntityWeakRepeater)te).dirs[i].offsetX), (int)(y + ((TileEntityWeakRepeater)te).dirs[i].offsetY), (int)(z + ((TileEntityWeakRepeater)te).dirs[i].offsetZ));
                    }
                    world.func_147449_b(x, y, z, ChromaBlocks.CHROMA.getBlockInstance());
                    ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz", (float)2.0f, (float)0.5f);
                    break;
                }
                case EXPLOSION: {
                    te.delete();
                    for (int i = 0; i < 6; ++i) {
                        ReikaWorldHelper.ignite((World)world, (int)(x + ((TileEntityWeakRepeater)te).dirs[i].offsetX), (int)(y + ((TileEntityWeakRepeater)te).dirs[i].offsetY), (int)(z + ((TileEntityWeakRepeater)te).dirs[i].offsetZ));
                    }
                    world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 2.0f, !world.field_72995_K, !world.field_72995_K);
                    break;
                }
                case RUPTURE: {
                    ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz", (float)2.0f, (float)0.5f);
                    for (int m = 0; m < 40; ++m) {
                        ReikaParticleHelper.LAVA.spawnAt(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble() * 1.5, (double)z + rand.nextDouble());
                    }
                    world.func_147449_b(x, y + 1, z, Blocks.field_150350_a);
                    world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 2.0f, false, false);
                    te.ruptured = true;
                    te.triggerBlockUpdate();
                }
            }
        }

        static {
            failureModes = new WeightedRandom();
            RepeaterFailures[] list = RepeaterFailures.values();
            for (int i = 0; i < list.length; ++i) {
                failureModes.addEntry((Object)list[i], (double)list[i].weight);
            }
        }
    }
}

