/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Plants;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityMagicPlant;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBiomeReverter
extends TileEntityMagicPlant
implements LocationCached {
    private StepTimer timer = new StepTimer(40);
    private static double[][] randomDistrib = new double[][]{{0.0, 0.0, 0.0, 1.0, 2.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 2.0, 5.0, 2.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 3.0, 5.0, 7.0, 5.0, 3.0, 1.0, 0.0}, {1.0, 2.0, 5.0, 8.0, 10.0, 8.0, 5.0, 2.0, 1.0}, {2.0, 5.0, 7.0, 10.0, 10.0, 10.0, 7.0, 5.0, 2.0}, {1.0, 2.0, 5.0, 8.0, 10.0, 8.0, 5.0, 2.0, 1.0}, {0.0, 1.0, 3.0, 5.0, 7.0, 5.0, 3.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 2.0, 5.0, 2.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 2.0, 1.0, 0.0, 0.0, 0.0}};
    private static final Collection<WorldLocation> cache = new ArrayList<WorldLocation>();
    private static final WeightedRandom<Coordinate> coordinateRand = WeightedRandom.fromArray((double[][])randomDistrib);

    @Override
    public ForgeDirection getGrowthDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.REVERTER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            return;
        }
        int n = 1 + 2 * this.getAccelerationPlants();
        for (int i = 0; i < n; ++i) {
            this.timer.update();
        }
        if (this.timer.checkCap()) {
            this.revertBiome(world, x, y, z);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        if (!cache.contains(loc)) {
            cache.add(loc);
        }
    }

    public void breakBlock() {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        cache.remove(loc);
    }

    public static boolean stopConversion(World world, int x, int z) {
        for (WorldLocation te : cache) {
            Coordinate c = new Coordinate(x - te.xCoord, 0, z - te.zCoord);
            if (!coordinateRand.hasEntry((Object)c)) continue;
            return true;
        }
        return false;
    }

    private void revertBiome(World world, int x, int y, int z) {
        BiomeGenBase nat;
        Coordinate c = ((Coordinate)coordinateRand.getRandomEntry()).offset(x, y, z);
        BiomeGenBase b = c.getBiome(world);
        if (b != (nat = ReikaWorldHelper.getNaturalGennedBiomeAt((World)world, (int)c.xCoord, (int)c.zCoord)) && nat != null) {
            ReikaWorldHelper.setBiomeForXZ((World)world, (int)c.xCoord, (int)c.zCoord, (BiomeGenBase)nat);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean isPlantable(World world, int x, int y, int z) {
        return ReikaPlantHelper.FLOWER.canPlantAt(world, x, y, z) || ChromaTiles.getTile((IBlockAccess)world, x, y - 1, z) == ChromaTiles.PLANTACCEL;
    }
}

