/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Plants;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityMagicPlant;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Block.Worldgen.BlockCliffStone;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityFluidFX;
import Reika.DragonAPI.Instantiable.ParticleController.AttractiveMotionController;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Block.FluidBlockSurrogate;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityCobbleGen
extends TileEntityMagicPlant
implements OperationInterval {
    private final MultiMap<String, Coordinate> fluidLocations = new MultiMap(MultiMap.CollectionType.HASHSET);
    private final StepTimer areaScan = new StepTimer(100);
    public static final int XZ_RANGE = 4;
    public static final int Y_RANGE = 5;
    public static final int RANDOM_SCANS = 2;
    private FluidMix activeRecipe = null;
    private int recipeTick = 0;
    private Coordinate primaryLocation = null;
    private Coordinate secondaryLocation = null;
    private OutputModifier modifier;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.COBBLEGEN;
    }

    @Override
    public ForgeDirection getGrowthDirection() {
        return ForgeDirection.DOWN;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.areaScan.setTick(this.areaScan.getCap() - 1);
        this.doScan(world, x, y, z);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("recipeTick", this.recipeTick);
        NBT.func_74768_a("recipe", this.activeRecipe != null ? this.activeRecipe.ordinal() : -1);
        NBT.func_74768_a("modifier", this.modifier != null ? this.modifier.ordinal() : -1);
        if (this.primaryLocation != null) {
            this.primaryLocation.writeToNBT("loc1", NBT);
        }
        if (this.secondaryLocation != null) {
            this.secondaryLocation.writeToNBT("loc2", NBT);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.recipeTick = NBT.func_74762_e("recipeTick");
        int r = NBT.func_74762_e("recipe");
        this.activeRecipe = r >= 0 ? FluidMix.list[r] : null;
        int m = NBT.func_74762_e("modifier");
        OutputModifier outputModifier = this.modifier = m >= 0 ? OutputModifier.list[m] : null;
        if (NBT.func_74764_b("loc2")) {
            this.primaryLocation = Coordinate.readFromNBT((String)"loc1", (NBTTagCompound)NBT);
        }
        if (NBT.func_74764_b("loc1")) {
            this.secondaryLocation = Coordinate.readFromNBT((String)"loc2", (NBTTagCompound)NBT);
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            this.doScan(world, x, y, z);
        } else {
            this.doParticles(world, x, y, z);
        }
        if (this.recipeTick > 0) {
            this.doRecipeTick(world, x, y, z);
        } else if (!world.field_72995_K) {
            for (int i = 0; i < FluidMix.list.length; ++i) {
                FluidMix f = FluidMix.list[i];
                Coordinate primary = this.getFluid(world, x, y, z, f.primaryFluid);
                Coordinate secondary = this.getFluid(world, x, y, z, f.secondaryFluid);
                if (primary == null || secondary == null) continue;
                this.recipeTick = f.duration / 3;
                this.activeRecipe = f;
                this.primaryLocation = primary;
                this.secondaryLocation = secondary;
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        if (this.modifier != null) {
            this.modifier.doParticles(world, x, y, z, this);
        }
    }

    private void doRecipeTick(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            --this.recipeTick;
        }
        if (this.recipeTick == 0) {
            this.craft(world, x, y, z);
        } else if (world.field_72995_K) {
            this.doRecipeParticles(world, x, y, z);
        } else {
            FluidStack f1 = this.getFluidAtBlock(world, this.primaryLocation.xCoord, this.primaryLocation.yCoord, this.primaryLocation.zCoord);
            FluidStack f2 = this.getFluidAtBlock(world, this.secondaryLocation.xCoord, this.secondaryLocation.yCoord, this.secondaryLocation.zCoord);
            if (f1 == null || !f1.getFluid().getName().equals(this.activeRecipe.primaryFluid) || f1.amount < this.activeRecipe.requiredPrimaryAmount || f2 == null || !f2.getFluid().getName().equals(this.activeRecipe.secondaryFluid) || f2.amount < this.activeRecipe.requiredSecondaryAmount) {
                this.terminateCrafting(world, x, y, z, false);
            }
        }
    }

    private void craft(World world, int x, int y, int z) {
        Fluid f;
        FluidBlockSurrogate fb;
        int num = Math.min(64, ReikaMathLibrary.intpow2((int)2, (int)this.getAccelerationPlants()));
        ItemStack is = ReikaItemHelper.getSizedItemStack((ItemStack)this.activeRecipe.output, (int)num);
        if (this.modifier != null) {
            is = this.modifier.getOutput(is);
        }
        EntityItem ei = ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.125), (double)((double)z + 0.5), (ItemStack)is);
        ei.lifespan = 300;
        ei.field_70181_x = 0.0;
        ei.field_70179_y = 0.0;
        ei.field_70159_w = 0.0;
        if (this.activeRecipe.consumePrimaryFluid > 0.0f) {
            Block b1 = this.primaryLocation.getBlock((IBlockAccess)world);
            if (b1 instanceof FluidBlockSurrogate) {
                fb = (FluidBlockSurrogate)b1;
                f = FluidRegistry.getFluid((String)this.activeRecipe.primaryFluid);
                if (fb.supportsQuantization(world, this.primaryLocation.xCoord, this.primaryLocation.yCoord, this.primaryLocation.zCoord)) {
                    fb.drain(world, this.primaryLocation.xCoord, this.primaryLocation.yCoord, this.primaryLocation.zCoord, f, this.activeRecipe.requiredPrimaryAmount, true);
                } else if (ReikaRandomHelper.doWithChance((double)this.activeRecipe.consumePrimaryFluid)) {
                    fb.drain(world, this.primaryLocation.xCoord, this.primaryLocation.yCoord, this.primaryLocation.zCoord, f, 1000, true);
                }
            } else if (ReikaRandomHelper.doWithChance((double)this.activeRecipe.consumePrimaryFluid)) {
                this.primaryLocation.setBlock(world, Blocks.field_150350_a);
            }
        }
        if (this.activeRecipe.consumeSecondaryFluid > 0.0f) {
            Block b2 = this.secondaryLocation.getBlock((IBlockAccess)world);
            if (b2 instanceof FluidBlockSurrogate) {
                fb = (FluidBlockSurrogate)b2;
                f = FluidRegistry.getFluid((String)this.activeRecipe.secondaryFluid);
                if (fb.supportsQuantization(world, this.secondaryLocation.xCoord, this.secondaryLocation.yCoord, this.secondaryLocation.zCoord)) {
                    fb.drain(world, this.secondaryLocation.xCoord, this.secondaryLocation.yCoord, this.secondaryLocation.zCoord, f, this.activeRecipe.requiredSecondaryAmount, true);
                } else if (ReikaRandomHelper.doWithChance((double)this.activeRecipe.consumeSecondaryFluid)) {
                    fb.drain(world, this.secondaryLocation.xCoord, this.secondaryLocation.yCoord, this.secondaryLocation.zCoord, f, 1000, true);
                }
            } else if (ReikaRandomHelper.doWithChance((double)this.activeRecipe.consumeSecondaryFluid)) {
                this.secondaryLocation.setBlock(world, Blocks.field_150350_a);
            }
        }
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz", (float)0.75f, (float)2.0f);
        this.terminateCrafting(world, x, y, z, true);
    }

    private void terminateCrafting(World world, int x, int y, int z, boolean success) {
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.COBBLEGENEND.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{this.activeRecipe.ordinal(), success ? 1 : 0});
        this.activeRecipe = null;
        this.recipeTick = 0;
        this.primaryLocation = null;
        this.secondaryLocation = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void endCraftingFX(World world, int x, int y, int z, int recipe, boolean success) {
        int a;
        FluidMix f = FluidMix.list[recipe];
        double v = success ? 0.0625 : 0.375;
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(f.output);
        int n = 5;
        for (int i = a = rand.nextInt(n); i < 360; i += n) {
            double[] vel = ReikaPhysicsHelper.polarToCartesian((double)v, (double)0.0, (double)i);
            EntityBlurFX fx = success ? new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.125, (double)z + 0.5, vel[0], -0.125, vel[2]).setGravity(-0.125f) : new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.125, (double)z + 0.5, vel[0], 0.0, vel[2]).setIcon(ChromaIcons.SPARKLE).setNoSlowdown();
            int c = tag == null || tag.isEmpty() ? 0x22AAFF : ((CrystalElement)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, tag.elementSet())).getColor();
            fx.setColor(c).setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doRecipeParticles(World world, int x, int y, int z) {
        if (this.activeRecipe == null || this.primaryLocation == null || this.secondaryLocation == null) {
            return;
        }
        double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.primaryLocation.xCoord + 0.5), (double)0.35);
        double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.primaryLocation.zCoord + 0.5), (double)0.35);
        EntityFluidFX fx1 = new EntityFluidFX(world, px, (double)this.primaryLocation.yCoord + 0.85, pz, FluidRegistry.getFluid((String)this.activeRecipe.primaryFluid));
        px = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.secondaryLocation.xCoord + 0.5), (double)0.35);
        pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.secondaryLocation.zCoord + 0.5), (double)0.35);
        EntityFluidFX fx2 = new EntityFluidFX(world, px, (double)this.secondaryLocation.yCoord + 0.85, pz, FluidRegistry.getFluid((String)this.activeRecipe.secondaryFluid));
        fx1.setMotionController((MotionController)new AttractiveMotionController((double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.375, (double)this.field_145849_e + 0.5, 0.0026041666666666665, ReikaRandomHelper.getRandomPlusMinus((double)0.155, (double)0.005), ReikaRandomHelper.getRandomPlusMinus((double)0.98, (double)0.005)));
        fx2.setMotionController((MotionController)new AttractiveMotionController((double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.375, (double)this.field_145849_e + 0.5, 0.0026041666666666665, ReikaRandomHelper.getRandomPlusMinus((double)0.155, (double)0.005), ReikaRandomHelper.getRandomPlusMinus((double)0.98, (double)0.005)));
        fx1.setLife(70);
        fx2.setLife(70);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        EntityRuneFX fx = null;
        float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125);
        float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)1.25, (double)0.25);
        if (rand.nextBoolean()) {
            CrystalElement e = ChromaAux.getRune(FluidRegistry.getFluid((String)(rand.nextBoolean() ? this.activeRecipe.primaryFluid : this.activeRecipe.secondaryFluid)));
            fx = new EntityRuneFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), e).setGravity(g).setScale(s);
        } else {
            CrystalElement e;
            int dy;
            g = -g;
            for (dy = y - 1; dy > 0 && world.func_147439_a(x, dy, z).isAir((IBlockAccess)world, x, dy, z); --dy) {
            }
            ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(this.activeRecipe.output);
            CrystalElement crystalElement = e = tag != null && !tag.isEmpty() ? (CrystalElement)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, tag.elementSet()) : null;
            if (e != null) {
                fx = new EntityRuneFX(world, (double)x + rand.nextDouble(), dy + 1, (double)z + rand.nextDouble(), e).setGravity(g).setScale(s);
            }
        }
        if (fx != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
        }
    }

    private Coordinate getFluid(World world, int x, int y, int z, String f) {
        Collection li = this.fluidLocations.get((Object)f);
        boolean flag = !li.isEmpty();
        Iterator it = li.iterator();
        while (it.hasNext()) {
            Coordinate c = (Coordinate)it.next();
            FluidStack at = this.getFluidAtBlock(world, c.xCoord, c.yCoord, c.zCoord);
            if (at != null && at.getFluid().getName().equals(f)) {
                return c;
            }
            it.remove();
        }
        if (li.isEmpty()) {
            this.areaScan.setTick(this.areaScan.getCap() - 1);
        }
        return null;
    }

    private void doScan(World world, int x, int y, int z) {
        this.areaScan.update();
        if (this.areaScan.checkCap()) {
            this.fluidLocations.clear();
            for (int i = -4; i <= 4; ++i) {
                for (int k = -4; k <= 4; ++k) {
                    int dx = x + i;
                    int dz = z + k;
                    this.scanPosition(world, dx, y, dz);
                }
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)4);
                int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)4);
                this.scanPosition(world, dx, y, dz);
            }
        }
        this.modifier = this.getModifier(world, x, y, z);
    }

    private OutputModifier getModifier(World world, int x, int y, int z) {
        for (int i = 1; i < 5; ++i) {
            BlockKey bk = BlockKey.getAt((IBlockAccess)world, (int)x, (int)(y - i), (int)z);
            OutputModifier mod = OutputModifier.getByBlock(bk);
            if (mod != null) {
                return mod;
            }
            if (!bk.blockID.func_149662_c()) continue;
            return null;
        }
        return null;
    }

    private void scanPosition(World world, int dx, int y, int dz) {
        FluidStack f;
        int dy = this.getYPosition(world, dx, y, dz);
        if (dy != -1 && (f = this.getFluidAtBlock(world, dx, dy, dz)) != null) {
            this.fluidLocations.addValue((Object)f.getFluid().getName(), (Object)new Coordinate(dx, dy, dz));
        }
    }

    private FluidStack getFluidAtBlock(World world, int dx, int dy, int dz) {
        Block b = world.func_147439_a(dx, dy, dz);
        if (ReikaWorldHelper.isLiquidSourceBlock((World)world, (int)dx, (int)dy, (int)dz)) {
            Fluid f = ReikaFluidHelper.lookupFluidForBlock((Block)b);
            return f != null ? new FluidStack(f, 1000) : null;
        }
        if (b instanceof FluidBlockSurrogate) {
            FluidBlockSurrogate fb = (FluidBlockSurrogate)b;
            Fluid f = fb.getFluid(world, dx, dy, dz);
            return f != null ? new FluidStack(f, fb.drain(world, dx, dy, dz, f, 1000, false)) : null;
        }
        return null;
    }

    private int getYPosition(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (!b.isAir((IBlockAccess)world, x, y, z) && ChromaTiles.getTileFromIDandMetadata(b, world.func_72805_g(x, y, z)) != this.getTile()) {
            return -1;
        }
        int d = 0;
        while (y > 0 && (b.isAir((IBlockAccess)world, x, y, z) || ChromaTiles.getTileFromIDandMetadata(b, world.func_72805_g(x, y, z)) == this.getTile())) {
            ++d;
            b = world.func_147439_a(x, --y, z);
        }
        return d <= 5 ? y : -1;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public float getOperationFraction() {
        return this.activeRecipe == null ? 0.0f : (float)this.recipeTick / (float)this.activeRecipe.duration;
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.activeRecipe != null ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.INVALID;
    }

    @Override
    public boolean isPlantable(World world, int x, int y, int z) {
        return world.func_147439_a(x, y + 1, z).isSideSolid((IBlockAccess)world, x, y + 1, z, ForgeDirection.DOWN) && world.func_147439_a(x, y + 1, z).func_149688_o().func_76220_a() || ChromaTiles.getTile((IBlockAccess)world, x, y + 1, z) == ChromaTiles.PLANTACCEL;
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }

    private static enum OutputModifier {
        COBBLESMELT(ChromaTiles.HEATLILY);

        private final BlockKey block;
        private static final OutputModifier[] list;
        private static final BlockMap<OutputModifier> map;

        private OutputModifier(ChromaTiles c) {
            this(new BlockKey(c.getBlock(), c.getBlockMetadata()));
        }

        public static OutputModifier getByBlock(BlockKey bk) {
            return (OutputModifier)((Object)map.get(bk));
        }

        private OutputModifier(BlockKey b) {
            this.block = b;
        }

        private ItemStack getOutput(ItemStack in) {
            switch (this) {
                case COBBLESMELT: {
                    if (!ReikaItemHelper.matchStackWithBlock((ItemStack)in, (Block)Blocks.field_150347_e)) break;
                    return new ItemStack(Blocks.field_150348_b, in.field_77994_a, 0);
                }
            }
            return in;
        }

        @SideOnly(value=Side.CLIENT)
        private void doParticles(World world, int x, int y, int z, TileEntityCobbleGen te) {
            switch (this) {
                case COBBLESMELT: {
                    double a = 0.0;
                    int n = 3;
                    int sp = 360 / n;
                    double r = 0.75 + 0.25 * Math.sin((double)te.getTicksExisted() / 10.0);
                    for (int i = 0; i < 360; i += sp) {
                        double ri = Math.toRadians(i);
                        double dx = (double)x + 0.5 + r * Math.sin(a + ri);
                        double dy = y - 4;
                        double dz = (double)z + 0.5 + r * Math.cos(a + ri);
                        EntityBlurFX fx = new EntityCCBlurFX(CrystalElement.ORANGE, world, dx, dy, dz, 0.0, 0.1875, 0.0).setIcon(ChromaIcons.TRIDOT).setScale(2.5f).setNoSlowdown().setLife(25);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    break;
                }
            }
        }

        static {
            list = OutputModifier.values();
            map = new BlockMap();
            for (int i = 0; i < list.length; ++i) {
                BlockKey b = OutputModifier.list[i].block;
                map.put(b, (Object)list[i]);
            }
        }
    }

    private static enum FluidMix {
        COBBLESTONE(FluidRegistry.WATER, FluidRegistry.LAVA, new ItemStack(Blocks.field_150347_e), 10, 20.0f, 0.0f),
        CRYSTALSTONE("chroma", "lava", ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.SMOOTH.ordinal()), 50, 25.0f, 50.0f),
        CLIFFSTONE("luma", "lava", ChromaBlocks.CLIFFSTONE.getStackOfMetadata(BlockCliffStone.Variants.STONE.getMeta(false, false)), 120, 0.0f, 10.0f),
        ENDSTONE("ender", "lava", new ItemStack(Blocks.field_150377_bs), 80, 1.0f, 20.0f);

        private final ItemStack output;
        private final String primaryFluid;
        private final String secondaryFluid;
        private final int duration;
        private final float consumePrimaryFluid;
        private final float consumeSecondaryFluid;
        private final int requiredPrimaryAmount;
        private final int requiredSecondaryAmount;
        private static final FluidMix[] list;

        private FluidMix(Fluid f1, Fluid f2, ItemStack is, int t, float c1, float c2) {
            this(f1.getName(), f2.getName(), is, t, c1, c2);
        }

        private FluidMix(String f1, String f2, ItemStack is, int t, float c1, float c2) {
            this.primaryFluid = f1;
            this.secondaryFluid = f2;
            this.output = is;
            this.duration = t;
            this.consumePrimaryFluid = c1;
            this.consumeSecondaryFluid = c2;
            this.requiredPrimaryAmount = Math.max(1, (int)((double)(1000.0f * this.consumePrimaryFluid) / 100.0));
            this.requiredSecondaryAmount = Math.max(1, (int)((double)(1000.0f * this.consumeSecondaryFluid) / 100.0));
        }

        static {
            list = FluidMix.values();
        }
    }
}

