/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Plants;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityMagicPlant;
import Reika.ChromatiCraft.Block.Worldgen.BlockCliffStone;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.ModCropList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCropSpeedPlant
extends TileEntityMagicPlant {
    private static double[][] growthDistrib = new double[][]{{0.0, 0.0, 4.0, 0.0, 0.0}, {0.0, 1.0, 8.0, 1.0, 0.0}, {4.0, 8.0, 0.0, 8.0, 4.0}, {0.0, 1.0, 8.0, 1.0, 0.0}, {0.0, 0.0, 4.0, 0.0, 0.0}};
    private static double[][] hydrateDistrib = new double[][]{{0.0, 1.0, 4.0, 1.0, 0.0}, {1.0, 2.0, 6.0, 2.0, 1.0}, {4.0, 6.0, 4.0, 6.0, 4.0}, {1.0, 2.0, 6.0, 2.0, 1.0}, {0.0, 1.0, 4.0, 1.0, 0.0}};
    private static final WeightedRandom<Coordinate> growthRand = WeightedRandom.fromArray((double[][])growthDistrib);
    private static final WeightedRandom<Coordinate> hydrateRand = WeightedRandom.fromArray((double[][])hydrateDistrib);

    @Override
    public ForgeDirection getGrowthDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.CROPSPEED;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        double n;
        if (world.field_72995_K) {
            return;
        }
        if (rand.nextInt(4) == 0) {
            this.hydrateFarmland(world, x, y, z);
        }
        for (n = 0.5 + (double)this.getAccelerationPlants() / 2.0; n >= 1.0; n -= 1.0) {
            this.growCrop(world, x, y, z);
        }
        if (ReikaRandomHelper.doWithChance((double)n)) {
            this.growCrop(world, x, y, z);
        }
    }

    private void hydrateFarmland(World world, int x, int y, int z) {
        Coordinate c = ((Coordinate)hydrateRand.getRandomEntry()).offset(x, y - 1, z);
        Block b = c.getBlock((IBlockAccess)world);
        if (b == Blocks.field_150458_ak) {
            ReikaWorldHelper.hydrateFarmland((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (boolean)false);
        }
    }

    private void growCrop(World world, int x, int y, int z) {
        Coordinate c = ((Coordinate)growthRand.getRandomEntry()).offset(x, y, z);
        Block b = c.getBlock((IBlockAccess)world);
        int meta = c.getBlockMetadata((IBlockAccess)world);
        boolean flag = b instanceof BlockSapling || b == ChromaBlocks.DECOFLOWER.getBlockInstance() || b instanceof BlockReed || b instanceof BlockCactus || b == Blocks.field_150395_bd;
        flag |= ReikaCropHelper.getCrop((Block)b) != null;
        if (flag |= ModCropList.getModCrop((Block)b, (int)meta) != null) {
            c.updateTick(world);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean isPlantable(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z) == Blocks.field_150458_ak || ChromaTiles.getTile((IBlockAccess)world, x, y - 1, z) == ChromaTiles.PLANTACCEL || world.func_147439_a(x, y - 1, z) == ChromaBlocks.CLIFFSTONE.getBlockInstance() && BlockCliffStone.Variants.getVariant(world.func_72805_g(x, y - 1, z)) == BlockCliffStone.Variants.FARMLAND;
    }
}

