/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Plants;

import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrystalPlant
extends TileEntity {
    private static final Random random = new Random();
    private int flags;
    private boolean sterile;
    private int growthTick = 2;
    private long lastShardTick = -1L;

    public boolean renderPod() {
        return this.growthTick <= 1;
    }

    public boolean emitsLight() {
        return this.growthTick == 0;
    }

    public void grow() {
        if (this.growthTick > 0) {
            --this.growthTick;
            if (this.isPure()) {
                for (int i = 2; i < 6; ++i) {
                    if (!ReikaRandomHelper.doWithChance((double)(this.is(Modifier.PRIMAL) ? 80.0 : (this.is(Modifier.BOOSTED) ? 30.0 : 5.0)))) continue;
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                    int dx = this.field_145851_c + dir.offsetX;
                    int dy = this.field_145848_d + dir.offsetY;
                    int dz = this.field_145849_e + dir.offsetZ;
                    Block id = this.field_145850_b.func_147439_a(dx, dy, dz);
                    int meta = this.field_145850_b.func_72805_g(dx, dy, dz);
                    if (id != ChromaBlocks.PLANT.getBlockInstance() || meta != this.getColor().ordinal()) continue;
                    TileEntityCrystalPlant te = (TileEntityCrystalPlant)this.field_145850_b.func_147438_o(dx, dy, dz);
                    te.grow();
                }
            }
        } else if (!this.is(Modifier.PRIMAL)) {
            this.tryGrowPrimal();
        }
        this.updateLight();
    }

    private void tryGrowPrimal() {
        if (random.nextInt(60) > 0) {
            return;
        }
        for (int i = 2; i < 6; ++i) {
            TileEntityCrystalPlant te;
            boolean flag = false;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = this.field_145851_c + dir.offsetX;
            int dy = this.field_145848_d + dir.offsetY;
            int dz = this.field_145849_e + dir.offsetZ;
            Block id = this.field_145850_b.func_147439_a(dx, dy, dz);
            int meta = this.field_145850_b.func_72805_g(dx, dy, dz);
            if (id == ChromaBlocks.PLANT.getBlockInstance() && meta == this.getColor().ordinal() && (te = (TileEntityCrystalPlant)this.field_145850_b.func_147438_o(dx, dy, dz)).is(Modifier.BOOSTED)) {
                flag = true;
            }
            if (flag) continue;
            return;
        }
        this.flags |= Modifier.PRIMAL.flag;
    }

    public void makeRipe() {
        while (!this.canHarvest()) {
            this.grow();
        }
    }

    public void updateLight() {
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void harvest(boolean drops) {
        this.growthTick = 2;
        if (drops) {
            ArrayList<ItemStack> li = this.getDrops();
            ReikaItemHelper.dropItems((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), li);
        }
        this.updateLight();
    }

    public ArrayList<ItemStack> getDrops() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (this.isSterile()) {
            return li;
        }
        if (this.isPure() || random.nextInt(4) == 0) {
            int meta = this.getColor().ordinal();
            if (this.isPure() && !this.is(Modifier.PRIMAL)) {
                int rand = random.nextInt(20);
                int num = 0;
                if (rand == 0) {
                    num = 2;
                } else if (rand < 5) {
                    num = 1;
                }
                int smeta = meta + Modifier.IMPURE.flag;
                if (this.isPure() && random.nextInt(this.is(Modifier.BOOSTED) ? 4 : 400) == 0) {
                    smeta = meta + Modifier.BOOSTED.flag;
                }
                for (int i = 0; i < num; ++i) {
                    li.add(ChromaItems.SEED.getStackOfMetadata(smeta));
                }
                if (random.nextInt(10) == 0) {
                    ItemStack deco = ChromaItems.SEED.getStackOfMetadata(smeta);
                    deco.field_77990_d = new NBTTagCompound();
                    deco.field_77990_d.func_74757_a("sterile", true);
                    li.add(deco);
                }
            }
            long time = this.field_145850_b.func_82737_E();
            if (ChromaOptions.CRYSTALFARM.getState() && time - this.lastShardTick >= (long)(this.is(Modifier.PRIMAL) ? 60 : (this.is(Modifier.BOOSTED) ? 150 : 600)) && ReikaRandomHelper.doWithChance((double)(this.is(Modifier.PRIMAL) ? 10.0 : (this.is(Modifier.BOOSTED) ? 5.0 : 2.0)))) {
                li.add(ChromaItems.SHARD.getStackOfMetadata(meta));
                this.lastShardTick = time;
            }
        }
        return li;
    }

    public boolean canHarvest() {
        return this.growthTick == 0;
    }

    public CrystalElement getColor() {
        return CrystalElement.elements[this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)];
    }

    public boolean canUpdate() {
        return false;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.field_148860_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.growthTick = NBT.func_74762_e("growth");
        this.lastShardTick = NBT.func_74763_f("shard");
        this.flags = NBT.func_74762_e("flags");
        this.sterile = NBT.func_74767_n("sterile");
    }

    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("growth", this.growthTick);
        NBT.func_74772_a("shard", this.lastShardTick);
        NBT.func_74768_a("flags", this.flags);
        NBT.func_74757_a("sterile", this.sterile);
    }

    public int getGrowthState() {
        return this.growthTick;
    }

    public void setStates(ItemStack item) {
        int meta = item.func_77960_j();
        for (int i = 0; i < Modifier.list.length; ++i) {
            Modifier m = Modifier.list[i];
            if (!m.present(meta)) continue;
            this.setState(m);
        }
        this.sterile = item.field_77990_d != null && item.field_77990_d.func_74767_n("sterile");
    }

    public void setState(Modifier m) {
        this.flags |= m.flag;
    }

    public boolean is(Modifier m) {
        return m.present(this.flags);
    }

    public boolean isPure() {
        return !this.is(Modifier.IMPURE);
    }

    public boolean isSterile() {
        return this.sterile;
    }

    public static enum Modifier {
        IMPURE("Impure"),
        BOOSTED("Enriched"),
        PRIMAL("Primal");

        public final int flag = 1 << this.ordinal() + 4;
        public final String displayName;
        public static final Modifier[] list;

        private Modifier(String s) {
            this.displayName = s;
        }

        public boolean present(int flags) {
            return (flags & this.flag) != 0;
        }

        public static Modifier getFromFlag(int flags) {
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].present(flags)) continue;
                return list[i];
            }
            return null;
        }

        public boolean showsInCreative() {
            return this != PRIMAL;
        }

        static {
            list = Modifier.values();
        }
    }
}

