/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Processing;

import Reika.ChromatiCraft.API.Interfaces.EnchantableItem;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaExtractable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaPowered;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.Interfaces.VariableTexture;
import Reika.ChromatiCraft.Base.ChromaticEnchantment;
import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Base.TileEntity.FluidReceiverInventoryBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaEnchants;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaRegistryHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.InfusionEnchantmentHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TileEntityAutoEnchanter
extends FluidReceiverInventoryBase
implements ChromaPowered,
ChromaExtractable,
OperationInterval,
VariableTexture {
    private HashMap<Enchantment, Integer> selected = new HashMap();
    public static final int CHROMA_PER_LEVEL_BASE = 500;
    private static final HashMap<Enchantment, EnchantmentTier> tiers;
    private static final HashMap<Enchantment, Integer> boostedLevels;
    private static final HashSet<Enchantment> blacklist;
    private static final HashSet<ImmutablePair<Enchantment, Enchantment>> allowedPairs;
    private StepTimer progress = new StepTimer(40);
    public int progressTimer;

    public static Map<Enchantment, Integer> getBoostedLevels() {
        return Collections.unmodifiableMap(boostedLevels);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ENCHANTER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.canProgress()) {
            this.progress.update();
            if (this.progress.checkCap() && !world.field_72995_K) {
                this.applyEnchants();
            }
        } else {
            this.progress.reset();
        }
        this.progressTimer = this.progress.getTick();
    }

    public int getProgressScaled(int a) {
        return a * this.progressTimer / this.progress.getCap();
    }

    private boolean canProgress() {
        return this.isValid(this.inv[0]) && this.hasSufficientChroma() && this.enchanting();
    }

    private boolean hasSufficientChroma() {
        return this.getChromaLevel() >= this.getConsumedChroma();
    }

    private boolean enchanting() {
        if (this.selected.isEmpty()) {
            return false;
        }
        for (Enchantment e : this.selected.keySet()) {
            int level = this.selected.get(e);
            if (level <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getChromaLevel() {
        return this.tank.getLevel();
    }

    @Override
    public boolean addChroma(int amt) {
        if (this.tank.canTakeIn(amt)) {
            this.tank.addLiquid(amt, FluidRegistry.getFluid((String)"chroma"));
            return true;
        }
        return false;
    }

    private boolean isValid(ItemStack is) {
        return is != null && this.isItemEnchantable(is) && this.areEnchantsValid(is);
    }

    private boolean isItemEnchantable(ItemStack is) {
        if (is.func_77973_b() == Items.field_151122_aG || is.func_77973_b() == Items.field_151134_bR) {
            return true;
        }
        if (is.func_77973_b() instanceof EnchantableItem) {
            return true;
        }
        if (ChromaItems.BEEFRAME.matchWith(is)) {
            return true;
        }
        if (this.isSoulboundable(is, is.func_77973_b())) {
            return true;
        }
        return is.func_77973_b().getItemEnchantability(is) > 0;
    }

    private boolean areEnchantsValid(ItemStack is) {
        Item i = is.func_77973_b();
        Set<Enchantment> has = ReikaEnchantmentHelper.getEnchantments((ItemStack)is).keySet();
        for (Enchantment e : this.selected.keySet()) {
            if (!this.isEnchantValid(e, is, i, true)) {
                return false;
            }
            if (this.isCompatible(has, e)) continue;
            return false;
        }
        return true;
    }

    public EnchantValidity isCompatible(Enchantment e) {
        if (!this.isCompatible(this.selected.keySet(), e)) {
            return EnchantValidity.INCOMPATIBLEWITHSELF;
        }
        if (this.inv[0] != null) {
            if (!this.isCompatible(ReikaEnchantmentHelper.getEnchantments((ItemStack)this.inv[0]).keySet(), e)) {
                return EnchantValidity.INCOMPATIBLEWITHEXISTING;
            }
            if (!this.isEnchantValid(e, this.inv[0], this.inv[0].func_77973_b(), false)) {
                return EnchantValidity.WRONGITEM;
            }
        }
        return EnchantValidity.VALID;
    }

    private boolean isCompatible(Collection<Enchantment> c, Enchantment e) {
        for (Enchantment e2 : c) {
            if (this.isCompatible(e, e2)) continue;
            return false;
        }
        return true;
    }

    private boolean isCompatible(Enchantment e, Enchantment e2) {
        return e == e2 || allowedPairs.contains(new ImmutablePair((Object)e, (Object)e2)) || allowedPairs.contains(new ImmutablePair((Object)e2, (Object)e)) || ReikaEnchantmentHelper.areEnchantsCompatible((Enchantment)e, (Enchantment)e2);
    }

    public boolean isEnchantValid(Enchantment e, ItemStack is, Item i, boolean checkLevels) {
        if (!(i != Items.field_151122_aG && i != Items.field_151134_bR || e.isAllowedOnBooks())) {
            return false;
        }
        if (checkLevels && ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)e, (ItemStack)is) >= this.selected.get(e)) {
            return false;
        }
        if (i instanceof EnchantableItem) {
            Event.Result res = ((EnchantableItem)i).getEnchantValidity(e, is);
            switch (res) {
                case ALLOW: {
                    return true;
                }
                case DEFAULT: {
                    break;
                }
                case DENY: {
                    return false;
                }
            }
        }
        if (ChromaItems.BEEFRAME.matchWith(is) && e != Enchantment.field_77347_r) {
            return false;
        }
        boolean soulbound = e.func_77320_a().toLowerCase(Locale.ENGLISH).contains("soulbound");
        if (soulbound && this.isSoulboundable(is, i)) {
            return true;
        }
        if (i instanceof ItemShears) {
            return e.field_77351_y == EnumEnchantmentType.digger || e.field_77351_y == EnumEnchantmentType.breakable || e.field_77351_y == EnumEnchantmentType.all;
        }
        if (ModList.TINKERER.isLoaded() && TinkerToolHandler.getInstance().isTool(is)) {
            return e instanceof ChromaticEnchantment && (e.field_77351_y == EnumEnchantmentType.all || e.field_77351_y == EnumEnchantmentType.digger);
        }
        if (ModList.TINKERER.isLoaded() && TinkerToolHandler.getInstance().isWeapon(is)) {
            return e instanceof ChromaticEnchantment && (e.field_77351_y == EnumEnchantmentType.all || e.field_77351_y == EnumEnchantmentType.weapon);
        }
        return i == Items.field_151122_aG || i == Items.field_151134_bR ? true : e.func_92089_a(is);
    }

    private boolean isSoulboundable(ItemStack is, Item i) {
        if (ChromaItems.HELP.matchWith(is)) {
            return true;
        }
        if (Loader.isModLoaded((String)"Backpack") && i.getClass().getName().toLowerCase(Locale.ENGLISH).contains("backpack")) {
            return true;
        }
        if (Loader.isModLoaded((String)"EnderStorage") && i.getClass().getName().toLowerCase(Locale.ENGLISH).contains("enderpouch")) {
            return true;
        }
        if (ModList.THAUMCRAFT.isLoaded() && i.getClass().getName().toLowerCase(Locale.ENGLISH).contains("focuspouch")) {
            return true;
        }
        if (ModList.THAUMCRAFT.isLoaded() && i == ThaumItemHelper.ItemEntry.WAND.getItem().func_77973_b()) {
            return true;
        }
        if (ModList.THAUMICTINKER.isLoaded() && i.getClass().getName().toLowerCase(Locale.ENGLISH).contains("ichorpouch")) {
            return true;
        }
        if (i instanceof ItemChromaTool || i instanceof ItemTool || i instanceof ItemSword || i instanceof ItemShears || i instanceof ItemArmor) {
            return true;
        }
        return ModList.TINKERER.isLoaded() && (TinkerToolHandler.getInstance().isTool(is) || TinkerToolHandler.getInstance().isWeapon(is));
    }

    private void applyEnchants() {
        if (this.inv[0].func_77973_b() == Items.field_151122_aG) {
            this.inv[0] = new ItemStack((Item)Items.field_151134_bR);
        }
        ReikaEnchantmentHelper.removeEnchantments((ItemStack)this.inv[0], this.selected.keySet());
        if (this.inv[1] != null) {
            ReikaEnchantmentHelper.removeEnchantments((ItemStack)this.inv[1], this.selected.keySet());
            int dmg = 0;
            for (Map.Entry<Enchantment, Integer> e : this.selected.entrySet()) {
                dmg = (int)((double)dmg + (double)e.getValue().intValue() * ReikaRandomHelper.getRandomBetween((double)4.0, (double)15.0) * (double)this.getCostFactor(e.getKey()));
            }
            this.inv[1].func_77972_a(dmg, (EntityLivingBase)this.getPlacer());
        }
        ReikaEnchantmentHelper.applyEnchantments((ItemStack)this.inv[0], this.selected);
        this.tank.removeLiquid(this.getConsumedChroma());
        this.syncAllData(true);
    }

    public int getConsumedChroma() {
        int total = 0;
        for (Enchantment e : this.selected.keySet()) {
            float level = this.selected.get(e).intValue();
            if (this.inv[1] != null) {
                level = Math.max(0.25f, level - 0.8f * (float)ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)e, (ItemStack)this.inv[1]));
            }
            float add = level * 500.0f * this.getCostFactor(e);
            if (this.isAssisted()) {
                add /= Math.min(2.5f, 1.0f + this.getAssistPower());
            }
            add = Math.max(add, 50.0f * level);
            add = ReikaMathLibrary.roundToNearestX((int)100, (int)Math.round(add));
            total += (int)add;
        }
        return total;
    }

    private float getCostFactor(Enchantment e) {
        EnchantmentTier t = tiers.get(e);
        if (t == null) {
            t = EnchantmentTier.NORMAL;
        }
        return t.costFactor;
    }

    public boolean setEnchantment(Enchantment e, int level) {
        this.onEnchantChanged(e);
        level = Math.min(TileEntityAutoEnchanter.getMaxEnchantmentLevel(e), level);
        if (level <= 0) {
            this.removeEnchantment(e);
            return true;
        }
        this.selected.put(e, level);
        return true;
    }

    private void onEnchantChanged(Enchantment e) {
        this.progress.reset();
        this.progressTimer = 0;
    }

    public static int getMaxEnchantmentLevel(Enchantment e) {
        if (e == Enchantment.field_77346_s) {
            return 5;
        }
        if (e == Enchantment.field_77335_o) {
            return 5;
        }
        if (e == Enchantment.field_77340_h) {
            return 5;
        }
        if (e == Enchantment.field_151370_z) {
            return 5;
        }
        if (e == Enchantment.field_77345_t) {
            return 10;
        }
        if (e == Enchantment.field_77338_j) {
            return 10;
        }
        if (e == Enchantment.field_77347_r) {
            return 5;
        }
        return e.func_77325_b();
    }

    public void removeEnchantment(Enchantment e) {
        this.selected.remove(e);
        this.onEnchantChanged(e);
    }

    public boolean incrementEnchantment(Enchantment e, boolean toMax, EntityPlayer ep) {
        int level = this.getEnchantment(e);
        int max = TileEntityAutoEnchanter.getAvailableEnchantmentLevel(e, ep);
        int newlevel = Math.min(max, toMax ? TileEntityAutoEnchanter.getMaxEnchantmentLevel(e) : level + 1);
        return this.setEnchantment(e, newlevel);
    }

    public void decrementEnchantment(Enchantment e, boolean toZero) {
        int level = this.getEnchantment(e);
        int newlevel = toZero ? 0 : Math.max(level - 1, 0);
        this.setEnchantment(e, newlevel);
    }

    public void clearEnchantments() {
        this.selected.clear();
    }

    public int getEnchantment(Enchantment e) {
        return this.selected.containsKey(e) ? this.selected.get(e) : 0;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return Collections.unmodifiableMap(this.selected);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.isValid(itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return ReikaEnchantmentHelper.hasEnchantments((ItemStack)itemstack);
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null) continue;
            int lvl = this.getEnchantment(Enchantment.field_77331_b[i]);
            NBT.func_74768_a(Enchantment.field_77331_b[i].func_77320_a(), lvl);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.selected = new HashMap();
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            int lvl;
            if (Enchantment.field_77331_b[i] == null || (lvl = NBT.func_74762_e(Enchantment.field_77331_b[i].func_77320_a())) <= 0) continue;
            this.selected.put(Enchantment.field_77331_b[i], lvl);
        }
    }

    @Override
    public int getCapacity() {
        return 12000;
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.getFluid((String)"chroma");
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return true;
    }

    @Override
    public float getOperationFraction() {
        return !this.canProgress() ? 0.0f : this.progress.getFraction();
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.isValid(this.inv[0]) && this.enchanting() ? (this.hasSufficientChroma() ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    public static boolean isBlacklisted(Enchantment e) {
        if (e.func_77320_a().toLowerCase(Locale.ENGLISH).startsWith("enchantment.molecule")) {
            return true;
        }
        if (ModList.THAUMCRAFT.isLoaded() && InfusionEnchantmentHandler.instance.isInfusionEnchantment(e)) {
            return true;
        }
        return blacklist.contains(e);
    }

    public static void blacklistEnchantment(Enchantment e) {
        if (ReikaEnchantmentHelper.isVanillaEnchant((Enchantment)e)) {
            ChromatiCraft.logger.logError((Object)"You cannot blacklist vanilla enchantments!");
        } else if (e instanceof ChromaticEnchantment) {
            ChromatiCraft.logger.logError((Object)"You cannot blacklist ChromatiCraft enchantments!");
        } else {
            blacklist.add(e);
            ChromatiCraft.logger.log((Object)("Received request to blacklist enchantment " + e.func_77320_a() + " from " + ReikaRegistryHelper.getActiveLoadingMod()));
        }
    }

    public static int getAvailableEnchantmentLevel(Enchantment e, EntityPlayer ep) {
        return e instanceof ChromaticEnchantment ? TileEntityAutoEnchanter.getMaxEnchantment(ep, (ChromaticEnchantment)e) : TileEntityAutoEnchanter.getMaxEnchantmentLevel(e);
    }

    private static int getMaxEnchantment(EntityPlayer ep, ChromaticEnchantment e) {
        for (int i = 1; i <= e.func_77325_b(); ++i) {
            if (e.isVisibleToPlayer(ep, i)) continue;
            return i - 1;
        }
        return e.func_77325_b();
    }

    public boolean isAssisted() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof BlockEnchantmentTable;
    }

    private float getAssistPower() {
        float ret = 0.0f;
        float max = 0.0f;
        int y = this.field_145848_d + 1;
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                if (dz == 0 && dx == 0 || !this.field_145850_b.func_147437_c(this.field_145851_c + dx, y, this.field_145849_e + dz) || !this.field_145850_b.func_147437_c(this.field_145851_c + dx, y + 1, this.field_145849_e + dz)) continue;
                ret += ForgeHooks.getEnchantPower((World)this.field_145850_b, (int)(this.field_145851_c + dx * 2), (int)y, (int)(this.field_145849_e + dz * 2));
                ret += ForgeHooks.getEnchantPower((World)this.field_145850_b, (int)(this.field_145851_c + dx * 2), (int)(y + 1), (int)(this.field_145849_e + dz * 2));
                max += 2.0f;
                if (dx == 0 || dz == 0) continue;
                ret += ForgeHooks.getEnchantPower((World)this.field_145850_b, (int)(this.field_145851_c + dx * 2), (int)y, (int)(this.field_145849_e + dz));
                ret += ForgeHooks.getEnchantPower((World)this.field_145850_b, (int)(this.field_145851_c + dx * 2), (int)(y + 1), (int)(this.field_145849_e + dz));
                ret += ForgeHooks.getEnchantPower((World)this.field_145850_b, (int)(this.field_145851_c + dx), (int)y, (int)(this.field_145849_e + dz * 2));
                ret += ForgeHooks.getEnchantPower((World)this.field_145850_b, (int)(this.field_145851_c + dx), (int)(y + 1), (int)(this.field_145849_e + dz * 2));
                max += 4.0f;
            }
        }
        return ret / max;
    }

    @Override
    public int getIconState(int side) {
        return side > 1 && this.isAssisted() ? 1 : 0;
    }

    @Override
    public void removeLiquid(int amt) {
        this.tank.removeLiquid(amt);
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }

    static {
        Enchantment soulbound;
        tiers = new HashMap();
        boostedLevels = new HashMap();
        blacklist = new HashSet();
        allowedPairs = new HashSet();
        tiers.put(Enchantment.field_77336_l, EnchantmentTier.WORTHLESS);
        tiers.put(Enchantment.field_77339_k, EnchantmentTier.WORTHLESS);
        tiers.put(Enchantment.field_77337_m, EnchantmentTier.BASIC);
        tiers.put(Enchantment.field_77344_u, EnchantmentTier.BASIC);
        tiers.put(Enchantment.field_151369_A, EnchantmentTier.BASIC);
        tiers.put(ChromaEnchants.FASTSINK.getEnchantment(), EnchantmentTier.BASIC);
        tiers.put(Enchantment.field_77346_s, EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77338_j, EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77335_o, EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77345_t, EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77332_c, EnchantmentTier.VALUABLE);
        tiers.put(ChromaEnchants.USEREPAIR.getEnchantment(), EnchantmentTier.VALUABLE);
        tiers.put(ChromaEnchants.ENDERLOCK.getEnchantment(), EnchantmentTier.VALUABLE);
        tiers.put(ChromaEnchants.AGGROMASK.getEnchantment(), EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77348_q, EnchantmentTier.RARE);
        tiers.put(Enchantment.field_77342_w, EnchantmentTier.RARE);
        tiers.put(ChromaEnchants.RARELOOT.getEnchantment(), EnchantmentTier.RARE);
        tiers.put(ChromaEnchants.WEAPONAOE.getEnchantment(), EnchantmentTier.RARE);
        tiers.put(ChromaEnchants.HARVESTLEVEL.getEnchantment(), EnchantmentTier.RARE);
        tiers.put(ChromaEnchants.PHASING.getEnchantment(), EnchantmentTier.RARE);
        tiers.put(ChromaEnchants.BOSSKILL.getEnchantment(), EnchantmentTier.RARE);
        Enchantment multishot = ReikaEnchantmentHelper.getEnchantmentByName((String)"Multishot");
        if (multishot != null) {
            tiers.put(multishot, EnchantmentTier.RARE);
        }
        if ((soulbound = ReikaEnchantmentHelper.getEnchantmentByName((String)"Soulbound")) != null) {
            tiers.put(soulbound, EnchantmentTier.RARE);
        }
        boostedLevels.put(Enchantment.field_77346_s, 5);
        boostedLevels.put(Enchantment.field_77335_o, 5);
        boostedLevels.put(Enchantment.field_77340_h, 5);
        boostedLevels.put(Enchantment.field_151370_z, 5);
        boostedLevels.put(Enchantment.field_77345_t, 10);
        boostedLevels.put(Enchantment.field_77338_j, 10);
        boostedLevels.put(Enchantment.field_77332_c, 5);
        allowedPairs.add((ImmutablePair<Enchantment, Enchantment>)new ImmutablePair((Object)Enchantment.field_77346_s, (Object)Enchantment.field_77348_q));
        allowedPairs.add((ImmutablePair<Enchantment, Enchantment>)new ImmutablePair((Object)Enchantment.field_77338_j, (Object)Enchantment.field_77336_l));
        allowedPairs.add((ImmutablePair<Enchantment, Enchantment>)new ImmutablePair((Object)Enchantment.field_77338_j, (Object)Enchantment.field_77339_k));
    }

    private static enum EnchantmentTier {
        WORTHLESS(0.25f),
        BASIC(0.75f),
        NORMAL(1.0f),
        VALUABLE(1.5f),
        RARE(2.0f);

        public final float costFactor;

        private EnchantmentTier(float f) {
            this.costFactor = f;
        }
    }

    public static enum EnchantValidity {
        VALID("Valid"),
        WRONGITEM("Invalid for Item"),
        INCOMPATIBLEWITHEXISTING("Incompatible with Existing"),
        INCOMPATIBLEWITHSELF("Incompatible with Selected");

        public final String desc;

        private EnchantValidity(String s) {
            this.desc = s;
        }

        public int getTextColor() {
            switch (this) {
                case VALID: {
                    return 0xFFFFFF;
                }
                case WRONGITEM: {
                    return 16774976;
                }
                case INCOMPATIBLEWITHEXISTING: {
                    return 16762688;
                }
                case INCOMPATIBLEWITHSELF: {
                    return 0xFF9090;
                }
            }
            return 0;
        }
    }
}

