/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Processing;

import Reika.ChromatiCraft.API.Interfaces.CrystalFurnaceMultiplier;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.Interfaces.VariableTexture;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Interfaces.Block.CraftableStone;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.AppEngHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.HardOresHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModInteract.ItemStackRepository;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.GeoStrata.Registry.RockTypes;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntityCrystalFurnace
extends InventoriedRelayPowered
implements IFluidHandler,
IPipeConnection,
OperationInterval,
VariableTexture {
    private static final ElementTagCompound smelt = new ElementTagCompound();
    public static final int MULTIPLY = 2;
    public int smeltTimer;
    private float xp;
    private final HybridTank tank = new HybridTank("crystalfurn", 4000);

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.canSmelt()) {
            this.smeltTimer += this.getSmeltSpeed();
            if (this.smeltTimer >= this.getSmeltTime()) {
                this.smelt();
                this.smeltTimer = 0;
            }
        } else {
            this.smeltTimer = 0;
        }
    }

    public int getSmeltSpeed() {
        return 1 + this.energy.getTotalEnergy() / 12000;
    }

    public int getSmeltTime() {
        return Math.max(5, 200 - this.getEnergy(CrystalElement.LIGHTBLUE) / 100);
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot == 1;
    }

    public int func_70302_i_() {
        return 2;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 && FurnaceRecipes.func_77602_a().func_151395_a(is) != null;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FURNACE;
    }

    private boolean canSmelt() {
        if (this.inv[0] == null) {
            return false;
        }
        if (!this.energy.containsAtLeast(smelt)) {
            return false;
        }
        ItemStack out = FurnaceRecipes.func_77602_a().func_151395_a(this.inv[0]);
        if (out == null) {
            return false;
        }
        out = out.func_77946_l();
        out.field_77994_a *= TileEntityCrystalFurnace.getMultiplyRate(this.inv[0], out);
        if (this.inv[1] == null) {
            return true;
        }
        return ReikaItemHelper.areStacksCombinable((ItemStack)out, (ItemStack)this.inv[1], (int)this.func_70297_j_());
    }

    private void smelt() {
        ItemStack is = FurnaceRecipes.func_77602_a().func_151395_a(this.inv[0]).func_77946_l();
        ElementTagCompound tag = TileEntityCrystalFurnace.getSmeltingCost(this.inv[0], is);
        is.field_77994_a *= TileEntityCrystalFurnace.getMultiplyRate(this.inv[0], is);
        ReikaInventoryHelper.addOrSetStack((ItemStack)is, (ItemStack[])this.inv, (int)1);
        this.xp += FurnaceRecipes.func_77602_a().func_151398_b(this.inv[1]) * 6.0f * TileEntityCrystalFurnace.getXPModifier(this.inv[0]);
        if (this.xp >= 1.0f) {
            int amt = (int)(this.xp / 1.0f);
            this.tank.addLiquid(amt, FluidRegistry.getFluid((String)"chroma"));
            this.xp = 0.0f;
        }
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
        tag.addValueToColor(CrystalElement.LIGHTBLUE, 250);
        this.drainEnergy(tag);
    }

    public static float getXPModifier(ItemStack in) {
        if (ReikaBlockHelper.isOre((ItemStack)in)) {
            return 2.0f;
        }
        if (ModList.ROTARYCRAFT.isLoaded() && ExtractorModOres.isOreFlake((ItemStack)in)) {
            return 2.0f;
        }
        if (in.func_77973_b() instanceof ItemFood) {
            return 0.125f;
        }
        if (ReikaItemHelper.matchStackWithBlock((ItemStack)in, (Block)Blocks.field_150364_r) || ReikaItemHelper.matchStackWithBlock((ItemStack)in, (Block)Blocks.field_150363_s)) {
            return 1.125f;
        }
        if (ModWoodList.isModWood((ItemStack)in)) {
            return 1.125f;
        }
        if (ModList.THAUMCRAFT.isLoaded() && in.func_77973_b() == ThaumItemHelper.ItemEntry.NUGGETCLUSTER.getItem().func_77973_b()) {
            return 4.0f;
        }
        if (in.func_82833_r() != null && in.func_82833_r().toLowerCase(Locale.ENGLISH).contains("cobblestone")) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static ElementTagCompound getSmeltingCost(ItemStack in, ItemStack out) {
        ElementTagCompound tag = smelt.copy();
        if (ReikaBlockHelper.isOre((ItemStack)in)) {
            tag.scale(1.5f);
        } else if (HardOresHandler.instance.isLoaded() && HardOresHandler.instance.getRootOre(in) != null) {
            tag.scale(4.0f);
        } else if (ModList.ROTARYCRAFT.isLoaded() && ExtractorModOres.isOreFlake((ItemStack)in)) {
            tag.scale(2.0f);
            OreType ore = ExtractorModOres.getOreFromExtract((ItemStack)in);
            if (ore.getRarity() == OreType.OreRarity.RARE) {
                tag.scale(1.5f);
            }
        } else if (in.func_77973_b() instanceof ItemFood) {
            tag.scale(0.5f);
        } else if (ReikaItemHelper.matchStackWithBlock((ItemStack)in, (Block)Blocks.field_150364_r) || ReikaItemHelper.matchStackWithBlock((ItemStack)in, (Block)Blocks.field_150363_s)) {
            tag.scale(0.75f);
        } else if (ModWoodList.isModWood((ItemStack)in)) {
            tag.scale(0.75f);
        }
        return tag.scale((float)Math.pow((float)TileEntityCrystalFurnace.getMultiplyRate(in, out) / 2.0f, 2.0));
    }

    public static int getMultiplyRate(ItemStack in, ItemStack out) {
        int ret;
        if (in.func_77973_b() instanceof CrystalFurnaceMultiplier && (ret = ((CrystalFurnaceMultiplier)in.func_77973_b()).getMultiplyRateAsInput(in, out)) > 0) {
            return ret;
        }
        if (out.func_77973_b() instanceof CrystalFurnaceMultiplier && (ret = ((CrystalFurnaceMultiplier)out.func_77973_b()).getMultiplyRateAsOutput(out, in)) > 0) {
            return ret;
        }
        return TileEntityCrystalFurnace.calcMultiplyRate(in, out);
    }

    private static int calcMultiplyRate(ItemStack in, ItemStack out) {
        if (ChromaBlocks.PYLONSTRUCT.match(out)) {
            return 1;
        }
        if (in.func_82833_r() != null && in.func_82833_r().toLowerCase(Locale.ENGLISH).contains("cobblestone")) {
            return 1;
        }
        if (ModList.GENDUSTRY.isLoaded() && in.func_82833_r() != null && in.func_82833_r().toLowerCase(Locale.ENGLISH).contains("gene")) {
            return 1;
        }
        if (Block.func_149634_a((Item)in.func_77973_b()) instanceof CraftableStone) {
            return 1;
        }
        if (ModList.GREGTECH.isLoaded() && (ReikaItemHelper.getRegistrantMod((ItemStack)in).toLowerCase(Locale.ENGLISH).contains("gregapi") || ReikaItemHelper.getRegistrantMod((ItemStack)in).toLowerCase(Locale.ENGLISH).contains("gregtech"))) {
            if (in.func_77973_b() instanceof ItemFood) {
                return 2;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)in);
            for (int i = 0; i < ids.length; ++i) {
                String name = OreDictionary.getOreName((int)ids[i]);
                if (!name.startsWith("crushed") && !name.startsWith("ore")) continue;
                return 2;
            }
            return 1;
        }
        if (ModList.GEOSTRATA.isLoaded() && RockTypes.getTypeFromID((Block)Block.func_149634_a((Item)in.func_77973_b())) != null) {
            return 1;
        }
        if (ModList.ROTARYCRAFT.isLoaded() && ReikaItemHelper.matchStacks((ItemStack)in, (ItemStack)ItemStackRepository.instance.getItem(ModList.ROTARYCRAFT, "ironscrap"))) {
            return 1;
        }
        if (ModList.THAUMCRAFT.isLoaded() && in.func_77973_b() == ThaumItemHelper.ItemEntry.NUGGETCLUSTER.getItem().func_77973_b()) {
            return 4;
        }
        if (ModList.THAUMCRAFT.isLoaded() && in.func_77973_b() == ThaumItemHelper.ItemEntry.COIN.getItem().func_77973_b()) {
            return 1;
        }
        if (ModList.APPENG.isLoaded() && ReikaItemHelper.matchStackWithBlock((ItemStack)in, (Block)AppEngHandler.getInstance().chargedCertusOre)) {
            return 8;
        }
        if (ReikaItemHelper.getRegistrantMod((ItemStack)in).equals("GardenStuff") && Item.field_150901_e.func_148750_c((Object)in.func_77973_b()).equals("wrought_iron_ingot")) {
            return 1;
        }
        if (ReikaBlockHelper.isOre((ItemStack)in)) {
            int ret = 4;
            ReikaOreHelper ore = ReikaOreHelper.getEntryByOreDict((ItemStack)in);
            if (ore == null) {
                ore = ModOreList.getModOreFromOre((ItemStack)in);
            }
            if (ore != null) {
                if (ore.getRarity() == OreType.OreRarity.RARE) {
                    ret *= 2;
                }
                ret *= ore.getDropCount();
            }
            return ret;
        }
        if (HardOresHandler.instance.isLoaded() && HardOresHandler.instance.getRootOre(in) != null) {
            in = HardOresHandler.instance.getRootOre(in);
            out = FurnaceRecipes.func_77602_a().func_151395_a(in);
            if (out != null && !ReikaItemHelper.matchStacks((ItemStack)in, (ItemStack)out)) {
                return HardOresHandler.instance.getYield(in) * TileEntityCrystalFurnace.getMultiplyRate(in, out);
            }
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)in);
        for (int i = 0; i < ids.length; ++i) {
            String name = OreDictionary.getOreName((int)ids[i]);
            if (name.startsWith("dust")) {
                return 1;
            }
            if (!name.equalsIgnoreCase("cobblestone")) continue;
            return 1;
        }
        return 2;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.smeltTimer = NBT.func_74762_e("time");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("time", this.smeltTimer);
        this.tank.writeToNBT(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    @Override
    public ElementTagCompound getRequiredEnergy() {
        ElementTagCompound tag = smelt.copy();
        tag.addTag(CrystalElement.LIGHTBLUE, 500);
        return tag;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return e == CrystalElement.LIGHTBLUE ? 60000 : 400000;
    }

    public static ElementTagCompound smeltTags() {
        return smelt.copy();
    }

    public int getCookProgressScaled(int a) {
        return this.smeltTimer * a / this.getSmeltTime();
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return smelt.contains(e) || e == CrystalElement.LIGHTBLUE;
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.canDrain(from, null) ? this.tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @DependentMethodStripper.ModDependent(value={ModList.BCTRANSPORT})
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public int getIconState(int side) {
        return side > 1 && this.canSmelt() ? 1 : 0;
    }

    @Override
    public float getOperationFraction() {
        return !this.canSmelt() ? 0.0f : (float)this.smeltTimer / (float)Math.max(1, this.getSmeltTime());
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.inv[0] != null && FurnaceRecipes.func_77602_a().func_151395_a(this.inv[0]) != null ? (this.energy.containsAtLeast(smelt) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }

    static {
        smelt.addTag(CrystalElement.ORANGE, 200);
        smelt.addTag(CrystalElement.YELLOW, 40);
        smelt.addTag(CrystalElement.PURPLE, 100);
    }
}

