/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Processing;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaExtractable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.Interfaces.VariableTexture;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaEnchants;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModList;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntityEnchantDecomposer
extends InventoriedRelayPowered
implements IFluidHandler,
IPipeConnection,
OperationInterval,
VariableTexture,
ChromaExtractable {
    private static final ElementTagCompound required = new ElementTagCompound();
    public static final int CAPACITY = 6000;
    public int processTimer;
    private final HybridTank tank = new HybridTank("enchantdecomp", 6000);
    private EntityItem entity;

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.entity = this.inv[0] != null ? new InertItem(this.field_145850_b, this.inv[0]) : null;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.canProcess()) {
            ++this.processTimer;
            if (this.processTimer >= this.getProcessTime()) {
                this.process();
                this.processTimer = 0;
            }
        } else {
            this.processTimer = 0;
        }
    }

    public int getProcessTime() {
        if (this.inv[0] == null) {
            return 1;
        }
        HashMap map = ReikaEnchantmentHelper.getEnchantments((ItemStack)this.inv[0]);
        int t = 0;
        for (Integer lvl : map.values()) {
            t += 10 * lvl * lvl;
        }
        return t;
    }

    public static int getChromaValue(ItemStack is) {
        int val = 0;
        HashMap map = ReikaEnchantmentHelper.getEnchantments((ItemStack)is);
        for (Enchantment e : map.keySet()) {
            val += ReikaMathLibrary.roundDownToX((int)100, (int)((int)(100.0 * Math.pow(TileEntityEnchantDecomposer.getEnchantPowerValue(e), ((Integer)map.get(e)).intValue()))));
        }
        return val;
    }

    private static double getEnchantPowerValue(Enchantment e) {
        if (e == ChromaEnchants.WEAPONAOE.getEnchantment()) {
            return 1.75;
        }
        if (e == Enchantment.field_77348_q) {
            return 1.5;
        }
        if (e == Enchantment.field_77342_w) {
            return 1.5;
        }
        if (e == Enchantment.field_77346_s) {
            return 1.25;
        }
        if (e == Enchantment.field_77345_t) {
            return 1.25;
        }
        if (e == Enchantment.field_77332_c) {
            return 1.25;
        }
        if (e == Enchantment.field_77338_j) {
            return 1.125;
        }
        if (e == Enchantment.field_77347_r) {
            return 1.125;
        }
        String n = e.func_77320_a().toLowerCase(Locale.ENGLISH);
        if (n.contains("soul") && n.contains("bound")) {
            return 2.0;
        }
        return 1.0;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 && TileEntityEnchantDecomposer.isItemValid(is);
    }

    public static boolean isItemValid(ItemStack is) {
        return ReikaEnchantmentHelper.hasEnchantments((ItemStack)is);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ENCHANTDECOMP;
    }

    private boolean canProcess() {
        if (this.inv[0] == null) {
            return false;
        }
        if (!this.energy.containsAtLeast(required)) {
            return false;
        }
        if (!TileEntityEnchantDecomposer.isItemValid(this.inv[0])) {
            return false;
        }
        int val = TileEntityEnchantDecomposer.getChromaValue(this.inv[0]);
        return this.tank.canTakeIn(val);
    }

    private void process() {
        this.tank.addLiquid(TileEntityEnchantDecomposer.getChromaValue(this.inv[0]), FluidRegistry.getFluid((String)"chroma"));
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
        this.drainEnergy(required);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.processTimer = NBT.func_74762_e("time");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("time", this.processTimer);
        this.tank.writeToNBT(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    public static ElementTagCompound getTags() {
        return required.copy();
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 1000;
    }

    public int getCookProgressScaled(int a) {
        return this.canProcess() ? this.processTimer * a / this.getProcessTime() : 0;
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return this.isAcceptingColor(e);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.canDrain(from, null) ? this.tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @DependentMethodStripper.ModDependent(value={ModList.BCTRANSPORT})
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public int getIconState(int side) {
        return side > 1 && this.canProcess() ? 1 : 0;
    }

    public int getFluidScaled(int i) {
        return i * this.tank.getLevel() / this.tank.getCapacity();
    }

    public EntityItem getEntityItem() {
        return this.entity;
    }

    @Override
    public int getChromaLevel() {
        return this.tank.getLevel();
    }

    @Override
    public void removeLiquid(int amt) {
        this.tank.removeLiquid(amt);
    }

    @Override
    public float getOperationFraction() {
        return !this.canProcess() ? 0.0f : (float)this.processTimer / (float)Math.max(1, this.getProcessTime());
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.inv[0] != null && TileEntityEnchantDecomposer.isItemValid(this.inv[0]) ? (this.energy.containsAtLeast(required) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }

    static {
        required.addTag(CrystalElement.PURPLE, 50);
        required.addTag(CrystalElement.BLACK, 20);
    }
}

