/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Processing;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.FabricationRecipes;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Magic.ElementMixer;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.LumenTile;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.RunningAverage;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Event.ScheduledTickEvent;
import Reika.DragonAPI.Instantiable.Rendering.FXCollection;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityGlowFire
extends InventoriedChromaticBase
implements LumenTile,
InertIInv,
ItemOnRightClick,
BreakAction {
    public static final int MAX_BRANCHES = 6;
    private static final float BASE_ITEM_FACTOR = 10.0f;
    public static final String DROP_TAG = "GlowFire";
    private final ElementTagCompound energy = new ElementTagCompound();
    private RunningAverage averageIngredientValue = new RunningAverage();
    private RunningAverage averageOutputValue = new RunningAverage();
    private int temperatureBoost;
    private double primaryAngleTheta = rand.nextDouble() * 360.0;
    private double primaryAngleThetaVel = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)90.0);
    private double primaryAnglePhi = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)3);
    private double primaryAnglePhiVel = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)3);
    private double[] secondaryAngleTheta = new double[6];
    private double[] secondaryAnglePhi = new double[6];
    private double[] secondaryAngleThetaVel = new double[6];
    private double[] secondaryAnglePhiVel = new double[6];
    private int[] secondaryLife = new int[6];
    @SideOnly(value=Side.CLIENT)
    public FXCollection particles;

    public TileEntityGlowFire() {
        if (this.getSide() == Side.CLIENT) {
            this.particles = new FXCollection();
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.GLOWFIRE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            this.particles.update();
            int n = Math.round(1.0f + this.isSmothered() * 4.0f);
            if (rand.nextInt(n) == 0) {
                this.doParticles(world, x, y, z);
            }
        } else {
            if (this.temperatureBoost > 0) {
                if (rand.nextInt(6) == 0) {
                    --this.temperatureBoost;
                }
            } else {
                CrystalElement e = (CrystalElement)this.energy.asWeightedRandom().getRandomEntry();
                int has = this.energy.getValue(e);
                if (has > 1 && rand.nextFloat() < (float)has / (float)this.getMaxStorage(e)) {
                    this.energy.subtract(e, 1);
                }
            }
            this.consumeItems(world, x, y, z);
            this.doOverloadShocks();
        }
    }

    private void doOverloadShocks() {
        CrystalElement e = (CrystalElement)this.energy.asWeightedRandom().getRandomEntry();
        float f = 0.005859375f * (float)this.energy.getValue(e) / (float)this.getMaxStorage(e);
        if (ReikaRandomHelper.doWithChance((double)f)) {
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(6.0, 3.0, 6.0);
            List li = this.field_145850_b.func_72872_a(EntityPlayer.class, box);
            for (EntityPlayer ep : li) {
                TileEntityGlowFire.dischargeIntoPlayer(this, ep, e, 1.0f);
            }
        }
    }

    public float isSmothered() {
        double f = this.getValueRatio();
        if (f <= 1.0 || f == Double.NaN || f == Double.POSITIVE_INFINITY || f == Double.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        if ((f = Math.pow(f, 0.75)) >= 2.5) {
            return 1.0f;
        }
        return (float)((f - 1.0) / 1.5);
    }

    public int getTemperatureBoost() {
        return this.temperatureBoost;
    }

    public boolean craft() {
        if (this.inv[0] == null) {
            return false;
        }
        if (this.energy.isEmpty()) {
            return false;
        }
        ItemStack in = this.inv[0];
        ItemStack out = in.func_77946_l();
        EntityPlayer ep = this.getPlacer();
        if (ep != null && !ReikaPlayerAPI.isFake((EntityPlayer)ep) && Chromabilities.DOUBLECRAFT.enabledOn(ep)) {
            out.field_77994_a *= 2;
        }
        this.inv[0] = null;
        boolean flag = true;
        boolean flag2 = false;
        while (flag) {
            this.dropItem(out);
            flag = this.craftAndDrop(in);
            flag2 |= flag;
        }
        return flag2;
    }

    private double getValueRatio() {
        if (this.averageOutputValue.getAverage() == 0.0) {
            return 1.0;
        }
        return (this.averageOutputValue.getAverage() - (double)this.temperatureBoost) / this.averageIngredientValue.getAverage();
    }

    private boolean craftAndDrop(ItemStack in) {
        ElementTagCompound cost = TileEntityGlowFire.getCost(in);
        ElementTagCompound remove = new ElementTagCompound();
        boolean[] flags = ReikaArrayHelper.getTrueArray((int)16);
        for (CrystalElement e : cost.elementSet()) {
            int req = cost.getValue(e);
            if (this.energy.getValue(e) >= req) {
                remove.addTag(e, req);
                continue;
            }
            flags[e.ordinal()] = false;
        }
        for (int i = 0; i < 16; ++i) {
            CrystalElement e;
            if (flags[i]) continue;
            e = CrystalElement.elements[i];
            if (e.isPrimary()) {
                return false;
            }
            ElementTagCompound combine = TileEntityGlowFire.getCompositionCost(e, cost.getValue(e));
            for (CrystalElement e2 : combine.elementSet()) {
                int add = combine.getValue(e2);
                remove.addValueToColor(e2, add);
            }
        }
        remove = this.getModulatedCost(remove);
        for (CrystalElement e : remove.elementSet()) {
            int val = remove.getValue(e);
            if (this.energy.getValue(e) >= val) continue;
            return false;
        }
        int amt = remove.getTotalEnergy();
        this.averageOutputValue.addValue((double)amt);
        this.temperatureBoost = Math.max(this.temperatureBoost - amt, 0);
        this.energy.subtract(remove);
        return true;
    }

    private ElementTagCompound getModulatedCost(ElementTagCompound value) {
        if (this.temperatureBoost <= 0) {
            return value;
        }
        ElementTagCompound ret = new ElementTagCompound();
        for (CrystalElement e : value.elementSet()) {
            float val;
            float f = value.getFraction(e);
            float boost = (float)this.temperatureBoost * f;
            val = boost < (val = (float)value.getValue(e)) ? (val -= boost) : (val > 1.0f ? 1.0f / (boost - val + 2.0f) : 1.0f / (boost + 1.0f));
            ret.addTag(e, (int)Math.max(1.0f, val));
        }
        return ret;
    }

    public static ElementTagCompound getCompositionCost(CrystalElement e, int amt) {
        ElementTagCompound tag = new ElementTagCompound();
        Collection<CrystalElement> parents = ElementMixer.instance.getMixParents(e);
        if (parents == null) {
            return null;
        }
        for (CrystalElement in : parents) {
            tag.addTag(in, 2);
        }
        while (!tag.isPrimaryOnly()) {
            for (CrystalElement in : tag.elementSet()) {
                if (in.isPrimary()) continue;
                int get = tag.removeTag(in);
                Collection<CrystalElement> parents2 = ElementMixer.instance.getMixParents(in);
                for (CrystalElement in2 : parents2) {
                    tag.addTag(in2, get + 1);
                }
            }
        }
        for (CrystalElement in : tag.elementSet()) {
            tag.setTag(in, MathHelper.func_76143_f((double)Math.pow(amt, -0.75 + (double)tag.getValue(in))));
        }
        return tag;
    }

    private void consumeItems(World world, int x, int y, int z) {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72331_e(0.2, 0.2, 0.2);
        List li = world.func_72872_a(EntityItem.class, box);
        for (EntityItem ei : li) {
            ItemStack is;
            ElementTagCompound tag;
            if (!this.isConsumableItem(ei) || (tag = this.consumeItem(is = ei.func_92059_d())) == null) continue;
            --is.field_77994_a;
            if (is.field_77994_a <= 0) {
                ei.func_70106_y();
            }
            this.energy.addTag(this.getScaledBurnValue(is, tag));
            this.averageIngredientValue.addValue((double)tag.getTotalEnergy());
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FIRECONSUMEITEM.ordinal(), (TileEntity)this, (int)32, (int[])new int[]{tag.keySetAsBits()});
        }
    }

    private boolean isConsumableItem(EntityItem ei) {
        if (ei.getEntityData().func_74767_n(DROP_TAG) || ei.getEntityData().func_74764_b("PLAYER_DEATH_DROP")) {
            return false;
        }
        EntityPlayer ep = ReikaItemHelper.getDropper((EntityItem)ei);
        return ep != null && !ReikaPlayerAPI.isFake((EntityPlayer)ep) && !(ep.func_70068_e((Entity)ei) >= 64.0);
    }

    private ElementTagCompound consumeItem(ItemStack is) {
        ElementTagCompound tag = TileEntityGlowFire.getDecompositionValue(is);
        if (tag != null) {
            for (CrystalElement e : tag.elementSet()) {
                if (this.energy.getValue(e) + tag.getValue(e) <= this.getMaxStorage(e)) continue;
                return null;
            }
            if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaStacks.glowcavedust)) {
                tag.intersectWith(this.energy);
                if (!tag.isEmpty()) {
                    ++this.temperatureBoost;
                }
            }
        }
        if (tag != null && tag.isEmpty()) {
            tag = null;
        }
        return tag;
    }

    private ElementTagCompound getScaledBurnValue(ItemStack is, ElementTagCompound tag) {
        int[] data = tag.toArray();
        double f = Math.min(2.5, 1.0 / this.getValueRatio());
        for (int i = 0; i < 16; ++i) {
            data[i] = (int)((double)data[i] * f);
        }
        return new ElementTagCompound(data);
    }

    public static ElementTagCompound getCost(ItemStack is) {
        if (!FabricationRecipes.recipes().isItemFabricable(is)) {
            return null;
        }
        if (ReikaBlockHelper.isOre((ItemStack)is)) {
            return null;
        }
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(is).copy();
        if (tag != null) {
            tag = TileEntityGlowFire.scaleCostTag(is, tag);
        }
        return tag != null && !tag.isEmpty() ? tag : null;
    }

    public static ElementTagCompound getDecompositionValue(ItemStack is) {
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(is);
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        tag = tag.copy();
        tag = TileEntityGlowFire.scaleDecompositionTag(is, tag);
        return tag;
    }

    private static ElementTagCompound scaleCostTag(ItemStack is, ElementTagCompound tag) {
        boolean sc = tag.getMaximumValue() == 1;
        tag.power(1.15).scale(1.5f);
        if (ChromaBlocks.CRYSTAL.match(is)) {
            tag.power(1.1);
            tag.scale(2.0f);
        }
        tag.scale(10.0f);
        if (is.func_77973_b() == Items.field_151100_aR || ChromaItems.DYE.matchWith(is) || ReikaItemHelper.isOreNugget((ItemStack)is)) {
            tag.scale(0.25f);
        }
        if (sc) {
            tag.scale(1.2f);
        }
        if (ChromaItems.SHARD.matchWith(is)) {
            tag.scale(is.func_77960_j() >= 16 ? 5.0f : 2.0f);
        }
        if (ReikaItemHelper.isInOreTag((ItemStack)is, (String)"flower")) {
            TileEntityGlowFire.addFlowerCrafting(is, tag);
        }
        return tag;
    }

    private static void addFlowerCrafting(ItemStack is, ElementTagCompound tag) {
        ItemStack out = ReikaRecipeHelper.getShapelessCraftResult((ItemStack[])new ItemStack[]{is});
        Collection c = ReikaDyeHelper.getColorsFromItem((ItemStack)out);
        if (c != null) {
            for (ReikaDyeHelper dye : c) {
                tag.addValueToColor(CrystalElement.elements[dye.ordinal()], 2);
            }
        }
    }

    private static ElementTagCompound scaleDecompositionTag(ItemStack is, ElementTagCompound tag) {
        if (is.func_77973_b() != Items.field_151100_aR && !ChromaItems.DYE.matchWith(is) && !ReikaItemHelper.isOreNugget((ItemStack)is)) {
            tag.scale(10.0f);
        }
        if (ChromaBlocks.PYLONSTRUCT.match(is)) {
            tag.scale(0.2f);
        }
        if (ChromaItems.SHARD.matchWith(is)) {
            tag.scale(is.func_77960_j() >= 16 ? 3.0f : 2.0f);
        }
        return tag;
    }

    @SideOnly(value=Side.CLIENT)
    public static void consumeItemFX(World world, int x, int y, int z, int colors) {
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if ((colors & 1 << e.ordinal()) == 0) continue;
            int n = 1 + rand.nextInt(5);
            for (int k = 0; k < n; ++k) {
                double rx = (double)x + rand.nextDouble();
                double ry = (double)y + rand.nextDouble();
                double rz = (double)z + rand.nextDouble();
                float s = 1.0f + rand.nextFloat();
                int l = 12 + rand.nextInt(18);
                EntityBlurFX fx = new EntityCCBlurFX(world, rx, ry, rz).setColor(e.getColor()).setLife(l).setScale(s).setRapidExpand();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public void empty() {
        if (!this.field_145850_b.field_72995_K) {
            ChromaSounds.RIFT.playSoundAtBlock((TileEntity)this);
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FIREDUMP.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{this.energy.keySetAsBits()});
            if (this.inv[0] != null) {
                this.dropItem(this.inv[0]);
            }
            this.inv[0] = null;
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(6.0, 3.0, 6.0);
            List li = this.field_145850_b.func_72872_a(EntityPlayer.class, box);
            for (EntityPlayer ep : li) {
                int tick = 1 + rand.nextInt(3);
                for (CrystalElement e : this.energy.elementSet()) {
                    TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)new GlowFireDischarge(this, ep, e, (float)this.energy.getValue(e) / (float)this.getMaxStorage(e))), tick);
                    tick += 1 + rand.nextInt(10);
                }
            }
            this.energy.clear();
            this.temperatureBoost = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void emptyClientFX(World world, int x, int y, int z, int colors) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if ((colors & 1 << e.ordinal()) == 0) continue;
            li.add(e.getColor());
        }
        if (li.isEmpty()) {
            li.add(2134271);
        }
        int n = 20 + rand.nextInt(90);
        for (int i = 0; i < n; ++i) {
            EntityBlurFX fx = new EntityCCFloatingSeedsFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, rand.nextDouble() * 360.0, ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)10.0)).setColor((Integer)li.get(rand.nextInt(li.size()))).setColliding();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        this.addParticle(world, x, y, z, this.primaryAnglePhi, this.primaryAngleTheta, true, 0.0);
        this.primaryAngleTheta += this.primaryAngleThetaVel;
        this.primaryAnglePhi += this.primaryAnglePhiVel;
        if (rand.nextInt(200) == 0) {
            this.primaryAngleThetaVel = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)3);
            this.primaryAnglePhiVel = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)3);
        }
        for (int i = 0; i < 6; ++i) {
            if (this.secondaryLife[i] > 0) {
                int n = i;
                this.secondaryLife[n] = this.secondaryLife[n] - 1;
                this.addParticle(world, x, y, z, this.secondaryAnglePhi[i], this.secondaryAngleTheta[i], false, this.secondaryLife[i]);
                int n2 = i;
                this.secondaryAngleTheta[n2] = this.secondaryAngleTheta[n2] + this.secondaryAngleThetaVel[i];
                int n3 = i;
                this.secondaryAnglePhi[n3] = this.secondaryAnglePhi[n3] + this.secondaryAnglePhiVel[i];
                if (rand.nextInt(20) != 0) continue;
                this.retargetSecondary(i);
                continue;
            }
            if (rand.nextInt(40) != 0) continue;
            this.secondaryLife[i] = 30 + rand.nextInt(270);
            this.retargetSecondary(i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addParticle(World world, int x, int y, int z, double phi, double theta, boolean primary, double timer) {
        int l0 = primary ? 10 + rand.nextInt(30) : 10 + rand.nextInt(10);
        int l = (int)((float)l0 + (float)this.temperatureBoost / 5.0f);
        float s = primary ? 2.2f : 1.25f;
        double[] v = ReikaPhysicsHelper.polarToCartesian((double)(0.125 / (double)l0 * 6.0), (double)theta, (double)phi);
        int c = ReikaColorAPI.getModifiedHue((int)1077503, (int)((int)(215.0 + 70.0 * Math.sin(timer / 40.0))));
        float f = this.isSmothered();
        if (f > 0.0f) {
            int c2 = ReikaColorAPI.getModifiedHue((int)c, (int)rand.nextInt(60));
            c2 = ReikaColorAPI.getModifiedSat((int)c2, (float)0.5f);
            c2 = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c2, (float)(0.5f + 0.25f * rand.nextFloat()));
            c = ReikaColorAPI.mixColors((int)c2, (int)c, (float)f);
        }
        EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, v[0], v[1], v[2]).setColor(c).setScale(s).setLife(l);
        if (primary) {
            fx.setRapidExpand();
        }
        if (rand.nextBoolean()) {
            fx.setColliding();
            fx.forceIgnoreLimits();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        } else if (GuiScreen.func_146271_m()) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        } else {
            this.particles.addEffectWithVelocity(0.5, 0.5, 0.5, v[0], v[1], v[2], ChromaIcons.FADE.getIcon(), l, s, c, primary);
        }
    }

    private void retargetSecondary(int i) {
        this.secondaryAngleThetaVel[i] = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)2);
        this.secondaryAnglePhiVel[i] = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)2);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(2.0, 2.0, 2.0);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getEnergy(CrystalElement e) {
        return this.energy.getValue(e);
    }

    @Override
    public ElementTagCompound getEnergy() {
        return this.energy.copy();
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 10000 + Math.min(10000, 50 * this.temperatureBoost);
    }

    public boolean func_102008_b(int i, ItemStack is, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    @Override
    public ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        if (this.inv[0] != null) {
            this.dropItem(this.inv[0]);
            this.inv[0] = null;
        }
        if (item != null) {
            if (TileEntityGlowFire.getCost(item) != null) {
                this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)item, (int)1);
                --item.field_77994_a;
                return item.field_77994_a > 0 ? item : null;
            }
        }
        return item;
    }

    private void dropItem(ItemStack is) {
        EntityItem ei = ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        ei.getEntityData().func_74757_a(DROP_TAG, true);
        this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.pop", 1.0f, 0.8f, true);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.energy.readFromNBT("energy", NBT);
        this.temperatureBoost = NBT.func_74762_e("temp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.energy.writeToNBT("energy", NBT);
        NBT.func_74768_a("temp", this.temperatureBoost);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.averageIngredientValue.readFromNBT("inputval", NBT);
        this.averageOutputValue.readFromNBT("outputval", NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.averageIngredientValue.writeToNBT("inputval", NBT);
        this.averageOutputValue.writeToNBT("outputval", NBT);
    }

    public void breakBlock() {
        this.empty();
    }

    private static void dischargeIntoPlayer(TileEntityGlowFire tile, EntityPlayer player, CrystalElement color, float power) {
        ChromaAux.dischargeIntoPlayer((double)tile.field_145851_c + 0.5, player.field_70163_u, (double)tile.field_145849_e + 0.5, rand, (EntityLivingBase)player, color, power, 1.0f);
    }

    private static class GlowFireDischarge
    implements ScheduledTickEvent.DelayableSchedulableEvent {
        private final DecimalPosition tile;
        private final EntityPlayer player;
        private final CrystalElement color;
        private final float fraction;

        public GlowFireDischarge(TileEntityGlowFire te, EntityPlayer ep, CrystalElement e, float amt) {
            this.tile = new DecimalPosition((TileEntity)te);
            this.player = ep;
            this.color = e;
            this.fraction = amt;
        }

        public void fire() {
            ChromaAux.dischargeIntoPlayer(this.tile.xCoord, this.tile.yCoord * 0.0 + this.player.field_70163_u, this.tile.zCoord, this.player.field_70170_p.field_73012_v, (EntityLivingBase)this.player, this.color, this.fraction, 1.0f);
        }

        public boolean runOnSide(Side s) {
            return s == Side.SERVER;
        }

        public boolean canTick() {
            return this.player != null && !ReikaPlayerAPI.isFake((EntityPlayer)this.player) && this.player.field_70170_p != null && ReikaPlayerAPI.getPlayerByNameAnyWorld((String)this.player.func_70005_c_()) != null;
        }
    }
}

