/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.Interfaces.FocusAcceleratable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemCollision;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.MultiBlockCheck;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityFlareFX;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFocusCrystal;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Collections.ThreadSafeSet;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public abstract class TileEntityAuraInfuser
extends InventoriedChromaticBase
implements ItemOnRightClick,
ItemCollision,
OwnedTile,
InertIInv,
IPipeConnection,
OperationInterval,
MultiBlockChromaTile,
FocusAcceleratable,
LocationCached,
IFluidHandler {
    private InertItem item;
    private int craftingTick = 0;
    private boolean hasStructure = true;
    private static final ElementTagCompound required = new ElementTagCompound();
    private EntityPlayer craftingPlayer;
    private static final int DURATION = 608;
    private int focusCrystalTotal;
    private boolean allExquisite = false;
    private int fluidCooldown = 0;
    protected final HashSet<Coordinate> focusCrystalSpots = new HashSet();
    private final ArrayList<Coordinate> chromaLocations = new ArrayList();
    private static final ThreadSafeSet<WorldLocation> cache = new ThreadSafeSet();

    public final void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.hasStructure) {
            if (this.craftingTick > 0) {
                this.tickCrafting(world, x, y, z);
            }
        } else {
            this.craftingTick = 0;
        }
        if (!world.field_72995_K && this.fluidCooldown > 0) {
            --this.fluidCooldown;
        }
        if (world.field_72995_K && this.hasStructure) {
            ChromaFX.doFocusCrystalParticles(world, x, y, z, this);
            if (this.craftingTick == 0) {
                this.doAmbientParticles(world, x, y, z);
            }
        }
        if (DragonAPICore.debugtest) {
            this.getStructure().getArray(world, x, y, z).place();
        }
    }

    protected void doAmbientParticles(World world, int x, int y, int z) {
    }

    protected abstract ChromaStructures getStructure();

    protected void onFirstTick(World world, int x, int y, int z) {
        this.validateStructure();
        cache.add((Object)new WorldLocation((TileEntity)this));
    }

    @Override
    public final void validateStructure() {
        this.focusCrystalTotal = 0;
        this.allExquisite = true;
        this.focusCrystalSpots.clear();
        this.chromaLocations.clear();
        ChromaStructures struct = this.getStructure();
        struct.getStructure().resetToDefaults();
        FilledBlockArray arr = struct.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.hasStructure = arr.matchInWorld();
        this.collectChromaLocations(arr);
        if (this.hasStructure) {
            this.collectFocusCrystalLocations(arr);
            this.countFocusCrystals(arr);
        } else {
            if (this.craftingTick > 0) {
                this.killCrafting();
            }
            this.craftingTick = 0;
        }
        this.func_70296_d();
        this.syncAllData(false);
    }

    @Override
    public final ChromaStructures getPrimaryStructure() {
        return this.getStructure();
    }

    @Override
    public final Coordinate getStructureOffset() {
        return null;
    }

    @Override
    public final boolean canStructureBeInspected() {
        return true;
    }

    private void collectChromaLocations(FilledBlockArray arr) {
        for (Coordinate c : arr.keySet()) {
            if (arr.getBlockAt(c.xCoord, c.yCoord, c.zCoord) != ChromaBlocks.CHROMA.getBlockInstance()) continue;
            this.chromaLocations.add(c);
        }
    }

    protected final Collection<Coordinate> getChromaLocations() {
        return Collections.unmodifiableCollection(this.chromaLocations);
    }

    protected abstract void collectFocusCrystalLocations(FilledBlockArray var1);

    private void countFocusCrystals(FilledBlockArray arr) {
        for (Coordinate c2 : this.focusCrystalSpots) {
            if (ChromaTiles.getTile((IBlockAccess)this.field_145850_b, c2.xCoord, c2.yCoord, c2.zCoord) != ChromaTiles.FOCUSCRYSTAL) continue;
            TileEntityFocusCrystal te = (TileEntityFocusCrystal)c2.getTileEntity((IBlockAccess)this.field_145850_b);
            TileEntityFocusCrystal.CrystalTier ct = te.getTier();
            if (ct.ordinal() > 0) {
                int power = ReikaMathLibrary.intpow2((int)2, (int)(ct.getEffectiveOrdinal() - 1));
                this.focusCrystalTotal += power;
                if (!ct.isMaxPower()) {
                    this.allExquisite = false;
                }
                te.addConnection(this, true);
                continue;
            }
            this.focusCrystalTotal = 0;
            this.allExquisite = false;
            break;
        }
    }

    private void killCrafting() {
        ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
    }

    public final boolean hasStructure() {
        return this.hasStructure;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
        this.craftingTick = NBT.func_74762_e("craft");
        this.focusCrystalTotal = NBT.func_74762_e("focus");
        this.allExquisite = NBT.func_74767_n("exq");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
        NBT.func_74768_a("craft", this.craftingTick);
        NBT.func_74757_a("exq", this.allExquisite);
        NBT.func_74768_a("focus", this.focusCrystalTotal);
    }

    private void tickCrafting(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            this.spawnParticles(world, x, y, z);
        }
        if (!this.canCraft()) {
            this.craftingTick = 0;
            this.killCrafting();
            return;
        }
        int sp = this.getCraftSpeed();
        if (sp == 4 && this.craftingTick % 152 == 0) {
            ChromaSounds.INFUSION_SHORT.playSoundAtBlock((TileEntity)this);
        } else if (this.craftingTick % 304 == 0) {
            ChromaSounds.INFUSION.playSoundAtBlock((TileEntity)this);
        }
        --this.craftingTick;
        this.onCraftingTick(world, x, y, z);
        if (this.craftingTick == 0) {
            this.craft();
            if (world.field_72995_K) {
                this.craftParticles(world, x, y, z);
            }
            this.craftingPlayer = null;
        }
    }

    protected void onCraftingTick(World world, int x, int y, int z) {
    }

    private int getCraftSpeed() {
        if (this.allExquisite && this.focusCrystalTotal >= 16) {
            return 4;
        }
        if (this.focusCrystalTotal >= 8) {
            return 2;
        }
        return 1;
    }

    protected final EntityPlayer getCraftingPlayer() {
        return this.craftingPlayer;
    }

    private void craft() {
        ChromaSounds.INFUSE.playSoundAtBlock((TileEntity)this);
        this.onCraft();
        ChromaStructures struct = this.getStructure();
        struct.getStructure().resetToDefaults();
        FilledBlockArray arr = struct.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int i = 0; i < arr.getSize(); ++i) {
            Coordinate c = arr.getNthBlock(i);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            if (!arr.hasBlockAt(dx, dy, dz, ChromaBlocks.CHROMA.getBlockInstance(), 0)) continue;
            this.field_145850_b.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
        }
        this.validateStructure();
        this.scheduleCallback(new MultiBlockCheck(this), 20);
        this.scheduleCallback(new MultiBlockCheck(this), 100);
        this.scheduleCallback(new MultiBlockCheck(this), 200);
        this.func_70296_d();
    }

    protected abstract void onCraft();

    @SideOnly(value=Side.CLIENT)
    private void craftParticles(World world, int x, int y, int z) {
        for (int i = 0; i < 360; i += 15) {
            double ang = Math.toRadians(ReikaRandomHelper.getRandomPlusMinus((int)i, (int)5));
            double v = 0.075;
            double vx = v * Math.sin(ang);
            double vz = v * Math.cos(ang);
            EntityFlareFX fx = new EntityFlareFX(CrystalElement.WHITE, world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vx, 0.0, vz);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public final void func_70296_d() {
        super.func_70296_d();
        ItemStack is = this.inv[0];
        boolean flag = false;
        if (this.item == null) {
            flag = is != null;
        } else if (!ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)this.item.func_92059_d())) {
            flag = true;
        }
        if (flag) {
            InertItem inertItem = this.item = is != null ? new InertItem(this.field_145850_b, is) : null;
        }
        if (this.canCraft()) {
            if (this.craftingTick == 0) {
                this.craftingTick = 608 / this.getCraftSpeed();
            }
        } else {
            if (this.craftingTick > 0) {
                this.killCrafting();
            }
            this.craftingTick = 0;
        }
    }

    protected final boolean canCraft() {
        return this.getCraftingPlayer() != null && ProgressStage.ALLOY.isPlayerAtStage(this.getCraftingPlayer()) && this.isReady();
    }

    protected abstract boolean isReady();

    @SideOnly(value=Side.CLIENT)
    protected abstract void spawnParticles(World var1, int var2, int var3, int var4);

    public final boolean func_102008_b(int side, ItemStack is, int slot) {
        return false;
    }

    public final int func_70302_i_() {
        return 1;
    }

    protected final void animateWithTick(World world, int x, int y, int z) {
    }

    public final EntityItem getItem() {
        return this.item;
    }

    @Override
    public final ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        if (!this.isOwnedByPlayer(ep)) {
            return item;
        }
        this.validateStructure();
        if (!this.hasStructure) {
            if (this.inv[0] != null && item == null) {
                ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.inv[0]);
                this.inv[0] = null;
            }
            return item;
        }
        if (item != null && !this.func_94041_b(0, item)) {
            return item;
        }
        if (item != null && ReikaItemHelper.matchStacks((ItemStack)item, (ItemStack)this.inv[0]) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)this.inv[0])) {
            if (this.inv[0].field_77994_a + item.field_77994_a <= this.func_70297_j_()) {
                this.inv[0].field_77994_a += item.field_77994_a;
                item = null;
            } else if (this.inv[0].field_77994_a < this.func_70297_j_()) {
                ++this.inv[0].field_77994_a;
                --item.field_77994_a;
            }
        } else if (this.inv[0] != null) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.inv[0]);
            this.inv[0] = null;
        }
        if (item != null && this.inv[0] == null) {
            if (item.field_77994_a <= this.func_70297_j_()) {
                this.inv[0] = item.func_77946_l();
                item = null;
            } else {
                this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)item, (int)1);
                --item.field_77994_a;
            }
        }
        this.craftingPlayer = ep;
        this.syncAllData(true);
        return item;
    }

    @Override
    public final boolean onItemCollision(EntityItem ei) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack is = ei.func_92059_d();
            if (ei.field_145804_b == 0 && this.func_94041_b(0, is) && (this.inv[0] == null || ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.inv[0]))) {
                int has = this.inv[0] != null ? this.inv[0].field_77994_a : 0;
                int max = is.field_77994_a;
                int add = Math.min(max, is.func_77976_d() - has);
                if (add > 0) {
                    this.craftingTick = 0;
                    this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)(has + add));
                    is.field_77994_a -= add;
                    this.craftingPlayer = ReikaItemHelper.getDropper((EntityItem)ei);
                    this.syncAllData(true);
                    if (is.field_77994_a <= 0) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final int getCraftingTick() {
        return this.craftingTick;
    }

    @DependentMethodStripper.ModDependent(value={ModList.BCTRANSPORT})
    public final IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public final float getOperationFraction() {
        return 1.0f - (float)this.craftingTick / (float)(608 / this.getCraftSpeed());
    }

    @Override
    public final OperationInterval.OperationState getState() {
        return this.canCraft() ? (this.hasStructure ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    @Override
    public final float getAccelerationFactor() {
        return this.getCraftSpeed() == 1 ? 0.0f : (float)this.getCraftSpeed();
    }

    @Override
    public final float getMaximumAcceleratability() {
        return 4.0f;
    }

    @Override
    public final float getProgressToNextStep() {
        if (this.focusCrystalTotal < 8) {
            return (float)this.focusCrystalTotal / 8.0f;
        }
        if (this.focusCrystalTotal >= 16) {
            return 0.0f;
        }
        if (!this.allExquisite) {
            return 0.0f;
        }
        return (float)(this.focusCrystalTotal - 8) / 8.0f;
    }

    @Override
    public final void recountFocusCrystals() {
        this.validateStructure();
    }

    @Override
    public final Collection<Coordinate> getRelativeFocusCrystalLocations() {
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
        for (Coordinate c : this.focusCrystalSpots) {
            ret.add(c.offset(-this.field_145851_c, -this.field_145848_d, -this.field_145849_e));
        }
        return ret;
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
    }

    public final void breakBlock() {
        cache.remove((Object)new WorldLocation((TileEntity)this));
    }

    public static void clearCache() {
        cache.clear();
    }

    public static WorldLocation searchForMatch(Function<WorldLocation, Boolean> check) {
        return (WorldLocation)cache.iterateAsSearch(check);
    }

    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) && resource.amount >= 1000 && (!doFill || this.tryAddBucketToStructure()) ? 1000 : 0;
    }

    private boolean tryAddBucketToStructure() {
        Collection<Coordinate> li = this.getChromaLocations();
        for (Coordinate c : li) {
            if (!c.getBlock((IBlockAccess)this.field_145850_b).isAir((IBlockAccess)this.field_145850_b, c.xCoord, c.yCoord, c.zCoord) && (c.getBlock((IBlockAccess)this.field_145850_b) != ChromaBlocks.CHROMA.getBlockInstance() || c.getBlockMetadata((IBlockAccess)this.field_145850_b) == 0)) continue;
            c.setBlock(this.field_145850_b, ChromaBlocks.CHROMA.getBlockInstance());
            ReikaSoundHelper.playSoundFromServerAtBlock((World)this.field_145850_b, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (String)"game.neutral.swim", (float)1.0f, (float)(0.5f + rand.nextFloat()), (boolean)true);
            this.fluidCooldown = 2;
            return true;
        }
        return false;
    }

    public final FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public final boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fluidCooldown == 0 && fluid == ChromatiCraft.chroma && !this.field_145850_b.field_72995_K;
    }

    public final boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    static {
        required.addTag(CrystalElement.PURPLE, 500);
        required.addTag(CrystalElement.BLACK, 2500);
    }
}

