/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Auxiliary.Interfaces.CastingAutomationBlock;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecursiveCastingAutomationSystem;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityGlobeFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingInjector;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.ModList;
import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCastingAuto
extends CrystalReceiverBase
implements CastingAutomationBlock<RecursiveCastingAutomationSystem> {
    private static final ElementTagCompound required = new ElementTagCompound();
    private RecursiveCastingAutomationSystem handler = new RecursiveCastingAutomationSystem(this);

    @Override
    public TileEntityCastingTable getTable() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        for (int i = 1; i < 5; ++i) {
            Block b = world.func_147439_a(x, y - i, z);
            if (b.isAir((IBlockAccess)world, x, y - i, z)) continue;
            return null;
        }
        TileEntity te = world.func_147438_o(x, y - 5, z);
        return te instanceof TileEntityCastingTable ? (TileEntityCastingTable)te : null;
    }

    public TileEntityCastingInjector getInjector(TileEntityCastingTable te) {
        TileEntity te2 = te.getAdjacentTileEntity(ForgeDirection.DOWN);
        return te2 instanceof TileEntityCastingInjector ? (TileEntityCastingInjector)te2 : null;
    }

    @Override
    public Collection<CastingRecipe> getAvailableRecipes() {
        TileEntityCastingTable te = this.getTable();
        return te != null ? te.getCompletedRecipes() : new HashSet<CastingRecipe>();
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.AUTOMATOR;
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        this.handler.destroy();
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        TileEntityCastingTable te = this.getTable();
        if (te != null && world.field_72995_K) {
            this.doConnectionParticles(world, x, y, z, te);
        }
        if (!world.field_72995_K) {
            TileEntityCastingInjector te2;
            if (te != null && (te2 = this.getInjector(te)) != null) {
                te2.setInactive(this);
            }
            this.handler.tick(world);
            if (this.getCooldown() == 0 && this.checkTimer.checkCap()) {
                this.checkAndRequest();
            }
        }
    }

    private void checkAndRequest() {
        for (CrystalElement e : required.elementSet()) {
            int sp;
            int amt = this.getEnergy(e);
            if (amt >= (sp = this.getRemainingSpace(e))) continue;
            this.requestEnergy(e, sp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doConnectionParticles(World world, int x, int y, int z, TileEntityCastingTable te) {
        double a = Math.toRadians(this.getTicksExisted() * 2 % 360);
        int n = 6;
        int sp = 360 / n;
        double r = 0.5 + 0.125 * Math.sin((double)this.getTicksExisted() / 10.0);
        for (int i = 0; i < 360; i += sp) {
            double ri = Math.toRadians(i);
            double dx = (double)x + 0.5 + r * Math.sin(a + ri);
            double dy = te.field_145848_d + 1;
            double dz = (double)z + 0.5 + r * Math.cos(a + ri);
            EntityGlobeFX fx = new EntityGlobeFX(world, dx, dy, dz, 0.0, 0.125, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public boolean canCraft(World world, int x, int y, int z, TileEntityCastingTable te) {
        return te.isReadyToCraft() && te.getPlacerUUID() != null && te.getPlacerUUID().equals(this.getPlacerUUID());
    }

    @Override
    public boolean isAbleToRun(TileEntityCastingTable te) {
        TileEntityCastingInjector te2 = this.getInjector(te);
        return te2 != null && te2.isAbleToRun(te) && this.energy.containsAtLeast(required);
    }

    @Override
    public int getInjectionTickRate() {
        return 5;
    }

    @Override
    public boolean canRecursivelyRequest(CastingRecipe c) {
        return true;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void onPathBroken(CrystalFlow p, CrystalNetworkLogger.FlowFail f) {
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    public int maxThroughput() {
        return 2500;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 12000;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public IGridNode getGridNode(ForgeDirection dir) {
        return this.handler.getGridNode(dir);
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public IGridNode getActionableNode() {
        return this.handler.getActionableNode();
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public void securityBreak() {
    }

    @Override
    public boolean onlyAllowOwnersToUse() {
        return true;
    }

    @Override
    public boolean canTriggerCrafting() {
        return true;
    }

    @Override
    public RecursiveCastingAutomationSystem getAutomationHandler() {
        return this.handler;
    }

    @Override
    public void consumeEnergy(CastingRecipe c, TileEntityCastingTable te, ItemStack is) {
        ElementTagCompound tag = required.copy();
        tag.scale(c.getAutomationCostFactor(this, te, is));
        this.drainEnergy(tag);
    }

    @Override
    public boolean canPlaceCentralItemForMultiRecipes() {
        return true;
    }

    @Override
    public TileEntity getItemPool() {
        return this.getAdjacentTileEntity(ForgeDirection.UP);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.handler.writeToNBT(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.handler.readFromNBT(NBT);
    }

    public void breakBlock() {
        this.handler.onBreak(this.field_145850_b);
    }

    static {
        required.addTag(CrystalElement.BLACK, 50);
        required.addTag(CrystalElement.PURPLE, 20);
        required.addTag(CrystalElement.LIGHTBLUE, 10);
        required.addTag(CrystalElement.LIGHTGRAY, 20);
    }
}

