/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.CastingAutomationSystem;
import Reika.ChromatiCraft.Auxiliary.Interfaces.CastingAutomationBlock;
import Reika.ChromatiCraft.Auxiliary.Interfaces.VariableTexture;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Block.BlockCastingInjectorFocus;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCastingInjector
extends InventoriedChromaticBase
implements CastingAutomationBlock<CastingAutomationSystem>,
VariableTexture {
    private static final HashSet<Coordinate> foci = new HashSet();
    private CastingAutomationSystem handler;
    private Coordinate delegate = null;
    private final HashSet<Coordinate> localFoci = new HashSet();

    public TileEntityCastingInjector() {
        this.handler = new CastingAutomationSystem(this);
    }

    public void setInactive(TileEntityCastingAuto te) {
        this.delegate = new Coordinate((TileEntity)te);
    }

    @Override
    public TileEntityCastingTable getTable() {
        TileEntity te = this.getAdjacentTileEntity(ForgeDirection.UP);
        return te instanceof TileEntityCastingTable ? (TileEntityCastingTable)te : null;
    }

    @Override
    public Collection<CastingRecipe> getAvailableRecipes() {
        TileEntityCastingTable te = this.getTable();
        HashSet<CastingRecipe> rec = te != null ? te.getCompletedRecipes() : new HashSet<CastingRecipe>();
        Iterator it = rec.iterator();
        while (it.hasNext()) {
            CastingRecipe c = (CastingRecipe)it.next();
            if (c.canBeSimpleAutomated()) continue;
            it.remove();
        }
        return rec;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.INJECTOR;
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        this.handler.destroy();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            if (this.delegate != null) {
                ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, this.delegate.xCoord, this.delegate.yCoord, this.delegate.zCoord);
                if (c != ChromaTiles.AUTOMATOR) {
                    this.delegate = null;
                }
            } else {
                this.handler.tick(world);
            }
            if (this.getTicksExisted() % 5 == 0) {
                this.checkStructure(this.getTable());
            }
            if (this.inv[0] != null) {
                TileEntityCastingAuto te;
                if (this.delegate != null && (te = (TileEntityCastingAuto)this.delegate.getTileEntity((IBlockAccess)world)) != null && te.getAutomationHandler().recursionEnabled && te.getAutomationHandler().isRecursiveCrafting()) {
                    te.getAutomationHandler().cacheIngredient(this.inv[0]);
                    this.inv[0] = null;
                }
                if (this.inv[0] != null) {
                    if (DragonAPICore.debugtest) {
                        ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 2.5), (double)((double)z + 0.5), (ItemStack)this.inv[0]);
                        this.inv[0] = null;
                    } else if (this.handler.recoverItem(this.inv[0])) {
                        this.inv[0] = null;
                    }
                }
            }
        }
    }

    @Override
    public int getInjectionTickRate() {
        return 30;
    }

    @Override
    public boolean canRecursivelyRequest(CastingRecipe c) {
        return false;
    }

    @Override
    public boolean isAbleToRun(TileEntityCastingTable te) {
        return this.localFoci.size() == foci.size();
    }

    private void checkStructure(TileEntityCastingTable te) {
        if (te == null) {
            return;
        }
        this.localFoci.clear();
        for (Coordinate c : foci) {
            Coordinate c2 = c.offset(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            if (c2.getBlock((IBlockAccess)te.field_145850_b) != ChromaBlocks.INJECTORAUX.getBlockInstance()) continue;
            BlockCastingInjectorFocus.CastingInjectorAuxTile te2 = (BlockCastingInjectorFocus.CastingInjectorAuxTile)c2.getTileEntity((IBlockAccess)te.field_145850_b);
            te2.setTile(this);
            this.localFoci.add(c);
        }
    }

    @Override
    public boolean canTriggerCrafting() {
        return false;
    }

    @Override
    public CastingAutomationSystem getAutomationHandler() {
        return this.handler;
    }

    @Override
    public void consumeEnergy(CastingRecipe c, TileEntityCastingTable te, ItemStack is) {
    }

    @Override
    public boolean canCraft(World world, int x, int y, int z, TileEntityCastingTable te) {
        return te.isReadyToCraft() && te.getPlacerUUID() != null && te.getPlacerUUID().equals(this.getPlacerUUID());
    }

    public final UUID getPlacerUUID() {
        EntityPlayer ep = this.getPlacer();
        return ep != null ? ep.func_110124_au() : null;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public IGridNode getGridNode(ForgeDirection dir) {
        return this.handler.getGridNode(dir);
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public void securityBreak() {
    }

    @Override
    public boolean onlyAllowOwnersToUse() {
        return true;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public IGridNode getActionableNode() {
        return this.handler.getActionableNode();
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return true;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return true;
    }

    @Override
    public int getIconState(int side) {
        return side != 0 && this.getTable() != null ? 1 : 0;
    }

    public static Set<Coordinate> getFoci() {
        return Collections.unmodifiableSet(foci);
    }

    @Override
    public boolean canPlaceCentralItemForMultiRecipes() {
        return false;
    }

    @Override
    public TileEntity getItemPool() {
        return this.getAdjacentTileEntity(ForgeDirection.DOWN);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.handler.writeToNBT(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.handler.readFromNBT(NBT);
    }

    public void breakBlock() {
        this.handler.onBreak(this.field_145850_b);
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
    }

    static {
        for (int i = -4; i <= 4; i += 4) {
            for (int k = -4; k <= 4; k += 4) {
                if (i == 0 && k == 0) continue;
                foci.add(new Coordinate(i, 0, k));
            }
        }
    }
}

