/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.API.Event.CastingEvent;
import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Auxiliary.Interfaces.FocusAcceleratable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.VariableTexture;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedCrystalReceiver;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.CastingTuning.CastingTuningManager;
import Reika.ChromatiCraft.Magic.CastingTuning.CastingTuningMismatchReaction;
import Reika.ChromatiCraft.Magic.CrystalTarget;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionCatchupHandling;
import Reika.ChromatiCraft.Magic.Progression.ProgressionLinking;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.BotaniaPetalShower;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.ChromatiCraft.Render.Particle.EntityGlobeFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.ChromatiCraft.Render.Particle.EntitySparkleFX;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFocusCrystal;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityItemStand;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Effects.EntityParticleEmitterFX;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.ConditionalUnbreakability;
import Reika.DragonAPI.Interfaces.TileEntity.TriggerableAction;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class TileEntityCastingTable
extends InventoriedCrystalReceiver
implements BreakAction,
TriggerableAction,
OwnedTile,
OperationInterval,
MultiBlockChromaTile,
FocusAcceleratable,
VariableTexture,
FilledBlockArray.BlockMatchFailCallback,
ConditionalUnbreakability {
    private CastingRecipe activeRecipe = null;
    private int craftingTick = 0;
    private int craftSoundTimer = 20000;
    private int craftingAmount;
    private EntityPlayer craftingPlayer;
    public boolean hasStructure = false;
    public boolean hasStructure2 = false;
    public boolean hasPylonConnections = false;
    private int tableXP;
    private CastingRecipe.RecipeType tier = CastingRecipe.RecipeType.CRAFTING;
    private boolean isEnhanced;
    private boolean isTuned;
    private boolean hasRunes;
    private final HashSet<KeyedItemStack> completedRecipes = new HashSet();
    private final ItemHashMap<Integer> craftedItems = new ItemHashMap();
    private CastingTuningMismatchReaction mismatch = null;

    public HashMap<Coordinate, CrystalElement> getCurrentTuningMap() {
        HashMap<Coordinate, CrystalElement> map = new HashMap<Coordinate, CrystalElement>();
        for (Coordinate c : CastingTuningManager.instance.getTuningKeyLocations()) {
            Coordinate c2 = c.offset(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (c2.getBlock((IBlockAccess)this.field_145850_b) != ChromaBlocks.RUNE.getBlockInstance()) continue;
            map.put(c, CrystalElement.elements[c2.getBlockMetadata((IBlockAccess)this.field_145850_b)]);
        }
        return map;
    }

    public boolean hasTuningKey() {
        return this.getCurrentTuningMap().size() == CastingTuningManager.instance.getTuningKeyLocations().size();
    }

    public CastingRecipe.RecipeType getTier() {
        return this.tier;
    }

    public boolean isAtLeast(CastingRecipe.RecipeType type) {
        if (!this.getTier().isAtLeast(type)) {
            return false;
        }
        switch (type) {
            case CRAFTING: {
                return true;
            }
            case TEMPLE: {
                return this.hasStructure;
            }
            case MULTIBLOCK: {
                return this.hasStructure2;
            }
            case PYLON: {
                return this.hasPylonConnections;
            }
        }
        return false;
    }

    private void setTier(CastingRecipe.RecipeType lvl) {
        if (lvl != this.tier) {
            this.tier = lvl;
            ChromaSounds.UPGRADE.playSoundAtBlock((TileEntity)this);
            if (this.field_145850_b.field_72995_K) {
                this.particleBurst();
            }
            this.validateStructure();
        }
    }

    public boolean isTuned() {
        return this.isTuned;
    }

    public CastingRecipe getActiveRecipe() {
        return this.activeRecipe;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.TABLE;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.mismatch != null) {
            if (this.mismatch.tick()) {
                this.mismatch = null;
            }
            return;
        }
        if (!world.field_72995_K && this.getTicksExisted() == 1) {
            this.evaluateRecipeAndRequest();
        }
        if (this.craftingTick > 0) {
            this.onCraftingTick(world, x, y, z);
        }
        if (!world.field_72995_K && this.getTicksExisted() % 20 == 0) {
            this.attemptTriggerProgressSync(world, x, y, z);
        }
        if (this.isEnhanced && this.hasPylonConnections && world.field_72995_K) {
            this.doEnhancedParticles(world, x, y, z);
        }
        if (world.field_72995_K) {
            ChromaFX.doFocusCrystalParticles(world, x, y, z, this);
        }
        if (DragonAPICore.debugtest) {
            this.addXP(800000);
            this.isEnhanced = false;
            for (CastingRecipe cr : RecipesCastingTable.instance.getAllRecipes()) {
                this.completedRecipes.add(new KeyedItemStack(cr.getOutput()));
            }
            this.func_70296_d();
            this.syncAllData(true);
        }
    }

    private void attemptTriggerProgressSync(World world, int x, int y, int z) {
        for (EntityPlayer ep : this.getOwners(false)) {
            if (!(ep.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= 100.0) || !ProgressionLinking.instance.hasLinkedPlayers(ep)) continue;
            for (ProgressionCatchupHandling.CastingProgressSyncTriggers cp : ProgressionCatchupHandling.CastingProgressSyncTriggers.getTriggers()) {
                if (!cp.isValid(this) || !ProgressionManager.instance.canStepPlayerTo(ep, cp.progress)) continue;
                ProgressionLinking.instance.attemptSyncTriggerProgressFor(ep, cp.progress);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doEnhancedParticles(World world, int x, int y, int z) {
        EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, rand.nextDouble() * 360.0, ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)45.0), ChromaIcons.HOLE);
        fx.angleVelocity *= 16.0;
        fx.freedom *= 0.25;
        fx.tolerance *= 2.0;
        fx.particleVelocity *= 1.25;
        fx.setRapidExpand().setScale(1.5f);
        fx.setColor(ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)(this.getTicksExisted() * 3 % 360)));
        fx.setGravity(-0.25f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.validateStructure();
        this.craftingTick = 0;
    }

    public int getCraftingTick() {
        return this.craftingTick;
    }

    public int getCraftAmountQueued() {
        return this.craftingAmount;
    }

    private void killCrafting() {
        this.craftingTick = 0;
        this.setStandLock(false);
        this.craftSoundTimer = 20000;
    }

    private void onCraftingTick(World world, int x, int y, int z) {
        ElementTagCompound req;
        float[] fa;
        if (this.activeRecipe == null) {
            return;
        }
        if (world.field_72995_K) {
            this.spawnCraftingParticles(world, x, y, z);
        }
        ++this.craftSoundTimer;
        ChromaSounds sound = this.activeRecipe.getSoundOverride(this, this.craftSoundTimer);
        if (sound != null) {
            sound.playSoundAtBlock((TileEntity)this, 2.0f, 1.0f);
            this.craftSoundTimer = 0;
        } else if (this.craftSoundTimer >= this.getSoundLength() && this.activeRecipe.getDuration() > 20) {
            this.craftSoundTimer = 0;
            ChromaSounds s = this.isEnhanced ? ChromaSounds.CRAFTING_BOOST : ChromaSounds.CRAFTING;
            s.playSoundAtBlock((TileEntity)this);
        }
        if (rand.nextInt(12) == 0 && (fa = this.activeRecipe.getHarmonics()) != null) {
            for (float f : fa) {
                if (f == 1.0f || rand.nextInt(50) != 0) continue;
                ChromaSounds.CASTHARMONIC.playSoundAtBlock((TileEntity)this, 1.0f, f);
            }
            if (rand.nextInt(25) == 0) {
                ChromaSounds.CASTHARMONIC.playSoundAtBlock((TileEntity)this, 1.0f, 1.0f);
            }
        }
        this.activeRecipe.onRecipeTick(this);
        if (this.activeRecipe instanceof CastingRecipe.PylonCastingRecipe && !this.energy.containsAtLeast(req = this.getRequiredEnergy())) {
            if (this.getCooldown() == 0 && this.checkTimer.checkCap()) {
                this.requestEnergyDifference(req);
            }
            return;
        }
        --this.craftingTick;
        if (this.craftingTick <= 0) {
            if (world.field_72995_K) {
                this.activeRecipe.onCrafted(this, this.craftingPlayer, this.inv[9], 1);
            } else {
                this.craft();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCraftingParticles(World world, int x, int y, int z) {
        int dy;
        BlockArray blocks;
        if (this.getTier().isAtLeast(CastingRecipe.RecipeType.TEMPLE) && this.hasStructure) {
            blocks = this.getStructureAccentLocations();
            for (int i = 0; i < blocks.getSize(); ++i) {
                Coordinate c = blocks.getNthBlock(i);
                int dx = c.xCoord;
                dy = c.yCoord;
                int dz = c.zCoord;
                double dd = ReikaMathLibrary.py3d((double)(dx - x), (double)(dy - y), (double)(dz - z));
                double dr = rand.nextDouble();
                double px = 0.5 + dr * (double)(dx - x) + (double)x;
                double py = 1.0 + dr * (double)(dy - y) + (double)y;
                double pz = 0.5 + dr * (double)(dz - z) + (double)z;
                Block b = world.func_147439_a(dx, dy, dz);
                CrystalElement e = CrystalElement.elements[this.getTicksExisted() / 20 % 16];
                EntityLaserFX fx = new EntityLaserFX(e, world, px, py, pz).setScale(2.0f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        if (this.getTier().isAtLeast(CastingRecipe.RecipeType.MULTIBLOCK) && this.hasStructure2) {
            double a = 60.0 * Math.sin(Math.toRadians(this.getTicksExisted() * 4 % 360));
            for (int i = 0; i < 360; i += 60) {
                double ang = Math.toRadians(a + (double)i);
                double r = 2.0;
                double rx = (double)x + 0.5 + r * Math.cos(ang);
                double ry = y;
                double rz = (double)z + 0.5 + r * Math.sin(ang);
                double v = 0.0625;
                double vx = v * ((double)x + 0.5 - rx);
                double vy = 0.0125 + v * ((double)y + 0.5 - ry);
                double vz = v * ((double)z + 0.5 - rz);
                EntityGlobeFX fx = new EntityGlobeFX(world, rx, ry, rz, vx, vy, vz);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        if (this.getTier().isAtLeast(CastingRecipe.RecipeType.PYLON) && this.hasPylonConnections && this.activeRecipe instanceof CastingRecipe.PylonCastingRecipe) {
            blocks = this.getStructureRuneLocations(((CastingRecipe.PylonCastingRecipe)this.activeRecipe).getRequiredAura());
            int mod = 17 - blocks.getSize();
            if (blocks.getSize() > 0 && this.getTicksExisted() % mod == 0) {
                Coordinate c = blocks.getNthBlock(this.getTicksExisted() % blocks.getSize());
                int dx = c.xCoord;
                dy = c.yCoord;
                int dz = c.zCoord;
                Block b = world.func_147439_a(dx, dy, dz);
                if (b == ChromaBlocks.RUNE.getBlockInstance()) {
                    int meta = world.func_72805_g(dx, dy, dz);
                    CrystalElement e = CrystalElement.elements[meta];
                    double dd = ReikaMathLibrary.py3d((double)(dx - x), (double)(dy - y), (double)(dz - z));
                    double v = 0.125;
                    double vx = v * (double)(x - dx) / dd;
                    double vy = v * (double)(y - dy) / dd;
                    double vz = v * (double)(z - dz) / dd;
                    int t = dd < 9.0 ? 70 : 80;
                    EntityRuneFX fx = new EntityRuneFX(world, (double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5, vx, vy, vz, e).setLife(t).setScale(2.0f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
            }
        }
    }

    public BlockArray getStructureAccentLocations() {
        BlockArray blocks = new BlockArray();
        blocks.addBlockCoordinate(this.field_145851_c - 6, this.field_145848_d + 5, this.field_145849_e);
        blocks.addBlockCoordinate(this.field_145851_c + 6, this.field_145848_d + 5, this.field_145849_e);
        blocks.addBlockCoordinate(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e - 6);
        blocks.addBlockCoordinate(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e + 6);
        blocks.addBlockCoordinate(this.field_145851_c + 6, this.field_145848_d + 4, this.field_145849_e + 6);
        blocks.addBlockCoordinate(this.field_145851_c + 6, this.field_145848_d + 4, this.field_145849_e - 6);
        blocks.addBlockCoordinate(this.field_145851_c - 6, this.field_145848_d + 4, this.field_145849_e - 6);
        blocks.addBlockCoordinate(this.field_145851_c - 6, this.field_145848_d + 4, this.field_145849_e + 6);
        return blocks;
    }

    public BlockArray getStructureRuneLocations(ElementTagCompound elements) {
        BlockArray blocks = new BlockArray();
        HashSet<BlockKey> li = new HashSet<BlockKey>();
        for (CrystalElement e : elements.elementSet()) {
            li.add(new BlockKey(ChromaBlocks.RUNE.getBlockInstance(), e.ordinal()));
        }
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c - 8, this.field_145848_d + 2, this.field_145849_e + 2, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c - 8, this.field_145848_d + 2, this.field_145849_e - 2, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c - 8, this.field_145848_d + 2, this.field_145849_e + 6, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c - 8, this.field_145848_d + 2, this.field_145849_e - 6, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c + 8, this.field_145848_d + 2, this.field_145849_e + 2, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c + 8, this.field_145848_d + 2, this.field_145849_e - 2, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c + 8, this.field_145848_d + 2, this.field_145849_e + 6, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c + 8, this.field_145848_d + 2, this.field_145849_e - 6, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c + 2, this.field_145848_d + 2, this.field_145849_e - 8, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c - 2, this.field_145848_d + 2, this.field_145849_e - 8, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c + 6, this.field_145848_d + 2, this.field_145849_e - 8, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c - 6, this.field_145848_d + 2, this.field_145849_e - 8, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c + 2, this.field_145848_d + 2, this.field_145849_e + 8, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c - 2, this.field_145848_d + 2, this.field_145849_e + 8, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c + 6, this.field_145848_d + 2, this.field_145849_e + 8, li);
        blocks.addBlockCoordinateIf(this.field_145850_b, this.field_145851_c - 6, this.field_145848_d + 2, this.field_145849_e + 8, li);
        return blocks;
    }

    public int getSoundLength() {
        switch (this.getTier()) {
            case CRAFTING: {
                return 1;
            }
            case TEMPLE: {
                return 1;
            }
            case MULTIBLOCK: 
            case PYLON: {
                return 152;
            }
        }
        return 1;
    }

    @Override
    public void validateStructure() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d - 1;
        int z = this.field_145849_e;
        ChromaStructures.CASTING1.getStructure().resetToDefaults();
        ChromaStructures.CASTING2.getStructure().resetToDefaults();
        ChromaStructures.CASTING3.getStructure().resetToDefaults();
        FilledBlockArray b = ChromaStructures.CASTING1.getArray(world, x, y, z);
        FilledBlockArray b2 = ChromaStructures.CASTING2.getArray(world, x, y, z);
        FilledBlockArray b3 = ChromaStructures.CASTING3.getArray(world, x, y, z);
        if (this.getTier().isAtLeast(CastingRecipe.RecipeType.PYLON)) {
            if (b3.matchInWorld((FilledBlockArray.BlockMatchFailCallback)this)) {
                this.hasPylonConnections = true;
                this.hasStructure2 = true;
                this.hasStructure = true;
            } else if (b2.matchInWorld()) {
                this.hasStructure2 = true;
                this.hasStructure = true;
                this.hasPylonConnections = false;
            } else if (b.matchInWorld()) {
                this.hasStructure = true;
                this.hasPylonConnections = false;
                this.hasStructure2 = false;
            } else {
                this.hasPylonConnections = false;
                this.hasStructure2 = false;
                this.hasStructure = false;
            }
        } else if (this.getTier().isAtLeast(CastingRecipe.RecipeType.MULTIBLOCK)) {
            if (b2.matchInWorld((FilledBlockArray.BlockMatchFailCallback)this)) {
                this.hasStructure2 = true;
                this.hasStructure = true;
            } else if (b.matchInWorld()) {
                this.hasStructure = true;
                this.hasStructure2 = false;
            } else {
                this.hasStructure2 = false;
                this.hasStructure = false;
            }
            this.hasPylonConnections = false;
        } else if (this.getTier().isAtLeast(CastingRecipe.RecipeType.TEMPLE)) {
            this.hasStructure = b.matchInWorld((FilledBlockArray.BlockMatchFailCallback)this);
            this.hasPylonConnections = false;
            this.hasStructure2 = false;
        } else {
            this.hasPylonConnections = false;
            this.hasStructure2 = false;
            this.hasStructure = false;
        }
        if (this.hasStructure2) {
            ProgressStage.MULTIBLOCK.stepPlayerTo(this.getPlacer());
        }
        if (this.activeRecipe != null && !this.getValidRecipeTypes().contains((Object)this.activeRecipe.type)) {
            if (this.craftingTick > 0) {
                this.killCrafting();
            }
            this.activeRecipe = null;
        }
        this.recountFocusCrystals();
        if (!world.field_72995_K) {
            this.hasRunes = false;
            if (this.hasStructure) {
                for (Coordinate c : b.keySet()) {
                    if (c.getBlock((IBlockAccess)world) != ChromaBlocks.RUNE.getBlockInstance()) continue;
                    this.hasRunes = true;
                    break;
                }
            }
            this.isTuned = false;
            if (this.hasStructure2) {
                for (UUID uid : this.owners) {
                    EntityPlayer ep = world.func_152378_a(uid);
                    if (ep == null || ReikaPlayerAPI.isFake((EntityPlayer)ep)) continue;
                    this.isTuned |= CastingTuningManager.instance.getTuningKey(ep).check(this);
                    if (!this.isTuned) continue;
                    ProgressStage.TUNECAST.stepPlayerTo(ep);
                }
            }
        }
        this.syncAllData(true);
    }

    public boolean triggerCrafting(EntityPlayer ep) {
        if (ep == null || ReikaPlayerAPI.isFake((EntityPlayer)ep) || !ReikaEntityHelper.isInWorld((Entity)ep)) {
            return false;
        }
        if (this.mismatch != null) {
            return false;
        }
        if (this.activeRecipe != null && this.craftingTick == 0) {
            if (this.isOwnedByPlayer(ep)) {
                if (this.activeRecipe.canRunRecipe((TileEntity)this, ep)) {
                    this.craftingPlayer = ep;
                    if (this.field_145850_b.field_72995_K) {
                        return true;
                    }
                    this.syncAllData(true);
                    ChromaSounds.CAST.playSoundAtBlock((TileEntity)this);
                    this.setStandLock(true);
                    this.craftingAmount = ReikaInventoryHelper.getSmallestStack((ItemStack[])this.inv, (int)0, (int)8).field_77994_a;
                    if (this.activeRecipe instanceof CastingRecipe.MultiBlockCastingRecipe) {
                        CastingRecipe.MultiBlockCastingRecipe mult = (CastingRecipe.MultiBlockCastingRecipe)this.activeRecipe;
                        HashMap<WorldLocation, ItemMatch> map = mult.getOtherInputs(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        for (WorldLocation loc : map.keySet()) {
                            TileEntityItemStand te = (TileEntityItemStand)loc.getTileEntity((IBlockAccess)this.field_145850_b);
                            if (te == null) continue;
                            this.craftingAmount = Math.min(this.craftingAmount, te.func_70301_a((int)0).field_77994_a);
                        }
                    }
                    if (this.activeRecipe instanceof CastingRecipe.PylonCastingRecipe) {
                        this.requestEnergyDifference(this.getRequiredEnergy());
                    }
                    if (!this.activeRecipe.canBeStacked()) {
                        // empty if block
                    }
                    this.setRecipeTickDuration(this.activeRecipe);
                    return true;
                }
            } else if (this.hasTuningKey()) {
                this.triggerTuningMismatch(ep);
            }
        }
        ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
        return false;
    }

    private void triggerTuningMismatch(EntityPlayer ep) {
        this.mismatch = new CastingTuningMismatchReaction(this, ep);
    }

    public ElementTagCompound getRequiredEnergy() {
        if (this.activeRecipe instanceof CastingRecipe.PylonCastingRecipe) {
            ElementTagCompound tag = ((CastingRecipe.PylonCastingRecipe)this.activeRecipe).getRequiredAura();
            return tag.scale(this.craftingAmount);
        }
        return null;
    }

    private void setRecipeTickDuration(CastingRecipe r) {
        this.craftingTick = this.getRecipeTickDuration(r);
    }

    public int getRecipeTickDuration(CastingRecipe r) {
        int t = r.getDuration();
        if (this.isEnhanced) {
            t = Math.max(t / r.getEnhancedTableAccelerationFactor(), Math.min(t, 20));
        }
        if (r.canBeStacked()) {
            t = (int)((float)t * r.getRecipeStackedTimeFactor(this, this.craftingAmount));
        }
        if (t > 20 && r instanceof CastingRecipe.MultiBlockCastingRecipe) {
            t = Math.max(20, (int)((float)t / this.getAccelerationFactor()));
        }
        return t;
    }

    public boolean isReadyToCraft() {
        return this.craftingTick == 0 && this.inv[9] == null && this.mismatch == null;
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.readRecipes(NBT);
        if (NBT.func_74764_b("crafter") && this.field_145850_b != null && this.craftingPlayer == null) {
            UUID uid = UUID.fromString(NBT.func_74779_i("crafter"));
            this.craftingPlayer = this.field_145850_b.func_152378_a(uid);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.writeRecipes(NBT);
        if (this.craftingPlayer != null) {
            NBT.func_74778_a("crafter", this.craftingPlayer.func_110124_au().toString());
        }
    }

    private void writeRecipes(NBTTagCompound NBT) {
        NBTTagCompound tag;
        NBTTagList li = new NBTTagList();
        for (KeyedItemStack is : this.completedRecipes) {
            tag = new NBTTagCompound();
            is.getItemStack().func_77955_b(tag);
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("recipes", (NBTBase)li);
        li = new NBTTagList();
        for (KeyedItemStack is : this.craftedItems.keySet()) {
            tag = new NBTTagCompound();
            is.func_77955_b(tag);
            tag.func_74768_a("total", ((Integer)this.craftedItems.get((ItemStack)is)).intValue());
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("counts", (NBTBase)li);
    }

    private void readRecipes(NBTTagCompound NBT) {
        ItemStack is;
        NBTTagCompound tag;
        this.completedRecipes.clear();
        NBTTagList li = NBT.func_150295_c("recipes", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            tag = (NBTTagCompound)o;
            is = ItemStack.func_77949_a((NBTTagCompound)tag);
            this.completedRecipes.add(new KeyedItemStack(is));
        }
        this.craftedItems.clear();
        li = NBT.func_150295_c("counts", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            tag = (NBTTagCompound)o;
            is = ItemStack.func_77949_a((NBTTagCompound)tag);
            int amt = tag.func_74762_e("total");
            this.craftedItems.put(is, (Object)amt);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasPylonConnections = NBT.func_74767_n("pylons");
        this.hasStructure = NBT.func_74767_n("struct");
        this.hasStructure2 = NBT.func_74767_n("struct2");
        this.tableXP = NBT.func_74762_e("xp");
        this.tier = CastingRecipe.RecipeType.typeList[NBT.func_74762_e("tier")];
        this.craftingTick = NBT.func_74762_e("craft");
        this.isEnhanced = NBT.func_74767_n("enhance");
        this.isTuned = NBT.func_74767_n("tune");
        this.hasRunes = NBT.func_74767_n("runes");
        this.craftingAmount = NBT.func_74762_e("crafting");
        if (NBT.func_74764_b("crafter") && this.isInWorld()) {
            this.craftingPlayer = this.field_145850_b.func_152378_a(UUID.fromString(NBT.func_74779_i("crafter")));
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
        NBT.func_74757_a("struct2", this.hasStructure2);
        NBT.func_74757_a("pylons", this.hasPylonConnections);
        NBT.func_74768_a("tier", this.tier.ordinal());
        NBT.func_74768_a("xp", this.tableXP);
        NBT.func_74768_a("craft", this.craftingTick);
        NBT.func_74757_a("enhance", this.isEnhanced);
        NBT.func_74757_a("tune", this.isTuned);
        NBT.func_74757_a("runes", this.hasRunes);
        NBT.func_74768_a("crafting", this.craftingAmount);
        if (this.craftingPlayer != null) {
            NBT.func_74778_a("crafter", this.craftingPlayer.func_110124_au().toString());
        }
    }

    private void craft() {
        CastingRecipe recipe;
        CastingRecipe cachedRecipe = recipe = this.activeRecipe;
        int count = 0;
        boolean repeat = false;
        NBTTagCompound NBTin = null;
        int xpToAdd = 0;
        int max = Math.max(1, this.activeRecipe.getOutput().func_77976_d() / this.activeRecipe.getOutput().field_77994_a);
        while (this.activeRecipe == recipe && count < max) {
            if (this.inv[4] != null) {
                NBTin = recipe.getOutputTag(this.craftingPlayer, this.inv[4].field_77990_d);
            }
            xpToAdd += (int)((float)this.activeRecipe.getExperience() * this.getXPModifier(this.activeRecipe));
            if (this.activeRecipe instanceof CastingRecipe.MultiBlockCastingRecipe) {
                CastingRecipe.MultiBlockCastingRecipe mult = (CastingRecipe.MultiBlockCastingRecipe)this.activeRecipe;
                HashMap<WorldLocation, ItemMatch> map = mult.getOtherInputs(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                for (WorldLocation loc : map.keySet()) {
                    TileEntityItemStand te = (TileEntityItemStand)loc.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (te == null) continue;
                    ItemStack is = te.func_70301_a(0);
                    if (FluidContainerRegistry.isFilledContainer((ItemStack)is)) {
                        is = FluidContainerRegistry.drainFluidContainer((ItemStack)is);
                        te.func_70299_a(0, is.func_77946_l());
                    } else {
                        ReikaInventoryHelper.decrStack((int)0, (IInventory)te, (int)1);
                    }
                    te.syncAllData(true);
                }
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack ret;
                if (i == 4 && (ret = recipe.getCentralLeftover(this.inv[i])) != null) {
                    this.inv[i] = ret;
                    continue;
                }
                if (this.inv[i] == null) continue;
                ItemStack container = recipe.getContainerItem(this.inv[i], this.inv[i].func_77973_b().getContainerItem(this.inv[i]));
                if (container == null) {
                    int amt = 1;
                    if (recipe instanceof CastingRecipe.MultiBlockCastingRecipe) {
                        amt = ((CastingRecipe.MultiBlockCastingRecipe)recipe).getRequiredCentralItemCount();
                    }
                    ReikaInventoryHelper.decrStack((int)i, (IInventory)this, (int)amt);
                    continue;
                }
                container = container.func_77946_l();
                container.field_77994_a = 1;
                if (this.inv[i].field_77994_a == 1) {
                    this.inv[i] = container;
                    continue;
                }
                ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
                ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.25), (double)((double)this.field_145849_e + 0.5), (ItemStack)container);
            }
            ++count;
            if (this.activeRecipe instanceof CastingRecipe.PylonCastingRecipe) {
                this.energy.subtract(((CastingRecipe.PylonCastingRecipe)this.activeRecipe).getRequiredAura());
            }
            this.activeRecipe = recipe;
            recipe = this.getValidRecipe();
            if (this.activeRecipe.canBeStacked() || recipe != this.activeRecipe) continue;
            this.setRecipeTickDuration(this.activeRecipe);
            ChromaSounds.CAST.playSoundAtBlock((TileEntity)this);
            repeat = true;
            break;
        }
        boolean triggerCrafted = true;
        int ct = count;
        ItemStack out = this.activeRecipe.getOutput();
        block3: while (count > 0) {
            NBTTagCompound NBTout;
            --count;
            ItemStack toadd = ReikaItemHelper.getSizedItemStack((ItemStack)out, (int)this.activeRecipe.getOutput().field_77994_a);
            if (Chromabilities.DOUBLECRAFT.enabledOn(this.craftingPlayer)) {
                toadd.field_77994_a *= 2;
            }
            NBTTagCompound nBTTagCompound = NBTout = NBTin != null ? (NBTTagCompound)NBTin.func_74737_b() : null;
            if (NBTout != null) {
                ReikaNBTHelper.combineNBT((NBTTagCompound)NBTout, (NBTTagCompound)toadd.field_77990_d);
                toadd.field_77990_d = (NBTTagCompound)NBTout.func_74737_b();
            }
            toadd.field_77990_d = this.activeRecipe.handleNBTResult(this, this.craftingPlayer, NBTin, toadd.field_77990_d);
            this.activeRecipe.setOwner(toadd, this.craftingPlayer);
            ReikaInventoryHelper.addOrSetStack((ItemStack)toadd, (ItemStack[])this.inv, (int)9);
            this.addCrafted(out, 1);
            --this.craftingAmount;
            if (triggerCrafted) {
                triggerCrafted = false;
                CastingRecipe temp = this.activeRecipe;
                this.activeRecipe.onCrafted(this, this.craftingPlayer, this.inv[9], ct);
                this.activeRecipe = temp;
            }
            if (this.inv[9] == null) continue;
            MinecraftForge.EVENT_BUS.post((Event)new CastingEvent(this, this.activeRecipe, this.craftingPlayer, this.inv[9].func_77946_l()));
            int push = this.inv[9].field_77994_a;
            for (int i = 0; i < 6; ++i) {
                TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
                if (!(te instanceof IInventory)) continue;
                int amt = Math.min(this.inv[9].func_77976_d(), push);
                boolean flag = false;
                do {
                    flag = false;
                    if (!ReikaInventoryHelper.addToIInv((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)this.inv[9], (int)amt), (IInventory)((IInventory)te))) continue;
                    flag = true;
                    ReikaInventoryHelper.decrStack((int)9, (IInventory)this, (int)amt);
                    push -= amt;
                } while (flag && this.inv[9] != null);
                if (this.inv[9] == null) continue block3;
            }
        }
        this.addXP(xpToAdd);
        if (this.inv[9] != null) {
            repeat = false;
        }
        if (this.getValidRecipe() == cachedRecipe && this.inv[9] == null) {
            repeat = true;
            this.setRecipeTickDuration(this.activeRecipe);
        }
        EntityPlayer ep = this.craftingPlayer;
        if (!repeat) {
            this.activeRecipe = null;
            this.craftSoundTimer = 20000;
            this.craftingTick = 0;
        }
        this.onCraftingComplete(cachedRecipe, ct, ep);
    }

    private void onCraftingComplete(CastingRecipe rec, int ct, EntityPlayer ep) {
        ChromatiCraft.logger.log((Object)("Player " + ep + " crafted " + rec));
        RecipesCastingTable.setPlayerHasCrafted(ep, rec.type);
        ChromaSounds.CRAFTDONE.playSoundAtBlock((TileEntity)this);
        if (this.field_145850_b.field_72995_K) {
            this.particleBurst();
        }
        if (ct > 0) {
            ProgressStage.CASTING.stepPlayerTo(ep);
            if (rec instanceof CastingRecipe.PylonCastingRecipe) {
                ProgressStage.LINK.stepPlayerTo(ep);
            }
        }
        for (TileEntityItemStand te : this.getOtherStands().values()) {
            te.lock(false);
            te.syncAfterCraft();
        }
    }

    private void setStandLock(boolean lock) {
        for (TileEntityItemStand te : this.getOtherStands().values()) {
            te.lock(lock);
        }
    }

    private float getXPModifier(CastingRecipe recipe) {
        Integer get = (Integer)this.craftedItems.get(recipe.getOutput());
        int max = recipe.getPenaltyThreshold();
        if (get != null && get >= max) {
            float mult = recipe.getPenaltyMultiplier();
            float fac = (float)Math.pow(mult, get - max);
            return fac;
        }
        return 1.0f;
    }

    private void addCrafted(ItemStack is, int count) {
        Integer get = (Integer)this.craftedItems.get(is);
        int has = get != null ? get : 0;
        this.craftedItems.put(is, (Object)(has + count));
    }

    public void breakBlock() {
        HashMap<List<Integer>, TileEntityItemStand> tiles = this.getOtherStands();
        for (TileEntityItemStand te : tiles.values()) {
            te.setTable(null);
        }
        tiles.clear();
    }

    @SideOnly(value=Side.CLIENT)
    private void particleBurst() {
        for (int i = 0; i < 128; ++i) {
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.125);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            EntitySparkleFX fx = new EntitySparkleFX(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, vx, vy, vz).setScale(1.5f);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void addXP(int experience) {
        if (!this.field_145850_b.field_72995_K) {
            EntityPlayer ep;
            this.tableXP += experience;
            if (this.tableXP >= this.tier.levelUp) {
                this.setTier(this.tier.next());
            }
            if (this.tableXP > 1000000 && (ep = this.getPlacer()) != null && !ReikaPlayerAPI.isFake((EntityPlayer)ep) && ProgressStage.CTM.isPlayerAtStage(ep) && TileEntityAuraPoint.hasAuraPoints(ep)) {
                this.isEnhanced = true;
            }
            this.syncAllData(false);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getXP() {
        return this.tableXP;
    }

    private void spawnParticles(World world, int x, int y, int z) {
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        CastingRecipe r = this.getValidRecipe();
        if (this.inv[9] != null) {
            r = null;
        }
        this.changeRecipe(r);
    }

    private void changeRecipe(CastingRecipe r) {
        if (r == null || r != this.activeRecipe || r.type != CastingRecipe.RecipeType.PYLON) {
            CrystalNetworker.instance.breakPaths(this);
            if (r == null || r != this.activeRecipe) {
                this.killCrafting();
            }
        }
        this.activeRecipe = r;
    }

    private CastingRecipe getValidRecipe() {
        CastingRecipe r = RecipesCastingTable.instance.getRecipe(this, this.getValidRecipeTypes());
        if (this.field_145850_b.field_73011_w.field_76574_g != 0 && r instanceof CastingRecipe.TempleCastingRecipe && !PylonGenerator.instance.canGenerateIn(this.field_145850_b)) {
            r = null;
        }
        if (r instanceof CastingRecipe.MultiBlockCastingRecipe) {
            CastingRecipe.MultiBlockCastingRecipe m = (CastingRecipe.MultiBlockCastingRecipe)r;
            HashMap<List<Integer>, TileEntityItemStand> map = this.getOtherStands();
            for (List<Integer> key : map.keySet()) {
                int i = key.get(0);
                int k = key.get(1);
                int dx = this.field_145851_c + i;
                int dz = this.field_145849_e + k;
                int dy = this.field_145848_d + (Math.abs(i) != 4 && Math.abs(k) != 4 ? 0 : 1);
                TileEntityItemStand te = (TileEntityItemStand)this.field_145850_b.func_147438_o(dx, dy, dz);
                te.setTable(this);
            }
        }
        return r;
    }

    private ArrayList<CastingRecipe.RecipeType> getValidRecipeTypes() {
        ArrayList<CastingRecipe.RecipeType> li = new ArrayList<CastingRecipe.RecipeType>();
        li.add(CastingRecipe.RecipeType.CRAFTING);
        if (this.tier.isAtLeast(CastingRecipe.RecipeType.TEMPLE) && this.hasStructure) {
            li.add(CastingRecipe.RecipeType.TEMPLE);
            if (this.tier.isAtLeast(CastingRecipe.RecipeType.MULTIBLOCK) && this.hasStructure2) {
                li.add(CastingRecipe.RecipeType.MULTIBLOCK);
                if (this.tier.isAtLeast(CastingRecipe.RecipeType.PYLON) && this.hasPylonConnections) {
                    li.add(CastingRecipe.RecipeType.PYLON);
                }
            }
        }
        return li;
    }

    private void evaluateRecipeAndRequest() {
        CastingRecipe r = this.getValidRecipe();
        if (r != null && r != this.activeRecipe && r instanceof CastingRecipe.PylonCastingRecipe) {
            ElementTagCompound tag = this.getRequiredEnergy();
            this.requestEnergyDifference(tag);
        }
        this.activeRecipe = r;
    }

    public HashMap<List<Integer>, TileEntityItemStand> getOtherStands() {
        HashMap<List<Integer>, TileEntityItemStand> li = new HashMap<List<Integer>, TileEntityItemStand>();
        for (int i = -4; i <= 4; i += 2) {
            for (int k = -4; k <= 4; k += 2) {
                int dx = this.field_145851_c + i;
                int dz = this.field_145849_e + k;
                int dy = this.field_145848_d + (Math.abs(i) != 4 && Math.abs(k) != 4 ? 0 : 1);
                ChromaTiles c = ChromaTiles.getTile((IBlockAccess)this.field_145850_b, dx, dy, dz);
                if (c != ChromaTiles.STAND) continue;
                TileEntityItemStand te = (TileEntityItemStand)this.field_145850_b.func_147438_o(dx, dy, dz);
                li.put(Arrays.asList(i, k), te);
            }
        }
        return li;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int func_70302_i_() {
        return 10;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot != 9;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot == 9;
    }

    @Override
    public void onPathBroken(CrystalFlow p, CrystalNetworkLogger.FlowFail f) {
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null;
    }

    @Override
    public int maxThroughput() {
        int base = Math.min(1000, Math.max(100, 100 * (this.tableXP / CastingRecipe.RecipeType.MULTIBLOCK.levelUp - 1)));
        if (this.isEnhanced && this.activeRecipe instanceof CastingRecipe.PylonCastingRecipe) {
            CastingRecipe.PylonCastingRecipe pr = (CastingRecipe.PylonCastingRecipe)this.activeRecipe;
            base = Math.min(2500, Math.max(base, pr.getRequiredAura().getAverageValue() * this.craftingAmount / 40));
        }
        return base;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public int getReceiveRange() {
        return 24;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return Integer.MAX_VALUE;
    }

    public boolean isCrafting() {
        return this.activeRecipe != null;
    }

    public ArrayList<CrystalTarget> getTargets() {
        ArrayList<CrystalTarget> li = new ArrayList<CrystalTarget>();
        return li;
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        super.getTagsToWriteToStack(NBT);
        NBT.func_74768_a("lvl", this.getTier().ordinal());
        NBT.func_74768_a("xp", this.tableXP);
        NBT.func_74757_a("enhance", this.isEnhanced);
        this.writeRecipes(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        super.setDataFromItemStackTag(is);
        if (ChromaItems.PLACER.matchWith(is) && is.func_77960_j() == this.getTile().ordinal() && is.field_77990_d != null) {
            int lvl = is.field_77990_d.func_74762_e("lvl");
            this.tier = CastingRecipe.RecipeType.typeList[lvl];
            this.tableXP = is.field_77990_d.func_74762_e("xp");
            this.isEnhanced = is.field_77990_d.func_74767_n("enhance");
            this.readRecipes(is.field_77990_d);
        }
    }

    @Override
    public ElementTagCompound getRequestedTotal() {
        return this.craftingTick > 0 && this.activeRecipe instanceof CastingRecipe.PylonCastingRecipe ? this.getRequiredEnergy() : null;
    }

    public BlockArray getBlocks() {
        switch (this.tier) {
            case CRAFTING: {
                return null;
            }
            case TEMPLE: {
                return ChromaStructures.CASTING1.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            }
            case MULTIBLOCK: {
                return ChromaStructures.CASTING2.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            }
            case PYLON: {
                return ChromaStructures.CASTING3.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            }
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(12.0, 6.0, 12.0);
    }

    public boolean trigger() {
        return this.getPlacer() != null && !ReikaPlayerAPI.isFake((EntityPlayer)this.getPlacer()) && this.getPlacer().field_70173_aa >= 20 && this.triggerCrafting(this.getPlacer());
    }

    public void giveRecipe(EntityPlayer ep, CastingRecipe cr) {
        this.completedRecipes.add(new KeyedItemStack(cr.getOutput()));
        this.func_70296_d();
        this.syncAllData(true);
    }

    public HashSet<CastingRecipe> getCompletedRecipes() {
        HashSet<CastingRecipe> set = new HashSet<CastingRecipe>();
        for (KeyedItemStack is : this.completedRecipes) {
            set.addAll(RecipesCastingTable.instance.getAllRecipesMaking(is.getItemStack()));
        }
        return set;
    }

    public boolean hasRecipeBeenUsed(CastingRecipe cr) {
        return this.getCompletedRecipes().contains(cr);
    }

    @Override
    public int getIconState(int side) {
        return this.isEnhanced ? 1 : 0;
    }

    @Override
    public boolean onlyAllowOwnersToUse() {
        return true;
    }

    @Override
    public float getOperationFraction() {
        if (this.activeRecipe == null) {
            return 0.0f;
        }
        return 1.0f - (float)this.craftingTick / (float)this.getRecipeTickDuration(this.activeRecipe);
    }

    @Override
    public OperationInterval.OperationState getState() {
        if (this.activeRecipe == null) {
            return OperationInterval.OperationState.INVALID;
        }
        if (this.activeRecipe instanceof CastingRecipe.PylonCastingRecipe) {
            return this.energy.containsAtLeast(this.getRequiredEnergy()) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING;
        }
        return OperationInterval.OperationState.RUNNING;
    }

    public void dumpAllStands() {
        if (this.tier.isAtLeast(CastingRecipe.RecipeType.MULTIBLOCK)) {
            for (TileEntityItemStand te : this.getOtherStands().values()) {
                te.dropSlot();
                ChromaSounds.ITEMSTAND.playSoundAtBlock((TileEntity)te);
                te.syncAllData(true);
            }
        }
    }

    @Override
    public void recountFocusCrystals() {
        this.getAccelerationFactor();
    }

    @Override
    public float getAccelerationFactor() {
        return TileEntityFocusCrystal.getSummedFocusFactor(this, CastingFocusLocation.set);
    }

    @Override
    public float getMaximumAcceleratability() {
        return TileEntityFocusCrystal.CrystalTier.TURBOCHARGED.efficiencyFactor * (float)CastingFocusLocation.list.length;
    }

    @Override
    public float getProgressToNextStep() {
        return 0.0f;
    }

    @Override
    public Collection<Coordinate> getRelativeFocusCrystalLocations() {
        ArrayList<Coordinate> c = new ArrayList<Coordinate>();
        for (CastingFocusLocation f : CastingFocusLocation.list) {
            c.add(f.relativeLocation());
        }
        return c;
    }

    public void onBlockFailure(World world, int x, int y, int z, BlockCheck seek) {
    }

    @SideOnly(value=Side.CLIENT)
    @DependentMethodStripper.ModDependent(value={ModList.BOTANIA})
    public void onClickedWithBotaniaWand(ReikaDyeHelper dye1, ReikaDyeHelper dye2) {
        ReikaSoundHelper.playNormalClientSound((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (String)"botania:spreaderFire", (float)1.0f, (float)1.0f, (boolean)true);
        for (int i = 0; i < 8; ++i) {
            double ang = rand.nextDouble() * 360.0;
            double vy = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.375);
            double vel = ReikaRandomHelper.getRandomBetween((double)0.0625, (double)0.25);
            double[] v = ReikaPhysicsHelper.polarToCartesian((double)vel, (double)0.0, (double)ang);
            double g = ReikaRandomHelper.getRandomBetween((double)0.0078125, (double)0.03125);
            int l = ReikaRandomHelper.getRandomBetween((int)20, (int)80);
            EntityParticleEmitterFX fx = new EntityParticleEmitterFX(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, v[0], vy, v[2], (EntityParticleEmitterFX.ParticleSpawner)new BotaniaPetalShower(rand.nextBoolean() ? dye1 : dye2));
            fx.setVelocityDeltas(0, -g, 0).setLife(l);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean isPlayerAccessible(EntityPlayer var1) {
        return super.isPlayerAccessible(var1) && this.mismatch == null;
    }

    public boolean isUnbreakable(EntityPlayer ep) {
        return this.mismatch != null;
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        switch (this.getTier()) {
            case CRAFTING: {
                return null;
            }
            case TEMPLE: {
                return ChromaStructures.CASTING1;
            }
            case MULTIBLOCK: {
                return ChromaStructures.CASTING2;
            }
            case PYLON: {
                return ChromaStructures.CASTING3;
            }
        }
        return null;
    }

    @Override
    public Coordinate getStructureOffset() {
        return new Coordinate(0, -1, 0);
    }

    @Override
    public boolean canStructureBeInspected() {
        return true;
    }

    public void onAddRune(World world, int x, int y, int z, EntityPlayer e, ItemStack is) {
        if (this.isAtLeast(CastingRecipe.RecipeType.TEMPLE)) {
            ProgressStage.RUNEUSE.stepPlayerTo(e);
            this.hasRunes = true;
        }
    }

    public boolean hasRunes() {
        return this.hasRunes;
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }

    public static enum CastingFocusLocation implements TileEntityFocusCrystal.FocusLocation
    {
        N1(-1, 1, -3),
        N2(1, 1, -3),
        E1(3, 1, -1),
        E2(3, 1, 1),
        S1(1, 1, 3),
        S2(-1, 1, 3),
        W1(-3, 1, 1),
        W2(-3, 1, -1);

        public final Coordinate relativeLocation;
        private static final CastingFocusLocation[] list;
        private static final Set<TileEntityFocusCrystal.FocusLocation> set;

        private CastingFocusLocation(int x, int y, int z) {
            this.relativeLocation = new Coordinate(x, y, z);
        }

        @Override
        public Coordinate relativeLocation() {
            return this.relativeLocation;
        }

        static {
            list = CastingFocusLocation.values();
            set = new HashSet<TileEntityFocusCrystal.FocusLocation>();
            for (CastingFocusLocation cf : list) {
                set.add(cf);
            }
        }
    }
}

