/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.FocusAcceleratable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PoolRecipes;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedRelayPowered;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityChromaFluidFX;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFocusCrystal;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModList;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntityChromaCrafter
extends InventoriedRelayPowered
implements IFluidHandler,
OwnedTile,
IPipeConnection,
OperationInterval,
BreakAction,
FocusAcceleratable {
    public static final int CRAFTING_DURATION = 300;
    private static final ElementTagCompound required = new ElementTagCompound();
    private PoolRecipes.PoolRecipe recipe = null;
    private int recipeTick = 0;
    private int hasEtherBerries = 0;
    private ArrayList<ItemStack> recipeItems = new ArrayList();
    public static final int CAPACITY = 3000;
    private final HybridTank tank = new HybridTank("chromacraft", 3000);

    public int getChromaLevel() {
        return this.tank.getLevel();
    }

    public PoolRecipes.PoolRecipe getActiveRecipe() {
        return this.recipe;
    }

    public ItemHashMap<Integer> getCurrentItems() {
        ItemHashMap ret = new ItemHashMap();
        for (ItemStack is : this.recipeItems) {
            ret.add(is, is.field_77994_a);
        }
        return ret;
    }

    public int getBerryCount() {
        return this.hasEtherBerries;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("etherb", this.hasEtherBerries);
        NBT.func_74768_a("recipe", this.recipeTick);
        this.tank.writeToNBT(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasEtherBerries = NBT.func_74762_e("etherb");
        this.recipeTick = NBT.func_74762_e("recipe");
        this.tank.readFromNBT(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        ReikaNBTHelper.writeCollectionToNBT(this.recipeItems, (NBTTagCompound)NBT, (String)"recipeItems");
        NBT.func_74778_a("recipetype", this.recipe != null ? this.recipe.ID : "none");
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        ReikaNBTHelper.readCollectionFromNBT(this.recipeItems, (NBTTagCompound)NBT, (String)"recipeItems");
        this.recipe = PoolRecipes.instance.getByID(NBT.func_74779_i("recipetype"));
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.inv[0] != null) {
            if (ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ChromaStacks.etherBerries)) {
                this.hasEtherBerries += this.inv[0].field_77994_a;
                this.inv[0] = null;
                this.syncAllData(true);
            } else if (this.recipe == null) {
                this.recipeItems.add(this.inv[0]);
                this.recipeItems = ReikaItemHelper.collateItemList(this.recipeItems);
                this.inv[0] = null;
                this.recipe = this.checkRecipe();
                if (this.recipe != null) {
                    this.recipeTick = this.getCraftingDuration();
                    this.syncAllData(true);
                }
            }
        }
        if (this.recipeTick > 0) {
            this.onRecipeTick(world, x, y, z);
        }
        if (world.field_72995_K && this.hasStructure()) {
            ChromaFX.doFocusCrystalParticles(world, x, y, z, this);
        }
    }

    private int getCraftingDuration() {
        int base = 300;
        float f = this.getAccelerationFactor();
        return f >= 1.0f ? (int)((float)base / f) : base;
    }

    private PoolRecipes.PoolRecipe checkRecipe() {
        return PoolRecipes.instance.getPoolRecipe(this.recipeItems);
    }

    private void onRecipeTick(World world, int x, int y, int z) {
        if (this.energy.containsAtLeast(required) && this.tank.getLevel() == 3000 && this.hasStructure()) {
            --this.recipeTick;
        }
        if (this.recipeTick == 0) {
            if (!world.field_72995_K) {
                this.craft();
            }
        } else if (world.field_72995_K) {
            this.recipeParticles(world, x, y, z);
        }
    }

    public boolean hasStructure() {
        for (int i = 1; i <= 2; ++i) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + i, this.field_145849_e) == ChromaBlocks.STRUCTSHIELD.getBlockInstance() && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + i, this.field_145849_e) % 8 == BlockStructureShield.BlockType.GLASS.ordinal()) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void recipeParticles(World world, int x, int y, int z) {
        double[] v = ReikaPhysicsHelper.polarToCartesian((double)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.125), (double)(rand.nextDouble() * 90.0), (double)(rand.nextDouble() * 360.0));
        EntityChromaFluidFX fx = new EntityChromaFluidFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble() * 3.0, (double)z + rand.nextDouble(), v[0], v[1], v[2]).setGravity(0.125f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void craft() {
        EntityPlayer ep;
        this.recipeTick = 0;
        Collection<ItemStack> li = this.recipe.getInputs();
        li.add(this.recipe.getMainInput());
        block0: for (ItemStack is : li) {
            int val = is.field_77994_a;
            Iterator<ItemStack> it = this.recipeItems.iterator();
            while (it.hasNext()) {
                ItemStack is2 = it.next();
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)is2)) continue;
                int rem = Math.min(val, is2.field_77994_a);
                is2.field_77994_a -= rem;
                val -= rem;
                if (is2.field_77994_a != 0) continue;
                it.remove();
                continue block0;
            }
        }
        ItemStack out = this.recipe.getOutput();
        if (this.recipe.allowDoubling() && this.hasEtherBerries >= 16) {
            out.field_77994_a *= 2;
            this.hasEtherBerries -= 16;
        }
        if ((ep = this.getPlacer()) != null && !ReikaPlayerAPI.isFake((EntityPlayer)ep) && Chromabilities.DOUBLECRAFT.enabledOn(ep)) {
            out.field_77994_a *= 2;
        }
        ReikaInventoryHelper.addOrSetStack((ItemStack)out, (ItemStack[])this.inv, (int)1);
        this.recipe = null;
        this.tank.removeLiquid(3000);
        this.energy.subtract(required);
        ChromaSounds.INFUSE.playSoundAtBlock((TileEntity)this);
        this.syncAllData(true);
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot == 1;
    }

    public int func_70302_i_() {
        return 2;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 && this.hasStructure() && this.canAcceptMoreOf(is);
    }

    private boolean canAcceptMoreOf(ItemStack is) {
        return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaStacks.etherBerries) ? this.getBerryCount() + is.field_77994_a <= 512 : this.getItemCount(is) + is.field_77994_a <= 64;
    }

    private int getItemCount(ItemStack is) {
        int ret = 0;
        for (ItemStack in : this.recipeItems) {
            if (!ReikaItemHelper.matchStacks((ItemStack)in, (ItemStack)is)) continue;
            ret += in.field_77994_a;
        }
        return ret;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        FluidStack fs = new FluidStack(resource.getFluid(), Math.min(25, resource.amount));
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(fs, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.offsetY == 0 && fluid == FluidRegistry.getFluid((String)"chroma") && this.hasStructure();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 10000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.CHROMACRAFTER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return dir != ForgeDirection.UP;
    }

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return required.contains(e);
    }

    @DependentMethodStripper.ModDependent(value={ModList.BCTRANSPORT})
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.FLUID) {
            return with.offsetY == 0 ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
        }
        if (type == IPipeTile.PipeType.ITEM) {
            return with != ForgeDirection.UP ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public boolean onlyAllowOwnersToUse() {
        return true;
    }

    @Override
    public float getOperationFraction() {
        if (this.recipe == null) {
            return 0.0f;
        }
        return 1.0f - (float)this.recipeTick / (float)this.getCraftingDuration();
    }

    @Override
    public OperationInterval.OperationState getState() {
        if (this.recipe == null) {
            return OperationInterval.OperationState.INVALID;
        }
        return this.energy.containsAtLeast(required) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72321_a(0.0, 2.0, 0.0);
    }

    public boolean hasEtherBerries() {
        return this.hasEtherBerries > 0;
    }

    public void breakBlock() {
        ReikaItemHelper.dropItems((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), this.recipeItems);
        for (int i = 0; i < this.hasEtherBerries; ++i) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)ChromaStacks.etherBerries);
        }
    }

    @Override
    public float getAccelerationFactor() {
        return TileEntityFocusCrystal.getSummedFocusFactorDirect(this, this.getRelativeFocusCrystalLocations()) / 2.0f;
    }

    @Override
    public float getMaximumAcceleratability() {
        return 4.0f * TileEntityFocusCrystal.CrystalTier.TURBOCHARGED.efficiencyFactor;
    }

    @Override
    public float getProgressToNextStep() {
        return 0.0f;
    }

    @Override
    public void recountFocusCrystals() {
        this.getAccelerationFactor();
    }

    @Override
    public Collection<Coordinate> getRelativeFocusCrystalLocations() {
        ArrayList<Coordinate> c = new ArrayList<Coordinate>();
        int d = 2;
        for (int i = 2; i < 6; ++i) {
            c.add(new Coordinate(this.dirs[i].offsetX * d, 0, this.dirs[i].offsetZ * d));
        }
        return c;
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }

    static {
        required.addTag(CrystalElement.BLACK, 1000);
        required.addTag(CrystalElement.GRAY, 500);
        required.addTag(CrystalElement.PURPLE, 2500);
        required.addTag(CrystalElement.CYAN, 200);
        required.addTag(CrystalElement.BROWN, 200);
    }
}

