/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;
import net.minecraft.world.World;

public class TileEntityCrystalBrewer
extends InventoriedChromaticBase
implements OperationInterval {
    private int time = 400;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.canBrew()) {
            --this.time;
            if (this.time <= 0) {
                this.brew();
                this.time = 400;
            }
        } else {
            this.time = 400;
        }
    }

    private boolean canBrew() {
        if (this.inv[0] == null) {
            return false;
        }
        if (this.inv[0].func_77973_b() != ChromaItems.SHARD.getItemInstance()) {
            return false;
        }
        return this.isSlotModifiable(1) || this.isSlotModifiable(2) || this.isSlotModifiable(3);
    }

    private boolean isSlotModifiable(int i) {
        ItemStack is = this.inv[i];
        ItemStack z = this.inv[0];
        int zd = z.func_77960_j();
        if (is == null) {
            return false;
        }
        if (is.func_77973_b() == Items.field_151068_bn) {
            if (CrystalPotionController.instance.isPotionModifier(CrystalElement.elements[zd % 16])) {
                return ReikaPotionHelper.isActualPotion((int)is.func_77960_j());
            }
            return !ReikaPotionHelper.isActualPotion((int)is.func_77960_j());
        }
        if (is.func_77973_b() == ChromaItems.POTION.getItemInstance()) {
            return CrystalPotionController.instance.isPotionModifier(CrystalElement.elements[zd % 16]);
        }
        return false;
    }

    private void brew() {
        CrystalElement color = CrystalElement.elements[this.inv[0].func_77960_j() % 16];
        boolean boost = this.inv[0].func_77960_j() >= 16;
        this.inv[0] = null;
        for (int i = 1; i < 4; ++i) {
            if (this.inv[i] == null) continue;
            this.inv[i] = TileEntityCrystalBrewer.getPotionStackFromColor(this.inv[i].func_77960_j(), color, boost);
        }
    }

    public static ItemStack getPotionStackFromColor(int dmg, CrystalElement color, boolean boost) {
        ItemStack shard = ChromaItems.SHARD.getStackOfMetadata(color.ordinal());
        String eff = shard.func_77973_b().func_150896_i(shard);
        boolean custom = CrystalPotionController.instance.requiresCustomPotion(color);
        ItemStack is = new ItemStack((Item)Items.field_151068_bn, 1, 16);
        if (CrystalPotionController.instance.isPotionModifier(color)) {
            is.func_77964_b(dmg);
        }
        if (custom) {
            is = new ItemStack(ChromaItems.POTION.getItemInstance(), 1, color.ordinal());
        } else if (CrystalPotionController.instance.isCorruptedPotion(color)) {
            int newmeta = PotionHelper.func_77913_a((int)is.func_77960_j(), (String)eff);
            is = new ItemStack(is.func_77973_b(), 1, newmeta);
            int cmeta = PotionHelper.func_77913_a((int)is.func_77960_j(), (String)PotionHelper.field_77921_e);
            is = new ItemStack(is.func_77973_b(), 1, cmeta);
        } else {
            int newmeta = PotionHelper.func_77913_a((int)is.func_77960_j(), (String)eff);
            is = new ItemStack(is.func_77973_b(), 1, newmeta);
        }
        if (boost) {
            is.func_77964_b(is.func_77960_j() | 0x20 | 0x40);
        }
        return is;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int func_70302_i_() {
        return 4;
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_70300_a(EntityPlayer ep) {
        return ReikaMathLibrary.py3d((double)(ep.field_70165_t - (double)this.field_145851_c - 0.5), (double)(ep.field_70163_u - (double)this.field_145848_d - 0.5), (double)(ep.field_70161_v - (double)this.field_145849_e - 0.5)) <= 8.0;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        if (is.func_77973_b() == ChromaItems.POTION.getItemInstance()) {
            return i != 0;
        }
        if (is.func_77973_b() == ChromaItems.SHARD.getItemInstance()) {
            return i == 0;
        }
        if (is.func_77973_b() == Items.field_151068_bn) {
            return i != 0;
        }
        if (is.func_77973_b().func_150896_i(is) != null) {
            return i == 0;
        }
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i != 0;
    }

    public int getBrewTime() {
        return this.time;
    }

    public void setBrewTime(int par2) {
        this.time = par2;
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.time = NBT.func_74762_e("BrewTime");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("BrewTime", this.time);
    }

    @Override
    public int getRedstoneOverride() {
        return this.canBrew() ? 0 : 15;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.BREWER;
    }

    @Override
    public float getOperationFraction() {
        return !this.canBrew() ? 0.0f : 1.0f - (float)this.time / 400.0f;
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.canBrew() ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.INVALID;
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }
}

