/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityChromaFluidFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityAuraInfuser;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityItemInfuser
extends TileEntityAuraInfuser {
    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.INFUSER;
    }

    @Override
    protected ChromaStructures getStructure() {
        return ChromaStructures.INFUSION;
    }

    @Override
    protected void collectFocusCrystalLocations(FilledBlockArray arr) {
        for (Coordinate c : arr.keySet()) {
            if (c.yCoord != this.field_145848_d - 1 || c.getTaxicabDistanceTo(new Coordinate((TileEntity)this)) <= 2 || arr.getBlockAt(c.xCoord, c.yCoord, c.zCoord) != ChromaBlocks.PYLONSTRUCT.getBlockInstance()) continue;
            Coordinate c2 = c.offset(0, 1, 0);
            this.focusCrystalSpots.add(c2);
        }
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaStacks.rawCrystal);
    }

    @Override
    protected boolean isReady() {
        return ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ChromaStacks.rawCrystal);
    }

    @Override
    protected void onCraft() {
        int n = this.inv[0].field_77994_a;
        EntityPlayer ep = this.getCraftingPlayer();
        if (!ReikaPlayerAPI.isFake((EntityPlayer)ep) && Chromabilities.DOUBLECRAFT.enabledOn(ep)) {
            n *= 2;
        }
        this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.iridCrystal, (int)n);
        ProgressStage.INFUSE.stepPlayerTo(ep);
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void spawnParticles(World world, int x, int y, int z) {
        double ang = Math.toRadians(this.getTicksExisted() * 2 % 360);
        float fac = (float)Math.sin(Math.toRadians(this.getTicksExisted() * 4));
        float s = 1.25f + 0.25f * fac;
        for (int i = 0; i < 360; i += 60) {
            boolean tall = i % 120 == 0;
            float g = tall ? 0.375f * (0.5f + 0.5f * fac) : 0.375f;
            double a = ang + Math.toRadians(i);
            double r = 1.85;
            double v = tall ? 0.0425 * (double)(1.0f + fac) : ReikaRandomHelper.getRandomPlusMinus((double)0.0425, (double)0.005);
            double px = (double)x + 0.5 + r * Math.sin(a);
            double py = (double)y - 0.75;
            double pz = (double)z + 0.5 + r * Math.cos(a);
            double vx = -v * (px - (double)x - 0.5);
            double vy = 0.3;
            double vz = -v * (pz - (double)z - 0.5);
            EntityChromaFluidFX fx = new EntityChromaFluidFX(CrystalElement.WHITE, world, px, py, pz, vx, vy, vz).setScale(s).setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }
}

