/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Interfaces.TileEntity.ConditionalUnbreakability;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntityItemStand
extends InventoriedChromaticBase
implements ItemOnRightClick,
OwnedTile,
InertIInv,
IPipeConnection,
ConditionalUnbreakability {
    private InertItem item;
    private Coordinate tile;
    private boolean locked;
    private int updateRadius = 96;
    private static final MultiMap<UUID, WorldLocation> spreadSet = new MultiMap(MultiMap.CollectionType.HASHSET);

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            TileEntity te;
            if (this.tile != null && (te = this.tile.getTileEntity((IBlockAccess)world)) instanceof TileEntityCastingTable && ((TileEntityCastingTable)te).getCraftingTick() > 0) {
                this.spawnCraftParticles(world, x, y, z);
            }
            if (this.item != null) {
                this.spawnItemParticles(world, x, y, z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnItemParticles(World world, int x, int y, int z) {
        if (rand.nextInt(2) == 0) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.375);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5), (double)0.125);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.375);
            float gv = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.03125, (double)0.025));
            int l = ReikaRandomHelper.getRandomPlusMinus((int)60, (int)15);
            ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(this.inv[0]);
            CrystalElement e = tag != null ? (CrystalElement)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, tag.elementSet()) : null;
            int r = e != null ? e.getRed() : 0;
            int g = e != null ? e.getGreen() : 96;
            int b = e != null ? e.getBlue() : 255;
            EntityBlurFX fx = new EntityCCBlurFX(world, rx, ry, rz, 0.0, 0.0, 0.0).setColor(r, g, b).setGravity(gv).setLife(l);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCraftParticles(World world, int x, int y, int z) {
        if (rand.nextInt(32) == 0) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.375);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.375);
            EntityCenterBlurFX fx = new EntityCenterBlurFX(world, rx, y, rz, 0.0, 0.1, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.updateItem();
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return false;
    }

    @Override
    public ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        if (this.isLocked()) {
            return item;
        }
        if (ChromaItems.HELP.matchWith(item)) {
            return item;
        }
        UUID uid = ep.func_110124_au();
        if (!spreadSet.isEmpty() && !this.field_145850_b.field_72995_K) {
            ItemStack ret = item == null && spreadSet.containsValueForKey((Object)uid, (Object)new WorldLocation((TileEntity)this)) ? null : TileEntityItemStand.spreadItems(ep, item);
            spreadSet.remove((Object)uid);
            return ret;
        }
        if (this.inv[0] == null) {
            if (item == null) {
                return null;
            }
            this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)item, (int)1);
            --item.field_77994_a;
        } else if (ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)item)) {
            int add = Math.min(item.field_77994_a, this.inv[0].func_77976_d() - this.inv[0].field_77994_a);
            this.inv[0].field_77994_a += add;
            item.field_77994_a -= add;
        } else if (item == null) {
            this.dropSlot();
        } else {
            this.dropSlot();
            this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)item, (int)1);
            --item.field_77994_a;
        }
        if (item != null && item.field_77994_a <= 0) {
            item = null;
        }
        ChromaSounds.ITEMSTAND.playSoundAtBlock((TileEntity)this);
        return item;
    }

    public void spreadItemWith(EntityPlayer ep, ItemStack is) {
        if (this.inv[0] == null) {
            spreadSet.addValue((Object)ep.func_110124_au(), (Object)new WorldLocation((TileEntity)this));
        }
    }

    private static ItemStack spreadItems(EntityPlayer ep, ItemStack is) {
        if (is == null) {
            return null;
        }
        UUID uid = ep.func_110124_au();
        int n = spreadSet.get((Object)uid).size();
        int amt = is.field_77994_a;
        for (WorldLocation loc : spreadSet.get((Object)uid)) {
            TileEntityItemStand te = (TileEntityItemStand)loc.getTileEntity((IBlockAccess)ep.field_70170_p);
            if (te.inv[0] == null) continue;
            amt += te.inv[0].field_77994_a;
        }
        int div = amt / n;
        int left = amt - div * n;
        for (WorldLocation loc : spreadSet.get((Object)uid)) {
            TileEntityItemStand te = (TileEntityItemStand)loc.getTileEntity();
            te.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)div);
            ChromaSounds.ITEMSTAND.playSoundAtBlock((TileEntity)te);
            te.syncAllData(true);
        }
        return ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)left);
    }

    private void updateItem() {
        InertItem inertItem = this.item = this.inv[0] != null ? new InertItem(this.field_145850_b, ReikaItemHelper.getSizedItemStack((ItemStack)this.inv[0], (int)1)) : null;
        if (this.field_145850_b != null) {
            TileEntity te;
            TileEntity tileEntity = te = this.tile != null ? this.tile.getTileEntity((IBlockAccess)this.field_145850_b) : null;
            if (te instanceof TileEntityCastingTable) {
                ((TileEntityCastingTable)te).func_70296_d();
            }
        }
    }

    public EntityItem getItem() {
        return this.item;
    }

    public void dropSlot() {
        if (this.inv[0] != null) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.inv[0]);
            this.inv[0] = null;
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.STAND;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.updateItem();
        if (NBT.func_74764_b("table")) {
            this.tile = Coordinate.readFromNBT((String)"table", (NBTTagCompound)NBT);
        }
        this.locked = NBT.func_74767_n("lock");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        if (this.tile != null) {
            this.tile.writeToNBT("table", NBT);
        }
        NBT.func_74757_a("lock", this.locked);
    }

    public void setTable(TileEntityCastingTable te) {
        this.tile = te != null ? new Coordinate((TileEntity)te) : null;
    }

    @Override
    public boolean onlyAllowOwnersToUse() {
        return true;
    }

    @DependentMethodStripper.ModDependent(value={ModList.BCTRANSPORT})
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    public void lock(boolean lock) {
        this.locked = lock;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getUpdatePacketRadius() {
        return this.updateRadius;
    }

    public boolean isUnbreakable(EntityPlayer ep) {
        return this.isLocked();
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
    }

    public void syncAfterCraft() {
        this.updateRadius = -1;
        this.syncAllData(true);
        this.updateRadius = 96;
    }
}

