/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Magic.ElementBufferCapacityBoost;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityChromaFluidFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityAuraInfuser;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityPlayerInfuser
extends TileEntityAuraInfuser {
    private AxisAlignedBB targetBox;

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        double d = 0.0625;
        this.targetBox = AxisAlignedBB.func_72330_a((double)((double)x - d), (double)((double)y + 0.375 - d), (double)((double)z - d), (double)((double)(x + 1) + d), (double)((double)y + 0.75 + d), (double)((double)(z + 1) + d));
    }

    public AxisAlignedBB getTargetBox() {
        return this.targetBox.func_72329_c();
    }

    public int func_70297_j_() {
        return 8;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.PLAYERINFUSER;
    }

    @Override
    protected ChromaStructures getStructure() {
        return ChromaStructures.PLAYERINFUSION;
    }

    @Override
    protected void collectFocusCrystalLocations(FilledBlockArray arr) {
        for (Coordinate c : arr.keySet()) {
            if (arr.getBlockAt(c.xCoord, c.yCoord, c.zCoord) != ChromaBlocks.PYLONSTRUCT.getBlockInstance() || arr.getMetaAt(c.xCoord, c.yCoord, c.zCoord) != BlockPylonStructure.StoneTypes.STABILIZER.ordinal()) continue;
            Coordinate c2 = c.offset(0, 1, 0);
            this.focusCrystalSpots.add(c2);
        }
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return this.getEffect(is) != null;
    }

    @Override
    protected boolean isReady() {
        if (this.inv[0] == null || this.inv[0].field_77994_a < 8) {
            return false;
        }
        if (this.targetBox == null || !this.targetBox.func_72326_a(this.getCraftingPlayer().field_70121_D)) {
            return false;
        }
        ElementBufferCapacityBoost e = this.getSelectedEffect();
        return e != null && ElementBufferCapacityBoost.getAvailableBoosts(this.getCraftingPlayer()).contains((Object)e);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void spawnParticles(World world, int x, int y, int z) {
        int n = Math.max(1, rand.nextInt(4) - Minecraft.func_71410_x().field_71474_y.field_74362_aa);
        for (int i = 0; i < n; ++i) {
            Coordinate p = (Coordinate)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.getChromaLocations());
            double r = 1.85;
            double px = (double)p.xCoord + rand.nextDouble();
            double pz = (double)p.zCoord + rand.nextDouble();
            double vy = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.4);
            float s = 1.5f;
            float g = (float)(vy * 1.2);
            double vx = -vy * (px - (double)x - 0.5) / 6.0;
            double vz = -vy * (pz - (double)z - 0.5) / 6.0;
            EntityChromaFluidFX fx = new EntityChromaFluidFX(CrystalElement.WHITE, world, px, (double)p.yCoord + 0.5, pz, vx, vy, vz).setScale(s).setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void doAmbientParticles(World world, int x, int y, int z) {
        Coordinate p = (Coordinate)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.getChromaLocations());
        double px = (double)p.xCoord + rand.nextDouble();
        double pz = (double)p.zCoord + rand.nextDouble();
        float s = 1.75f;
        double vy = ReikaRandomHelper.getRandomBetween((double)0.0625, (double)0.375);
        float g = (float)Math.max(ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.25), vy);
        EntityChromaFluidFX fx = new EntityChromaFluidFX(CrystalElement.WHITE, world, px, (double)p.yCoord + 0.5, pz, 0.0, vy, 0.0).setScale(s).setGravity(g);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private ElementBufferCapacityBoost getEffect(ItemStack is) {
        for (ElementBufferCapacityBoost e : ElementBufferCapacityBoost.list) {
            ItemStack is2 = e.getIngredient();
            if (is2 == null || !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)is2)) continue;
            return e;
        }
        return null;
    }

    @Override
    protected void onCraft() {
        this.getSelectedEffect().give(this.getCraftingPlayer());
        this.inv[0] = null;
    }

    public ElementBufferCapacityBoost getSelectedEffect() {
        return this.inv[0] != null ? this.getEffect(this.inv[0]) : null;
    }

    @Override
    protected void onCraftingTick(World world, int x, int y, int z) {
        EntityPlayer ep = this.getCraftingPlayer();
        AxisAlignedBB box = ep.field_70121_D;
        double cx = (box.field_72336_d + box.field_72340_a) / 2.0;
        double cy = box.field_72338_b;
        double cz = (box.field_72334_f + box.field_72339_c) / 2.0;
        double cx2 = (this.targetBox.field_72336_d + this.targetBox.field_72340_a) / 2.0;
        double cy2 = (this.targetBox.field_72337_e + this.targetBox.field_72338_b) / 2.0;
        double cz2 = (this.targetBox.field_72334_f + this.targetBox.field_72339_c) / 2.0;
        double dx = cx2 - cx;
        double dy = cy2 - cy;
        double dz = cz2 - cz;
        double v = 0.25;
        ep.field_70159_w += dx * dx * v * Math.signum(dx);
        ep.field_70181_x += dy * dy * v * 1.5 * Math.signum(dy);
        ep.field_70179_y += dz * dz * v * Math.signum(dz);
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }
}

