/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.API.Event.RitualCompletionEvent;
import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.VariableTexture;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.AbilityRituals;
import Reika.ChromatiCraft.Auxiliary.Structure.RitualStructure;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedCrystalReceiver;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityGlobeFX;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.TriggerableAction;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityRitualTable
extends InventoriedCrystalReceiver
implements BreakAction,
TriggerableAction,
OwnedTile,
OperationInterval,
MultiBlockChromaTile,
VariableTexture {
    private boolean hasStructure = false;
    private boolean hasEnhancedStructure = false;
    private int abilityTick = 0;
    private AbilityAPI.Ability ability;
    private int abilitySoundTick = 2000;
    private int tickNoPlayer = 0;
    private int tickPlayerOut = 0;
    private boolean playerSteppedIn = false;
    private boolean isEnhanced;
    private EntityPlayer ritualPlayer;

    @Override
    public void onPathBroken(CrystalFlow p, CrystalNetworkLogger.FlowFail f) {
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.abilityTick > 0) {
            this.onRitualTick(world, x, y, z);
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        AbilityRituals.addTable(this);
        this.validateStructure();
    }

    private void onRitualTick(World world, int x, int y, int z) {
        EntityPlayer ep;
        ElementTagCompound tag = AbilityRituals.instance.getAura(this.ability);
        if (this.getCooldown() == 0 && this.checkTimer.checkCap()) {
            this.requestEnergyDifference(tag, true);
        }
        if ((ep = this.ritualPlayer) == null || world.func_152378_a(ep.getPersistentID()) == null) {
            ++this.tickNoPlayer;
            if (this.tickNoPlayer > 200) {
                this.terminateRitual();
            }
            return;
        }
        this.tickNoPlayer = 0;
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72317_d(0.0, 2.0, 0.0).func_72314_b(0.0, 1.0, 0.0);
        boolean nrg = this.energy.containsAtLeast(tag);
        boolean inbox = ep.field_70121_D.func_72326_a(box);
        if (nrg) {
            if (inbox) {
                this.playerSteppedIn = true;
                this.tickPlayerOut = 0;
            } else if (this.playerSteppedIn) {
                ++this.tickPlayerOut;
                if (this.tickPlayerOut > 50) {
                    this.terminateRitual();
                }
                return;
            }
        }
        boolean canTick = nrg && inbox;
        ++this.abilitySoundTick;
        if (this.abilitySoundTick >= 490 && this.abilityTick > 120) {
            this.abilitySoundTick = 0;
            ChromaSounds.ABILITY.playSoundAtBlock((TileEntity)this);
        }
        if (world.field_72995_K) {
            this.spawnParticles(world, x, y, z, canTick, tag);
        }
        if (canTick && !world.field_72995_K) {
            double dx = ep.field_70165_t - (double)x - 0.5;
            double dy = ep.field_70163_u - (double)y - 2.25 - 0.75 * Math.sin(Math.toRadians(2 * this.getTicksExisted()));
            double dz = ep.field_70161_v - (double)z - 0.5;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            double v = 0.1875;
            double sx = dx > 0.0 ? 1.0 : -1.0;
            double sy = dy > 0.0 ? 1.0 : -1.0;
            double sz = dz > 0.0 ? 1.0 : -1.0;
            double vx = -v * sx * (dx * dx) / dd;
            double vy = -v * sy * (dy * dy) / dd;
            double vz = -v * sz * (dz * dz) / dd;
            ep.field_70159_w = vx;
            ep.field_70181_x = vy;
            ep.field_70179_y = vz;
            ep.field_70133_I = true;
            ep.field_70143_R = 0.0f;
            if (ep instanceof EntityPlayerMP) {
                ((EntityPlayerMP)ep).field_71135_a.field_147365_f = 0;
            }
        }
        if (canTick) {
            --this.abilityTick;
        }
        if (this.abilityTick <= 0) {
            ChromaSounds.ABILITYCOMPLETE.playSound((Entity)ep, 1.0f, 1.0f);
            this.giveAbility(ep);
            this.energy.subtract(tag);
        }
    }

    private void terminateRitual() {
        this.abilitySoundTick = 20000;
        this.abilityTick = 0;
        this.tickPlayerOut = 0;
        this.playerSteppedIn = false;
        if (this.ritualPlayer != null && this.field_145850_b.field_72995_K) {
            this.resetGUIs();
        }
        this.ritualPlayer = null;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z, boolean canTick, ElementTagCompound tag) {
        int a = 2 * this.getTicksExisted() % 360;
        for (int i = 0; i < 360; i += 120) {
            double ang = Math.toRadians(a + i);
            double r = 0.5;
            double rx = (double)x + 0.5 + r * Math.cos(ang);
            double ry = y;
            double rz = (double)z + 0.5 + r * Math.sin(ang);
            double v = 0.04;
            double vx = v * Math.cos(ang);
            double vz = v * Math.sin(ang);
            EntityGlobeFX fx = new EntityGlobeFX(world, rx, y, rz, vx, 0.1875, vz).setScale(1.5f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        tag.intersectWithMinimum(this.energy);
        int n = tag.tagCount();
        if (n > 0) {
            a = 8 * this.getTicksExisted() % 360;
            int i = 0;
            for (CrystalElement e : tag.elementSet()) {
                double ang = Math.toRadians((double)a + (double)i * 360.0 / (double)n);
                double r = 0.25;
                double rx = (double)x + 0.5 + r * Math.cos(ang);
                double ry = y;
                double rz = (double)z + 0.5 + r * Math.sin(ang);
                double v = 0.0125;
                double vx = v * Math.cos(ang);
                double vz = v * Math.sin(ang);
                EntityGlobeFX fx = new EntityGlobeFX(e, world, rx, y, rz, vx, 0.1875, vz).setScale(1.5f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                ++i;
            }
        }
        if (canTick) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g.func_70005_c_().equals(this.ritualPlayer.func_70005_c_())) {
                mc.field_71474_y.field_74320_O = 2;
                mc.field_71439_g.field_70177_z = this.getTicksExisted() % 360;
                mc.field_71439_g.field_70759_as = mc.field_71439_g.field_70177_z - 35.0f;
                mc.field_71439_g.field_70125_A = 0.0f;
                mc.field_71474_y.field_74319_N = true;
            }
        }
    }

    private void giveAbility(EntityPlayer ep) {
        if (ep == null || ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            ChromatiCraft.logger.logError((Object)"Tried to give ability to null or fake player???");
            return;
        }
        boolean flag = false;
        if (this.ability instanceof Chromabilities && !ChromaResearchManager.instance.playerHasFragment(ep, ChromaResearch.getPageFor((Chromabilities)this.ability))) {
            ReikaParticleHelper.EXPLODE.spawnAroundBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 6);
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.explode");
            ReikaEntityHelper.knockbackEntityFromPos((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d - 0.5), (double)((double)this.field_145849_e + 0.5), (Entity)ep, (double)4.0);
            ep.field_70143_R += 12.0f;
        } else {
            Chromabilities.give(ep, this.ability);
            MinecraftForge.EVENT_BUS.post((Event)new RitualCompletionEvent(ep, this.ability.getID()));
            flag = true;
        }
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
        if (this.field_145850_b.field_72995_K) {
            this.resetGUIs();
            if (flag) {
                TileEntityRitualTable.doCompletionParticles(ep, this.ability);
            }
        }
        this.abilitySoundTick = 2000;
        this.ability = null;
    }

    @SideOnly(value=Side.CLIENT)
    private static void doCompletionParticles(EntityPlayer ep, AbilityAPI.Ability a) {
        int n = ReikaRandomHelper.getRandomBetween((int)100, (int)200);
        ElementTagCompound tag = AbilityRituals.instance.getAura(a);
        WeightedRandom<CrystalElement> wr = tag.asWeightedRandom();
        for (int i = 0; i < n; ++i) {
            double v0 = ReikaRandomHelper.getRandomBetween((double)0.1, (double)0.35);
            double[] v = ReikaPhysicsHelper.polarToCartesian((double)v0, (double)(rand.nextDouble() * 360.0), (double)(rand.nextDouble() * 360.0));
            float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.125));
            int l = ReikaRandomHelper.getRandomBetween((int)40, (int)100);
            EntityCCBlurFX fx = new EntityCCBlurFX(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u - 1.62 + 0.8, ep.field_70161_v, v[0], v[1], v[2]);
            fx.setGravity(g).setScale(2.0f).setLife(l);
            fx.setRapidExpand().setAlphaFading();
            fx.setColor(((CrystalElement)wr.getRandomEntry()).getColor());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void validateStructure() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d - 2;
        int z = this.field_145849_e;
        ChromaStructures.RITUAL.getStructure().resetToDefaults();
        ((RitualStructure)ChromaStructures.RITUAL.getStructure()).initializeEnhance(this.isEnhanced, false);
        FilledBlockArray array = ChromaStructures.RITUAL.getArray(world, x, y, z);
        this.hasStructure = array.matchInWorld();
        boolean bl = this.hasEnhancedStructure = this.isEnhanced && this.hasStructure && ChromaStructures.RITUAL2.getArray(world, x, y, z).matchInWorld();
        if (!this.hasStructure && this.abilityTick > 0) {
            this.killRitual();
        }
        this.syncAllData(true);
    }

    private void checkEnhancement(EntityPlayer ep) {
        this.isEnhanced = ProgressStage.DIMENSION.isPlayerAtStage(ep);
    }

    public boolean isFullyEnhanced() {
        return this.isEnhanced && this.hasEnhancedStructure;
    }

    private void killRitual() {
        this.abilitySoundTick = 2000;
        this.abilityTick = 0;
        this.playerSteppedIn = false;
        this.ability = null;
        if (this.field_145850_b.field_72995_K) {
            this.resetGUIs();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void resetGUIs() {
        if (this.field_145850_b.field_72995_K) {
            GameSettings gs = Minecraft.func_71410_x().field_71474_y;
            gs.field_74320_O = 0;
            gs.field_74319_N = false;
        }
    }

    public boolean triggerRitual(EntityPlayer ep) {
        this.initEnhancementCheck(ep);
        if (this.hasStructure && this.abilityTick == 0 && this.ability != null && AbilityRituals.instance.hasRitual(this.ability) && this.isOwnedByPlayer(ep)) {
            this.ritualPlayer = ep;
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            ElementTagCompound tag = AbilityRituals.instance.getAura(this.ability);
            this.requestEnergyDifference(tag, true);
            this.abilityTick = AbilityRituals.instance.getDuration(this.ability);
            this.playerSteppedIn = false;
            ChromaSounds.USE.playSoundAtBlock((TileEntity)this);
            this.syncAllData(true);
            return true;
        }
        ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
        return false;
    }

    public void initEnhancementCheck(EntityPlayer ep) {
        this.checkEnhancement(ep);
        this.validateStructure();
    }

    public void setChosenAbility(AbilityAPI.Ability c) {
        this.killRitual();
        this.ability = c;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
        NBT.func_74757_a("structe", this.hasEnhancedStructure);
        NBT.func_74768_a("atick", this.abilityTick);
        NBT.func_74778_a("ability", this.ability != null ? this.ability.getID() : "null");
        NBT.func_74757_a("enhance", this.isEnhanced);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
        this.hasEnhancedStructure = NBT.func_74767_n("structe");
        this.abilityTick = NBT.func_74762_e("atick");
        String a = NBT.func_74779_i("ability");
        this.ability = a != null && !a.isEmpty() && !a.equals("null") ? Chromabilities.getAbility(a) : null;
        this.isEnhanced = NBT.func_74767_n("enhance");
    }

    @Override
    public int maxThroughput() {
        return this.isFullyEnhanced() ? 2500 : 200;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public int func_70297_j_() {
        return 0;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return AbilityRituals.instance.getMaxAbilityCost() * 3 / 2;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.RITUAL;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public ElementTagCompound getRequestedTotal() {
        return this.ability != null && this.abilityTick > 0 ? AbilityHelper.instance.getElementsFor(this.ability) : null;
    }

    public boolean isActive() {
        return this.abilityTick > 0;
    }

    public void breakBlock() {
        AbilityRituals.removeTable(this);
    }

    public boolean isPlayerUsing(EntityPlayer ep) {
        ElementTagCompound tag = AbilityRituals.instance.getAura(this.ability);
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72317_d(0.0, 2.0, 0.0).func_72314_b(0.0, 1.0, 0.0);
        return this.energy.containsAtLeast(tag) && ep.field_70121_D.func_72326_a(box);
    }

    public boolean trigger() {
        return this.getPlacer() != null && this.triggerRitual(this.getPlacer());
    }

    @Override
    public boolean onlyAllowOwnersToUse() {
        return true;
    }

    @Override
    public int getIconState(int side) {
        return this.isEnhanced ? 1 : 0;
    }

    @Override
    public float getOperationFraction() {
        return this.ability == null ? 0.0f : 1.0f - (float)this.abilityTick / (float)AbilityRituals.instance.getDuration(this.ability);
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.ability != null && this.hasStructure ? (this.energy.containsAtLeast(AbilityRituals.instance.getAura(this.ability)) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        return ChromaStructures.RITUAL;
    }

    @Override
    public Coordinate getStructureOffset() {
        return new Coordinate(0, -2, 0);
    }

    @Override
    public boolean canStructureBeInspected() {
        return true;
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }
}

