/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Storage;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityMassStorage;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.AppEngHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;

public class TileEntityToolStorage
extends TileEntityMassStorage {
    private static final int MAX_COUNT = 360000;
    private ToolType filter = ToolType.OTHER;

    public boolean stepMode() {
        if (this.getPendingInput() == null && this.getItems().isEmpty()) {
            this.filter = ToolType.list[(this.filter.ordinal() + 1) % ToolType.list.length];
            this.resetWorkTimer();
            return true;
        }
        return false;
    }

    @Override
    public InertItem getFilterItemRender() {
        return this.filter.getRenderItem();
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.TOOLSTORAGE;
    }

    @Override
    protected KeyedItemStack key(ItemStack is) {
        return new KeyedItemStack(is).setIgnoreMetadata(!this.filter.isDamageImportant()).setIgnoreNBT(!this.filter.isNBTImportant()).setSized(false).setSimpleHash(true);
    }

    @Override
    public boolean isItemValid(ItemStack is) {
        return this.filter.isItemValid(is);
    }

    @Override
    public int maxItemCount() {
        return 360000;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("mode", this.filter.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.filter = ToolType.list[NBT.func_74762_e("mode")];
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
    }

    public static enum ToolType {
        PICK(Items.field_151046_w),
        AXE(Items.field_151036_c),
        SHOVEL(Items.field_151011_C),
        SWORD(Items.field_151048_u),
        BOW((Item)Items.field_151031_f),
        SHEARS((Item)Items.field_151097_aZ),
        HELMET((Item)Items.field_151161_ac),
        CHESTPLATE((Item)Items.field_151163_ad),
        LEGS((Item)Items.field_151173_ae),
        BOOTS((Item)Items.field_151175_af),
        BOOK((Item)Items.field_151134_bR),
        HORSEARMOR(Items.field_151136_bY),
        POTION(ReikaPotionHelper.getPotionItem((Potion)Potion.field_76428_l, (boolean)false, (boolean)false, (boolean)false)),
        TINKER(ModList.TINKERER.isLoaded() ? TinkerToolHandler.Tools.HAMMER.getToolOfMaterials(1, 1, 1, 1) : (ItemStack)null),
        OTHER((ItemStack)null);

        private static final ToolType[] list;
        private final ItemStack icon;
        private InertItem render;

        @SideOnly(value=Side.CLIENT)
        public InertItem getRenderItem() {
            if (this.render == null && this.icon != null) {
                this.render = new InertItem((World)Minecraft.func_71410_x().field_71441_e, this.icon);
            }
            return this.render;
        }

        public boolean isDamageImportant() {
            switch (this) {
                case POTION: 
                case OTHER: {
                    return true;
                }
            }
            return false;
        }

        public boolean isNBTImportant() {
            switch (this) {
                case OTHER: 
                case TINKER: 
                case BOOK: {
                    return true;
                }
            }
            return false;
        }

        private ToolType(Item i) {
            this(new ItemStack(i));
        }

        private ToolType(ItemStack is) {
            this.icon = is;
        }

        public boolean isItemValid(ItemStack is) {
            return ToolType.getTypeForTool(is) == this;
        }

        private static ToolType getTypeForTool(ItemStack is) {
            if (ToolType.isTinker(is)) {
                return TINKER;
            }
            if (is.func_77973_b() instanceof ItemArmor) {
                int type = ((ItemArmor)is.func_77973_b()).field_77881_a;
                switch (type) {
                    case 0: {
                        return HELMET;
                    }
                    case 1: {
                        return CHESTPLATE;
                    }
                    case 2: {
                        return LEGS;
                    }
                    case 3: {
                        return BOOTS;
                    }
                }
            }
            if (is.func_77973_b() instanceof ItemAxe) {
                return AXE;
            }
            if (is.func_77973_b() instanceof ItemBow) {
                return BOW;
            }
            if (is.func_77973_b() instanceof ItemPickaxe) {
                return PICK;
            }
            if (is.func_77973_b() instanceof ItemShears) {
                return SHEARS;
            }
            if (is.func_77973_b() instanceof ItemSpade) {
                return SHOVEL;
            }
            if (is.func_77973_b() instanceof ItemSword) {
                return SWORD;
            }
            if (is.func_77973_b() instanceof ItemEnchantedBook) {
                return BOOK;
            }
            if (is.func_77973_b() == Items.field_151138_bX || is.func_77973_b() == Items.field_151136_bY || is.func_77973_b() == Items.field_151125_bZ) {
                return HORSEARMOR;
            }
            if (is.func_77973_b() instanceof ItemPotion) {
                return POTION;
            }
            if (ModList.BOTANIA.isLoaded() && InterfaceCache.BREWITEM.instanceOf((Object)is.func_77973_b())) {
                return POTION;
            }
            return ToolType.isValidMiscToolItem(is) ? OTHER : null;
        }

        private static boolean isValidMiscToolItem(ItemStack is) {
            if (ModList.APPENG.isLoaded()) {
                Item i = is.func_77973_b();
                if (i == AppEngHandler.getInstance().get1KCell() || i == AppEngHandler.getInstance().get4KCell()) {
                    return false;
                }
                if (i == AppEngHandler.getInstance().get16KCell() || i == AppEngHandler.getInstance().get64KCell()) {
                    return false;
                }
            }
            if (ModList.FORESTRY.isLoaded() && ReikaBeeHelper.isGenedItem((ItemStack)is)) {
                return false;
            }
            return is.func_77976_d() == 1;
        }

        private static boolean isTinker(ItemStack is) {
            return ModList.TINKERER.isLoaded() && (TinkerToolHandler.getInstance().isTool(is) || TinkerToolHandler.getInstance().isWeapon(is));
        }

        public static String getTypesAsString() {
            StringBuilder sb = new StringBuilder();
            for (ToolType type : list) {
                sb.append(type.displayName());
                if (type == OTHER) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        public String displayName() {
            return ReikaStringParser.capFirstChar((String)this.name());
        }

        static {
            list = ToolType.values();
        }
    }
}

