/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.Decoration.BlockMetaAlloyLamp;
import Reika.ChromatiCraft.Entity.EntityTunnelNuker;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ProximityMap;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityDataNode
extends TileEntityChromaticBase
implements OperationInterval,
StructureRenderer.StructureRenderingParticleSpawner {
    private double extension0;
    private double extension1;
    private double extension2;
    private double lastLowerHeight;
    private double lastUpperHeight;
    private static final int EXTENSION_TIME_0 = 24;
    private static final int EXTENSION_TIME_1 = 50;
    private static final int EXTENSION_TIME_2 = 36;
    public static final double EXTENSION_LIMIT_0 = 0.75;
    public static final double EXTENSION_LIMIT_1 = 1.375;
    public static final double EXTENSION_LIMIT_2 = 1.125;
    private static final double EXTENSION_SPEED_0 = 0.03125;
    private static final double EXTENSION_SPEED_1 = 0.0275;
    private static final double EXTENSION_SPEED_2 = 0.03125;
    private double rotation;
    private double rotationSpeed;
    private static final int SCAN_TIME = 120;
    private static final int SCAN_COOLDOWN = 240;
    private int scanTick;
    private int scanSustain;
    private int scanCooldown;
    private static final int PROGRESS_DELAY_LENGTH = 50;
    private EntityPlayer progressPlayer;
    private int progressDelay;
    private Towers tower;
    private final HashSet<String> scannedPlayers = new HashSet();
    private final ProximityMap metaAlloyPlants = new ProximityMap(64, 1);
    private int plantRand = 800;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.DATANODE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        EntityPlayer ep = world.func_72977_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 16.0);
        this.lastLowerHeight = this.extension0 + this.extension1;
        this.lastUpperHeight = this.extension2;
        if (ep != null || ReikaObfuscationHelper.isDeObfEnvironment() && KeyWatcher.instance.isKeyDown(world.func_72924_a("Reika"), KeyWatcher.Key.LCTRL)) {
            if (this.extension0 < 0.75) {
                this.extension0 = Math.min(this.extension0 + 0.03125, 0.75);
            } else if (this.extension1 < 1.375) {
                this.extension1 = Math.min(this.extension1 + 0.0275, 1.375);
            } else {
                this.extension2 = Math.min(this.extension2 + 0.03125, 1.125);
            }
        } else if (this.extension1 == 0.0) {
            this.extension0 = Math.max(this.extension0 - 0.03125, 0.0);
        } else if (this.extension2 == 0.0) {
            this.extension1 = Math.max(this.extension1 - 0.0275, 0.0);
        } else {
            this.extension2 = Math.max(this.extension2 - 0.03125, 0.0);
        }
        if (this.extension0 > 0.0 && !world.field_72995_K) {
            ArrayList<ChromaSounds> snd = new ArrayList<ChromaSounds>();
            if ((this.extension0 + this.extension1 > this.lastLowerHeight || this.extension2 > this.lastUpperHeight) && (this.getTicksExisted() % 5 == 0 || this.lastLowerHeight <= 0.0)) {
                snd.add(ChromaSounds.TOWEREXTEND1);
            }
            if (this.extension1 >= 1.375 && this.lastLowerHeight < 2.125) {
                snd.add(ChromaSounds.TOWEREXTEND2);
            }
            if (this.extension2 == 1.125 && (this.getTicksExisted() % 50 == 0 || this.lastUpperHeight < 1.125)) {
                snd.add(ChromaSounds.TOWERAMBIENT);
            }
            for (ChromaSounds s : snd) {
                s.playSoundAtBlock(world, x, y + 3, z, 2.0f, 1.0f);
                List li = world.func_72872_a(EntityPlayer.class, ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(30.0, 18.0, 30.0));
                for (EntityPlayer ep2 : li) {
                    float f = (float)Math.max(0.4, 2.0 - ep2.func_70011_f((double)x + 0.5, (double)y + 2.5, (double)z + 0.5) / 15.0);
                    s.playSound((Entity)ep2, f, 1.0f);
                }
            }
        }
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z);
        } else if (this.tower != null) {
            this.tower.generatedAt(x, y, z);
        }
        if (this.scanSustain > 0) {
            --this.scanSustain;
            ++this.scanTick;
        } else if (this.scanTick > 0) {
            this.scanTick = Math.max(0, this.scanTick - 8);
        }
        if (this.scanTick > 0) {
            float f = 0.5f + 1.5f * this.getScanProgress();
            ChromaSounds.KILLAURA_CHARGE.playSoundAtBlock((TileEntity)this, 1.0f, f);
        }
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (this.progressDelay > 0) {
            --this.progressDelay;
            if (this.progressDelay == 0 && this.tower != null) {
                LoreManager.instance.triggerLore(this.progressPlayer, this.tower);
            }
        }
        if (this.tower != null && !world.field_72995_K) {
            if (rand.nextInt(this.plantRand) == 0) {
                if (this.spawnMetaAlloy(world, x, y, z)) {
                    this.plantRand = 800;
                } else {
                    this.plantRand = Math.max(300, this.plantRand - 50);
                    for (Coordinate c : this.metaAlloyPlants.getLocations()) {
                        if (c.getBlock((IBlockAccess)world) == ChromaBlocks.METAALLOYLAMP.getBlockInstance()) continue;
                        this.metaAlloyPlants.remove(c);
                    }
                }
            }
            if (rand.nextInt(300) == 0) {
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this);
                List li = world.func_72872_a(EntityTunnelNuker.class, box = box.func_72314_b(192.0, 64.0, 192.0));
                if (li.size() < 8 && ReikaWorldHelper.isRadiusLoaded((World)world, (int)x, (int)z, (int)6)) {
                    EntityTunnelNuker e = new EntityTunnelNuker(this.field_145850_b);
                    int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)128);
                    int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)128);
                    int dy = world.func_72825_h(dx, dz) + 3 + rand.nextInt(12);
                    e.func_70012_b((double)dx + rand.nextDouble(), dy, (double)dz + rand.nextDouble(), rand.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)e);
                }
            }
        }
    }

    public void tickFX() {
    }

    private boolean spawnMetaAlloy(World world, int x, int y, int z) {
        int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)256);
        int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)256);
        int dy = world.func_72825_h(x, z) + 1;
        Block b = world.func_147439_a(dx, dy, dz);
        while (dy >= 0 && (b.isAir((IBlockAccess)world, dx, dy, dz) || ReikaBlockHelper.isLeaf((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) || ReikaBlockHelper.isWood((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) {
            b = world.func_147439_a(dx, --dy, dz);
        }
        if (b == Blocks.field_150349_c && world.func_147439_a(dx, dy + 1, dz).isAir((IBlockAccess)world, dx, dy, dz) && this.metaAlloyPlants.add(new Coordinate(dx, dy + 1, dz))) {
            world.func_147449_b(dx, dy + 1, dz, ChromaBlocks.METAALLOYLAMP.getBlockInstance());
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        if (this.canBeAccessed()) {
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)4.0);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)4.0);
            double py = ReikaRandomHelper.getRandomBetween((double)((double)y + 3.5), (double)(y + 5));
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.FADE_RAY).setColor(10543359).setLife(30).setScale(0.5f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        if (this.canBeAccessed() && rand.nextInt(5) == 0 && this.tower != null) {
            if (this.tower == Towers.ALPHA) {
                int idx = 1 + this.getTicksExisted() / 120 % (Towers.towerList.length - 1);
                this.sendParticlesToTower(world, x, y, z, Towers.towerList[idx]);
            } else {
                this.sendParticlesToTower(world, x, y, z, this.tower.getNeighbor1());
                this.sendParticlesToTower(world, x, y, z, this.tower.getNeighbor2());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void sendParticlesToTower(World world, int x, int y, int z, Towers t) {
        if (t == null || t.getRootPosition() == null) {
            return;
        }
        double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)1.0);
        double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)1.0);
        double py = ReikaRandomHelper.getRandomBetween((double)((double)y + 3.5), (double)(y + 5));
        double dx = t.getRootPosition().field_77276_a - this.tower.getRootPosition().field_77276_a;
        double dz = t.getRootPosition().field_77275_b - this.tower.getRootPosition().field_77275_b;
        double a = -ReikaPhysicsHelper.cartesianToPolar((double)dx, (double)0.0, (double)dz)[2] - 90.0;
        float s = rand.nextFloat() + 0.25f;
        EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(world, px, py, pz, a, 0.0, ChromaIcons.FADE);
        fx.freedom *= 0.5;
        fx.setColor(10543359).setLife(120).setScale(s);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public double getRotation() {
        return this.rotation;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        this.rotationSpeed = this.extension2 == 1.125 ? 1.5 : (this.extension1 == 1.375 ? 1.0 : (this.extension0 == 0.75 ? 0.5 : 0.0));
        this.rotation += this.rotationSpeed;
    }

    public double getExtension0() {
        return StructureRenderer.isRenderingTiles() ? 0.75 : this.extension0;
    }

    public double getExtension1() {
        return StructureRenderer.isRenderingTiles() ? 1.375 : this.extension1;
    }

    public double getExtension2() {
        return StructureRenderer.isRenderingTiles() ? 1.125 : this.extension2;
    }

    public boolean canBeAccessed() {
        return this.extension2 >= 1.125;
    }

    public void scan(EntityPlayer ep) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() && KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.LCTRL)) {
            this.scannedPlayers.clear();
            this.scanCooldown = 0;
        }
        if (this.scanCooldown > 0) {
            return;
        }
        if (!this.canBeAccessed()) {
            return;
        }
        if (this.hasBeenScanned(ep)) {
            return;
        }
        ++this.scanTick;
        this.scanSustain = 4;
        if (this.scanTick >= 120 && !this.field_145850_b.field_72995_K) {
            this.doScan(ep);
        }
    }

    public float getScanProgress() {
        return (float)this.scanTick / 120.0f;
    }

    private void doScan(EntityPlayer ep) {
        this.scanTick = 0;
        this.scanSustain = 0;
        this.scanCooldown = 240;
        this.progressDelay = 50;
        this.progressPlayer = ep;
        ProgressStage.TOWER.stepPlayerTo(ep);
        this.scannedPlayers.add(ep.func_110124_au().toString());
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.DATASCAN.ordinal(), (TileEntity)this, (int)128, (int[])new int[0]);
        ItemStack is = ChromaItems.DATACRYSTAL.getStackOf();
        is.field_77990_d = new NBTTagCompound();
        is.field_77990_d.func_74778_a("owner", ep.func_110124_au().toString());
        EntityItem ei = ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)(this.field_145848_d + 5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is, (double)3.0);
        ei.field_70181_x = Math.max(ei.field_70181_x, 0.75);
        ei.field_70133_I = true;
        this.scannedPlayers.add(ep.func_110124_au().toString());
        this.syncAllData(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void doScanFX(World world, int x, int y, int z) {
        EntityCCFloatingSeedsFX fx;
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.BOUNCE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.0f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.BOUNCE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.0f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.MONUMENTRAY, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)0.8f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.MONUMENTRAY, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.6f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.KILLAURA, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)2.0f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.KILLAURA, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.0f, (boolean)false);
        for (double a = 0.0; a < 360.0; a += 1.0) {
            fx = new EntityCCFloatingSeedsFX(world, (double)x + 0.5, (double)y + 4.5, (double)z + 0.5, a, 0.0);
            fx.setColor(10543359).setLife(120).setRapidExpand();
            fx.particleVelocity *= 2.0;
            fx.freedom *= 2.0;
            fx.angleVelocity *= 2.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (double i = 0.0; i <= 64.0; i += 0.25) {
            fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 4.5 + i, (double)z + 0.5).setColor(10543359).setLife(120).setRapidExpand().setAlphaFading().setScale(4.0f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 4.5 + i, (double)z + 0.5).setColor(0xFFFFFF).setLife(120).setAlphaFading().setScale(1.5f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.75 + 1.375 + 1.125 + 2.0), (double)((double)this.field_145849_e + 0.5)).func_72314_b(6.0, 6.0, 6.0);
    }

    public double func_145833_n() {
        return super.func_145833_n() * 16.0;
    }

    @Override
    public float getOperationFraction() {
        return this.getScanProgress();
    }

    @Override
    public OperationInterval.OperationState getState() {
        return !this.canBeAccessed() || this.scanCooldown > 0 ? OperationInterval.OperationState.INVALID : (this.scanTick > 0 ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.scanCooldown = NBT.func_74762_e("cooldown");
        ReikaNBTHelper.readCollectionFromNBT(this.scannedPlayers, (NBTTagCompound)NBT, (String)"players");
        if (NBT.func_74764_b("tower")) {
            this.tower = Towers.towerList[NBT.func_74762_e("tower")];
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("cooldown", this.scanCooldown);
        ReikaNBTHelper.writeCollectionToNBT(this.scannedPlayers, (NBTTagCompound)NBT, (String)"players");
        if (this.tower != null) {
            NBT.func_74768_a("tower", this.tower.ordinal());
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagList li = new NBTTagList();
        for (Coordinate c : this.metaAlloyPlants.getLocations()) {
            li.func_74742_a((NBTBase)c.writeToTag());
        }
        NBT.func_74782_a("plants", (NBTBase)li);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.metaAlloyPlants.clear();
        NBTTagList li = NBT.func_150295_c("plants", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound b = (NBTTagCompound)o;
            Coordinate c = Coordinate.readTag((NBTTagCompound)b);
            this.metaAlloyPlants.add(c);
        }
    }

    public boolean hasBeenScanned(EntityPlayer ep) {
        return this.scannedPlayers.contains(ep.func_110124_au().toString());
    }

    public void setTower(Towers tower) {
        this.tower = tower;
    }

    public Towers getTower() {
        return this.tower;
    }

    public boolean hasWork() {
        return false;
    }

    public static void removeMetaAlloy(World world, int x, int y, int z) {
        LoreManager.instance.initTowers(world);
        Coordinate c = new Coordinate(x, y, z);
        for (int i = 0; i < Towers.towerList.length; ++i) {
            TileEntity te;
            Towers t = Towers.towerList[i];
            Coordinate loc = t.getGeneratedLocation();
            if (loc == null || !((te = loc.getTileEntity((IBlockAccess)world)) instanceof TileEntityDataNode) || !((TileEntityDataNode)te).metaAlloyPlants.remove(c)) continue;
            ((TileEntityDataNode)te).syncAllData(true);
            if (!ModList.FORESTRY.isLoaded()) continue;
            BlockMetaAlloyLamp.doBeeDrops(world, x, y, z);
        }
    }
}

