/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Magic.Progression.ProgressionLinking;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Event.ScheduledTickEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityProgressionLinker
extends TileEntityChromaticBase
implements OwnedTile,
MultiBlockChromaTile {
    private boolean hasStructure;
    private int linkProgress;
    private UUID targetPlayer;
    private int failTicks = 0;
    public ProgressionLinking.LinkFailure failure;
    public static final int DURATION = 600;
    private static final int FAIL_FADE = 300;

    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.validateStructure();
    }

    @Override
    public void validateStructure() {
        ChromaStructures.PROGRESSLINK.getStructure().resetToDefaults();
        this.hasStructure = ChromaStructures.PROGRESSLINK.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.PROGRESSLINK;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.failTicks > 0) {
            --this.failTicks;
        }
        if (this.failTicks <= 0) {
            this.failure = null;
        }
        if (this.failTicks > 0) {
            return;
        }
        if (this.hasStructure() && this.hasPlayer()) {
            EntityPlayer ep = world.func_152378_a(this.targetPlayer);
            if (ep == null || !ep.field_70121_D.func_72326_a(ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72321_a(0.0, 4.0, 0.0))) {
                this.linkProgress = 0;
                this.targetPlayer = null;
            } else {
                if (this.linkProgress % 20 == 0) {
                    ChromaSounds.LOREHEX.playSoundAtBlock((TileEntity)this, 1.0f, 0.5f);
                }
                --this.linkProgress;
                if (this.linkProgress == 0 && !world.field_72995_K) {
                    this.linkPlayers(this.getPlacer(), ep);
                    this.targetPlayer = null;
                } else {
                    double dy = 0.1875 * Math.sin((double)System.currentTimeMillis() / 400.0);
                    ep.field_70165_t = (double)x + 0.5;
                    ep.field_70161_v = (double)z + 0.5;
                    ep.field_70163_u = (double)y + 0.625 + 1.62 + dy;
                    ep.field_70122_E = false;
                    ep.field_70179_y = 0.0;
                    ep.field_70181_x = 0.0;
                    ep.field_70159_w = 0.0;
                    ep.field_70143_R = 0.0f;
                    ep.field_70160_al = true;
                    ep.field_70754_ba = 0.0f;
                    ep.field_70721_aZ = 0.0f;
                }
            }
        }
    }

    private void linkPlayers(EntityPlayer ep, EntityPlayer target) {
        ProgressionLinking.LinkFailure lf = ProgressionLinking.instance.linkProgression(ep, target);
        if (lf == null) {
            for (int i = 0; i <= 100; i += 5) {
                ScheduledTickEvent.ScheduledSoundEvent evt = new ScheduledTickEvent.ScheduledSoundEvent((SoundEnum)ChromaSounds.LOREHEX, (Entity)ep, 1.0f, 2.0f);
                TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)evt), 1 + i);
            }
        } else {
            ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
            this.failTicks = 300;
            NBTTagCompound tag = lf.writeToNBT();
            new Coordinate((TileEntity)this).writeToNBT("loc", tag);
            ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.LINKFAIL.ordinal(), (NBTTagCompound)tag, (PacketTarget)new PacketTarget.RadiusTarget((TileEntity)this, 64.0));
        }
    }

    public boolean trigger(EntityPlayer ep) {
        if (this.failTicks > 0) {
            return false;
        }
        if (this.hasStructure() && this.isOwnedByPlayer(ep) && !this.hasPlayer()) {
            this.targetPlayer = this.findPlayer();
            if (this.targetPlayer != null) {
                this.linkProgress = 600;
                ChromaSounds.USE.playSoundAtBlock((TileEntity)this);
                return true;
            }
        }
        ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
        return false;
    }

    private UUID findPlayer() {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72317_d(0.0, 0.5, 0.0);
        List li = this.field_145850_b.func_72872_a(EntityPlayer.class, box);
        for (EntityPlayer ep : li) {
            if (this.isOwnedByPlayer(ep) && (!DragonAPICore.isReikasComputer() || !ReikaObfuscationHelper.isDeObfEnvironment())) continue;
            return ep.func_110124_au();
        }
        return null;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean hasPlayer() {
        return this.linkProgress > 0 && this.targetPlayer != null;
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
        this.failTicks = NBT.func_74762_e("fail");
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
        NBT.func_74768_a("fail", this.failTicks);
    }

    public boolean hasStructure() {
        return this.hasStructure;
    }

    public float getFailFade() {
        return (float)this.failTicks / 300.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void showFailure(ProgressionLinking.LinkFailure f) {
        this.failTicks = 300;
        this.failure = f;
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        return ChromaStructures.PROGRESSLINK;
    }

    @Override
    public Coordinate getStructureOffset() {
        return null;
    }

    @Override
    public boolean canStructureBeInspected() {
        return true;
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
    }
}

