/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAreaDistributor;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.Transport.TileEntityRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityFluidFX;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Instantiable.ParticleController.SplineMotionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Interfaces.TileEntity.NonIFluidTank;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidDistributor
extends TileEntityAreaDistributor
implements IFluidHandler {
    private static final HashSet<Class> blacklist = new HashSet();
    private PluralMap<Spline> splines = new PluralMap(2);
    private final TimerMap<ParticleChannel> particleDuration = new TimerMap();

    public int fill(ForgeDirection from, FluidStack fs, boolean doFill) {
        if (this.hasRedstoneSignal()) {
            return 0;
        }
        this.addInput(new WorldLocation((TileEntity)this).move(from, 1));
        return this.tryDistributeFluid(this.field_145850_b, fs, doFill);
    }

    private int tryDistributeFluid(World world, FluidStack fs, boolean doFill) {
        int add = 0;
        Iterator<WorldLocation> it = this.getTargets();
        while (it.hasNext()) {
            int give;
            WorldLocation loc = it.next();
            TileEntity te = loc.getTileEntity((IBlockAccess)world);
            if (te instanceof IFluidHandler) {
                give = this.tryGiveFluid(fs, doFill, (IFluidHandler)te);
                if (give <= 0) continue;
                if (!this.field_145850_b.field_72995_K) {
                    this.sendFluid(new FluidStack(fs.getFluid(), give), loc);
                }
                fs.amount -= give;
                add += give;
                if (fs.amount > 0) continue;
                return add;
            }
            if (te instanceof NonIFluidTank) {
                give = this.tryGiveFluid(fs, doFill, (NonIFluidTank)te);
                if (give <= 0) continue;
                if (!this.field_145850_b.field_72995_K) {
                    this.sendFluid(new FluidStack(fs.getFluid(), give), loc);
                }
                fs.amount -= give;
                add += give;
                if (fs.amount > 0) continue;
                return add;
            }
            it.remove();
        }
        return add;
    }

    private int tryGiveFluid(FluidStack fs, boolean doFill, IFluidHandler ie) {
        int add = 0;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int give = ie.fill(dir, fs, doFill);
            if (give <= 0) continue;
            fs.amount -= give;
            add += give;
            if (fs.amount > 0) continue;
            return add;
        }
        return add;
    }

    private int tryGiveFluid(FluidStack fs, boolean doFill, NonIFluidTank ie) {
        int add = 0;
        int give = ie.addFluid(fs.getFluid(), fs.amount, doFill);
        if (give > 0) {
            fs.amount -= give;
            add += give;
            if (fs.amount <= 0) {
                return add;
            }
        }
        return add;
    }

    private void sendFluid(FluidStack fs, WorldLocation loc) {
        int x = loc.xCoord;
        int y = loc.yCoord;
        int z = loc.zCoord;
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FLUIDSEND.ordinal(), (TileEntity)this, (int)48, (int[])new int[]{x, y, z, fs.getFluidID(), fs.amount});
    }

    @SideOnly(value=Side.CLIENT)
    public void sendFluidToClient(int x, int y, int z, Fluid f, int amt) {
        WorldLocation loc = new WorldLocation(this.field_145850_b, x, y, z);
        this.particleDuration.put((Object)new ParticleChannel(loc, f, amt), 20);
    }

    @SideOnly(value=Side.CLIENT)
    private void sendFluidToClient(WorldLocation loc, Fluid f, int amt) {
        Spline spl = this.getOrCreateSpline(f, loc);
        spl.update();
        if (rand.nextInt(3) > 0) {
            return;
        }
        int l = 90;
        double r = 0.3125;
        double dr = 0.0625;
        FluidStack fs = new FluidStack(f, amt);
        double px = (double)this.field_145851_c + 0.5;
        double py = (double)this.field_145848_d + 0.5;
        double pz = (double)this.field_145849_e + 0.5;
        float s = (float)(0.5 + ReikaMathLibrary.logbase((long)amt, (int)10) / 4.0);
        SplineMotionController p = new SplineMotionController(l, spl);
        double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(loc.xCoord - this.field_145851_c), (double)(loc.yCoord - this.field_145848_d), (double)(loc.zCoord - this.field_145849_e));
        double theta = -angs[1] + 60.0 * Math.sin((double)this.getTicksExisted() / 64.0);
        double phi = -angs[2] + 90.0 + 60.0 * Math.cos((double)this.getTicksExisted() / 32.0);
        double[] vel = ReikaPhysicsHelper.polarToCartesian((double)0.125, (double)theta, (double)phi);
        EntityFluidFX fx = new EntityFluidFX(this.field_145850_b, px, py, pz, vel[0], vel[1], vel[2], f).setLife(l).setScale(s).setPositionController((PositionController)p);
        fx.field_70145_X = true;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private Spline getOrCreateSpline(Fluid f, WorldLocation loc) {
        Spline s = (Spline)this.splines.get(new Object[]{loc, f});
        if (s == null) {
            s = new Spline(Spline.SplineType.CHORDAL);
            this.splines.put((Object)s, new Object[]{loc, f});
            DecimalPosition pos1 = new DecimalPosition((TileEntity)this);
            DecimalPosition pos2 = new DecimalPosition(loc).offset(0.0, 1.0, 0.0);
            for (double d = 0.0; d <= 1.0; d += 0.125) {
                Spline.BasicVariablePoint p = new Spline.BasicVariablePoint(DecimalPosition.interpolate((DecimalPosition)pos1, (DecimalPosition)pos2, (double)d), 0.5, 0.0078125);
                p.tolerance *= 0.03125;
                s.addPoint((Spline.SplineAnchor)p);
            }
            Spline.BasicVariablePoint p = new Spline.BasicVariablePoint(new DecimalPosition(loc), 0.5, 0.0078125);
            p.tolerance *= 0.03125;
            s.addPoint((Spline.SplineAnchor)p);
        }
        return s;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FLUIDDISTRIBUTOR;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z);
            this.particleDuration.tick();
            for (ParticleChannel pc : this.particleDuration.keySet()) {
                this.sendFluidToClient(pc.location, pc.fluid, pc.amount);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        if (rand.nextInt(3) == 0) {
            double px = (double)x + rand.nextDouble();
            double py = (double)y + rand.nextDouble();
            double pz = (double)z + rand.nextDouble();
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625) / 2.0;
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            int l = 20 + rand.nextInt(60);
            float s = 1.5f;
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz, vx, vy, vz).setIcon(ChromaIcons.BLURFLARE).setColor(0x2255FF).setLife(l).setScale(s).setRapidExpand().bound(box, true, false);
            EntityBlurFX fx2 = new EntityCCBlurFX(world, px, py, pz, vx, vy, vz).setColor(0xFFFFFF).setLife(l).setScale(s / 2.5f).setRapidExpand().bound(box, true, false);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    @Override
    protected boolean isValidTarget(TileEntity te) {
        if (te == this) {
            return false;
        }
        if (te == null) {
            return false;
        }
        if (te instanceof TileEntityRift) {
            return false;
        }
        Class<?> c = te.getClass();
        if (blacklist.contains(c)) {
            return false;
        }
        if (te.field_145848_d >= this.field_145848_d) {
            return false;
        }
        if (te instanceof IFluidHandler) {
            String s = c.getName().toLowerCase(Locale.ENGLISH);
            if (s.contains("conduit") || ReikaStringParser.containsWord((String)s, (String)"duct") || s.contains("cable") || s.contains("pipe")) {
                blacklist.add(c);
                return false;
            }
            if (s.contains("tesseract") || s.contains("hypercube")) {
                blacklist.add(c);
                return false;
            }
            return true;
        }
        if (te instanceof NonIFluidTank) {
            NonIFluidTank nif = (NonIFluidTank)te;
            return nif.allowAutomation();
        }
        return false;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    private static class ParticleChannel {
        private final WorldLocation location;
        private final Fluid fluid;
        private final int amount;

        private ParticleChannel(WorldLocation loc, Fluid f, int amt) {
            this.location = loc;
            this.fluid = f;
            this.amount = amt;
        }
    }
}

