/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Auxiliary.Interfaces.Linkable;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.TileEntity.SidePlacedTile;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BCPipeHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockOre;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityItemRift
extends TileEntityRelayPowered
implements SidePlacedTile,
Linkable<Coordinate> {
    private static final ElementTagCompound required = ElementTagCompound.of(CrystalElement.LIME);
    private Coordinate otherEnd;
    private ForgeDirection facing;
    private boolean isEmitting;
    private boolean isFunctioning;
    private boolean[] filterSet = ReikaArrayHelper.getTrueArray((int)ItemCategory.values().length);

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && this.isEmitting && this.hasValidConnection()) {
            TileEntityItemRift tile;
            IInventory tgt;
            ChromaTiles c;
            boolean wasFunctioning = this.isFunctioning;
            this.isFunctioning = false;
            IInventory src = this.getAttachment();
            if (src != null && (c = ChromaTiles.getTile((IBlockAccess)world, this.otherEnd.xCoord, this.otherEnd.yCoord, this.otherEnd.zCoord)) == this.getTile() && (tgt = (tile = (TileEntityItemRift)this.otherEnd.getTileEntity((IBlockAccess)world)).getAttachment()) != null) {
                ItemStack moved = TileEntityItemRift.transferItems(src, tgt, this.getFacing().getOpposite(), Math.min(tgt.func_70297_j_(), TileEntityItemRift.getMaxTransferRate(this.energy.getValue(CrystalElement.LIME))));
                if (moved != null) {
                    this.energy.subtract(CrystalElement.LIME, TileEntityItemRift.getConsumedEnergy(moved.field_77994_a));
                    ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(moved);
                    int flags = ReikaArrayHelper.booleanToBitflags((boolean[])tag.flagSet());
                    int dir = this.getFacing().getOpposite().ordinal();
                    int dd = this.otherEnd.getTaxicabDistanceTo((double)x, (double)y, (double)z);
                    ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.ITEMRIFTMOVE.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{flags, tag.getTotalEnergy(), dir, dd});
                    this.isFunctioning = true;
                }
            }
            if (this.isFunctioning != wasFunctioning) {
                this.syncAllData(false);
                if (this.hasValidConnection()) {
                    TileEntityItemRift te = (TileEntityItemRift)this.getConnection().getTileEntity((IBlockAccess)world);
                    te.isFunctioning = this.isFunctioning;
                    te.syncAllData(false);
                }
            }
        }
        if (world.field_72995_K && this.hasValidConnection() && this.isEmitting) {
            this.spawnParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doMoveParticles(int flags, int total, ForgeDirection dir, int dist) {
        int i;
        ArrayList<Integer> li = new ArrayList<Integer>();
        if (total == 0) {
            li.add(0x22AAFF);
        } else {
            boolean[] arr = ReikaArrayHelper.booleanFromBitflags((int)flags, (int)16);
            for (i = 0; i < 16; ++i) {
                if (!arr[i]) continue;
                li.add(CrystalElement.elements[i].getColor());
            }
        }
        int n = total == 0 ? 2 : total;
        for (i = 0; i < n; ++i) {
            int color = (Integer)ReikaJavaLibrary.getRandomListEntry((Random)rand, li);
            double px = (double)this.field_145851_c + 0.5 - 0.5 * (double)dir.offsetX;
            double py = (double)this.field_145848_d + 0.5 - 0.5 * (double)dir.offsetY;
            double pz = (double)this.field_145849_e + 0.5 - 0.5 * (double)dir.offsetZ;
            double r = 0.1875;
            if (dir.offsetX == 0) {
                px = ReikaRandomHelper.getRandomPlusMinus((double)px, (double)r);
            }
            if (dir.offsetY == 0) {
                py = ReikaRandomHelper.getRandomPlusMinus((double)py, (double)r);
            }
            if (dir.offsetZ == 0) {
                pz = ReikaRandomHelper.getRandomPlusMinus((double)pz, (double)r);
            }
            double v = 0.075;
            EntityCCBlurFX fx = new EntityCCBlurFX(this.field_145850_b, px, py, pz, (double)dir.offsetX * v, (double)dir.offsetY * v, (double)dir.offsetZ * v);
            int l = dist * 18;
            fx.setIcon(ChromaIcons.FADE_CLOUD).setAlphaFading().setNoSlowdown().setColor(color).setScale(2.5f).setLife(l);
            if (this.otherEnd != null) {
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this);
                box = box.func_72321_a((double)(this.otherEnd.xCoord - this.field_145851_c), (double)(this.otherEnd.yCoord - this.field_145848_d), (double)(this.otherEnd.zCoord - this.field_145849_e));
                fx.bound(box, false, true);
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private IInventory getAttachment() {
        TileEntity te = this.getAdjacentTileEntity(this.getFacing());
        return te instanceof IInventory ? (IInventory)te : null;
    }

    private static int getMaxTransferRate(int energy) {
        return Math.max(1, (int)Math.sqrt(energy / 10));
    }

    private static int getConsumedEnergy(int moved) {
        return 10 * moved * moved;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ITEMRIFT;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        ForgeDirection dir = this.getFacing().getOpposite();
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        int len = 1 + this.otherEnd.getTaxicabDistanceTo((double)x, (double)y, (double)z);
        double r = 0.25;
        int n = Math.max(1, len / 2 - 1);
        int[] c = new int[]{CrystalElement.LIME.getColor(), 0x22AAFF, CrystalElement.YELLOW.getColor()};
        for (int f = 0; f < c.length; ++f) {
            for (int i = 0; i < n; ++i) {
                double d = ((double)this.getTicksExisted() / 2.0 + (double)(i * len) * 9.0 / (double)n) % (double)(len * 9) / 9.0 - 0.5 + (double)f * 1.25;
                if (d >= (double)len - 0.5) {
                    d -= (double)len;
                }
                double ang = Math.toRadians(((double)this.getTicksExisted() * 12.0 + (double)f * 360.0 / (double)c.length) % 360.0);
                double sin = r * Math.sin(ang);
                double cos = r * Math.cos(ang);
                double px = (double)x + 0.5 + (double)dir.offsetX * d + (double)left.offsetX * cos;
                double py = (double)y + 0.5 + (double)dir.offsetY * d + sin;
                double pz = (double)z + 0.5 + (double)dir.offsetZ * d + (double)left.offsetZ * cos;
                EntityCCBlurFX fx = new EntityCCBlurFX(world, px, py, pz, 0.0, 0.0, 0.0);
                fx.setRapidExpand().setColor(c[f]);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        for (int i = 0; i <= 1; ++i) {
            double d = (double)(this.getTicksExisted() * 4 % (len * 16)) / 32.0 - 0.5 + (double)(i * 2);
            double px = (double)x + 0.5 + d * (double)dir.offsetX;
            double py = (double)y + 0.5 + d * (double)dir.offsetY;
            double pz = (double)z + 0.5 + d * (double)dir.offsetZ;
            EntityCCBlurFX fx = new EntityCCBlurFX(world, px, py, pz, 0.0, 0.0, 0.0);
            fx.setIcon(ChromaIcons.FADE_GENTLE).setScale(1.25f).setLife(15).setRapidExpand().setAlphaFading();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private static ItemStack transferItems(IInventory src, IInventory tgt, ForgeDirection move, int rate) {
        ItemStack total = null;
        int[] from = src instanceof ISidedInventory ? ((ISidedInventory)src).func_94128_d(move.ordinal()) : ReikaArrayHelper.getLinearArray((int)src.func_70302_i_());
        for (int i = 0; i < from.length; ++i) {
            ItemStack in2;
            int added;
            boolean extract;
            int slotfrom = from[i];
            ItemStack in = src.func_70301_a(slotfrom);
            if (in == null || total != null && (!ReikaItemHelper.matchStacks(total, (ItemStack)in, (boolean)true) || !ItemStack.func_77970_a(total, (ItemStack)in))) continue;
            boolean bl = extract = src instanceof ISidedInventory ? ((ISidedInventory)src).func_102008_b(slotfrom, in, move.ordinal()) : true;
            if (!extract || (added = ReikaInventoryHelper.addStackAndReturnCount((ItemStack)(in2 = ReikaItemHelper.getSizedItemStack((ItemStack)in, (int)Math.min(in.field_77994_a, rate))), (IInventory)tgt, (ForgeDirection)move.getOpposite())) <= 0) continue;
            in.field_77994_a -= added;
            if (total == null) {
                total = ReikaItemHelper.getSizedItemStack((ItemStack)in2, (int)added);
            } else {
                total.field_77994_a += added;
            }
            if (in.field_77994_a > 0) continue;
            src.func_70299_a(slotfrom, null);
            break;
        }
        return total;
    }

    public final void reset() {
        this.otherEnd = null;
    }

    public final void resetOther() {
        if (this.otherEnd == null) {
            return;
        }
        ChromaTiles m = ChromaTiles.getTile((IBlockAccess)this.field_145850_b, this.otherEnd.xCoord, this.otherEnd.yCoord, this.otherEnd.zCoord);
        if (m == this.getTile()) {
            TileEntityItemRift te = (TileEntityItemRift)this.otherEnd.getTileEntity((IBlockAccess)this.field_145850_b);
            te.reset();
        }
    }

    private final boolean canConnectTo(World world, int x, int y, int z) {
        int dx = x - this.field_145851_c;
        int dy = y - this.field_145848_d;
        int dz = z - this.field_145849_e;
        boolean[] blArray = new boolean[3];
        blArray[0] = dx != 0;
        blArray[1] = dy != 0;
        boolean bl = blArray[2] = dz != 0;
        if (!ReikaMathLibrary.nBoolsAreTrue((int)1, (boolean[])blArray)) {
            return false;
        }
        ForgeDirection dir = null;
        if (dx > 0) {
            dir = ForgeDirection.EAST;
        }
        if (dx < 0) {
            dir = ForgeDirection.WEST;
        }
        if (dy > 0) {
            dir = ForgeDirection.UP;
        }
        if (dy < 0) {
            dir = ForgeDirection.DOWN;
        }
        if (dz > 0) {
            dir = ForgeDirection.SOUTH;
        }
        if (dz < 0) {
            dir = ForgeDirection.NORTH;
        }
        if (dir == null) {
            return false;
        }
        if (!this.isValidDirection(dir)) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityItemRift) {
            if (((TileEntityItemRift)te).isEmitting == this.isEmitting) {
                return false;
            }
            for (int i = 1; i < Math.abs(dx + dy + dz); ++i) {
                int xi = this.field_145851_c + dir.offsetX * i;
                int yi = this.field_145848_d + dir.offsetY * i;
                int zi = this.field_145849_e + dir.offsetZ * i;
                if (this.isPassableBlock(world, xi, yi, zi)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isPassableBlock(World world, int x, int y, int z) {
        return PylonFinder.isBlockPassable(world, x, y, z) || ModList.BCTRANSPORT.isLoaded() && world.func_147439_a(x, y, z) == BCPipeHandler.getInstance().pipeID;
    }

    private boolean isValidDirection(ForgeDirection dir) {
        return true;
    }

    public final boolean tryConnect(World world, int x, int y, int z) {
        if (this.otherEnd != null) {
            return false;
        }
        if (!this.canConnectTo(world, x, y, z)) {
            return false;
        }
        if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e) {
            return false;
        }
        this.otherEnd = new Coordinate(x, y, z);
        return true;
    }

    public Coordinate getConnection() {
        return this.otherEnd;
    }

    public final boolean hasValidConnection() {
        if (this.otherEnd == null) {
            return false;
        }
        ChromaTiles m = ChromaTiles.getTile((IBlockAccess)this.field_145850_b, this.otherEnd.xCoord, this.otherEnd.yCoord, this.otherEnd.zCoord);
        return m == this.getTile() && this.canConnectTo(this.field_145850_b, this.otherEnd.xCoord, this.otherEnd.yCoord, this.otherEnd.zCoord);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("emit", this.isEmitting);
        NBT.func_74757_a("func", this.isFunctioning);
        if (this.otherEnd != null) {
            this.otherEnd.writeToNBT("endpoint", NBT);
        }
        NBT.func_74768_a("dir", this.getFacing().ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isEmitting = NBT.func_74767_n("emit");
        this.isFunctioning = NBT.func_74767_n("func");
        this.otherEnd = Coordinate.readFromNBT((String)"endpoint", (NBTTagCompound)NBT);
        this.facing = this.dirs[NBT.func_74762_e("dir")];
    }

    public ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.UP;
    }

    public void placeOnSide(int s) {
        this.facing = ForgeDirection.VALID_DIRECTIONS[s].getOpposite();
    }

    public void flip() {
        this.flip(true);
        ChromaSounds.BOUNCE.playSoundAtBlock((TileEntity)this);
    }

    private void flip(boolean other) {
        TileEntity te;
        this.isEmitting = !this.isEmitting;
        this.syncAllData(false);
        if (other && this.otherEnd != null && (te = this.otherEnd.getTileEntity((IBlockAccess)this.field_145850_b)) instanceof TileEntityItemRift) {
            ((TileEntityItemRift)te).flip(false);
        }
    }

    public boolean isEmitting() {
        return this.isEmitting;
    }

    public boolean isFunctioning() {
        return this.isFunctioning;
    }

    public boolean checkLocationValidity() {
        ForgeDirection dir = this.getFacing();
        int dx = this.field_145851_c + dir.offsetX;
        int dy = this.field_145848_d + dir.offsetY;
        int dz = this.field_145849_e + dir.offsetZ;
        Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
        return b instanceof BlockChest || b.isSideSolid((IBlockAccess)this.field_145850_b, dx, dy, dz, dir.getOpposite()) || ReikaBlockHelper.getBlockEdgeGap((Block)b, (World)this.field_145850_b, (int)dx, (int)dy, (int)dz, (ForgeDirection)dir.getOpposite()) <= 0.0625;
    }

    public void drop() {
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.getTile().getCraftedProduct());
        this.delete();
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return dir != this.getFacing() && dir != this.getFacing().getOpposite() && this.isAcceptingColor(e);
    }

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required;
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return e == CrystalElement.LIME;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 60000;
    }

    public void breakBlock() {
        this.resetOther();
    }

    private static enum ItemCategory {
        RAW("Raw Materials", Blocks.field_150450_ax),
        TOOLS("Tools", Items.field_151046_w),
        ARMOR("Armor", (Item)Items.field_151024_Q),
        FOOD("Food", Items.field_151034_e),
        MISC("Misc", Blocks.field_150380_bt);

        private final ItemStack displayItem;
        public final String displayName;

        private ItemCategory(String s, Item i) {
            this(s, new ItemStack(i));
        }

        private ItemCategory(String s, Block i) {
            this(s, new ItemStack(i));
        }

        private ItemCategory(String s, ItemStack i) {
            this.displayItem = i;
            this.displayName = s;
        }

        private static ItemCategory getCategory(ItemStack is) {
            Item i = is.func_77973_b();
            if (ReikaBlockHelper.isOre((ItemStack)is) || Block.func_149634_a((Item)i) instanceof BlockOre) {
                return RAW;
            }
            if (i instanceof ItemFood) {
                return FOOD;
            }
            if (i instanceof ItemArmor) {
                return ARMOR;
            }
            if (i instanceof ItemTool || i instanceof ItemPotion || i instanceof ItemNameTag || i instanceof ItemFlintAndSteel || i instanceof ItemEnchantedBook || i instanceof ItemWritableBook || i.func_77616_k(is) || i.func_77643_m_()) {
                return TOOLS;
            }
            return MISC;
        }
    }
}

