/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Base.ChromaStructureBase;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class TileEntityLaunchPad
extends TileEntityChromaticBase
implements MultiBlockChromaTile {
    public static final int CHARGE_DURATION = 20;
    private int charge;
    private boolean structure;
    private boolean enhanced;
    private boolean needsBigUpdate;
    private TimerMap<Entity> currentLaunches = new TimerMap();

    public float getChargeFraction() {
        return (float)this.charge / 20.0f;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.LAUNCHPAD;
    }

    public boolean hasStructure() {
        return this.structure;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K && this.hasStructure()) {
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)x - 0.75), (double)((double)y + 0.9375), (double)((double)z - 0.75), (double)((double)x + 1.75), (double)((double)y + 2.5), (double)((double)z + 1.75));
            List li = world.func_72872_a(Entity.class, box);
            for (Entity e : li) {
                e.field_70143_R = 0.0f;
            }
            this.currentLaunches.tick();
            for (Entity e : this.currentLaunches.keySet()) {
                this.flingEntity(e, false);
            }
            boolean flag = this.charge > 0;
            box = AxisAlignedBB.func_72330_a((double)(x - 1), (double)((double)y + 0.9375), (double)(z - 1), (double)(x + 2), (double)((double)y + 1.0625), (double)(z + 2));
            li = world.func_72872_a(Entity.class, box);
            Iterator it = li.iterator();
            while (it.hasNext()) {
                Entity e = (Entity)it.next();
                if (!(e instanceof EntityItem) && !(e instanceof EntityXPOrb)) continue;
                it.remove();
            }
            if (li.size() == 1 && ((Entity)li.get(0)).func_70093_af()) {
                li.clear();
            }
            if (!li.isEmpty()) {
                if (this.charge == 20) {
                    for (Entity e : li) {
                        this.flingEntity(e, true);
                    }
                    this.needsBigUpdate = true;
                    ChromaSounds.KILLAURA.playSoundAtBlockNoAttenuation((TileEntity)this, 1.0f, 0.5f, 90);
                    ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.LAUNCHFIRE.ordinal(), (TileEntity)this, (int)90, (int[])new int[0]);
                } else {
                    ++this.charge;
                    ChromaSounds.KILLAURA_CHARGE.playSoundAtBlock((TileEntity)this, 1.0f, 0.5f + this.getChargeFraction() * 0.5f);
                }
            } else if (this.charge > 0) {
                this.charge = Math.max(0, this.charge - 2);
                if (this.charge == 0) {
                    this.needsBigUpdate = true;
                    this.scheduleBlockUpdate(2);
                }
            }
            if (flag || this.charge > 0) {
                this.syncAllData(false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doFX(World world, int x, int y, int z) {
        for (int i = 0; i < 90; ++i) {
            double dx = ReikaRandomHelper.getRandomBetween((double)((double)x - 1.0), (double)(x + 2));
            double dz = ReikaRandomHelper.getRandomBetween((double)((double)z - 1.0), (double)(z + 2));
            double dy = (double)y + 1.0625;
            double v = ReikaRandomHelper.getRandomBetween((double)2.0, (double)5.0);
            EntityCCBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz, 0.0, v, 0.0);
            int l = ReikaRandomHelper.getRandomBetween((int)10, (int)60);
            float s = (float)ReikaRandomHelper.getRandomBetween((double)0.5, (double)1.2);
            EntityCCBlurFX fx2 = new EntityCCBlurFX(world, dx, dy, dz, 0.0, v, 0.0);
            fx.setIcon(ChromaIcons.CENTER).setColliding().setLife(l).setScale(s).setColor(65280).setAlphaFading().setRapidExpand();
            fx2.setIcon(ChromaIcons.CENTER).setLife(l).setScale(s * 0.4f).setColor(0xFFFFFF).setAlphaFading().setRapidExpand().setColliding().lockTo((EntityFX)fx2);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    private void flingEntity(Entity e, boolean cache) {
        float v = this.getSpeedFactor();
        if (e instanceof EntityPlayer) {
            e.field_70181_x = Math.max(e.field_70181_x, (3.5 + rand.nextDouble() * 0.5) * (double)v);
            e.field_70133_I = true;
        } else {
            e.field_70181_x = 1.8 * (double)v;
            e.field_70133_I = true;
        }
        e.field_70143_R = -100.0f;
        if (cache && this.isEnhanced()) {
            this.currentLaunches.put((Object)e, ReikaRandomHelper.getRandomBetween((int)12, (int)18));
        }
    }

    private float getSpeedFactor() {
        float base = this.isEnhanced() ? 2.5f : 1.0f;
        return base * Math.max(0.25f, ChromaOptions.LAUNCHPOWER.getFloat());
    }

    public boolean isEnhanced() {
        return this.enhanced;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.checkForStructure(world, x, y, z);
    }

    private void checkForStructure(World world, int x, int y, int z) {
        ChromaStructureBase struct = ChromaStructures.LAUNCHPAD.getStructure();
        struct.resetToDefaults();
        this.enhanced = false;
        this.structure = struct.getArray(world, x, y, z).matchInWorld();
        if (this.structure) {
            this.enhanced = this.checkForEnhanced(world, x, y, z);
        }
    }

    private boolean checkForEnhanced(World world, int x, int y, int z) {
        for (int i = -2; i <= 2; ++i) {
            for (int k = -2; k <= 2; ++k) {
                Fluid f;
                int dx = x + i;
                int dz = z + k;
                if (Math.abs(i) != 2 && Math.abs(k) != 2) continue;
                Block b = world.func_147439_a(dx, y, dz);
                Fluid fluid = f = world.func_72805_g(dx, y, dz) == 0 ? ReikaFluidHelper.lookupFluidForBlock((Block)b) : null;
                if (f != null && f.getName().equals("ender")) continue;
                return false;
            }
        }
        return true;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.structure);
        NBT.func_74757_a("enhanced", this.enhanced);
        NBT.func_74768_a("charge", this.charge);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.structure = NBT.func_74767_n("struct");
        this.enhanced = NBT.func_74767_n("enhanced");
        this.charge = NBT.func_74762_e("charge");
    }

    public int getUpdatePacketRadius() {
        return this.needsBigUpdate ? 128 : 32;
    }

    protected void onSync() {
        this.needsBigUpdate = false;
    }

    @Override
    public void validateStructure() {
        this.checkForStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        return ChromaStructures.LAUNCHPAD;
    }

    @Override
    public Coordinate getStructureOffset() {
        return null;
    }

    @Override
    public boolean canStructureBeInspected() {
        return false;
    }
}

