/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedCrystalTransmitter;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.SourceValidityRule;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityNetworkItemTransporter
extends InventoriedCrystalTransmitter
implements CrystalSource,
CrystalReceiver,
NBTTile,
BreakAction {
    private static final int EXCLUSION_RANGE = 64;
    private Request[] requestFilters = new Request[12];
    private Request currentRequest;
    private Request lastRequest;
    private int lastItemInput = 3000;
    private HashSet<Coordinate> nearby = new HashSet();
    private HashSet<KeyedItemStack> requestKeys = new HashSet();
    private boolean isBlocked;
    private EntityItem entity;
    @SideOnly(value=Side.CLIENT)
    public double itemRotation;
    @SideOnly(value=Side.CLIENT)
    public double itemOffset;

    public TileEntityNetworkItemTransporter() {
        for (int i = 0; i < this.requestFilters.length; ++i) {
            this.requestFilters[i] = new Request(i);
        }
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K) {
            for (int i = 0; i < this.requestFilters.length; ++i) {
                this.requestFilters[i].tick();
            }
            ++this.lastItemInput;
            this.isBlocked = this.isBlocked(world);
            if (!this.isBlocked && (this.currentRequest == null && this.lastItemInput >= 200 || this.currentRequest != null && this.currentRequest.ticksSinceReceived > 5 && this.currentRequest.currentAmount > 0)) {
                Request req;
                Request request = req = this.currentRequest != null ? this.currentRequest : this.getNextSlotToRequest();
                if (req != null) {
                    boolean success = this.tryFindItem(world, x, y, z, req);
                    req.cooldown = success ? 0 : 200;
                }
                if (this.currentRequest != this.lastRequest) {
                    if (this.currentRequest == null) {
                        CrystalNetworker.instance.breakPaths(this);
                    }
                    this.syncAllData(true);
                }
            }
            this.lastRequest = this.currentRequest;
            if (this.getTicksExisted() % 200 == 0) {
                this.syncAllData(true);
            }
        } else {
            if (this.currentRequest != this.lastRequest) {
                this.entity = this.currentRequest != null ? new InertItem(world, ReikaItemHelper.getSizedItemStack((ItemStack)this.currentRequest.item, (int)1)) : null;
            }
            this.lastRequest = this.currentRequest;
            this.doFX(world, x, y, z);
            this.itemOffset = Math.pow(Math.max(0.0, 1.0 + Math.sin((double)this.getTicksExisted() * 0.1)), 4.0) * 0.03125;
            this.itemRotation += 9.0 * Math.max(0.0, (0.625 - this.itemOffset) / 0.5);
        }
    }

    private boolean isBlocked(World world) {
        for (Coordinate c : this.nearby) {
            TileEntityNetworkItemTransporter net;
            TileEntity te = c.getTileEntity((IBlockAccess)world);
            if (!(te instanceof TileEntityNetworkItemTransporter) || !this.sharesItemRequest(net = (TileEntityNetworkItemTransporter)te)) continue;
            return true;
        }
        return false;
    }

    private boolean sharesItemRequest(TileEntityNetworkItemTransporter net) {
        if (this.requestKeys.isEmpty() || net.requestKeys.isEmpty()) {
            return false;
        }
        for (KeyedItemStack ks : net.requestKeys) {
            if (!this.requestKeys.contains(ks)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.buildFilterSet();
        if (!world.field_72995_K) {
            Coordinate here = new Coordinate((TileEntity)this);
            Collection<TileEntityNetworkItemTransporter> c = CrystalNetworker.instance.getNearTilesOfType(this, TileEntityNetworkItemTransporter.class, 64);
            for (TileEntityNetworkItemTransporter te : c) {
                if (te == this) continue;
                this.nearby.add(new Coordinate((TileEntity)te));
                te.nearby.add(here);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doFX(World world, int x, int y, int z) {
        double a = this.getTicksExisted() * 12 % 360;
        double r = 0.125;
        double dh = (double)(this.getTicksExisted() % 20) / 100.0;
        ArrayList<CrystalElement> e = this.currentRequest != null ? new ArrayList<CrystalElement>(TileEntityNetworkItemTransporter.getRequiredColorsForItem(this.currentRequest.item)) : null;
        for (int i = 0; i < 3; ++i) {
            double h0 = (double)i * 0.125;
            double h = h0 + dh;
            double ang = Math.toRadians(a - (double)(i * 180));
            double px = (double)x + 0.5 + r * Math.cos(ang);
            double py = (double)y + 0.25 + h0;
            double pz = (double)z + 0.5 + r * Math.sin(ang);
            EntityCCBlurFX fx = new EntityCCBlurFX(world, px, py, pz);
            int c = e == null || e.isEmpty() ? 0x22AAFF : e.get(i % e.size()).getColor();
            fx.setScale(0.6f).setColor(c).setLife(30).setAlphaFading();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        if (this.isBlocked) {
            double px = rand.nextBoolean() ? 0.3125 : 0.6875;
            double pz = rand.nextBoolean() ? 0.3125 : 0.6875;
            double py = 0.875;
            EntityCCBlurFX fx = new EntityCCBlurFX(world, (double)x + px, (double)y + py, (double)z + pz);
            float s = (float)ReikaRandomHelper.getRandomBetween((double)0.8, (double)1.2);
            float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.0625));
            int l = ReikaRandomHelper.getRandomBetween((int)90, (int)150);
            fx.setIcon(ChromaIcons.FADE_CLOUD).setScale(s).setColor(0xFF0000).setLife(l).setGravity(g).setRapidExpand().setAlphaFading();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private Request getNextSlotToRequest() {
        for (int i = 0; i < this.requestFilters.length; ++i) {
            Request r = this.requestFilters[i];
            if (r.item == null || r.cooldown != 0 || this.inv[r.inventorySlot] != null && this.inv[r.inventorySlot].field_77994_a >= this.requestFilters[i].requestAmount) continue;
            return r;
        }
        return null;
    }

    private boolean tryFindItem(World world, int x, int y, int z, Request slot) {
        int num = slot.requestAmount;
        if (this.inv[slot.inventorySlot] != null) {
            num -= this.inv[slot.inventorySlot].field_77994_a;
        }
        if (num > 0) {
            this.currentRequest = slot;
            slot.currentAmount = num;
            Set<CrystalElement> c = TileEntityNetworkItemTransporter.getRequiredColorsForItem(this.currentRequest.item);
            for (CrystalElement e : c) {
                if (CrystalNetworker.instance.checkConnectivity(e, this)) continue;
                this.currentRequest = null;
                return false;
            }
            int amt = this.currentRequest.currentAmount * 1000;
            for (CrystalElement e : c) {
                if (CrystalNetworker.instance.makeRequest(this, e, amt, world, this.getReceiveRange(), amt / 4, SourceValidityRule.ALWAYS)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int getSlotToSendTo(TileEntityNetworkItemTransporter requester) {
        ItemStack look;
        ItemStack itemStack = look = requester.currentRequest != null ? requester.currentRequest.item : null;
        if (look == null) {
            return -1;
        }
        for (int i = 0; i < 12; ++i) {
            if (this.inv[i] == null || !ReikaItemHelper.matchStacks((ItemStack)look, (ItemStack)this.inv[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean hasItemsToSendTo(TileEntityNetworkItemTransporter te) {
        return this.getSlotToSendTo(te) >= 0;
    }

    public static Set<CrystalElement> getRequiredColorsForItem(ItemStack is) {
        HashSet<CrystalElement> ret = new HashSet<CrystalElement>(ItemElementCalculator.instance.getValueForItem(is).elementSet());
        ret.add(CrystalElement.LIME);
        return ret;
    }

    @Override
    public int getSendRange() {
        return 32;
    }

    @Override
    public boolean needsLineOfSightToReceiver(CrystalReceiver r) {
        return true;
    }

    @Override
    public boolean canTransmitTo(CrystalReceiver r) {
        return r instanceof CrystalRepeater;
    }

    private boolean isValidReceiver(CrystalReceiver r) {
        return r instanceof TileEntityNetworkItemTransporter && this.hasItemsToSendTo((TileEntityNetworkItemTransporter)r);
    }

    @Override
    public int getPathPriority() {
        return 0;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return true;
    }

    @Override
    public int maxThroughput() {
        return 4000;
    }

    @Override
    public boolean canConduct() {
        return !this.isBlocked;
    }

    @Override
    public int getReceiveRange() {
        return 32;
    }

    @Override
    public boolean drain(CrystalElement e, int amt) {
        return true;
    }

    @Override
    public boolean canSupply(CrystalReceiver te, CrystalElement e) {
        return te instanceof TileEntityNetworkItemTransporter && this.hasItemsToSendTo((TileEntityNetworkItemTransporter)te);
    }

    @Override
    public boolean canBeSuppliedBy(CrystalSource te, CrystalElement e) {
        return this.currentRequest != null && te instanceof TileEntityNetworkItemTransporter;
    }

    @Override
    public void onUsedBy(EntityPlayer ep, CrystalElement e) {
    }

    @Override
    public boolean playerCanUse(EntityPlayer ep) {
        return true;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 100000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.NETWORKITEM;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getEnergy(CrystalElement e) {
        return 1000 * this.func_70297_j_();
    }

    @Override
    public ElementTagCompound getEnergy() {
        return new ElementTagCompound();
    }

    @Override
    public DecimalPosition getTargetRenderOffset(CrystalElement e) {
        return new DecimalPosition(0.0, 0.1875, 0.0);
    }

    @Override
    public int receiveElement(CrystalSource src, CrystalElement e, int amt) {
        ItemStack is;
        if (!(src instanceof TileEntityNetworkItemTransporter)) {
            return 0;
        }
        TileEntityNetworkItemTransporter sender = (TileEntityNetworkItemTransporter)src;
        int slot = sender.getSlotToSendTo(this);
        if (slot >= 0 && (is = sender.inv[slot]) != null) {
            int items = Math.max(1, amt / 1000);
            ItemStack is2 = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)items);
            int added = ReikaInventoryHelper.addStackAndReturnCount((ItemStack)is2.func_77946_l(), (IInventory)this, (int)this.currentRequest.inventorySlot, (int)this.currentRequest.inventorySlot);
            if (added > 0) {
                ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])sender.inv, (int)added);
                Request request = this.currentRequest;
                request.currentAmount = request.currentAmount - added;
                this.currentRequest.ticksSinceReceived = 0;
                this.lastItemInput = 0;
                if (this.currentRequest.currentAmount <= 0) {
                    this.currentRequest.cooldown = 600;
                    this.currentRequest = null;
                }
            }
            return added * 1000;
        }
        return 0;
    }

    @Override
    public boolean canReceiveFrom(CrystalTransmitter r) {
        return this.currentRequest != null && r instanceof CrystalRepeater;
    }

    @Override
    public boolean needsLineOfSightFromTransmitter(CrystalTransmitter r) {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot >= 12;
    }

    public int func_70302_i_() {
        return 24;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return i < 12;
    }

    @Override
    public double getIncomingBeamRadius() {
        return 0.125;
    }

    @Override
    public double getOutgoingBeamRadius() {
        return this.getIncomingBeamRadius();
    }

    @Override
    public double getMaximumBeamRadius() {
        return this.getOutgoingBeamRadius();
    }

    @Override
    public float getDroppedItemChargeRate(ItemStack is) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityItem getEntityItem() {
        return this.entity;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isBlocked = NBT.func_74767_n("blocked");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("blocked", this.isBlocked);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.saveFilters(NBT);
        NBT.func_74768_a("request", this.currentRequest != null ? this.currentRequest.index : -1);
        NBT.func_74768_a("lastin", this.lastItemInput);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.readFilters(NBT);
        int idx = NBT.func_74762_e("request");
        this.currentRequest = idx >= 0 ? this.requestFilters[idx] : null;
        this.lastItemInput = NBT.func_74762_e("lastin");
    }

    private void saveFilters(NBTTagCompound NBT) {
        NBTTagCompound fil = new NBTTagCompound();
        for (int i = 0; i < this.requestFilters.length; ++i) {
            Request is = this.requestFilters[i];
            NBTTagCompound tag = new NBTTagCompound();
            is.writeToNBT(tag);
            fil.func_74782_a("filter_" + i, (NBTBase)tag);
        }
        NBT.func_74782_a("filter", (NBTBase)fil);
    }

    private void readFilters(NBTTagCompound NBT) {
        NBTTagCompound fil = NBT.func_74775_l("filter");
        for (int i = 0; i < this.requestFilters.length; ++i) {
            String name = "filter_" + i;
            NBTTagCompound tag = fil.func_74775_l(name);
            this.requestFilters[i].readFromNBT(tag);
        }
        this.buildFilterSet();
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.saveFilters(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        if (is.field_77990_d == null) {
            return;
        }
        this.readFilters(is.field_77990_d);
    }

    public void setFilter(int slot, ItemStack is) {
        this.requestFilters[slot].setItem(is);
        this.buildFilterSet();
        if (!this.field_145850_b.field_72995_K) {
            this.syncAllData(true);
        }
    }

    private void buildFilterSet() {
        this.requestKeys.clear();
        for (int i = 0; i < this.requestFilters.length; ++i) {
            if (this.requestFilters[i].item == null) continue;
            this.requestKeys.add(new KeyedItemStack(this.requestFilters[i].item).setIgnoreNBT(true).setSized(false).setSimpleHash(true));
        }
    }

    public ItemStack getFilter(int slot) {
        return this.requestFilters[slot].item != null ? this.requestFilters[slot].item.func_77946_l() : null;
    }

    public void breakBlock() {
        Coordinate here = new Coordinate((TileEntity)this);
        for (Coordinate c : this.nearby) {
            TileEntity te = c.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(te instanceof TileEntityNetworkItemTransporter)) continue;
            ((TileEntityNetworkItemTransporter)te).nearby.remove(here);
        }
        this.nearby.clear();
    }

    private class Request {
        public final int index;
        public final int inventorySlot;
        private ItemStack item;
        private int cooldown;
        private int ticksSinceReceived;
        private int requestAmount;
        private int currentAmount;

        private Request(int i) {
            this.inventorySlot = i + 12;
            this.index = i;
        }

        private void tick() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            ++this.ticksSinceReceived;
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.cooldown = tag.func_74762_e("cool");
            this.requestAmount = tag.func_74762_e("req");
            this.currentAmount = tag.func_74762_e("amt");
            this.ticksSinceReceived = tag.func_74762_e("lastrec");
            if (tag.func_74764_b("item")) {
                NBTTagCompound val = tag.func_74775_l("item");
                this.item = ItemStack.func_77949_a((NBTTagCompound)val);
            } else {
                this.item = null;
            }
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("cool", this.cooldown);
            tag.func_74768_a("req", this.requestAmount);
            tag.func_74768_a("amt", this.currentAmount);
            tag.func_74768_a("lastrec", this.ticksSinceReceived);
            if (this.item != null) {
                NBTTagCompound val = new NBTTagCompound();
                this.item.func_77955_b(val);
                tag.func_74782_a("item", (NBTBase)val);
            }
        }

        private void setItem(ItemStack is) {
            this.item = is != null ? is.func_77946_l() : null;
            this.requestAmount = is != null ? Math.min(is.func_77976_d(), TileEntityNetworkItemTransporter.this.func_70297_j_()) : 0;
        }

        public String toString() {
            return this.index + "/" + this.inventorySlot + " = " + this.item + " #" + this.currentAmount + "/" + this.requestAmount + " @ " + this.cooldown + "/" + this.ticksSinceReceived;
        }
    }
}

