/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.BlockRouterNode;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Collections.InventoryCache;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.ModInteract.BasicAEInterface;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.AdjacentUpdateWatcher;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import appeng.api.AEApi;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.multiblock.IAlvearyComponent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"appeng.api.networking.security.IActionHost"})
public class TileEntityRouterHub
extends TileEntityChromaticBase
implements IActionHost,
BlockRouterNode.RouterFilter,
AdjacentUpdateWatcher {
    private final InventoryCache ingredients = new InventoryCache();
    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    private MESystemReader network;
    private Object aeGridBlock;
    private Object aeGridNode;
    private final StepTimer cacheTimer = new StepTimer(40);
    private final StepTimer operationTimer = new StepTimer(4);
    private final HashMap<Coordinate, Insertion> insertions = new HashMap();
    private final HashMap<Coordinate, Extraction> extractions = new HashMap();
    private final HashSet<Highlight> highlights = new HashSet();
    private ItemRule[] defaults = new ItemRule[9];
    private ForgeDirection facing = ForgeDirection.DOWN;

    public TileEntityRouterHub() {
        if (ModList.APPENG.isLoaded()) {
            this.aeGridBlock = new BasicAEInterface((TileEntity)this, this.getTile().getCraftedProduct());
            this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ROUTERHUB;
    }

    public void scanAndLink(World world, int x, int y, int z, int r) {
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                for (int j = -r / 2; j <= r / 2; ++j) {
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    if (world.func_147439_a(dx, dy, dz) != ChromaBlocks.ROUTERNODE.getBlockInstance()) continue;
                    BlockRouterNode.TileEntityRouterNode te = (BlockRouterNode.TileEntityRouterNode)world.func_147438_o(dx, dy, dz);
                    Coordinate c = new Coordinate((TileEntity)this);
                    if (te.getHub() != null && !te.getHub().equals((Object)c)) continue;
                    te.setHub(c);
                }
            }
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            this.cacheTimer.update();
            if (this.cacheTimer.checkCap()) {
                this.buildCache();
            }
            this.operationTimer.update();
            if (this.operationTimer.checkCap()) {
                ArrayList<Coordinate> li = new ArrayList<Coordinate>(this.extractions.keySet());
                li.addAll(this.insertions.keySet());
                int count = this.getRunnableTicks(li);
                Collections.shuffle(li);
                while (count > 0 && !li.isEmpty()) {
                    int idx = rand.nextInt(li.size());
                    Coordinate c = li.remove(idx);
                    Connection e = this.extractions.get(c);
                    if (e == null) {
                        e = this.insertions.get(c);
                    }
                    if (e == null || !e.performOperation(this)) continue;
                    this.addHighlight(c);
                    --count;
                }
            }
        }
    }

    private int getRunnableTicks(ArrayList<Coordinate> li) {
        return 1 + li.size() / 36;
    }

    public void addHighlight(Coordinate c) {
        if (this.field_145850_b.field_72995_K) {
            this.highlights.add(new Highlight(c, 5 + rand.nextInt(6)));
        } else {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.ROUTERLINK.ordinal(), (TileEntity)this, (int)48, (int[])new int[]{c.xCoord, c.yCoord, c.zCoord});
        }
    }

    public Collection<Highlight> getHighlightLocations() {
        return this.highlights;
    }

    public void removeConnection(BlockRouterNode.TileEntityRouterNode te) {
        Coordinate c = new Coordinate((TileEntity)te);
        this.insertions.remove(c);
        this.extractions.remove(c);
        this.syncAllData(true);
    }

    public void addInserter(BlockRouterNode.TileEntityRouterInsertion te) {
        Coordinate c = new Coordinate((TileEntity)te);
        this.insertions.put(c, new Insertion(c, te.getSide(), te.isBlacklist, te.getFilter()));
        this.syncAllData(true);
    }

    public void addExtractor(BlockRouterNode.TileEntityRouterExtraction te) {
        Coordinate c = new Coordinate((TileEntity)te);
        this.extractions.put(c, new Extraction(c, te.getSide(), te.isBlacklist, te.getFilter()));
        this.syncAllData(true);
    }

    private void buildCache() {
        this.ingredients.clear();
        TileEntity te = this.getAdjacentTileEntity(this.getFacing());
        if (te instanceof IInventory) {
            this.ingredients.addInventory((IInventory)te);
        }
        if (ModList.APPENG.isLoaded()) {
            Object oldNode = this.aeGridNode;
            if (this.aeGridNode == null) {
                Object object = this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
            }
            if (this.aeGridNode != null) {
                ((IGridNode)this.aeGridNode).updateState();
            }
            if (oldNode != this.aeGridNode || this.network == null) {
                this.network = this.aeGridNode == null ? null : (this.network == null ? new MESystemReader((IGridNode)this.aeGridNode, (IActionHost)this) : new MESystemReader((IGridNode)this.aeGridNode, this.network));
            }
        }
    }

    public ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.DOWN;
    }

    public void setFacing(ForgeDirection dir) {
        this.facing = dir;
        this.buildCache();
    }

    private ItemStack findItem(ItemStack is, MESystemReader.MatchMode mode, boolean simulate) {
        int has;
        if (DragonAPICore.debugtest) {
            return is.func_77946_l();
        }
        if (ModList.APPENG.isLoaded()) {
            ChromatiCraft.logger.debug((Object)("Router " + this + " requesting " + is + " from " + this.ingredients + " / " + this.network));
        } else {
            ChromatiCraft.logger.debug((Object)("Router " + this + " requesting " + is + " from " + this.ingredients));
        }
        if (ModList.APPENG.isLoaded()) {
            MESystemReader.ExtractedItemGroup rem = mode.removeItems(this.network, is, simulate, false);
            if (rem != null) {
                MESystemReader.ExtractedItem ei = rem.getBiggest();
                return ReikaItemHelper.getSizedItemStack((ItemStack)ei.getItem(), (int)((int)ei.amount));
            }
            ChromatiCraft.logger.debug((Object)(this + " failed to find " + is + " in its ME System."));
        }
        if ((has = this.ingredients.getItemCount(is)) > 0) {
            int rem = Math.min(is.field_77994_a, has);
            if (!simulate) {
                this.ingredients.removeXItems(is, rem);
            }
            return ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)rem);
        }
        return null;
    }

    private int injectItem(ItemStack is, boolean simulate) {
        int left;
        if (DragonAPICore.debugtest) {
            return 0;
        }
        is = is.func_77946_l();
        if (ModList.APPENG.isLoaded() && this.network != null) {
            left = (int)this.network.addItem(is, simulate);
            if (left == 0) {
                return 0;
            }
            is.field_77994_a = left;
        }
        left = this.ingredients.addItemsToUnderlyingInventories(is, simulate);
        return left;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.buildCache();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public IGridNode getActionableNode() {
        return (IGridNode)this.aeGridNode;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public IGridNode getGridNode(ForgeDirection dir) {
        return dir == this.getFacing() ? (IGridNode)this.aeGridNode : null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public void securityBreak() {
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).destroy();
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("facing", this.getFacing().ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.facing = this.dirs[NBT.func_74762_e("facing")];
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.defaults = new ItemRule[9];
        for (int i = 0; i < this.defaults.length; ++i) {
            this.defaults[i] = ItemRule.readFromNBT(NBT.func_74775_l("slot_" + i));
        }
        this.insertions.clear();
        this.extractions.clear();
        NBTTagList in = NBT.func_150295_c("insert", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : in.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            Insertion i = (Insertion)Connection.readFromNBT(tag);
            this.insertions.put(i.location, i);
        }
        NBTTagList out = NBT.func_150295_c("extract", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : out.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            Extraction i = (Extraction)Connection.readFromNBT(tag);
            this.extractions.put(i.location, i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        for (int i = 0; i < this.defaults.length; ++i) {
            if (this.defaults[i] == null) continue;
            NBT.func_74782_a("slot_" + i, (NBTBase)this.defaults[i].writeToNBT());
        }
        NBTTagList li = new NBTTagList();
        for (Insertion insertion : this.insertions.values()) {
            li.func_74742_a((NBTBase)insertion.writeToNBT());
        }
        NBT.func_74782_a("insert", (NBTBase)li);
        li = new NBTTagList();
        for (Extraction extraction : this.extractions.values()) {
            li.func_74742_a((NBTBase)extraction.writeToNBT());
        }
        NBT.func_74782_a("extract", (NBTBase)li);
    }

    @Override
    public void setFilterItem(int slot, ItemStack is) {
        MESystemReader.MatchMode mode = this.defaults[slot] != null ? this.defaults[slot].mode : MESystemReader.MatchMode.EXACT;
        this.defaults[slot] = is != null ? new ItemRule(is.func_77946_l(), mode) : null;
        this.syncAllData(true);
    }

    @Override
    public void setFilterMode(int slot, MESystemReader.MatchMode mode) {
        if (this.defaults[slot] == null) {
            return;
        }
        this.defaults[slot] = new ItemRule(this.defaults[slot].getItem(), mode);
        this.syncAllData(true);
    }

    @Override
    public ItemRule getFilter(int slot) {
        return this.defaults[slot];
    }

    public Collection<Coordinate> getInsertionLocations() {
        return Collections.unmodifiableCollection(this.insertions.keySet());
    }

    public Collection<Coordinate> getExtractionLocations() {
        return Collections.unmodifiableCollection(this.extractions.keySet());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    private boolean canExtractItemFrom(int slot, ItemStack in, IInventory ii, ForgeDirection side) {
        if (ModList.FORESTRY.isLoaded() && InterfaceCache.BEEHOUSE.instanceOf((Object)ii)) {
            if (ii instanceof IAlvearyComponent && ii.getClass().getName().endsWith("Sieve")) {
                return slot < 4;
            }
            IBeeHousing ibh = (IBeeHousing)ii;
            IBeeHousingInventory bhi = ibh.getBeeInventory();
            EnumBeeType type = ReikaBeeHelper.getBeeRoot().getType(in);
            if (bhi.getQueen() == null && (type == EnumBeeType.PRINCESS || type == EnumBeeType.QUEEN)) {
                return false;
            }
            if (bhi.getDrone() == null && type == EnumBeeType.DRONE) {
                return false;
            }
        }
        return !(ii instanceof ISidedInventory) || ((ISidedInventory)ii).func_102008_b(slot, in, side.ordinal());
    }

    public void onAdjacentUpdate(World world, int x, int y, int z, Block b) {
        this.buildCache();
    }

    public static class Highlight {
        public final Coordinate location;
        public final int lifespan;
        public int age;

        private Highlight(Coordinate c, int l) {
            this.location = c;
            this.lifespan = l;
        }
    }

    private static class Extraction
    extends Connection {
        private Extraction(Coordinate c, ForgeDirection dir, boolean blacklist, Collection<ItemRule> filter) {
            super(c, dir, blacklist, filter);
        }

        @Override
        protected boolean performOperation(TileEntityRouterHub te) {
            IInventory ii = this.getTarget(te.field_145850_b);
            if (ii == null) {
                return false;
            }
            boolean flag = false;
            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                int left;
                int amt;
                ItemStack in = ii.func_70301_a(i);
                if (in == null || !te.canExtractItemFrom(i, in, ii, this.direction) || this.allowsItem(in) == this.blacklist || (amt = in.field_77994_a - (left = te.injectItem(in, true))) <= 0) continue;
                ItemStack move = ReikaItemHelper.getSizedItemStack((ItemStack)in, (int)amt);
                ReikaInventoryHelper.decrStack((int)i, (IInventory)ii, (int)amt);
                te.injectItem(move, false);
                flag = true;
            }
            return flag;
        }
    }

    private static class Insertion
    extends Connection {
        private Insertion(Coordinate c, ForgeDirection dir, boolean blacklist, Collection<ItemRule> filter) {
            super(c, dir, blacklist, filter);
        }

        @Override
        protected boolean performOperation(TileEntityRouterHub te) {
            IInventory ii = this.getTarget(te.field_145850_b);
            if (ii == null) {
                return false;
            }
            boolean flag = false;
            HashSet<ItemRule> c = new HashSet<ItemRule>(this.items);
            for (int i = 0; i < te.defaults.length; ++i) {
                if (te.defaults[i] == null) continue;
                c.add(te.defaults[i]);
            }
            for (ItemRule i : c) {
                ItemStack move;
                ItemStack found = te.findItem(i.item, i.mode, true);
                if (found == null || !ReikaInventoryHelper.addToIInv((ItemStack)(move = ReikaItemHelper.getSizedItemStack((ItemStack)i.item, (int)found.field_77994_a)), (IInventory)ii)) continue;
                te.findItem(move, i.mode, false);
                flag = true;
            }
            return flag;
        }
    }

    private static abstract class Connection {
        protected final Coordinate location;
        protected final ForgeDirection direction;
        protected final HashSet<ItemRule> items = new HashSet();
        protected final boolean blacklist;

        private Connection(Coordinate c, ForgeDirection dir, boolean blacklist, Collection<ItemRule> filter) {
            this.location = c;
            this.direction = dir;
            this.blacklist = blacklist;
            this.items.addAll(filter);
        }

        public final boolean allowsItem(ItemStack is) {
            if (this.items.isEmpty()) {
                return true;
            }
            for (ItemRule item : this.items) {
                if (!item.matches(is)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean performOperation(TileEntityRouterHub var1);

        protected final IInventory getTarget(World world) {
            Coordinate c = this.location.offset(this.direction.getOpposite(), 1);
            TileEntity te = c.getTileEntity((IBlockAccess)world);
            return te instanceof IInventory ? (IInventory)te : null;
        }

        public final NBTTagCompound writeToNBT() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.location.writeToNBT("loc", NBT);
            NBT.func_74768_a("dir", this.direction.ordinal());
            NBT.func_74757_a("black", this.blacklist);
            NBTTagList li = new NBTTagList();
            for (ItemRule ir : this.items) {
                li.func_74742_a((NBTBase)ir.writeToNBT());
            }
            NBT.func_74782_a("items", (NBTBase)li);
            NBT.func_74778_a("type", this.getClass().getName());
            return NBT;
        }

        public static Connection readFromNBT(NBTTagCompound NBT) {
            String type = NBT.func_74779_i("type");
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[NBT.func_74762_e("dir")];
            Coordinate c = Coordinate.readFromNBT((String)"loc", (NBTTagCompound)NBT);
            boolean bl = NBT.func_74767_n("black");
            NBTTagList li = NBT.func_150295_c("items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            HashSet<ItemRule> set = new HashSet<ItemRule>();
            for (Object o : li.field_74747_a) {
                NBTTagCompound tag = (NBTTagCompound)o;
                ItemRule ir = ItemRule.readFromNBT(tag);
                set.add(ir);
            }
            try {
                Class<?> cl = Class.forName(type);
                Constructor<?> con = cl.getDeclaredConstructor(Coordinate.class, ForgeDirection.class, Boolean.TYPE, Collection.class);
                con.setAccessible(true);
                return (Connection)con.newInstance(c, dir, bl, set);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static final class ItemRule {
        private final ItemStack item;
        public final MESystemReader.MatchMode mode;

        public ItemRule(ItemStack is, MESystemReader.MatchMode m) {
            this.item = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)is.func_77976_d());
            this.mode = m;
        }

        public boolean matches(ItemStack is) {
            return this.mode.compare(is, this.item);
        }

        public int hashCode() {
            return this.item.func_77973_b().hashCode() ^ this.mode.ordinal();
        }

        public boolean equals(Object o) {
            if (o instanceof ItemRule) {
                ItemRule ir = (ItemRule)o;
                return ItemStack.func_77989_b((ItemStack)this.item, (ItemStack)ir.item) && this.mode == ir.mode;
            }
            return false;
        }

        public String toString() {
            return this.item + " * " + this.mode;
        }

        public ItemStack getItem() {
            return this.item.func_77946_l();
        }

        public static ItemRule readFromNBT(NBTTagCompound tag) {
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            int mode = tag.func_74762_e("mode");
            return is != null ? new ItemRule(is, MESystemReader.MatchMode.list[mode]) : null;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("mode", this.mode.ordinal());
            this.item.func_77955_b(tag);
            return tag;
        }
    }
}

