/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemUnknownArtefact;
import Reika.ChromatiCraft.Magic.Artefact.UABombingEffects;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaShaders;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityShaderFX;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerTimer;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Event.ScheduledTickEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.Orbit;
import Reika.DragonAPI.Instantiable.ParticleController.CollectingPositionController;
import Reika.DragonAPI.Instantiable.Rendering.FXCollection;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileEntityTeleportGate
extends CrystalReceiverBase
implements LocationCached,
OwnedTile,
GuiController,
ChunkLoadingTile,
MultiBlockChromaTile,
StructureRenderer.StructureRenderingParticleSpawner {
    private static final ElementTagCompound required = new ElementTagCompound();
    private static final HashSet<GateData> cache = new HashSet();
    private boolean hasStructure = true;
    public boolean publicMode = true;
    private Directionality direction = Directionality.BOTH;
    private String gateName;
    private int activationTick;
    private TileEntityTeleportGate teleportEnd;
    private final PlayerTimer cooldowns = new PlayerTimer();
    public static final int PUBLIC_COLOR = 4365055;
    public static final int PRIVATE_COLOR = 12067071;
    public static final int EXODUS_COLOR = 14690105;
    public static final int EMANCIPATION_COLOR = 16767055;
    public static final int ACTIVATION_DURATION = 100;
    private static final ArrayList<Orbit> activationOrbits = new ArrayList();
    private static final HashMap<WorldLocation, BufferedImage> imageCache = new HashMap();
    @SideOnly(value=Side.CLIENT)
    public FXCollection particles;
    private static final String LOGGER_ID = "telegate";

    public TileEntityTeleportGate() {
        if (this.getSide() == Side.CLIENT) {
            this.particles = new FXCollection();
        }
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && this.hasStructure() && this.getCooldown() == 0 && this.checkTimer.checkCap()) {
            this.checkAndRequest();
        }
        if (world.field_72995_K) {
            this.particles.update();
            if (this.hasStructure()) {
                this.doParticles(world, x, y, z);
            }
        }
        if (this.activationTick > 0) {
            if (this.hasStructure()) {
                --this.activationTick;
                this.onActivatingTick(world, x, y, z);
                if (this.activationTick == 0) {
                    this.onActivateComplete();
                }
            } else {
                this.activationTick = 0;
                ChromaSounds.POWERDOWN.playSoundAtBlock((TileEntity)this, 2.0f, 0.5f);
                ChromaSounds.POWERDOWN.playSoundAtBlock((TileEntity)this, 2.0f, 1.0f);
                ChromaSounds.POWERDOWN.playSoundAtBlock((TileEntity)this, 2.0f, 2.0f);
            }
        }
        if (this.hasStructure()) {
            this.consumeNametags(world, x, y, z);
            this.doGuiChecks(world, x, y, z);
        } else {
            this.cooldowns.clear();
        }
    }

    public void tickFX() {
        this.particles.update();
        this.doParticles(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void tryCreateSnapshot() {
        File f = new File(new File(this.getPreviewFolder(), "screenshots"), TileEntityTeleportGate.getPreviewFilename(new WorldLocation((TileEntity)this)));
        if (f.exists()) {
            return;
        }
        this.takeSnapshot();
    }

    @SideOnly(value=Side.CLIENT)
    public void takeSnapshot() {
        Minecraft mc = Minecraft.func_71410_x();
        boolean flag = mc.field_71474_y.field_74319_N;
        mc.field_71474_y.field_74319_N = true;
        TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)new TakeImage(new WorldLocation((TileEntity)this), flag)), 2);
    }

    @SideOnly(value=Side.CLIENT)
    private static File getPreviewFolder() {
        return new File(DragonAPICore.getMinecraftDirectory(), "mods/Reika/ChromatiCraft/GateShots");
    }

    @SideOnly(value=Side.CLIENT)
    public static String getTextureID(WorldLocation loc) {
        return "telegate " + loc.toString();
    }

    @SideOnly(value=Side.CLIENT)
    private static String getPreviewFilename(WorldLocation loc) {
        return loc.toString().replaceAll(" ", "_") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public static BufferedImage getPreview(WorldLocation loc) {
        BufferedImage img = imageCache.get(loc);
        if (img == null) {
            File f = new File(new File(TileEntityTeleportGate.getPreviewFolder(), "screenshots"), TileEntityTeleportGate.getPreviewFilename(loc));
            if (!f.exists()) {
                return null;
            }
            try {
                img = ImageIO.read(f);
                imageCache.put(loc, img);
            }
            catch (Exception e) {
                e.printStackTrace();
                ReikaChatHelper.write((Object)("Could not load preview image: " + e.toString()));
                return null;
            }
        }
        return img;
    }

    private void checkAndRequest() {
        for (CrystalElement e : required.elementSet()) {
            int amt = this.getRemainingSpace(e);
            if (amt <= 0) continue;
            boolean bl = this.requestEnergy(e, amt);
        }
    }

    public int getActivationTick() {
        return this.activationTick;
    }

    private void consumeNametags(World world, int x, int y, int z) {
        if (this.getTicksExisted() % 8 == 0) {
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)x - 0.75), (double)y, (double)((double)z - 0.75), (double)((double)x + 1.75), (double)((double)y + 1.5), (double)((double)z + 1.75));
            List li = world.func_72872_a(EntityItem.class, box);
            for (EntityItem ei : li) {
                ItemStack is;
                if (ei.field_70128_L || (is = ei.func_92059_d()).func_77973_b() != Items.field_151057_cb || is.field_77990_d == null) continue;
                this.setName(is.func_82833_r());
                ei.func_70106_y();
                return;
            }
        }
    }

    private void doGuiChecks(World world, int x, int y, int z) {
        this.cooldowns.tick(world);
        if (this.getTicksExisted() % 8 == 0) {
            AxisAlignedBB gui = ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72331_e(0.25, 0.0, 0.25);
            List li = world.func_72872_a(EntityPlayer.class, gui);
            for (EntityPlayer ep : li) {
                if (!ep.field_70122_E || !this.publicMode && !this.isOwnedByPlayer(ep)) continue;
                if (!this.cooldowns.containsKey(ep)) {
                    this.openGui(world, x, y, z, ep);
                }
                this.cooldowns.put(ep, 40);
            }
        }
    }

    private void openGui(World world, int x, int y, int z, EntityPlayer ep) {
        if (world.field_72995_K) {
            this.tryCreateSnapshot();
        } else {
            this.updateCache();
            ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.GATECACHE.ordinal(), (NBTTagCompound)TileEntityTeleportGate.getCacheAsNBT(), (PacketTarget)new PacketTarget.PlayerTarget((EntityPlayerMP)ep));
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, x, y, z);
        }
    }

    private static void updateCache() {
        HashSet<GateData> set = new HashSet<GateData>();
        for (GateData data : cache) {
            TileEntity te = data.location.getTileEntity();
            if (!(te instanceof TileEntityTeleportGate)) continue;
            GateData repl = new GateData((TileEntityTeleportGate)te);
            set.add(repl);
        }
        cache.clear();
        cache.addAll(set);
    }

    public static NBTTagCompound getCacheAsNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList li = new NBTTagList();
        for (GateData dat : cache) {
            li.func_74742_a((NBTBase)dat.writeToNBT());
        }
        tag.func_74782_a("data", (NBTBase)li);
        return tag;
    }

    public static void loadCacheFromNBT(NBTTagCompound NBT) {
        cache.clear();
        NBTTagList li = NBT.func_150295_c("data", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            GateData dat = GateData.readFromNBT((NBTTagCompound)o);
            cache.add(dat);
        }
    }

    public static Collection<GateData> getCache() {
        return Collections.unmodifiableCollection(cache);
    }

    private void onActivatingTick(World world, int x, int y, int z) {
        float f = (float)(0.5 + 1.5 * (double)(100 - this.activationTick) / 100.0);
        ChromaSounds.KILLAURA_CHARGE.playSoundAtBlock((TileEntity)this, 1.0f, f);
        if (world.field_72995_K) {
            this.doActivatingParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doActivatingParticles(World world, int x, int y, int z) {
        int c = this.getRenderColor();
        int i = 0;
        double f = Math.min(1.0, 0.5 + 1.0 * (double)(100 - this.activationTick) / 100.0);
        int l = (int)(7.5 * Math.pow(f, 2.0));
        double tt = (double)this.getTicksExisted() / 8.0;
        if (f < 1.0) {
            tt = rand.nextDouble() * 100000.0;
        }
        for (Orbit o : activationOrbits) {
            EntityBlurFX fx;
            DecimalPosition p;
            float s;
            double dt;
            double t;
            for (t = dt = (tt + (double)i * 10.0 + (double)(i % 2) / 2.0) * 48.0; t <= dt + 6.0; t += 0.5) {
                s = 2.75f * (float)f;
                p = o.getPosition((double)x + 0.5, (double)y + 0.5 + 1.5, (double)z + 0.5, t);
                fx = new EntityCCBlurFX(world, p.xCoord, p.yCoord, p.zCoord).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            for (t = dt; t <= dt + 6.0; t += 0.5) {
                s = 2.75f;
                p = o.getPosition((double)x + 0.5, (double)y + 0.5 + 1.5, (double)z + 0.5, -t + 200.0);
                fx = new EntityCCBlurFX(world, p.xCoord, p.yCoord, p.zCoord).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            ++i;
        }
        if (this.activationTick <= 15 && this.activationTick % 5 == 0) {
            int s = 1 + this.activationTick / 5;
            int n = s * 50;
            double r = 1 + s;
            double py = (double)y + 0.5 + (double)(4 - s);
            l = 10;
            float sc = 0.75f + (float)s / 3.0f;
            for (i = 0; i < n; ++i) {
                double ang = rand.nextDouble() * 360.0;
                double px = (double)x + 0.5 + r * Math.cos(ang);
                double pz = (double)z + 0.5 + r * Math.sin(ang);
                EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setScale(sc).setLife(l).setAlphaFading().forceIgnoreLimits();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        if (!world.field_72995_K) {
            cache.add(new GateData(this));
        }
        this.validateStructure();
        if (this.hasStructure && this.canLoadChunks()) {
            ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
        } else {
            ChunkManager.instance.unloadChunks((TileEntity)this);
        }
    }

    private boolean canLoadChunks() {
        if (this.publicMode) {
            return true;
        }
        return !this.getOwners(false).isEmpty();
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    @Override
    public void validateStructure() {
        ChromaStructures.TELEGATE.getStructure().resetToDefaults();
        boolean bl = this.hasStructure = !this.field_145850_b.field_72995_K && ChromaStructures.TELEGATE.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
        if (!this.hasStructure) {
            ChunkManager.instance.unloadChunks((TileEntity)this);
        }
    }

    private static boolean canTeleport(WorldLocation loc1, WorldLocation loc2, EntityPlayer caller) {
        TileEntity te1 = loc1.getTileEntity();
        TileEntity te2 = loc2.getTileEntity();
        ModularLogger.instance.log(LOGGER_ID, "Attempting teleport from " + loc1 + " to " + loc2 + " of " + caller.func_70005_c_());
        if (te1 instanceof TileEntityTeleportGate && te2 instanceof TileEntityTeleportGate) {
            TileEntityTeleportGate tg1 = (TileEntityTeleportGate)te1;
            TileEntityTeleportGate tg2 = (TileEntityTeleportGate)te2;
            ModularLogger.instance.log(LOGGER_ID, "Both tiles exist");
            if (tg1.hasStructure() && tg2.hasStructure()) {
                ModularLogger.instance.log(LOGGER_ID, "Both tiles have structures");
                if (tg1.direction.canSend && tg2.direction.canReceive) {
                    ModularLogger.instance.log(LOGGER_ID, "Directions permit");
                    if (tg1.canPlayerUse(caller) && tg2.canPlayerUse(caller)) {
                        ModularLogger.instance.log(LOGGER_ID, "Both tiles can be used");
                        ElementTagCompound cost = TileEntityTeleportGate.getCost(tg1, tg2);
                        ModularLogger.instance.log(LOGGER_ID, "Cost is " + cost + ", has1: " + tg1.energy.containsAtLeast(cost) + ", has2: " + tg2.energy.containsAtLeast(cost));
                        return tg1.energy.containsAtLeast(cost) || tg2.energy.containsAtLeast(cost);
                    }
                }
            }
        }
        return false;
    }

    public boolean canPlayerUse(EntityPlayer ep) {
        return this.publicMode || this.isOwnedByPlayer(ep);
    }

    public static void startTriggerTeleport(WorldLocation loc1, WorldLocation loc2, EntityPlayerMP ep) {
        if (TileEntityTeleportGate.canTeleport(loc1, loc2, (EntityPlayer)ep)) {
            TileEntityTeleportGate te2;
            TileEntityTeleportGate te1 = (TileEntityTeleportGate)loc1.getTileEntity();
            te1.teleportEnd = te2 = (TileEntityTeleportGate)loc2.getTileEntity();
            te2.teleportEnd = te1;
            te1.startActivate();
            ep.field_70125_A = 0.0f;
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.TELEPORTCONFIRM.ordinal(), (EntityPlayerMP)ep, (int[])new int[]{1});
        } else {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.TELEPORTCONFIRM.ordinal(), (EntityPlayerMP)ep, (int[])new int[]{0});
        }
    }

    private static void triggerTeleport(TileEntityTeleportGate te1, TileEntityTeleportGate te2) {
        if (!te1.field_145850_b.field_72995_K) {
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)te1).func_72314_b(1.5, 1.5, 1.5).func_72317_d(0.0, 1.0, 0.0);
            List li = te1.field_145850_b.func_72872_a(Entity.class, box);
            for (Entity e : li) {
                TileEntityTeleportGate.teleportFrom(te1.field_145850_b, te1.field_145851_c, te1.field_145848_d, te1.field_145849_e, te2, e);
            }
        }
    }

    public static void teleportFrom(World world, int x, int y, int z, TileEntityTeleportGate te2, Entity e) {
        double dx = e.field_70165_t - (double)x - 0.5;
        double dy = e.field_70163_u - (double)y - 0.5;
        double dz = e.field_70161_v - (double)z - 0.5;
        if (e instanceof EntityPlayer) {
            te2.cooldowns.put((EntityPlayer)e, 80);
        }
        if (world.field_73011_w.field_76574_g != te2.field_145850_b.field_73011_w.field_76574_g) {
            ReikaEntityHelper.transferEntityToDimension((Entity)e, (int)te2.field_145850_b.field_73011_w.field_76574_g, (Teleporter)new GateTeleporter((TileEntity)te2, dx, dy, dz));
        } else if (e instanceof EntityLivingBase) {
            double dx2 = (double)te2.field_145851_c + 0.5 + dx;
            double dy2 = (double)te2.field_145848_d + 0.5 + dy;
            double dz2 = (double)te2.field_145849_e + 0.5 + dz;
            if (e instanceof EntityPlayer) {
                TileEntityTeleportGate.onTeleportPlayer((EntityPlayer)e, dx, dy, dz, te2.field_145850_b, dx2, dy2, dz2);
            } else {
                ((EntityLivingBase)e).func_70634_a(dx2, dy2, dz2);
            }
        } else {
            e.func_70012_b((double)te2.field_145851_c + 0.5, (double)te2.field_145848_d + 0.5, (double)te2.field_145849_e + 0.5, e.field_70177_z, e.field_70125_A);
            e.field_70142_S = e.field_70165_t;
            e.field_70137_T = e.field_70163_u;
            e.field_70136_U = e.field_70161_v;
        }
    }

    private static void onTeleportPlayer(EntityPlayer ep, double dx, double dy, double dz, World w2, double nx, double ny, double nz) {
        Chromabilities.MAGNET.setToPlayer(ep, false);
        boolean flag = ReikaInventoryHelper.checkForItemStack((ItemStack)ChromaItems.ARTEFACT.getStackOfMetadata(ItemUnknownArtefact.ArtefactTypes.ARTIFACT.ordinal()), (IInventory)ep.field_71071_by, (boolean)false);
        if (flag) {
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)(2.0 + rand.nextDouble() * 6.0), (double)35.0, (double)(rand.nextDouble() * 360.0));
            ep.field_70159_w = xyz[0];
            ep.field_70181_x = xyz[1] + 1.5;
            ep.field_70179_y = xyz[2];
            ep.field_70133_I = true;
            nx = ReikaRandomHelper.getRandomPlusMinus((double)nx, (double)128.0);
            nz = ReikaRandomHelper.getRandomPlusMinus((double)nz, (double)128.0);
            ny = Math.max(ny, (double)(w2.func_72825_h(MathHelper.func_76128_c((double)nx), MathHelper.func_76128_c((double)nz)) + 2));
        }
        ep.func_70634_a(nx, ny, nz);
        if (flag) {
            UABombingEffects.instance.trigger((Entity)ep);
        }
    }

    private static ElementTagCompound getCost(TileEntityTeleportGate te1, TileEntityTeleportGate te2) {
        double d = Math.sqrt(te1.getDistanceSqTo(te2.field_145851_c, te2.field_145848_d, te2.field_145849_e));
        if (te1.field_145850_b.field_73011_w.field_76574_g != te2.field_145850_b.field_73011_w.field_76574_g) {
            d = Math.pow(d, 1.25) * 1.125;
        }
        double f = MathHelper.func_151237_a((double)Math.pow(1.125, 1.0 + d / 1024.0), (double)1.0, (double)10.0);
        return required.copy().scale((float)f);
    }

    private void startActivate() {
        this.activationTick = 100;
        this.syncAllData(false);
    }

    private void onActivateComplete() {
        this.doTelegateFX();
        TileEntityTeleportGate.triggerTeleport(this, this.teleportEnd);
        if (this.teleportEnd != null) {
            this.teleportEnd.teleportEnd = null;
            this.teleportEnd = null;
        }
    }

    private void doTelegateFX() {
        if (!this.field_145850_b.field_72995_K) {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.ACTIVEGATE.ordinal(), (TileEntity)this, (int)96, (int[])new int[0]);
        }
        ChromaSounds.RIFT.playSoundAtBlock((TileEntity)this, 1.5f, 0.5f);
        ChromaSounds.RIFT.playSoundAtBlock((TileEntity)this, 1.5f, 1.0f);
        ChromaSounds.RIFT.playSoundAtBlock((TileEntity)this, 1.5f, 2.0f);
        if (this.teleportEnd != null) {
            ChromaSounds.RIFT.playSoundAtBlock((TileEntity)this.teleportEnd, 1.5f, 0.5f);
            ChromaSounds.RIFT.playSoundAtBlock((TileEntity)this.teleportEnd, 1.5f, 1.0f);
            ChromaSounds.RIFT.playSoundAtBlock((TileEntity)this.teleportEnd, 1.5f, 2.0f);
        }
        ChromaSounds.MONUMENTRAY.playSoundAtBlockNoAttenuation((TileEntity)this, 0.75f, 1.0f, 32);
        ChromaSounds.MONUMENTRAY.playSoundAtBlockNoAttenuation((TileEntity)this, 0.75f, 0.5f, 32);
    }

    @SideOnly(value=Side.CLIENT)
    public void activateClientside(World world, int x, int y, int z) {
        for (int i = 0; i < 128; ++i) {
            double a = Math.toRadians(rand.nextDouble() * 360.0);
            double r = 5.0;
            double px = (double)x + 0.5 + r * Math.cos(a);
            double pz = (double)z + 0.5 + r * Math.sin(a);
            int l = ReikaRandomHelper.getRandomBetween((int)40, (int)180);
            float s = (float)ReikaRandomHelper.getRandomBetween((double)1.5, (double)4.0);
            double py = (double)y + 0.5;
            float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.25));
            double v = -ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.625) / 3.0;
            double dx = px - (double)x - 0.5;
            double dz = pz - (double)z - 0.5;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
            double vx = dx * v / dd;
            double vz = dz * v / dd;
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz, vx, 0.0, vz).setColor(this.getRenderColor()).setRapidExpand().forceIgnoreLimits().setScale(s).setLife(l).setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        double py;
        double pz;
        double px;
        float pf = 1.0f;
        double dd = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        if (dd >= 16384.0) {
            pf = 0.125f;
        } else if (dd >= 4096.0) {
            pf = 0.25f;
        } else if (dd >= 1024.0) {
            pf = 0.5f;
        } else if (dd >= 256.0) {
            pf = 0.75f;
        }
        double dt = StructureRenderer.isRenderingTiles() ? (double)System.currentTimeMillis() / 50.0 : (double)this.getTicksExisted();
        double r = 3.25;
        int l = 30;
        int c = this.getRenderColor();
        for (double t = dt; t <= dt + 0.75; t += 0.25) {
            double ang4;
            if (!ReikaRandomHelper.doWithChance((double)pf)) continue;
            float s = 2.75f / MathHelper.func_76129_c((float)pf) * (float)(1.0 - (t - dt) / 4.0);
            double ang1 = t / 12.0;
            px = (double)x + 0.5 + r * Math.cos(ang1);
            pz = (double)z + 0.5 + r * Math.sin(ang1);
            py = (double)y + 0.5 + 1.5 + 0.5 * Math.sin(t / 32.0);
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
            if (GuiScreen.func_146271_m()) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            } else {
                this.particles.addEffect(px - (double)x, py - (double)y, pz - (double)z, ChromaIcons.FADE.getIcon(), l, s, c, true);
            }
            px = (double)x + 0.5 + r * Math.cos(-ang1);
            pz = (double)z + 0.5 + r * Math.sin(-ang1);
            fx = new EntityCCBlurFX(world, px, py += 0.375, pz).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
            if (GuiScreen.func_146271_m()) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            } else {
                this.particles.addEffect(px - (double)x, py - (double)y, pz - (double)z, ChromaIcons.FADE.getIcon(), l, s, c, true);
            }
            double ang2 = ang1 + Math.toRadians(180.0);
            py = (double)y + 0.5 + 1.5 + 0.5 * Math.sin((t + 16.0) / 32.0);
            px = (double)x + 0.5 + r * Math.cos(ang2);
            pz = (double)z + 0.5 + r * Math.sin(ang2);
            fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
            if (GuiScreen.func_146271_m()) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            } else {
                this.particles.addEffect(px - (double)x, py - (double)y, pz - (double)z, ChromaIcons.FADE.getIcon(), l, s, c, true);
            }
            px = (double)x + 0.5 + r * Math.cos(-ang2);
            pz = (double)z + 0.5 + r * Math.sin(-ang2);
            fx = new EntityCCBlurFX(world, px, py += 0.375, pz).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
            if (GuiScreen.func_146271_m()) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            } else {
                this.particles.addEffect(px - (double)x, py - (double)y, pz - (double)z, ChromaIcons.FADE.getIcon(), l, s, c, true);
            }
            for (ang4 = ang2; ang4 <= ang2 + Math.PI; ang4 += Math.PI) {
                px = (double)x + 0.5 + 0.5 * Math.sin(t / 32.0);
                py = (double)y + 0.5 + r * Math.cos(-ang4);
                pz = (double)z + 0.5 + r * Math.sin(-ang4);
                if (py >= (double)y - 0.5) {
                    fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
                    if (GuiScreen.func_146271_m()) {
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    } else {
                        this.particles.addEffect(px - (double)x, py - (double)y, pz - (double)z, ChromaIcons.FADE.getIcon(), l, s, c, true);
                    }
                }
                px = (double)x + 0.5 + 0.5 * Math.sin((t + 16.0) / 32.0);
                py = (double)y + 0.5 + r * Math.cos(ang4);
                pz = (double)z + 0.5 + r * Math.sin(ang4);
                if (!(py >= (double)y - 0.5)) continue;
                fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
                if (GuiScreen.func_146271_m()) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    continue;
                }
                this.particles.addEffect(px - (double)x, py - (double)y, pz - (double)z, ChromaIcons.FADE.getIcon(), l, s, c, true);
            }
            for (ang4 = ang2; ang4 <= ang2 + Math.PI; ang4 += Math.PI) {
                pz = (double)z + 0.5 + 0.5 * Math.sin(t / 32.0);
                py = (double)y + 0.5 + r * Math.cos(-ang4 + 1.5707963267948966);
                px = (double)x + 0.5 + r * Math.sin(-ang4 + 1.5707963267948966);
                if (py >= (double)y - 0.5) {
                    fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
                    if (GuiScreen.func_146271_m()) {
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    } else {
                        this.particles.addEffect(px - (double)x, py - (double)y, pz - (double)z, ChromaIcons.FADE.getIcon(), l, s, c, true);
                    }
                }
                pz = (double)z + 0.5 + 0.5 * Math.sin((t + 16.0) / 32.0);
                py = (double)y + 0.5 + r * Math.cos(ang4 + 1.5707963267948966);
                px = (double)x + 0.5 + r * Math.sin(ang4 + 1.5707963267948966);
                if (!(py >= (double)y - 0.5)) continue;
                fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setRapidExpand().setScale(s).setLife(l).forceIgnoreLimits();
                if (GuiScreen.func_146271_m()) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    continue;
                }
                this.particles.addEffect(px - (double)x, py - (double)y, pz - (double)z, ChromaIcons.FADE.getIcon(), l, s, c, true);
            }
        }
        float s = 2.75f / MathHelper.func_76129_c((float)pf);
        int n = 1 + (int)((float)rand.nextInt(4) * pf);
        for (int i = 0; i < n; ++i) {
            double ang3 = rand.nextDouble() * 360.0;
            r = 3.125;
            px = (double)x + 0.5 + r * Math.cos(ang3);
            pz = (double)z + 0.5 + r * Math.sin(ang3);
            py = y;
            double vy = ReikaRandomHelper.getRandomBetween((double)0.0, (double)0.0625);
            float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.015625, (double)0.125));
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz, 0.0, vy, 0.0).setColor(c).setRapidExpand().forceIgnoreLimits().setScale(s).setLife(l).setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        double ty = (double)y + 3.25;
        double px2 = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)1.75);
        double pz2 = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)1.75);
        double py2 = ReikaRandomHelper.getRandomPlusMinus((double)(ty + 1.5), (double)0.75);
        CollectingPositionController p = new CollectingPositionController(px2, py2, pz2, (double)x + 0.5, ty, (double)z + 0.5, l);
        EntityBlurFX fx = new EntityCCBlurFX(world, px2, py2, pz2).setPositionController((PositionController)p).setColor(c).setLife(l).forceIgnoreLimits();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        if (rand.nextInt(4) == 0) {
            double ang = Math.toRadians(rand.nextDouble() * 360.0);
            r = 1.4;
            px2 = (double)x + 0.5 + r * Math.cos(ang);
            pz2 = (double)z + 0.5 + r * Math.sin(ang);
            py2 = (double)y - 0.25;
            s = (float)ReikaRandomHelper.getRandomBetween((double)4.0, (double)9.0);
            l = ReikaRandomHelper.getRandomBetween((int)20, (int)40);
            l = (int)((float)l * s);
            float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.125));
            float f = (float)ReikaRandomHelper.getRandomBetween((double)0.04, (double)0.15);
            if (rand.nextInt(4) == 0) {
                f = f * 2.0f + 0.125f;
            }
            fx = new EntityShaderFX(world, px2, py2, pz2, f, ChromaShaders.LENSPARTICLE).setLife(l).setScale(s).setGravity(g).forceIgnoreLimits().setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public int getReceiveRange() {
        return 32;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    public int maxThroughput() {
        return 240;
    }

    @Override
    public boolean canConduct() {
        return this.hasStructure;
    }

    public boolean hasStructure() {
        return this.hasStructure;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 180000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.TELEPORT;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void breakBlock() {
        cache.remove(new WorldLocation((TileEntity)this));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.hasStructure() ? ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(6.0, 6.0, 6.0) : super.getRenderBoundingBox();
    }

    public double func_145833_n() {
        return super.func_145833_n() * 4.0;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
        this.publicMode = NBT.func_74767_n("public");
        this.activationTick = NBT.func_74762_e("active");
        this.direction = Directionality.list[NBT.func_74762_e("senddir")];
        this.gateName = NBT.func_74779_i("name");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
        NBT.func_74757_a("public", this.publicMode);
        NBT.func_74768_a("active", this.activationTick);
        NBT.func_74768_a("senddir", this.direction.ordinal());
        if (!Strings.isNullOrEmpty((String)this.gateName)) {
            NBT.func_74778_a("name", this.gateName);
        }
    }

    public boolean isPowered() {
        return this.energy.containsAtLeast(required);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)1);
    }

    public int getRenderColor() {
        switch (this.direction) {
            default: {
                return this.publicMode ? 4365055 : 12067071;
            }
            case SEND: {
                return 16767055;
            }
            case RECEIVE: 
        }
        return 14690105;
    }

    public void incrementDirection() {
        this.direction = this.direction.next();
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        return ChromaStructures.TELEGATE;
    }

    @Override
    public Coordinate getStructureOffset() {
        return null;
    }

    @Override
    public boolean canStructureBeInspected() {
        return true;
    }

    public void setName(String s) {
        this.gateName = s;
        this.syncAllData(true);
        this.updateCache();
    }

    private static Collection<GateData> getAllGatesMeeting(World world, EntityPlayer ep) {
        ArrayList<GateData> c = new ArrayList<GateData>();
        for (GateData g : cache) {
            if (world != null && g.location.dimensionID != world.field_73011_w.field_76574_g || ep != null && !g.publicMode && !g.isOwnedBy(ep)) continue;
            c.add(g);
        }
        return c;
    }

    public static WorldLocation getRandomGate(World world, EntityPlayer ep) {
        if (cache.isEmpty()) {
            return null;
        }
        Collection<GateData> c = TileEntityTeleportGate.getAllGatesMeeting(world, ep);
        return c.isEmpty() ? null : ((GateData)ReikaJavaLibrary.getRandomCollectionEntry((Random)TileEntityTeleportGate.rand, c)).location;
    }

    public static Collection<GateData> getAllGatesInWorld(World world) {
        return TileEntityTeleportGate.getAllGatesMeeting(world, null);
    }

    public static WorldLocation getNearestGate(World world, int x, int y, int z, EntityPlayer ep) {
        GateData ret = null;
        double dist = Double.POSITIVE_INFINITY;
        for (GateData g : cache) {
            if (g.location.dimensionID != world.field_73011_w.field_76574_g) continue;
            double dd = g.location.getDistanceTo((double)x, (double)y, (double)z);
            if (ret != null && !(dd < dist)) continue;
            dist = dd;
            ret = g;
        }
        return ret != null ? ret.location : null;
    }

    static {
        required.addValueToColor(CrystalElement.LIME, 5000);
        required.addValueToColor(CrystalElement.BLACK, 2000);
        required.addValueToColor(CrystalElement.WHITE, 1000);
        required.addValueToColor(CrystalElement.LIGHTBLUE, 1000);
        required.addValueToColor(CrystalElement.PURPLE, 500);
        ModularLogger.instance.addLogger((DragonAPIMod)ChromatiCraft.instance, LOGGER_ID);
        double r = 7.5;
        for (int i = -30; i <= 30; i += 15) {
            for (double w = 0.0; w < 360.0; w += 90.0) {
                activationOrbits.add(new Orbit(r, 0.0, (double)(i + 90), 0.0, w, w));
            }
        }
    }

    private static enum Directionality {
        BOTH(true, true),
        SEND(true, false),
        RECEIVE(false, true);

        private final boolean canSend;
        private final boolean canReceive;
        private static final Directionality[] list;

        private Directionality(boolean s, boolean r) {
            this.canSend = s;
            this.canReceive = r;
        }

        private Directionality next() {
            return list[(this.ordinal() + 1) % list.length];
        }

        static {
            list = Directionality.values();
        }
    }

    public static enum Statuses {
        OWNED(0xFF0000),
        STRUCTURE(0xFF22FF),
        POWERED(0xFFFF00),
        DIMENSION(0x22AAFF);

        public final int color;
        public final int flag;
        public static Statuses[] list;

        private Statuses(int c) {
            this.color = c;
            this.flag = 1 << this.ordinal();
        }

        public boolean check(int flags) {
            return (flags & this.flag) != 0 == (this != DIMENSION);
        }

        static {
            list = Statuses.values();
        }
    }

    public static class GateData {
        public final WorldLocation location;
        public final int statusFlags;
        private final Collection<UUID> owners = new HashSet<UUID>();
        public final boolean publicMode;
        private String name;

        private GateData(TileEntityTeleportGate te) {
            this(new WorldLocation((TileEntity)te), GateData.getFlags(te), te.owners, te.publicMode, te.gateName);
        }

        private static int getFlags(TileEntityTeleportGate te) {
            int ret = 0;
            if (te.hasStructure()) {
                ret |= Statuses.STRUCTURE.flag;
            }
            if (te.isPowered()) {
                ret |= Statuses.POWERED.flag;
            }
            return ret;
        }

        private GateData(WorldLocation loc, int flags, Collection<UUID> c, boolean pb, String name) {
            this.location = loc;
            this.statusFlags = flags;
            this.owners.addAll(c);
            this.publicMode = pb;
            this.name = name;
        }

        private static GateData readFromNBT(NBTTagCompound tag) {
            WorldLocation loc = WorldLocation.readFromNBT((String)"loc", (NBTTagCompound)tag);
            HashSet<UUID> set = new HashSet<UUID>();
            NBTTagList li = tag.func_150295_c("owners", ReikaNBTHelper.NBTTypes.STRING.ID);
            for (Object o : li.field_74747_a) {
                NBTTagString s = (NBTTagString)o;
                set.add(UUID.fromString(s.func_150285_a_()));
            }
            return new GateData(loc, tag.func_74762_e("flags"), set, tag.func_74767_n("public"), tag.func_74779_i("name"));
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            this.location.writeToNBT("loc", tag);
            tag.func_74768_a("flags", this.statusFlags);
            NBTTagList li = new NBTTagList();
            for (UUID uid : this.owners) {
                li.func_74742_a((NBTBase)new NBTTagString(uid.toString()));
            }
            tag.func_74782_a("owners", (NBTBase)li);
            tag.func_74757_a("public", this.publicMode);
            if (!Strings.isNullOrEmpty((String)this.name)) {
                tag.func_74778_a("name", this.name);
            }
            return tag;
        }

        public boolean isOwnedBy(EntityPlayer ep) {
            return this.publicMode || this.owners.contains(ep.func_110124_au());
        }

        public String toString() {
            return this.location + " [" + Integer.toBinaryString(this.statusFlags) + "]";
        }

        public String getName() {
            return this.name;
        }
    }

    private static class GateTeleporter
    extends Teleporter {
        private final WorldLocation location;
        private final double relativeX;
        private final double relativeY;
        private final double relativeZ;

        public GateTeleporter(TileEntity te, double dx, double dy, double dz) {
            super((WorldServer)te.field_145850_b);
            this.location = new WorldLocation(te);
            this.relativeX = dx;
            this.relativeY = dy;
            this.relativeZ = dz;
        }

        public void func_77185_a(Entity e, double x, double y, double z, float facing) {
            e.func_70012_b((double)this.location.xCoord + 0.5 + this.relativeX, (double)this.location.yCoord + 0.5 + this.relativeY, (double)this.location.zCoord + 0.5 + this.relativeZ, e.field_70177_z, e.field_70125_A);
            this.func_77184_b(e, x, y, z, facing);
        }

        public boolean func_77184_b(Entity entity, double x, double y, double z, float facing) {
            return true;
        }

        private void makeReturnPortal(World world, int x, int y, int z) {
        }

        public boolean func_85188_a(Entity e) {
            return false;
        }
    }

    private static class TakeImage
    implements ScheduledTickEvent.ScheduledEvent {
        private final WorldLocation loc;
        private final boolean unhideGUI;

        public TakeImage(WorldLocation loc, boolean flag) {
            this.loc = loc;
            this.unhideGUI = flag;
        }

        public void fire() {
            Minecraft mc = Minecraft.func_71410_x();
            File dir = TileEntityTeleportGate.getPreviewFolder();
            String prev = TileEntityTeleportGate.getPreviewFilename(this.loc);
            File f = new File(new File(TileEntityTeleportGate.getPreviewFolder(), "screenshots"), prev);
            if (f.exists()) {
                f.delete();
            }
            f.getParentFile().mkdirs();
            ScreenShotHelper.func_148259_a((File)dir, (String)prev, (int)mc.field_71443_c, (int)mc.field_71440_d, (Framebuffer)mc.func_147110_a());
            mc.field_71474_y.field_74319_N = this.unhideGUI;
            imageCache.remove(this.loc);
            ReikaTextureHelper.resetTexture((String)prev);
        }

        public boolean runOnSide(Side s) {
            return s == Side.CLIENT;
        }
    }
}

