/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTransportWindow
extends TileEntityChromaticBase
implements BreakAction {
    private static final HashSet<BlockKey> acceptedFrames = new HashSet();
    private BlockKey hasStructure;
    private final WindowTimer cooldowns = new WindowTimer();
    private WorldLocation target;
    private WorldLocation source;
    private boolean renderBackPane = true;
    private boolean renderTexture = true;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.WINDOW;
    }

    public void toggleBackPane() {
        this.renderBackPane = !this.renderBackPane;
        this.syncRenderWithTarget();
    }

    public void toggleTexture() {
        this.renderTexture = !this.renderTexture;
        this.syncRenderWithTarget();
    }

    public void setRenderStates(boolean back, boolean texture) {
        this.renderBackPane = back;
        this.renderTexture = texture;
        this.syncRenderWithTarget();
    }

    private void syncRenderWithTarget() {
        TileEntity te;
        if (this.source != null && (te = this.source.getTileEntity()) instanceof TileEntityTransportWindow) {
            ((TileEntityTransportWindow)te).renderBackPane = this.renderBackPane;
            ((TileEntityTransportWindow)te).renderTexture = this.renderTexture;
        }
        if (this.target != null && (te = this.target.getTileEntity()) instanceof TileEntityTransportWindow) {
            ((TileEntityTransportWindow)te).renderBackPane = this.renderBackPane;
            ((TileEntityTransportWindow)te).renderTexture = this.renderTexture;
        }
    }

    public boolean renderTexture() {
        return this.renderTexture;
    }

    public boolean canLinkTo(TileEntityTransportWindow te) {
        return this.matchRenderStates(te) && this.hasStructure != null && this.hasStructure.equals((Object)te.hasStructure);
    }

    public boolean matchRenderStates(TileEntityTransportWindow te) {
        return te.renderBackPane == this.renderBackPane && te.renderTexture == this.renderTexture;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            if (this.hasStructure != null) {
                TileEntityTransportWindow te = this.getTarget();
                if (te != null) {
                    ForgeDirection dir = this.getFacing().getOpposite();
                    AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72317_d((double)dir.offsetX, (double)dir.offsetY, (double)dir.offsetZ);
                    List li = world.func_72872_a(EntityPlayer.class, box);
                    for (EntityPlayer ep : li) {
                        if (!this.canTeleport(dir, ep)) continue;
                        this.teleport(ep, te);
                    }
                }
            } else {
                this.cooldowns.clear();
            }
            this.cooldowns.tick(world);
        } else {
            this.doParticles(world, x, y, z, meta);
        }
    }

    private void teleport(EntityPlayer ep, TileEntityTransportWindow te) {
        te.cooldowns.put(ep, 60);
        this.cooldowns.put(ep, 60);
        ReikaEntityHelper.seamlessTeleport((Entity)ep, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e, (ForgeDirection)this.getFacing().getOpposite(), (ForgeDirection)te.getFacing().getOpposite());
    }

    private TileEntityTransportWindow getTarget() {
        TileEntity te = this.target != null ? this.target.getTileEntity() : null;
        return te instanceof TileEntityTransportWindow ? (TileEntityTransportWindow)te : null;
    }

    private TileEntityTransportWindow getSource() {
        TileEntity te = this.source != null ? this.source.getTileEntity() : null;
        return te instanceof TileEntityTransportWindow ? (TileEntityTransportWindow)te : null;
    }

    public void linkTo(TileEntityTransportWindow te) {
        this.target = new WorldLocation((TileEntity)te);
        te.source = new WorldLocation((TileEntity)this);
        this.syncAllData(true);
        te.syncAllData(true);
    }

    public WorldLocation getTargetLocation() {
        return this.target;
    }

    public WorldLocation getSourceLocation() {
        return this.source;
    }

    public void breakBlock() {
        this.reset();
    }

    public void reset() {
        TileEntityTransportWindow te = this.getSource();
        if (te != null) {
            te.target = null;
            te.syncAllData(true);
        }
        if ((te = this.getTarget()) != null) {
            te.source = null;
            te.syncAllData(true);
        }
        this.target = null;
        this.syncAllData(true);
    }

    public void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.validateStructure();
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z, int meta) {
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public ForgeDirection getFacing() {
        switch (this.func_145832_p()) {
            case 0: {
                return ForgeDirection.EAST;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.NORTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public void setFacing(ForgeDirection dir) {
        switch (dir) {
            case EAST: {
                this.setBlockMetadata(0);
                break;
            }
            case WEST: {
                this.setBlockMetadata(1);
                break;
            }
            case SOUTH: {
                this.setBlockMetadata(2);
                break;
            }
            case NORTH: {
                this.setBlockMetadata(3);
                break;
            }
        }
    }

    public boolean doRender() {
        return this.hasStructure != null && this.renderBackPane;
    }

    private boolean canTeleport(ForgeDirection dir, EntityPlayer ep) {
        if (this.cooldowns.containsKey(ep)) {
            return false;
        }
        return this.canTeleportPosition(dir, ep);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canTeleportPosition(ForgeDirection dir, EntityPlayer ep) {
        double phi;
        double dx = Math.abs(ep.field_70165_t - (double)this.field_145851_c - 0.5);
        double dy = Math.abs(ep.field_70163_u + 1.62 - (double)this.field_145848_d - 0.5);
        double dz = Math.abs(ep.field_70161_v - (double)this.field_145849_e - 0.5);
        double md = 0.82;
        double mw = 0.05;
        double d = dir.offsetX == 0 ? mw : md;
        if (!(dx < d)) return false;
        if (!(dy < 0.15)) return false;
        double d2 = dir.offsetZ == 0 ? mw : md;
        if (!(dz < d2)) return false;
        boolean bl = true;
        boolean dist = bl;
        if (!dist) {
            return false;
        }
        for (phi = (double)ep.field_70759_as; phi < 0.0; phi += 360.0) {
        }
        while (phi >= 360.0) {
            phi -= 360.0;
        }
        double phit = this.getTargetPhi();
        if (ReikaMathLibrary.approxr((double)phi, (double)phit, (double)5.0)) return true;
        if (!ReikaMathLibrary.approxr((double)phi, (double)(phit + 360.0), (double)5.0)) return false;
        return true;
    }

    private double getTargetPhi() {
        switch (this.func_145832_p()) {
            case 0: {
                return 270.0;
            }
            case 1: {
                return 90.0;
            }
            case 2: {
                return 0.0;
            }
            case 3: {
                return 180.0;
            }
        }
        return 0.0;
    }

    public void validateStructure() {
        this.hasStructure = this.checkStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.syncAllData(true);
    }

    private BlockKey checkStructure(World world, int x, int y, int z) {
        BlockKey ret = null;
        for (Coordinate c : this.getFrameLocations()) {
            BlockKey bk = BlockKey.getAt((IBlockAccess)world, (int)(x + c.xCoord), (int)(y + c.yCoord), (int)(z + c.zCoord));
            if (!acceptedFrames.contains(bk)) {
                return null;
            }
            if (ret != null && !ret.equals((Object)bk)) {
                return null;
            }
            ret = bk;
        }
        return ret;
    }

    private HashSet<Coordinate> getFrameLocations() {
        HashSet<Coordinate> ret = new HashSet<Coordinate>();
        ret.add(new Coordinate(0, 1, 0));
        ret.add(new Coordinate(0, -1, 0));
        if (this.getFacing().offsetX != 0) {
            for (int i = -1; i <= 1; ++i) {
                ret.add(new Coordinate(0, i, -1));
                ret.add(new Coordinate(0, i, 1));
            }
        } else {
            for (int i = -1; i <= 1; ++i) {
                ret.add(new Coordinate(-1, i, 0));
                ret.add(new Coordinate(1, i, 0));
            }
        }
        return ret;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.hasStructure != null) {
            this.hasStructure.writeToNBT("frame", NBT);
        }
        if (this.target != null) {
            this.target.writeToNBT("tgt", NBT);
        }
        if (this.source != null) {
            this.source.writeToNBT("src", NBT);
        }
        NBT.func_74757_a("back", this.renderBackPane);
        NBT.func_74757_a("tex", this.renderTexture);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74764_b("struct") ? BlockKey.readFromNBT((String)"frame", (NBTTagCompound)NBT) : null;
        this.source = WorldLocation.readFromNBT((String)"src", (NBTTagCompound)NBT);
        this.target = WorldLocation.readFromNBT((String)"tgt", (NBTTagCompound)NBT);
        this.renderBackPane = NBT.func_74767_n("back");
        this.renderTexture = NBT.func_74767_n("tex");
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return ChromaTiles.getTileFromIDandMetadata(oldBlock, oldMeta) != ChromaTiles.getTileFromIDandMetadata(newBlock, newMeta);
    }

    static {
        acceptedFrames.add(new BlockKey(Blocks.field_150357_h));
        acceptedFrames.add(new BlockKey(Blocks.field_150343_Z));
        acceptedFrames.add(new BlockKey(ChromaBlocks.PYLONSTRUCT.getBlockInstance()));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.ordinal()));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.ordinal()));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.ordinal()));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.MOSS.ordinal()));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.MOSS.metadata));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.ordinal()));
        acceptedFrames.add(new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata));
        acceptedFrames.add(new BlockKey(ChromaBlocks.SPECIALSHIELD.getBlockInstance()));
    }

    private class WindowTimer
    extends PlayerTimer {
        private WindowTimer() {
        }

        protected boolean shouldTickPlayer(EntityPlayer ep) {
            return TileEntityTransportWindow.this.canTeleportPosition(TileEntityTransportWindow.this.getFacing(), ep);
        }
    }
}

