/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.ChromatiCraft.Block.Worldgen.BlockDecoFlower;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.DecoratorEnderForest;
import Reika.ChromatiCraft.World.EnderOakGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Math.Noise.NoiseGeneratorBase;
import Reika.DragonAPI.Instantiable.Math.Noise.Simplex3DGenerator;
import Reika.DragonAPI.Instantiable.Math.Noise.VoronoiNoiseGenerator;
import Reika.DragonAPI.Interfaces.CustomMapColorBiome;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class BiomeEnderForest
extends BiomeGenForest
implements CustomMapColorBiome {
    private static final long root = 127645902378217L;
    private final NoiseGeneratorBase extraX = new Simplex3DGenerator(127645902379290L).setFrequency(0.25);
    private final NoiseGeneratorBase extraY = new Simplex3DGenerator(-127645902386400L).setFrequency(0.25);
    private final NoiseGeneratorBase extraZ = new Simplex3DGenerator(127645907756474L).setFrequency(0.25);
    private final VoronoiNoiseGenerator colorNoise = (VoronoiNoiseGenerator)new VoronoiNoiseGenerator(127645902391424L).setFrequency(0.08333333333333333).setDisplacement(this.extraX, this.extraY, this.extraZ, 6.0);
    private final WorldGenAbstractTree enderOakLarge = new EnderOakGenerator(3, 7, 5, 12, 3, 5, 0.15f, 6, 0.15f);
    private final WorldGenAbstractTree enderOakSmall = new EnderOakGenerator(2, 4, 3, 5, 2, 3, 0.0f, 0, 0.1f);
    private final WorldGenAbstractTree enderOakNarrow = new EnderOakGenerator(6, 12, 6, 15, 1, 2, 0.35f, 4, 0.0f);
    private final WeightedRandom<TreeEntry> treeTypes = new WeightedRandom();
    private static final Random colorRand = new Random();
    private final WorldGenAbstractTree treeSelector = new WorldGenAbstractTree(false){
        private NoiseGeneratorBase treeScaling;

        public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
            long seed = (world.func_72905_C() << 17) + (world.func_72905_C() >> 43);
            if (this.treeScaling == null || this.treeScaling.seed != seed) {
                this.treeScaling = new Simplex3DGenerator(seed).setFrequency(0.03333333333333333);
            }
            BiomeEnderForest.this.treeTypes.setRNG(rand);
            double val = this.treeScaling.getValue((double)x, (double)y, (double)z);
            for (TreeEntry e : BiomeEnderForest.this.treeTypes.getValues()) {
                e.calculate(val);
            }
            WorldGenAbstractTree gen = ((TreeEntry)BiomeEnderForest.this.treeTypes.getRandomEntry()).tree;
            return gen != null && gen.func_76484_a(world, rand, x, y, z);
        }
    };

    public BiomeEnderForest(int id) {
        super(id, 0);
        this.field_76760_I.field_76832_z = (int)((double)this.field_76760_I.field_76832_z * 0.7);
        this.func_76745_m();
        this.colorNoise.randomFactor = 0.55;
        this.field_76791_y = "Ender Forest";
        this.field_76761_J.clear();
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 10, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 1, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySpider.class, 1, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 1, 1, 4));
        this.treeTypes.addDynamicEntry((WeightedRandom.DynamicWeight)new TreeEntry((WorldGenAbstractTree)this.field_76757_N, 25.0, 10.0));
        this.treeTypes.addDynamicEntry((WeightedRandom.DynamicWeight)new TreeEntry((WorldGenAbstractTree)this.field_76758_O, 5.0, -2.0));
        this.treeTypes.addDynamicEntry((WeightedRandom.DynamicWeight)new TreeEntry(this.enderOakSmall, 50.0, 20.0));
        this.treeTypes.addDynamicEntry((WeightedRandom.DynamicWeight)new TreeEntry(this.enderOakLarge, 10.0, -5.0));
        this.treeTypes.addDynamicEntry((WeightedRandom.DynamicWeight)new TreeEntry(this.enderOakNarrow, 6.0, -1.0));
        this.treeTypes.addDynamicEntry((WeightedRandom.DynamicWeight)new TreeEntry(null, 0.0, 6.0));
    }

    public boolean func_76738_d() {
        return true;
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public int func_150558_b(int x, int y, int z) {
        if (ChromaOptions.ENDERCOLORING.getState()) {
            return ReikaColorAPI.RGBtoHex((int)255, (int)200, (int)255);
        }
        return ReikaColorAPI.mixColors((int)BiomeGenBase.field_76767_f.func_150558_b(x, y, z), (int)BiomeGenBase.field_76774_n.func_150558_b(x, y, z), (float)this.getMix(x, y, z));
    }

    public int func_150571_c(int x, int y, int z) {
        if (ChromaOptions.ENDERCOLORING.getState()) {
            return ReikaColorAPI.RGBtoHex((int)255, (int)150, (int)255);
        }
        return ReikaColorAPI.mixColors((int)BiomeGenBase.field_76767_f.func_150571_c(x, y, z), (int)BiomeGenBase.field_76774_n.func_150571_c(x, y, z), (float)this.getMix(x, y, z));
    }

    public void clearColorCache() {
    }

    private float getMix(int x, int y, int z) {
        colorRand.setSeed(new Coordinate((double)(x / 6) + this.extraX.getValue((double)x, (double)z) * 8.0, (double)(y / 4) + this.extraY.getValue((double)x, (double)z) * 3.0, (double)(z / 6) + this.extraZ.getValue((double)x, (double)z) * 8.0).hashCode());
        colorRand.nextBoolean();
        colorRand.nextBoolean();
        return colorRand.nextFloat();
    }

    public int getWaterColorMultiplier() {
        if (!ChromaOptions.ENDERCOLORING.getState()) {
            return BiomeGenBase.field_76767_f.getWaterColorMultiplier();
        }
        return ReikaColorAPI.RGBtoHex((int)195, (int)0, (int)105);
    }

    public BiomeDecorator func_76729_a() {
        return new DecoratorEnderForest();
    }

    public void plantFlower(World world, Random rand, int x, int y, int z) {
        if (rand.nextInt(4) > 0) {
            switch (rand.nextInt(2)) {
                case 0: {
                    if (!BlockDecoFlower.Flowers.ENDERFLOWER.canPlantAt(world, x, y, z)) break;
                    world.func_147465_d(x, y, z, ChromaBlocks.DECOFLOWER.getBlockInstance(), BlockDecoFlower.Flowers.ENDERFLOWER.ordinal(), 3);
                    break;
                }
                case 1: {
                    if (!BlockDecoFlower.Flowers.RESOCLOVER.canPlantAt(world, x, y, z)) break;
                    world.func_147465_d(x, y, z, ChromaBlocks.DECOFLOWER.getBlockInstance(), BlockDecoFlower.Flowers.RESOCLOVER.ordinal(), 3);
                }
            }
        } else {
            super.plantFlower(world, rand, x, y, z);
        }
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return this.treeSelector;
    }

    @SideOnly(value=Side.CLIENT)
    public int getMapColor(World world, int x, int z) {
        return 13136603;
    }

    private static class TreeEntry
    implements WeightedRandom.DynamicWeight {
        private final WorldGenAbstractTree tree;
        private final double baseWeight;
        private final double weightCoefficient;
        private double weight;

        private TreeEntry(WorldGenAbstractTree t, double w, double c) {
            this.tree = t;
            this.weightCoefficient = c;
            this.baseWeight = w;
        }

        private void calculate(double noiseVal) {
            this.weight = Math.max(0.0, this.baseWeight + this.weightCoefficient * noiseVal);
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

