/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityGlowCloud;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.GlowingCliffsColumnShaper;
import Reika.ChromatiCraft.World.GlowingCliffsDecorator;
import Reika.DragonAPI.Auxiliary.Trackers.WorldgenProfiler;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Math.Noise.NoiseGeneratorBase;
import Reika.DragonAPI.Instantiable.Math.Noise.SimplexNoiseGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ModifiableBigTree;
import Reika.DragonAPI.Instantiable.Worldgen.ModifiableSmallTrees;
import Reika.DragonAPI.Interfaces.CustomMapColorBiome;
import Reika.DragonAPI.Interfaces.WinterBiomeStrengthControl;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BoPBlockHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class BiomeGlowingCliffs
extends BiomeGenBase
implements WinterBiomeStrengthControl,
CustomMapColorBiome {
    private static final NoiseGeneratorBase hueShift = new SimplexNoiseGenerator(System.currentTimeMillis()).setFrequency(0.125);
    private static final NoiseGeneratorBase lumShift = new SimplexNoiseGenerator(-System.currentTimeMillis()).setFrequency(0.16666666666666666);
    private static final NoiseGeneratorBase waterColorMix = new SimplexNoiseGenerator(System.currentTimeMillis() ^ 0xFFFFFFFFFFFFFFFFL).setFrequency(0.1);
    private static final NoiseGeneratorBase skyColorMix = new SimplexNoiseGenerator((System.currentTimeMillis() ^ 0xFFFFFFFFFFFFFFFFL) * 2L).setFrequency(0.05);
    private static GlowingCliffsColumnShaper terrain;
    private static long worldSeed;
    private static HashMap<Class, Boolean> generatorRules;
    @SideOnly(value=Side.CLIENT)
    public static float renderFactor;
    private final WorldGenAbstractTree basicTreeGen = new SlightlyFloweringSmallTree(false);
    private final WorldGenAbstractTree bigTreeGen = new SlightlyFloweringBigTree(false);
    private final GlowingTreeGenerator glowTree = new GlowingTreeGenerator();
    private final GlowingTreeGenerator smallGlowTrees = new GlowingTreeGenerator();
    private final List<BiomeGenBase.SpawnListEntry> glowCloudList;

    public BiomeGlowingCliffs(int id, boolean register) {
        super(id, register);
        int i;
        this.field_76791_y = "Luminous Cliffs";
        this.field_76760_I = new GlowingCliffsDecorator();
        this.func_76732_a(0.75f, 0.85f);
        this.field_76765_S = false;
        for (i = 0; i < BlockFlower.field_149859_a.length; ++i) {
            this.flowers.add(new BiomeGenBase.FlowerEntry((Block)Blocks.field_150328_O, i, 20));
        }
        for (i = 0; i < BlockFlower.field_149858_b.length; ++i) {
            this.flowers.add(new BiomeGenBase.FlowerEntry((Block)Blocks.field_150327_N, i, 20));
        }
        if (ChromaOptions.BIOMEBLEND.getState()) {
            this.func_150570_a(new BiomeGenBase.Height(BiomeGenBase.field_150580_W.field_76748_D, BiomeGenBase.field_150580_W.field_76749_E));
        } else {
            this.func_150570_a(new BiomeGenBase.Height(-0.75f, 0.0f));
        }
        this.field_76761_J.clear();
        this.field_82914_M.clear();
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySpider.class, 10, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 10, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 5, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 10, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 2, 1, 4));
        this.field_82914_M.add(new BiomeGenBase.SpawnListEntry(EntityBat.class, 10, 8, 8));
        this.glowCloudList = ReikaJavaLibrary.makeListFrom((Object)new BiomeGenBase.SpawnListEntry(EntityGlowCloud.class, 30, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateRenderFactor(AbstractClientPlayer ep) {
        renderFactor = ep == null || ep.field_70170_p == null ? Math.max(0.0f, renderFactor - 0.1f) : (BiomeGlowingCliffs.isGlowingCliffs(ep.field_70170_p.func_72807_a(MathHelper.func_76128_c((double)ep.field_70165_t), MathHelper.func_76128_c((double)ep.field_70161_v))) ? Math.min(1.0f, renderFactor + 0.025f) : Math.max(0.0f, renderFactor - 0.0125f));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float temp) {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        return ReikaColorAPI.getShiftedHue((int)13672703, (float)((float)(15.0 * skyColorMix.getValue(ep.field_70165_t, ep.field_70161_v))));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_150558_b(int x, int y, int z) {
        int base = BiomeGenBase.field_76767_f.func_150558_b(x, y, z);
        int c = this.shiftHue(base, x, z);
        c = this.shiftBrightness(c, x, y, z);
        return c;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_150571_c(int x, int y, int z) {
        int base = BiomeGenBase.field_76767_f.func_150571_c(x, y, z);
        int c = this.shiftHue(base, x, z);
        c = this.shiftBrightness(c, x, y, z);
        return c;
    }

    public int getWaterColorMultiplier() {
        return 0x22FFBB;
    }

    public int getWaterColor(IBlockAccess world, int x, int y, int z, int l) {
        float f = (float)ReikaMathLibrary.normalizeToBounds((double)waterColorMix.getValue((double)x, (double)z), (double)0.0, (double)1.0);
        return ReikaColorAPI.mixColors((int)0x22FFBB, (int)16732368, (float)f);
    }

    private int shiftBrightness(int base, int x, int y, int z) {
        float f = (float)ReikaMathLibrary.normalizeToBounds((double)lumShift.getValue((double)x, (double)z), (double)0.05f, (double)0.6f);
        return ReikaColorAPI.mixColors((int)base, (int)0xFFFFFF, (float)(1.0f - (f *= MathHelper.func_76131_a((float)(((float)y - 64.0f) / 125.0f), (float)0.0f, (float)1.0f))));
    }

    private int shiftHue(int base, int x, int z) {
        float h = (float)ReikaMathLibrary.normalizeToBounds((double)hueShift.getValue((double)x, (double)z), (double)0.0, (double)50.0);
        return ReikaColorAPI.getShiftedHue((int)base, (float)h);
    }

    public List func_76747_a(EnumCreatureType type) {
        return type == ChromatiCraft.glowCloudType ? this.glowCloudList : super.func_76747_a(type);
    }

    public void func_150573_a(World world, Random rand, Block[] arr, byte[] m, int x, int z, double stoneNoise) {
        super.func_150573_a(world, rand, arr, m, x, z, stoneNoise);
    }

    public static void blendTerrainEdgesAndGenCliffs(World world, int chunkX, int chunkZ, Block[] blockArray, byte[] metaArray) {
        BiomeGlowingCliffs.initTerrain(world);
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int x = chunkX * 16 + i;
                int z = chunkZ * 16 + k;
                BiomeGenBase b = world.func_72959_q().func_76935_a(x, z);
                if (!BiomeGlowingCliffs.isGlowingCliffs(b)) {
                    if (!ChromaOptions.BIOMEBLEND.getState()) continue;
                    if (WorldgenProfiler.profilingEnabled()) {
                        WorldgenProfiler.startGenerator((World)world, (String)"Luminous cliff adjacency biome blending", (int)chunkX, (int)chunkZ);
                    }
                    terrain.blendEdge(world, x, z, blockArray, metaArray);
                    if (!WorldgenProfiler.profilingEnabled()) continue;
                    WorldgenProfiler.onRunGenerator((World)world, (String)"Luminous cliff adjacency biome blending", (int)chunkX, (int)chunkZ);
                    continue;
                }
                if (WorldgenProfiler.profilingEnabled()) {
                    WorldgenProfiler.startGenerator((World)world, (String)"Luminous cliff terrain shaping", (int)chunkX, (int)chunkZ);
                }
                terrain.generateColumn(world, x, z, chunkX, chunkZ, blockArray, metaArray, b);
                if (!WorldgenProfiler.profilingEnabled()) continue;
                WorldgenProfiler.onRunGenerator((World)world, (String)"Luminous cliff terrain shaping", (int)chunkX, (int)chunkZ);
            }
        }
    }

    private static void initTerrain(World world) {
        long seed = world.func_72905_C();
        if (seed != worldSeed || terrain == null) {
            terrain = new GlowingCliffsColumnShaper(seed);
            worldSeed = seed;
        }
    }

    public static GlowingCliffsColumnShaper getTerrain(World world) {
        BiomeGlowingCliffs.initTerrain(world);
        return terrain;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (rand.nextInt(20) == 0) {
            return this.glowTree;
        }
        return rand.nextInt(10) == 0 ? this.bigTreeGen : this.basicTreeGen;
    }

    public WorldGenAbstractTree getUndergroundTreeGen(Random rand, boolean construct, int bigChance) {
        return rand.nextInt(bigChance) == 0 ? (construct ? new GlowingTreeGenerator() : this.glowTree) : (construct ? new SmallGlowingTreeGenerator() : this.smallGlowTrees);
    }

    public float getWinterSkyStrength(World world, EntityPlayer ep) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getMapColor(World world, int x, int z) {
        return 0x22AAFF;
    }

    public static boolean isGlowingCliffs(BiomeGenBase b) {
        return b instanceof BiomeGlowingCliffs || ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.getMystParentBiome((BiomeGenBase)b) instanceof BiomeGlowingCliffs;
    }

    public static boolean canRunGenerator(IWorldGenerator gen) {
        Class<?> c = gen.getClass();
        Boolean flag = generatorRules.get(c);
        if (flag == null) {
            String s = c.getSimpleName().toLowerCase(Locale.ENGLISH);
            flag = true;
            if (s.contains("slimeisland")) {
                flag = false;
            }
            generatorRules.put(c, flag);
        }
        return flag;
    }

    public static BlockKey selectGlowingTreeLeaf(Random rand, int glowChance, BlockKey leafDefault, boolean isBig) {
        if (rand.nextInt(glowChance) == 0) {
            return new BlockKey(ChromaBlocks.GLOWLEAF.getBlockInstance());
        }
        return ModList.BOP.isLoaded() && rand.nextInt(isBig ? 20 : 25) == 0 ? BoPBlockHandler.LeafTypes.flowering.getBlock() : leafDefault;
    }

    public static BlockKey selectBasicTreeLeaf(Random rand, BlockKey leafDefault, boolean isBig) {
        return ModList.BOP.isLoaded() && rand.nextInt(isBig ? 15 : 10) == 0 ? BoPBlockHandler.LeafTypes.flowering.getBlock() : leafDefault;
    }

    static {
        generatorRules = new HashMap();
    }

    public static interface GlowingTreeGen {
        public void setGlowChance(int var1);

        public void resetGlowChance();
    }

    private static class SlightlyFloweringBigTree
    extends ModifiableBigTree {
        public SlightlyFloweringBigTree(boolean updates) {
            super(updates);
        }

        public BlockKey getLeafBlock(int x, int y, int z) {
            return BiomeGlowingCliffs.selectBasicTreeLeaf(this.rand, super.getLeafBlock(x, y, z), true);
        }
    }

    private static class SlightlyFloweringSmallTree
    extends ModifiableSmallTrees {
        public SlightlyFloweringSmallTree(boolean updates) {
            super(updates);
        }

        public BlockKey getLeafBlock(int x, int y, int z) {
            return BiomeGlowingCliffs.selectBasicTreeLeaf(this.rand, super.getLeafBlock(x, y, z), false);
        }
    }

    private static class SmallGlowingTreeGenerator
    extends ModifiableSmallTrees
    implements GlowingTreeGen {
        private static final int DEFAULT_GLOW_CHANCE = 16;
        private int glowChance = 16;
        private boolean isGenerating;
        private LinkedList<Integer> glowChanceHistory = new LinkedList();

        public SmallGlowingTreeGenerator() {
            super(false);
        }

        @Override
        public void setGlowChance(int c) {
            if (this.isGenerating) {
                this.glowChanceHistory.addLast(this.glowChance);
            }
            this.glowChance = c;
        }

        @Override
        public void resetGlowChance() {
            this.glowChance = 16;
        }

        public BlockKey getLeafBlock(int x, int y, int z) {
            return BiomeGlowingCliffs.selectGlowingTreeLeaf(this.rand, this.glowChance, super.getLeafBlock(x, y, z), false);
        }

        public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
            boolean wasGenerating = this.isGenerating;
            this.isGenerating = true;
            boolean flag = super.func_76484_a(world, rand, x, y, z);
            if (!this.glowChanceHistory.isEmpty()) {
                this.glowChance = this.glowChanceHistory.getLast();
            }
            this.isGenerating = wasGenerating;
            return flag;
        }
    }

    private static class GlowingTreeGenerator
    extends ModifiableBigTree
    implements GlowingTreeGen {
        private static final int DEFAULT_GLOW_CHANCE = 16;
        private int glowChance = 16;
        private boolean isGenerating;
        private LinkedList<Integer> glowChanceHistory = new LinkedList();

        public GlowingTreeGenerator() {
            super(false);
        }

        public BlockKey getLeafBlock(int x, int y, int z) {
            return BiomeGlowingCliffs.selectGlowingTreeLeaf(this.rand, this.glowChance, super.getLeafBlock(x, y, z), true);
        }

        @Override
        public void setGlowChance(int c) {
            if (this.isGenerating) {
                this.glowChanceHistory.addLast(this.glowChance);
            }
            this.glowChance = c;
        }

        @Override
        public void resetGlowChance() {
            this.glowChance = 16;
        }

        public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
            boolean wasGenerating = this.isGenerating;
            this.isGenerating = true;
            boolean flag = super.func_76484_a(world, rand, x, y, z);
            if (!this.glowChanceHistory.isEmpty()) {
                this.glowChance = this.glowChanceHistory.getLast();
            }
            this.isGenerating = wasGenerating;
            return flag;
        }
    }
}

