/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ThreadedGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class ArchCalculator
extends ThreadedGenerator {
    private static final int AREA = 4096;
    private static final int COUNT = 60;
    private static final ChunkSplicedGenerationCache arches = new ChunkSplicedGenerationCache().setWrapping(4096, 4096);

    public ArchCalculator(long seed) {
        super(seed);
    }

    @Override
    public void run() throws Throwable {
        arches.clear();
        for (int i = 0; i < 60; ++i) {
            int x = this.rand.nextInt(4096);
            int z = this.rand.nextInt(4096);
            Arch a = new Arch(x, z, this.rand.nextDouble() * 360.0, 30.0 + this.rand.nextDouble() * 60.0, 0.5 + this.rand.nextDouble(), (double)(4 + this.rand.nextInt(17)), (double)this.rand.nextInt(4), 1.0 + this.rand.nextDouble() * 2.0);
            a.calculate(this.rand);
            a.generate(ArchCalculator.arches, this.rand);
        }
    }

    public static void generateArchData(World world, int chunkX, int chunkZ) {
        arches.generate(world, chunkX, chunkZ);
    }

    @Override
    public String getStateMessage() {
        return "Arch layouts calculated.";
    }

    public static class Arch {
        private final int posX1;
        private final int posY1;
        private final int posZ1;
        private final double initAngle;
        private final double compassAngle;
        private final double angleDelta;
        private final double radius;
        private final double radiusVariation;
        private final double stepDistance;
        private double angle;
        private double posX;
        private double posY;
        private double posZ;
        private final HashSet<Coordinate> coords = new HashSet();

        private Arch(int x, int z, double ca, double ia, double da, double r, double rv, double d) {
            this(x, 16, z, ca, ia, da, r, rv, d);
        }

        public Arch(int x, int y, int z, double ca, double ia, double da, double r, double rv, double d) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            r = Math.max(r, d * 1.25);
            this.initAngle = ia;
            this.compassAngle = ca;
            this.angleDelta = da;
            this.radius = r;
            this.radiusVariation = rv;
            this.stepDistance = d;
        }

        public void calculate(Random rand) {
            this.angle = this.initAngle;
            this.posX = (double)this.posX1 + 0.5;
            this.posY = (double)this.posY1 + 0.5;
            this.posZ = (double)this.posZ1 + 0.5;
            do {
                this.placeBlob(rand);
                double[] d = ReikaPhysicsHelper.polarToCartesian((double)this.stepDistance, (double)this.angle, (double)this.compassAngle);
                this.posX += d[0];
                this.posY += d[1];
                this.posZ += d[2];
                this.angle -= this.angleDelta;
            } while (this.angle > -this.initAngle);
        }

        private void placeBlob(Random rand) {
            double pow = 1.75 + rand.nextDouble() * 2.25;
            double r = this.radius - this.radiusVariation / 2.0 + rand.nextDouble() * this.radiusVariation;
            for (double i = -r; i <= r; i += 0.5) {
                for (double j = -r; j <= r; j += 0.5) {
                    for (double k = -r; k <= r; k += 0.5) {
                        if (!(Math.pow(Math.abs(i), pow) + Math.pow(Math.abs(j), pow) + Math.pow(Math.abs(k), pow) <= Math.pow(Math.abs(r), pow))) continue;
                        this.coords.add(new Coordinate(this.posX + i, this.posY + j, this.posZ + k));
                    }
                }
            }
        }

        public void generate(World world, Random rand) {
            for (Coordinate c : this.coords) {
                if (!this.coords.contains(c.offset(0, 1, 0)) && !this.coords.contains(c.offset(0, -1, 0))) continue;
                if (this.coords.contains(c.offset(0, 1, 0))) {
                    c.setBlock(world, Blocks.field_150348_b);
                    continue;
                }
                c.setBlock(world, (Block)Blocks.field_150349_c);
            }
        }

        private void generate(ChunkSplicedGenerationCache world, Random rand) {
            for (Coordinate c : this.coords) {
                if (!this.coords.contains(c.offset(0, 1, 0)) && !this.coords.contains(c.offset(0, -1, 0))) continue;
                if (this.coords.contains(c.offset(0, 1, 0))) {
                    c.setBlock(world, Blocks.field_150348_b);
                    continue;
                }
                c.setBlock(world, (Block)Blocks.field_150349_c);
            }
        }
    }
}

