/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Biome;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class StructureBiome
extends ChromaDimensionBiome {
    public StructureBiome(int id, String n, ChromaDimensionManager.Biomes t) {
        super(id, n, t);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final int func_150558_b(int x, int y, int z) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int c = this.getBaseColor(x, y, z);
        if (world == null) {
            return c;
        }
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            for (int k = 1; k <= 4; ++k) {
                int dx = x + dir.offsetX * k;
                int dz = z + dir.offsetZ * k;
                BiomeGenBase b = world.func_72807_a(dx, dz);
                if (b == this) continue;
                return this.getHighlightColor(x, y, z, c);
            }
        }
        double rx = (double)x / 4.0;
        double rz = (double)z / 4.0;
        float f = (float)ReikaMathLibrary.normalizeToBounds((double)this.grassColor.getValue(rx, rz), (double)0.0, (double)1.0);
        c = ReikaColorAPI.mixColors((int)ReikaColorAPI.multiplyChannels((int)c, (float)1.0f, (float)1.5f, (float)1.0f), (int)this.getHighlightColor(x, y, z, c), (float)f);
        return c;
    }

    protected int getHighlightColor(int x, int y, int z, int c) {
        return ReikaColorAPI.multiplyChannels((int)c, (float)1.0f, (float)2.5f, (float)1.5f);
    }

    protected int getBaseColor(int x, int y, int z) {
        return ChromatiCraft.rainbowforest.func_150558_b(x, y, z);
    }

    @Override
    public int getWaterColorMultiplier() {
        return 0xFFFFFF;
    }
}

