/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaDimensionBiomeTerrainShaper;
import Reika.ChromatiCraft.World.Dimension.BiomeDistributor;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.Terrain.TerrainGenChromaIslands;
import Reika.ChromatiCraft.World.Dimension.Terrain.TerrainGenCrystalMountain;
import Reika.ChromatiCraft.World.Dimension.Terrain.TerrainGenGlowingCracks;
import Reika.ChromatiCraft.World.Dimension.Terrain.TerrainGenSkylandCanyons;
import Reika.ChromatiCraft.World.Dimension.Terrain.TerrainGenSparklingSands;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BiomeTerrainProvider {
    private final ArrayList<ChromaDimensionBiomeTerrainShaper> terrain = new ArrayList();

    protected BiomeTerrainProvider(long seed) {
        this.registerTerrain(new TerrainGenSkylandCanyons(seed));
        this.registerTerrain(new TerrainGenCrystalMountain(seed));
        this.registerTerrain(new TerrainGenChromaIslands(seed));
        this.registerTerrain(new TerrainGenSparklingSands(seed));
        this.registerTerrain(new TerrainGenGlowingCracks(seed));
    }

    public void registerTerrain(ChromaDimensionBiomeTerrainShaper b) {
        this.terrain.add(b);
    }

    public void generateChunk(World world, int chunkX, int chunkZ, Random rand) {
        chunkX <<= 4;
        chunkZ <<= 4;
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int dx = chunkX + i;
                int dz = chunkZ + k;
                ChromaDimensionBiome b = this.getBiome(dx, dz);
                int top = world.func_72825_h(dx, dz) - 1;
                for (ChromaDimensionBiomeTerrainShaper s : this.terrain) {
                    if (!s.canGenerateIn(b)) continue;
                    s.generateColumn(world, chunkX, chunkZ, i, k, top, rand, this.getEdgeFactor(world, dx, dz, s));
                }
            }
        }
    }

    private void clearColumn(World world, int dx, int dz) {
        for (int y = 0; y <= 255; ++y) {
            world.func_147465_d(dx, y, dz, Blocks.field_150348_b, 0, 4);
        }
    }

    protected final double getEdgeFactor(World world, int x, int z, ChromaDimensionBiomeTerrainShaper t) {
        if (t.isFlatWorld(world)) {
            return 1.0;
        }
        int minDist = Integer.MAX_VALUE;
        double search = t.getBiomeSearchDistance();
        block0: for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int d = 0;
            while ((double)d < search) {
                int dx = x + d * dir.offsetX;
                int dz = z + d * dir.offsetZ;
                ChromaDimensionBiome b = BiomeDistributor.getBiome(dx, dz);
                if (!t.canGenerateIn(b)) {
                    minDist = Math.min(minDist, d);
                    continue block0;
                }
                ++d;
            }
        }
        return minDist == Integer.MAX_VALUE ? 1.0 : (double)minDist / search;
    }

    protected ChromaDimensionBiome getBiome(int x, int z) {
        return BiomeDistributor.getBiome(x, z);
    }

    public static class ForcedBiomeTerrainProvider
    extends BiomeTerrainProvider {
        private final ChromaDimensionManager.ChromaDimensionBiomeType biome;

        public ForcedBiomeTerrainProvider(ChromaDimensionManager.ChromaDimensionBiomeType type, long seed) {
            super(seed);
            this.biome = type;
        }

        @Override
        protected ChromaDimensionBiome getBiome(int x, int z) {
            return this.biome.getBiome();
        }
    }
}

