/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class CheatingPreventionSystem {
    public static final CheatingPreventionSystem instance = new CheatingPreventionSystem();
    private final HashSet<BlockKey> bannedBlocks = new HashSet();
    private final HashMap<KeyedItemStack, BanReaction> bannedItems = new HashMap();

    private CheatingPreventionSystem() {
        Item i;
        if (ModList.ENDERIO.isLoaded()) {
            Block b = GameRegistry.findBlock((String)ModList.ENDERIO.modLabel, (String)"blockTravelAnchor");
            this.banBlock(b, BanReaction.DELETEONUSE);
            b = GameRegistry.findBlock((String)ModList.ENDERIO.modLabel, (String)"blockTelePad");
            this.banBlock(b, BanReaction.DELETEONUSE);
            Item i2 = GameRegistry.findItem((String)ModList.ENDERIO.modLabel, (String)"itemTravelStaff");
            if (i2 != null) {
                this.banItem(i2, BanReaction.DELETEONUSE);
            }
        }
        if ((i = GameRegistry.findItem((String)"GraviSuite", (String)"vajra")) != null) {
            this.banItem(i, BanReaction.PREVENTUSE);
        }
        if (ModList.THAUMICTINKER.isLoaded()) {
            Block b = GameRegistry.findBlock((String)ModList.THAUMICTINKER.modLabel, (String)"warpGate");
            this.banBlock(b, BanReaction.DELETEONUSE);
        }
        if (ModList.DRACONICEVO.isLoaded()) {
            i = GameRegistry.findItem((String)ModList.DRACONICEVO.modLabel, (String)"teleporterMKI");
            if (i != null) {
                this.banItem(i, BanReaction.DROPONUSE);
            }
            if ((i = GameRegistry.findItem((String)ModList.DRACONICEVO.modLabel, (String)"teleporterMKII")) != null) {
                this.banItem(i, BanReaction.DELETEONUSE);
            }
        }
        if (ModList.BOTANIA.isLoaded() && (i = GameRegistry.findItem((String)ModList.BOTANIA.modLabel, (String)"flugelEye")) != null) {
            this.banItem(i, BanReaction.PREVENTUSE);
        }
    }

    private void banBlock(Block b) {
        this.banBlock(b, null);
    }

    private void banBlock(Block b, BanReaction r) {
        Item i;
        if (b == null) {
            return;
        }
        BlockKey bk = new BlockKey(b);
        this.bannedBlocks.add(bk);
        if (r == null) {
            r = BanReaction.DELETEONUSE;
        }
        if ((i = Item.func_150898_a((Block)b)) != null) {
            this.bannedItems.put(new KeyedItemStack(i).setIgnoreMetadata(!bk.hasMetadata()).setSimpleHash(true), r);
        }
    }

    private void banItem(Item i, BanReaction r) {
        this.bannedItems.put(new KeyedItemStack(i).setIgnoreNBT(true).setSimpleHash(true), r);
    }

    private void banItem(ItemStack is, BanReaction r) {
        this.bannedItems.put(new KeyedItemStack(is).setIgnoreNBT(true).setSimpleHash(true), r);
    }

    public boolean isBannedDimensionBlock(Block b, int meta) {
        return this.bannedBlocks.contains(new BlockKey(b, meta));
    }

    @SubscribeEvent
    public void handleRightClicks(PlayerInteractEvent evt) {
        ItemStack is;
        BanReaction r;
        if ((evt.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || evt.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && evt.entityPlayer.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() && (r = this.getReaction(is = evt.entityPlayer.func_71045_bC())) != null && r.reactsToUse()) {
            r.perform(evt.entityPlayer, is, -1);
            evt.setCanceled(true);
        }
    }

    public void preJoin(EntityPlayer ep) {
        this.checkInventory(ep, BanReaction.PREVENTBRING);
    }

    public void postJoin(EntityPlayer ep) {
        this.checkInventory(ep, BanReaction.DELETEONENTRY);
    }

    private void checkInventory(EntityPlayer ep, BanReaction br) {
        BanReaction r;
        ItemStack is;
        int i;
        for (i = 0; i < 5; ++i) {
            is = ep.func_71124_b(i);
            r = this.getReaction(is);
            if (r != br) continue;
            r.perform(ep, is, -i);
        }
        for (i = 0; i < 36; ++i) {
            is = ep.field_71071_by.field_70462_a[i];
            r = this.getReaction(is);
            if (r != br) continue;
            r.perform(ep, is, -i);
        }
    }

    public void tick(EntityPlayer ep) {
        BanReaction r;
        ItemStack held;
        if (ep.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() && (held = ep.func_71045_bC()) != null && (r = this.getReaction(held)) != null && r.reactsToTick()) {
            r.perform(ep, held, -1);
        }
    }

    private BanReaction getReaction(ItemStack is) {
        return is == null || is.func_77973_b() == null ? null : this.bannedItems.get(new KeyedItemStack(is).setSimpleHash(true));
    }

    public void punishCheatingPlayer(EntityPlayer ep) {
        ReikaSoundHelper.playSoundAtEntity((World)ep.field_70170_p, (Entity)ep, (String)"random.explode", (float)1.0f, (float)1.0f);
        ReikaSoundHelper.playSoundAtEntity((World)ep.field_70170_p, (Entity)ep, (String)"random.explode", (float)1.0f, (float)0.5f);
        ReikaParticleHelper.EXPLODE.spawnAt((Entity)ep);
        ep.func_70097_a(DamageSource.field_76377_j, (float)ReikaRandomHelper.getRandomBetween((int)5, (int)10));
        Vec3 v = ep.func_70040_Z();
        ReikaEntityHelper.knockbackEntityFromPos((double)(ep.field_70165_t + v.field_72450_a), (double)(ep.field_70163_u + v.field_72448_b - 1.5), (double)(ep.field_70161_v + v.field_72449_c), (Entity)ep, (double)2.5);
        ep.field_70133_I = true;
        ep.field_70143_R += 10.0f;
    }

    private static enum BanReaction {
        PREVENTUSE,
        PREVENTBRING,
        DROPONUSE,
        DELETEONUSE,
        DELETEONHOLD,
        DELETEONENTRY;


        private void perform(EntityPlayer ep, ItemStack is, int slot) {
            switch (this) {
                case PREVENTUSE: {
                    ChromaSounds.ERROR.playSound((Entity)ep);
                    break;
                }
                case PREVENTBRING: 
                case DELETEONENTRY: {
                    if (this == PREVENTBRING) {
                        EntityItem ei = ReikaItemHelper.dropItem((Entity)ep, (ItemStack)is);
                        ei.lifespan = Integer.MAX_VALUE;
                    }
                    if (slot < 0) {
                        ep.func_70062_b(-slot, is);
                        break;
                    }
                    ep.field_71071_by.func_70299_a(slot, null);
                    break;
                }
                case DROPONUSE: 
                case DELETEONUSE: 
                case DELETEONHOLD: {
                    instance.punishCheatingPlayer(ep);
                    if (this == DROPONUSE) {
                        ReikaItemHelper.dropItem((Entity)ep, (ItemStack)is);
                    }
                    ep.func_70062_b(0, null);
                }
            }
            if (this.givesProgress()) {
                ProgressStage.STRUCTCHEAT.stepPlayerTo(ep);
            }
        }

        public boolean reactsToUse() {
            switch (this) {
                case PREVENTUSE: 
                case DROPONUSE: 
                case DELETEONUSE: {
                    return true;
                }
            }
            return false;
        }

        public boolean reactsToTick() {
            switch (this) {
                case DELETEONHOLD: {
                    return true;
                }
            }
            return false;
        }

        private boolean givesProgress() {
            return this.ordinal() >= DROPONUSE.ordinal();
        }
    }
}

