/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityAurora;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenCentral;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenChromaMountains;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenChromaOcean;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenCrystalForest;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenCrystalPlains;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenGlowCracks;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenGlowingForest;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenIslands;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenSkylands;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenSparkle;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenVoidlands;
import Reika.ChromatiCraft.World.Dimension.Biome.MonumentBiome;
import Reika.ChromatiCraft.World.Dimension.Biome.StructureBiome;
import Reika.ChromatiCraft.World.Dimension.CheatingPreventionSystem;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.ChromatiCraft.World.Dimension.DimensionTuningManager;
import Reika.ChromatiCraft.World.Dimension.Rendering.Aurora;
import Reika.ChromatiCraft.World.Dimension.WorldProviderChroma;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.IDCollisionTracker;
import Reika.DragonAPI.Auxiliary.Trackers.RetroGenController;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.entities.ITaintedMob;

public class ChromaDimensionManager {
    private static final PlayerMap<DimensionStructureGenerator> playersInStructures = new PlayerMap();
    private static final HashMap<Integer, ChromaDimensionBiomeType> IDMap = new HashMap();
    private static final Collection<EntityAurora> aurorae = new HashSet<EntityAurora>();
    static int dimensionAge = 0;
    static long dimensionSeed = -1L;
    public static boolean serverStopping = false;
    private static boolean dimensionClearing = false;

    public static void initialize() {
        int id = ExtraChromaIDs.DIMID.getValue();
        DimensionManager.registerProviderType((int)id, WorldProviderChroma.class, (boolean)false);
        DimensionManager.registerDimension((int)id, (int)id);
        RetroGenController.instance.excludeWorld(id);
        for (int i = 0; i < Biomes.biomeList.length; ++i) {
            Biomes b = Biomes.biomeList[i];
            b.create();
            BiomeDictionary.registerBiomeType((BiomeGenBase)b.instance, (BiomeDictionary.Type[])b.types);
            if (b.subBiome == null) continue;
            BiomeDictionary.registerBiomeType((BiomeGenBase)b.subBiome.instance, (BiomeDictionary.Type[])b.subBiome.types);
        }
    }

    public static void checkChromaDimensionUnload() {
        WorldServer world = DimensionManager.getWorld((int)ExtraChromaIDs.DIMID.getValue());
        if (world != null) {
            ChromatiCraft.logger.log((Object)("Checking dimension for unload - player entities: " + world.field_73010_i));
            if (world.field_73010_i.isEmpty()) {
                ChromaDimensionManager.resetDimension((World)world);
            }
        }
    }

    public static void resetDimension(World world) {
        boolean del;
        if (!DragonAPICore.hasGameLoaded()) {
            return;
        }
        if (dimensionAge <= 1200 && !serverStopping) {
            ChromatiCraft.logger.log((Object)("Dimension is only " + dimensionAge + " ticks old; not resetting"));
            return;
        }
        if (dimensionClearing) {
            ChromatiCraft.logger.log((Object)"Dimension already resetting; not attempting to reset during a reset");
            return;
        }
        dimensionClearing = true;
        ChromatiCraft.logger.log((Object)("Resetting dimension of age " + dimensionAge + "; Server shutdown? " + serverStopping));
        dimensionSeed = -1L;
        dimensionAge = 0;
        playersInStructures.clear();
        aurorae.clear();
        if (world instanceof WorldServer) {
            ((WorldServer)world).func_73041_k();
        }
        DimensionStructureGenerator.resetCachedGenerators();
        ChromaDimensionManager.getChunkProvider(world).clearCaches(!serverStopping);
        System.gc();
        File path = DimensionManager.getCurrentSaveRootDirectory();
        File dim = new File(path, "DIM" + ExtraChromaIDs.DIMID.getValue());
        if (dim.exists() && dim.isDirectory() && !(del = ReikaFileReader.deleteFolderWithContents((File)dim, (int)100))) {
            ChromatiCraft.logger.logError((Object)"Could not delete dimension chunk data; you must delete it manually or the dimension will be invalid.");
        }
        ReikaPacketHelper.sendDataPacketToEntireServer((String)"ChromaData", (int)ChromaPackets.LEAVEDIM.ordinal(), (int[])new int[0]);
        dimensionClearing = false;
    }

    public static void resetDimensionClient() {
        ChromatiCraft.logger.log((Object)"Resetting clientside dimension");
        dimensionSeed = -1L;
        dimensionAge = 0;
        playersInStructures.clear();
        System.gc();
        File f = new File(DragonAPICore.getMinecraftDirectory(), "mods/VoxelMods/voxelMap/cache");
        if (f.exists() && f.isDirectory()) {
            File[] saves = f.listFiles();
            for (int i = 0; i < saves.length; ++i) {
                File f2 = new File(saves[i], "Chroma (dimension 60)");
                if (!f2.exists()) continue;
                f2.delete();
            }
        }
    }

    public static ChunkProviderChroma getChunkProvider(World world) {
        return ((WorldProviderChroma)world.field_73011_w).getChunkGenerator();
    }

    public static void tickPlayersInStructures(World world) {
        for (UUID id : playersInStructures.keySet()) {
            EntityPlayer ep = world.func_152378_a(id);
            if (ep == null) continue;
            if (ep.field_70163_u >= 106.0) {
                ChromaDimensionManager.removePlayerFromStructure(ep);
                continue;
            }
            ((DimensionStructureGenerator)playersInStructures.directGet(id)).tickPlayer(ep);
            CheatingPreventionSystem.instance.tick(ep);
        }
    }

    public static DimensionStructureGenerator getStructurePlayerIsIn(EntityPlayer ep) {
        return (DimensionStructureGenerator)playersInStructures.get(ep);
    }

    public static boolean addPlayerToStructure(EntityPlayerMP ep, DimensionStructureGenerator structure) {
        if (!DimensionTuningManager.TuningThresholds.STRUCTURES.isSufficientlyTuned((EntityPlayer)ep)) {
            return false;
        }
        playersInStructures.put((EntityPlayer)ep, (Object)structure);
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.STRUCTUREENTRY.ordinal(), (EntityPlayerMP)ep, (int[])new int[]{structure.getType().ordinal()});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPlayerToStructureClient(EntityPlayer ep, DimensionStructureGenerator.DimensionStructureType structure) {
        playersInStructures.put(ep, (Object)structure.createGenerator(-1));
    }

    public static void removePlayerFromStructure(EntityPlayer ep) {
        playersInStructures.remove(ep);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addAurora(EntityAurora e) {
        aurorae.add(e);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderAurorae() {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2912);
        for (EntityAurora e : aurorae) {
            Aurora a = e.getAurora();
            if (a == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
            a.render();
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
    }

    public static void onPlayerBlockedFromBiome(World world, int x, int y, int z, Entity ep) {
        if (world.field_72995_K) {
            ChromaDimensionManager.onPlayerBlockedFromBiomeClient(world, x, y, z, ep);
        } else if (world.field_73012_v.nextInt(5) == 0) {
            ChromaSounds.LOREHEX.playSound(ep, 0.05f, 0.75f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void onPlayerBlockedFromBiomeClient(World world, int x, int y, int z, Entity ep) {
        Random rand = world.field_73012_v;
        if (rand.nextBoolean()) {
            return;
        }
        int r = 6;
        double dr0 = (double)r - 0.5;
        double dr1 = (double)r - 0.35;
        double dr2 = r - 2;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int dz;
                    int dy;
                    int dx;
                    if ((double)(i * i + j * j + k * k) > dr0 * dr0 || world.func_147439_a(dx = x + i, dy = y + j, dz = z + k) != Blocks.field_150350_a || ChromaDimensionManager.isStructureBiome(world.func_72807_a(dx, dz))) continue;
                    for (int d = 2; d < 6; ++d) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
                        int ddx = dx + dir.offsetX;
                        int ddz = dz + dir.offsetZ;
                        if (world.func_147439_a(ddx, dy, ddz) != Blocks.field_150350_a || ChromaDimensionManager.isStructureBiome(world.func_72807_a(ddx, ddz))) continue;
                        double sx = (double)dx + rand.nextDouble();
                        double sy = (double)dy + rand.nextDouble();
                        double sz = (double)dz + rand.nextDouble();
                        switch (dir) {
                            case NORTH: {
                                sz = dz;
                                break;
                            }
                            case SOUTH: {
                                sz = dz + 1;
                                break;
                            }
                            case EAST: {
                                sx = dx + 1;
                                break;
                            }
                            case WEST: {
                                sx = dx;
                                break;
                            }
                        }
                        if (ReikaMathLibrary.py3d((double)(sx - ep.field_70165_t), (double)(sy - ep.field_70163_u), (double)(sz - ep.field_70161_v)) > dr1) continue;
                        EntityCCBlurFX fx = new EntityCCBlurFX(world, sx, sy, sz);
                        float sc = 3.5f;
                        float br = 0.08f;
                        if (ReikaMathLibrary.py3d((double)(sx - ep.field_70165_t), (double)(sy - ep.field_70163_u), (double)(sz - ep.field_70161_v)) > dr2) {
                            double dd = ReikaMathLibrary.py3d((double)(sx - ep.field_70165_t), (double)(sy - ep.field_70163_u), (double)(sz - ep.field_70161_v)) - dr2;
                            br = (float)((double)br - dd / 20.0);
                        }
                        if (br <= 0.0f) continue;
                        int l = ReikaRandomHelper.getRandomBetween((int)80, (int)180);
                        fx.setIcon(ChromaIcons.FADE_GENTLE).setAlphaFading().setScale(sc).setColor(ReikaColorAPI.getColorWithBrightnessMultiplier((int)0x22AAFF, (float)br)).setRapidExpand().setLife(l);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                }
            }
        }
    }

    public static boolean isBlockedAir(World world, int x, int y, int z, Block b, Entity ep) {
        return !b.func_149662_c() && ep instanceof EntityPlayer && ChromaDimensionManager.isStructureBiome(world.func_72807_a(x, z)) && !DimensionTuningManager.TuningThresholds.STRUCTUREBIOMES.isSufficientlyTuned((EntityPlayer)ep);
    }

    public static boolean isStructureBiome(BiomeGenBase b) {
        ChromaDimensionBiomeType type = Biomes.getFromID(b.field_76756_M);
        return type == Biomes.STRUCTURE || type == Biomes.MONUMENT;
    }

    public static boolean isDisallowedEntity(Entity e) {
        if (ModList.THAUMCRAFT.isLoaded() && ChromaDimensionManager.isThaumEvilMob(e)) {
            return true;
        }
        return ModList.ARSMAGICA.isLoaded() && e.getClass().getName().endsWith("EntityDryad");
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    private static boolean isThaumEvilMob(Entity e) {
        if (e instanceof ITaintedMob || e instanceof IEldritchMob) {
            return true;
        }
        return e instanceof IMob && e.getClass().getName().startsWith("thaumcraft.common.entities.monster");
    }

    public static interface ChromaDimensionBiomeType {
        public ChromaDimensionBiome getBiome();

        public boolean isWaterBiome();

        public boolean isReasonablyFlat();

        public int getBaseHeightDelta();

        public String name();
    }

    public static enum SubBiomes implements ChromaDimensionBiomeType
    {
        MOUNTAINS(BiomeGenChromaMountains.class, "Crystal Mountains", 0.75, 0, ExtraChromaIDs.MOUNTAIN, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MOUNTAIN),
        DEEPOCEAN(BiomeGenChromaOcean.class, "Aura Ocean", 0.4, -30, ExtraChromaIDs.OCEAN, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.OCEAN),
        CRYSFOREST(BiomeGenCrystalForest.class, "Crystal Forest", 0.2, 15, ExtraChromaIDs.CRYSFOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST),
        VOIDLANDS(BiomeGenVoidlands.class, "Voidland", 0.1, 8, ExtraChromaIDs.VOID, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.END);

        private int id;
        public final String biomeName;
        private final Class biomeClass;
        private ChromaDimensionBiome.ChromaDimensionSubBiome instance;
        private final BiomeDictionary.Type[] types;
        public final double spawnWeight;
        private ExtraChromaIDs config;
        private Biomes parent;
        public final int baseHeightDelta;
        public static final SubBiomes[] biomeList;

        private SubBiomes(Class<? extends ChromaDimensionBiome.ChromaDimensionSubBiome> c, String n2, double w, int h, ExtraChromaIDs id, BiomeDictionary.Type ... t) {
            this.biomeClass = c;
            this.types = t;
            this.config = id;
            this.spawnWeight = w;
            this.biomeName = n2;
            this.baseHeightDelta = h;
        }

        private void create(Biomes b) {
            this.parent = b;
            this.id = this.config.getValue();
            IDCollisionTracker.instance.addBiomeID((DragonAPIMod)ChromatiCraft.instance, this.id, this.biomeClass);
            IDMap.put(this.id, this);
            try {
                Constructor c = this.biomeClass.getConstructor(Integer.TYPE, String.class, SubBiomes.class);
                this.instance = (ChromaDimensionBiome.ChromaDimensionSubBiome)((Object)c.newInstance(this.id, this.biomeName, this));
            }
            catch (Exception e) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not create biome instance " + this + ": " + e.getLocalizedMessage());
            }
        }

        public Biomes getParent() {
            return this.parent;
        }

        @Override
        public ChromaDimensionBiome getBiome() {
            return this.instance;
        }

        @Override
        public boolean isWaterBiome() {
            return this.parent.isWaterBiome();
        }

        @Override
        public boolean isReasonablyFlat() {
            return this != MOUNTAINS && this != VOIDLANDS;
        }

        @Override
        public int getBaseHeightDelta() {
            return this.baseHeightDelta;
        }

        static {
            biomeList = SubBiomes.values();
        }
    }

    public static enum Biomes implements ChromaDimensionBiomeType
    {
        PLAINS(BiomeGenCrystalPlains.class, "Crystal Plains", 8, 0, ExtraChromaIDs.PLAINS, SubBiomes.MOUNTAINS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.PLAINS),
        ISLANDS(BiomeGenIslands.class, "Iridescent Archipelago", 6, -5, ExtraChromaIDs.ISLANDS, SubBiomes.DEEPOCEAN, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET),
        SKYLANDS(BiomeGenSkylands.class, "Lumen Skylands", 2, 0, ExtraChromaIDs.SKYLANDS, SubBiomes.VOIDLANDS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.COLD),
        FOREST(BiomeGenGlowingForest.class, "Glowing Forest", 10, 10, ExtraChromaIDs.FOREST, SubBiomes.CRYSFOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST),
        SPARKLE(BiomeGenSparkle.class, "Sparkling Sands", 4, 0, ExtraChromaIDs.SPARKLE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SANDY),
        GLOWCRACKS(BiomeGenGlowCracks.class, "Radiant Fissures", 3, 0, ExtraChromaIDs.GLOWCRACKS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.HOT),
        STRUCTURE(StructureBiome.class, "Structure Field", 0, 0, ExtraChromaIDs.STRUCTURE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.PLAINS),
        CENTER(BiomeGenCentral.class, "Luminescent Sanctuary", 0, 0, ExtraChromaIDs.CENTRAL, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE),
        MONUMENT(MonumentBiome.class, "Monument Field", 0, 0, ExtraChromaIDs.MONUMENT, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.PLAINS);

        private int id;
        public final String biomeName;
        private final Class biomeClass;
        private ChromaDimensionBiome instance;
        private final BiomeDictionary.Type[] types;
        public final int spawnWeight;
        private ExtraChromaIDs config;
        private final SubBiomes subBiome;
        public final int baseHeightDelta;
        public static final Biomes[] biomeList;

        private Biomes(Class<? extends ChromaDimensionBiome> c, String n2, int w, int h, ExtraChromaIDs id, BiomeDictionary.Type ... t) {
            this(c, n2, w, h, id, (SubBiomes)null, t);
        }

        private Biomes(Class<? extends ChromaDimensionBiome> c, String n2, int w, int h, ExtraChromaIDs id, SubBiomes s, BiomeDictionary.Type ... t) {
            this.biomeClass = c;
            this.types = t;
            this.config = id;
            this.spawnWeight = w;
            this.subBiome = s;
            this.biomeName = n2;
            this.baseHeightDelta = h;
        }

        private void create() {
            this.id = this.config.getValue();
            IDCollisionTracker.instance.addBiomeID((DragonAPIMod)ChromatiCraft.instance, this.id, this.biomeClass);
            IDMap.put(this.id, this);
            if (this.subBiome != null) {
                this.subBiome.create(this);
            }
            try {
                Constructor c = this.biomeClass.getConstructor(Integer.TYPE, String.class, Biomes.class);
                this.instance = (ChromaDimensionBiome)((Object)c.newInstance(this.id, this.biomeName, this));
            }
            catch (Exception e) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not create biome instance " + this + ": " + e.getLocalizedMessage());
            }
        }

        @Override
        public ChromaDimensionBiome getBiome() {
            return this.instance;
        }

        public SubBiomes getSubBiome() {
            return this.subBiome;
        }

        public boolean isTechnical() {
            return this.spawnWeight == 0;
        }

        public boolean isFarRegions() {
            switch (this) {
                case FOREST: 
                case GLOWCRACKS: 
                case ISLANDS: 
                case PLAINS: 
                case SKYLANDS: 
                case SPARKLE: {
                    return true;
                }
                case CENTER: 
                case STRUCTURE: 
                case MONUMENT: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public boolean isWaterBiome() {
            return this == ISLANDS;
        }

        @Override
        public boolean isReasonablyFlat() {
            return this != SKYLANDS && this != ISLANDS;
        }

        @Override
        public int getBaseHeightDelta() {
            return this.baseHeightDelta;
        }

        public static ChromaDimensionBiomeType getFromID(int id) {
            return (ChromaDimensionBiomeType)IDMap.get(id);
        }

        static {
            biomeList = Biomes.values();
        }
    }
}

