/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Auxiliary.MusicLoader;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.ChromaClient;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityGlowCloud;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionalAudioHandler;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.ChromatiCraft.World.Dimension.OuterRegionsEvents;
import Reika.ChromatiCraft.World.Dimension.RegionMapper;
import Reika.ChromatiCraft.World.Dimension.SkyRiverManager;
import Reika.ChromatiCraft.World.Dimension.SkyRiverManagerClient;
import Reika.DragonAPI.Auxiliary.Trackers.RemoteAssetLoader;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.IO.DirectResourceManager;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class ChromaDimensionTicker
implements TickRegistry.TickHandler {
    public static final ChromaDimensionTicker instance = new ChromaDimensionTicker();
    private final Random rand = new Random();
    public final int dimID = ExtraChromaIDs.DIMID.getValue();
    private final Collection<ForgeChunkManager.Ticket> tickets = new ArrayList<ForgeChunkManager.Ticket>();

    private ChromaDimensionTicker() {
    }

    @SideOnly(value=Side.CLIENT)
    public static ISound getCurrentMusic() {
        return ChromaDimensionalAudioHandler.currentMusic;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerMusic(RemoteAssetLoader.RemoteAssetsDownloadCompleteEvent evt) {
        Collection<String> li = MusicLoader.instance.getMusicFiles();
        ChromatiCraft.logger.log((Object)(li.size() + " music tracks available for the dimension: " + li));
        for (String path : li) {
            ChromaDimensionalAudioHandler.DimensionMusic mus = new ChromaDimensionalAudioHandler.DimensionMusic(path, path.substring(0, path.length() - 4).endsWith("_c"));
            ChromaDimensionalAudioHandler.music.add(mus);
            DirectResourceManager.getInstance().registerCustomPath(mus.path, ChromaClient.chromaCategory, true);
        }
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        switch (type) {
            case WORLD: {
                World world = (World)tickData[0];
                if (world.field_73011_w.field_76574_g != this.dimID) break;
                world.field_72990_M = Integer.MAX_VALUE;
                if (!world.field_72995_K) {
                    this.unloadChunks();
                }
                ChromaDimensionManager.tickPlayersInStructures(world);
                SkyRiverManager.tickSkyRiverServer(world);
                world.func_72891_a(false, true);
                if (world.field_73010_i.isEmpty()) break;
                ++ChromaDimensionManager.dimensionAge;
                if (world.field_72995_K) break;
                for (EntityPlayer ep : world.field_73010_i) {
                    if (!(ep.field_70163_u < 30.0) || ReikaEntityHelper.canEntitySeeTheSky((Entity)ep) || ChromaDimensionManager.getStructurePlayerIsIn(ep) != null) continue;
                    this.spawnVoidLumaFog(ep);
                }
                break;
            }
            case CLIENT: {
                this.tickClient();
                break;
            }
            case PLAYER: {
                EntityPlayer ep = (EntityPlayer)tickData[0];
                if (ep.field_70170_p.field_73011_w.field_76574_g != this.dimID || RegionMapper.isPointInCentralRegion(ep.field_70165_t, ep.field_70161_v)) break;
                OuterRegionsEvents.instance.tickPlayerInOuterRegion(ep);
                break;
            }
            case SERVER: {
                for (DimensionStructureGenerator.StructurePair sp : ChunkProviderChroma.structures) {
                    WorldServer w = DimensionManager.getWorld((int)sp.generatedDimension);
                    if (w == null || w.field_73010_i.isEmpty()) continue;
                    sp.generator.updateTick((World)w);
                }
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void tickClient() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && !world.field_73010_i.isEmpty() && world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            if (!ChromaDimensionalAudioHandler.music.isEmpty()) {
                ChromaDimensionalAudioHandler.playMusic();
            }
            SkyRiverManagerClient.handleSkyRiverMovementClient();
            for (DimensionStructureGenerator.StructurePair sp : ChunkProviderChroma.structures) {
                if (sp.generatedDimension != world.field_73011_w.field_76574_g) continue;
                sp.generator.updateTick((World)world);
            }
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            if (ChromaDimensionManager.getStructurePlayerIsIn((EntityPlayer)ep) == null) {
                int n;
                double my = 36.0;
                int n2 = n = ep.field_70163_u <= 0.0 ? 6 : 18;
                if (ep.field_70163_u <= my && ep.field_70173_aa % n == 0) {
                    float mf = 0.66f;
                    double denom = my - 8.0;
                    double num = ep.field_70163_u - 8.0;
                    float f = ep.field_70163_u <= 8.0 ? mf : mf * (float)Math.pow(1.0 - num / denom, 1.25);
                    float p = 1.0f;
                    if (ep.field_70163_u <= 0.0) {
                        f = Math.max(0.25f, (float)Math.max(0.0, 1.0 + ep.field_70163_u / 64.0));
                        f = (float)((double)f * 0.5);
                        p = (float)((double)p + ep.field_70163_u * 0.002);
                    }
                    ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.LOWAMBIENT_SHORT, (Entity)ep, (float)f, (float)p, (boolean)false);
                }
            }
        }
    }

    private void spawnVoidLumaFog(EntityPlayer ep) {
        double x = ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70165_t, (double)32.0);
        double z = ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70161_v, (double)32.0);
        double y = ReikaRandomHelper.getRandomBetween((int)-10, (int)6);
        EntityGlowCloud e = new EntityGlowCloud(ep.field_70170_p, x, y, z);
        if (e.func_70601_bi()) {
            ep.field_70170_p.func_72838_d((Entity)e);
        }
    }

    private void unloadChunks() {
        for (ForgeChunkManager.Ticket t : this.tickets) {
            for (ChunkCoordIntPair p : t.getChunkList()) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)t, (ChunkCoordIntPair)p);
            }
        }
        this.tickets.clear();
    }

    public void scheduleTicketUnload(ForgeChunkManager.Ticket t) {
        this.tickets.add(t);
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.WORLD, TickRegistry.TickType.CLIENT, TickRegistry.TickType.PLAYER);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.END;
    }

    public String getLabel() {
        return "Chroma Dimension Tag";
    }
}

