/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.BiomeDistributor;
import Reika.ChromatiCraft.World.Dimension.BiomeTerrainProvider;
import Reika.ChromatiCraft.World.Dimension.ChromaChunkManager;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.ChromatiCraft.World.Dimension.MapGen.MapGenCanyons;
import Reika.ChromatiCraft.World.Dimension.MapGen.MapGenTendrils;
import Reika.ChromatiCraft.World.Dimension.Structure.MonumentGenerator;
import Reika.ChromatiCraft.World.Dimension.ThreadedGenerators;
import Reika.ChromatiCraft.World.IWG.TieredWorldGenerator;
import Reika.DragonAPI.Instantiable.Data.BumpMap;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockGrass;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class ChunkProviderChroma
implements IChunkProvider {
    private Random rand;
    private final long overWorldSeed;
    private final long randomSeed;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorPerlin noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    private NoiseGeneratorOctaves noiseGen6;
    private NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private WorldType worldType;
    private final double[] field_147434_q;
    private final float[] parabolicField;
    private double[] stoneNoise = new double[256];
    private BiomeGenBase[] biomesForGeneration;
    private double[] noiseData3;
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData6;
    private int[][] field_73219_j = new int[32][32];
    private final MapGenCanyons canyonGen = new MapGenCanyons();
    private final MapGenTendrils caveGenerator = new MapGenTendrils();
    private final ChromaChunkManager chunkManager;
    private final BiomeTerrainProvider terrainManager;
    private final OneWayCollections.OneWayList<ChromaWorldGenerator> decorators = new OneWayCollections.OneWayList();
    public static final int VERTICAL_OFFSET = 40;
    static final HashSet<DimensionStructureGenerator.StructurePair> structures = new HashSet();
    static final MonumentGenerator monument = new MonumentGenerator();
    private static int generationFlags = 0;

    public void clearCaches(boolean doGen) {
        ChunkProviderChroma.regenerateGenerators(doGen, 0);
        ChromaDimensionManager.dimensionAge = 0;
    }

    public static synchronized void triggerGenerator(ThreadedGenerators gen) {
        ChunkProviderChroma.regenerateGenerators(true, ~gen.getBit());
    }

    public static synchronized void regenerateGenerators() {
        ChunkProviderChroma.regenerateGenerators(true, 0);
    }

    private static synchronized void regenerateGenerators(boolean doGen, int invflags) {
        long seed = ChunkProviderChroma.getOrCreateSeed();
        if (doGen) {
            generationFlags = ReikaMathLibrary.getNBitflags((int)ThreadedGenerators.generators.length) & ~invflags;
        }
        if ((invflags & ThreadedGenerators.STRUCTURE.getBit()) == 0) {
            for (DimensionStructureGenerator.StructurePair s : structures) {
                s.generator.clear();
            }
            structures.clear();
            monument.clear();
        }
        if (doGen) {
            for (int i = 0; i < ThreadedGenerators.generators.length; ++i) {
                ThreadedGenerators gen = ThreadedGenerators.generators[i];
                if ((invflags & gen.getBit()) != 0) continue;
                gen.run(seed);
            }
        }
    }

    static synchronized void finishGeneration(ThreadedGenerators gen) {
        if ((generationFlags &= ~gen.getBit()) == 0) {
            ThreadedGenerators.reset();
        }
    }

    public static boolean isGeneratorReady(ThreadedGenerators g) {
        return (generationFlags & g.getBit()) == 0;
    }

    public static boolean areGeneratorsReady() {
        return generationFlags == 0;
    }

    public static Set<DimensionStructureGenerator.StructurePair> getStructures() {
        return Collections.unmodifiableSet(structures);
    }

    public static MonumentGenerator getMonumentGenerator() {
        return monument;
    }

    public ChunkProviderChroma(World world) {
        this.worldObj = world;
        this.randomSeed = this.getOrCreateSeed();
        this.chunkManager = new ChromaChunkManager(world);
        this.worldType = WorldType.field_77137_b;
        this.overWorldSeed = world.func_72905_C();
        this.rand = new Random(this.randomSeed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 96);
        this.noiseGen4 = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147434_q = new double[825];
        this.parabolicField = new float[25];
        this.terrainManager = new BiomeTerrainProvider(this.randomSeed);
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        this.createDecorators();
    }

    private static long getOrCreateSeed() {
        if (ChromaDimensionManager.dimensionSeed >= 0L) {
            return ChromaDimensionManager.dimensionSeed;
        }
        ChromaDimensionManager.dimensionSeed = System.currentTimeMillis();
        return ChromaDimensionManager.dimensionSeed;
    }

    private void createDecorators() {
        this.decorators.addAll(DimensionGenerators.getSortedList(this.rand, this.randomSeed));
    }

    static DimensionStructureGenerator.StructurePair getNearestStructureWithinRange(int x, int z, double r) {
        double d = Double.POSITIVE_INFINITY;
        DimensionStructureGenerator.StructurePair ret = null;
        for (DimensionStructureGenerator.StructurePair s : structures) {
            ChunkCoordIntPair p = s.generator.getCentralLocation();
            double dx = x - (p.field_77276_a << 4);
            double dz = z - (p.field_77275_b << 4);
            double dd = Math.sqrt(dx * dx + dz * dz);
            if (!(dd < d) || !(dd <= r)) continue;
            d = dd;
            ret = s;
        }
        return ret;
    }

    static double getDistanceToNearestStructureBlockCoords(int x, int z) {
        return ChunkProviderChroma.getDistanceToNearestStructureBlockCoordsWithinRange(x, z, -1.0);
    }

    static double getDistanceToNearestStructureBlockCoordsWithinRange(int x, int z, double r) {
        double dx = monument.getPosX() - x;
        double dz = monument.getPosZ() - z;
        double d = Math.sqrt(dx * dx + dz * dz);
        for (DimensionStructureGenerator.StructurePair s : structures) {
            ChunkCoordIntPair p = s.generator.getCentralLocation();
            dx = x - (p.field_77276_a << 4);
            dz = z - (p.field_77275_b << 4);
            double dd = Math.sqrt(dx * dx + dz * dz);
            if (!(dd <= r)) continue;
            d = Math.min(d, dd);
        }
        return d;
    }

    static double getDistanceToNearestStructureChunkCoords(int chunkX, int chunkZ) {
        double dx = (monument.getPosX() >> 4) - chunkX;
        double dz = (monument.getPosZ() >> 4) - chunkZ;
        double d = Math.sqrt(dx * dx + dz * dz);
        for (DimensionStructureGenerator.StructurePair s : structures) {
            ChunkCoordIntPair p = s.generator.getCentralLocation();
            dx = chunkX - p.field_77276_a;
            dz = chunkZ - p.field_77275_b;
            double dd = Math.sqrt(dx * dx + dz * dz);
            d = Math.min(d, dd);
        }
        return d;
    }

    public DimensionStructureGenerator.DimensionStructureType getStructureType(CrystalElement e) {
        for (DimensionStructureGenerator.StructurePair s : structures) {
            if (s.color != e) continue;
            return s.generator.getType();
        }
        return null;
    }

    public void generateColumnData(int chunkX, int chunkZ, Block[] columnData) {
        int b0 = 63;
        this.applyNoiseLayers(chunkX * 4, chunkZ * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.field_147434_q[k1 + k2];
                    double d2 = this.field_147434_q[l1 + k2];
                    double d3 = this.field_147434_q[i2 + k2];
                    double d4 = this.field_147434_q[j2 + k2];
                    double d5 = (this.field_147434_q[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.field_147434_q[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.field_147434_q[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.field_147434_q[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int j3 = i3 + k * 4 << 12 | 0 + j1 * 4 << 8 | k2 * 8 + l2;
                            int short1 = 256;
                            j3 -= short1;
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                columnData[j3 += short1] = d > 0.0 ? Blocks.field_150348_b : (k2 * 8 + l2 < b0 ? Blocks.field_150355_j : null);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void applyRawBumpMapping(int cx, int cz, Block[] data) {
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int i;
                int d = dx * 16 + dz;
                int posIndex = d * data.length / 256;
                int x = cx * 16 + dx;
                int z = cz * 16 + dz;
                int bump = -((int)(0.25 * Math.abs(Math.tan(x % 256 * (x % 256) + z % 256 * (z % 256)))));
                if (bump == 0) continue;
                int sy = -1;
                for (int y = 255; y > 0; --y) {
                    if (data[y + posIndex] != Blocks.field_150348_b) continue;
                    sy = y;
                    break;
                }
                if (sy < 0) continue;
                if (bump > 0) {
                    for (i = 1; i <= bump; ++i) {
                        data[sy + posIndex + i] = Blocks.field_150348_b;
                    }
                    continue;
                }
                bump = -bump;
                for (i = 0; i < bump; ++i) {
                    data[sy + posIndex - i] = Blocks.field_150350_a;
                }
            }
        }
    }

    private int calculateBlendedBump(int x, int z, BumpMap bp) {
        int mx = (x % 512 + 512) % 512;
        int mz = (z % 512 + 512) % 512;
        int mxp = ((x + 1) % 512 + 512) % 512;
        int mzp = ((z + 1) % 512 + 512) % 512;
        int mxm = ((x - 1) % 512 + 512) % 512;
        int mzm = ((z - 1) % 512 + 512) % 512;
        return 127 + (bp.getBump(mx, mz) + bp.getBump(mxp, mz) + bp.getBump(mxm, mz) + bp.getBump(mx, mzp) + bp.getBump(mx, mzm)) / 5 / 16;
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, Block[] columnData, byte[] metaData, BiomeGenBase[] biomeData, int dy) {
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_151599_a(this.stoneNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int x = chunkX * 16 + dx;
                int z = chunkZ * 16 + dz;
                int d = dx * 16 + dz;
                BiomeGenBase biome = biomeData[d];
                int posIndex = d * columnData.length / 256;
                this.generateBedrockLayer(x, z, posIndex, columnData, metaData, biome);
                this.generateSandBeaches(x, z, posIndex, columnData, metaData, dy, biome);
                this.generateSurfaceGrass(x, z, posIndex, columnData, metaData, dy, biome);
            }
        }
    }

    private void generateSandBeaches(int x, int z, int posIndex, Block[] columnData, byte[] metaData, int dy, BiomeGenBase biome) {
        Block b = columnData[62 + dy + posIndex];
        Block bb = columnData[61 + dy + posIndex];
        Block ba = columnData[63 + dy + posIndex];
        if (b == Blocks.field_150348_b && ba == null && bb == Blocks.field_150348_b) {
            columnData[62 + dy + posIndex] = Blocks.field_150354_m;
        }
        for (int y = 66 + dy; y > 0; --y) {
            b = columnData[y + posIndex];
            ba = columnData[y + 1 + posIndex];
            if (b != Blocks.field_150348_b || ba != Blocks.field_150355_j) continue;
            columnData[y + posIndex] = Blocks.field_150354_m;
        }
    }

    private void generateSurfaceGrass(int x, int z, int posIndex, Block[] columnData, byte[] metaData, int dy, BiomeGenBase biome) {
        int surface = 0;
        int filler = 0;
        int maxSurface = 1;
        int maxFiller = 3 + (int)(2.0 * Math.sin((double)x / 4.0) + 3.0 * Math.sin((double)z / 16.0));
        BlockGrass surf = Blocks.field_150349_c;
        Block fill = Blocks.field_150346_d;
        for (int y = 254; y > 0; --y) {
            Block b = columnData[y + posIndex];
            Block ba = columnData[y + 1 + posIndex];
            if (b != Blocks.field_150348_b || ba != null) continue;
            if (surface < maxSurface) {
                ++surface;
                columnData[y + posIndex] = surf;
                continue;
            }
            if (filler >= maxFiller) continue;
            ++filler;
            columnData[y + posIndex] = fill;
        }
    }

    private void generateBedrockLayer(int x, int z, int posIndex, Block[] columnData, byte[] metaData, BiomeGenBase biome) {
        double sxz2;
        double sxz1;
        double sz;
        double d1 = 1.3125 + this.rand.nextDouble() * 0.1875;
        double d2 = 0.875 + this.rand.nextDouble() * 0.125;
        double d3 = 0.4375 + this.rand.nextDouble() * 0.0625;
        double d4 = 0.1875 + this.rand.nextDouble() * 0.0625;
        double sx = d1 * Math.sin(Math.toRadians((double)(x % 64) / 64.0 * 360.0));
        double maxBedrockY = 2.25 + sx + (sz = d2 * Math.cos(4.71238898038469 + Math.toRadians((double)(z % 128) / 128.0 * 360.0))) + (sxz1 = d3 * Math.sin(Math.toRadians((double)(x * z) / 8.0)) * Math.cos(Math.toRadians((double)(x * z) / 16.0))) + (sxz2 = d4 * Math.cos(Math.toRadians((double)(x * z * z) / 128.0)) * Math.sin(Math.toRadians((double)(x * x * z) / 256.0)));
        if (maxBedrockY > 0.0 || !this.canSpawnBedrockHoles(biome)) {
            columnData[posIndex] = Blocks.field_150357_h;
        }
        for (int i = 0; i < 4; ++i) {
            if (!((double)(1 + i) <= maxBedrockY) || this.rand.nextInt(4) <= 0 && this.rand.nextInt(4 - i) <= 0) continue;
            columnData[posIndex + 1 + i] = Blocks.field_150357_h;
        }
    }

    private boolean canSpawnBedrockHoles(BiomeGenBase biome) {
        return ((ChromaDimensionBiome)biome).biomeType.isFarRegions();
    }

    public Chunk func_73158_c(int x, int p_73158_2_) {
        return this.func_73154_d(x, p_73158_2_);
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        Block[] ablock = new Block[65536];
        byte[] abyte = new byte[65536];
        this.biomesForGeneration = new BiomeGenBase[256];
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int x = chunkX * 16 + dx;
                int z = chunkZ * 16 + dz;
                int i = dz * 16 + dx;
                this.biomesForGeneration[i] = BiomeDistributor.getBiome(x, z);
            }
        }
        this.generateColumnData(chunkX, chunkZ, ablock);
        ablock = this.shiftTerrainGen(ablock, 40);
        this.replaceBlocksForBiome(chunkX, chunkZ, ablock, abyte, this.biomesForGeneration, 40);
        this.runGenerators(chunkZ, chunkZ, ablock, abyte);
        Chunk chunk = new Chunk(this.worldObj, ablock, abyte, chunkX, chunkZ);
        byte[] biomeData = chunk.func_76605_m();
        for (int k = 0; k < biomeData.length; ++k) {
            biomeData[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        this.func_73153_a(null, chunkX, chunkZ);
        return chunk;
    }

    private Block[] shiftTerrainGen(Block[] ablock, int dy) {
        Block[] temp = new Block[ablock.length];
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int j;
                int d = dx * 16 + dz;
                int posIndex = d * ablock.length / 256;
                for (j = 255 - dy; j >= 0; --j) {
                    temp[posIndex + j + dy] = ablock[posIndex + j];
                }
                for (j = 0; j < dy; ++j) {
                    temp[posIndex + j] = Blocks.field_150348_b;
                }
            }
        }
        return temp;
    }

    private void runGenerators(int chunkX, int chunkZ, Block[] ablock, byte[] abyte) {
    }

    private void applyNoiseLayers(int chunkX, int chunkZ) {
        double d0 = 684.412;
        double d1 = 684.412;
        double d2 = 512.0;
        double d3 = 512.0;
        this.noiseData6 = this.noiseGen6.func_76305_a(this.noiseData6, chunkX, chunkZ, 5, 5, 200.0, 200.0, 0.5);
        this.noiseData3 = this.noiseGen3.func_76304_a(this.noiseData3, chunkX, 0, chunkZ, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.noiseData1 = this.noiseGen1.func_76304_a(this.noiseData1, chunkX, 0, chunkZ, 5, 33, 5, 684.412, 684.412, 684.412);
        this.noiseData2 = this.noiseGen2.func_76304_a(this.noiseData2, chunkX, 0, chunkZ, 5, 33, 5, 684.412, 684.412, 684.412);
        boolean flag1 = false;
        boolean flag = false;
        int idx = 0;
        int i1 = 0;
        double d4 = 8.5;
        for (int j1 = 0; j1 < 5; ++j1) {
            for (int k1 = 0; k1 < 5; ++k1) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int b0 = 2;
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        float f0 = (float)Math.sqrt((double)(chunkX * chunkX + chunkZ * chunkZ) / 2097152.0);
                        f0 = (float)((double)f0 * 0.03125);
                        double dd = ChunkProviderChroma.getDistanceToNearestStructureChunkCoords(chunkX, chunkZ);
                        if (dd <= 8.0) {
                            f0 = (float)((double)f0 * (dd / 8.0));
                        }
                        float f3 = Math.max(-0.25f, 0.125f - f0 * 0.125f);
                        float f4 = 0.5f * f0;
                        double offset = 0.0;
                        if (offset > 0.0) {
                            f4 = (float)((double)f4 * (1.0 + offset));
                        }
                        float f5 = this.parabolicField[l1 + 2 + (i2 + 2) * 5] / (f3 + 2.0f);
                        f += f4 * f5;
                        f1 += f3 * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = (f1 * 4.0f - 1.0f) / 8.0f;
                double d12 = this.noiseData6[i1] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++i1;
                double d13 = f1;
                double d14 = f;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.noiseData1[idx] / 512.0;
                    double d8 = this.noiseData2[idx] / 512.0;
                    double d9 = (this.noiseData3[idx] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.field_147434_q[idx] = d10;
                    ++idx;
                }
            }
        }
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    public void func_73153_a(IChunkProvider loader, int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int k = chunkX * 16;
        int l = chunkZ * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(k + 16, l + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.worldObj.func_72905_C());
        BlockFalling.field_149832_M = false;
    }

    private void runDecorators(int x, int z) {
        for (ChromaWorldGenerator wg : this.decorators) {
            int n;
            ChromaDimensionBiome b = BiomeDistributor.getBiome(x, z);
            if (!wg.type.generateIn(b)) continue;
            float f = wg.getGenerationChance(this.worldObj, x, z, b);
            if (ReikaRandomHelper.doWithChance((double)(f - (float)(n = (int)f)))) {
                ++n;
            }
            for (int i = 0; i < n; ++i) {
                int dx = x + this.rand.nextInt(16) + 8;
                int dz = z + this.rand.nextInt(16) + 8;
                int y = this.worldObj.func_72825_h(dx, dz);
                wg.func_76484_a(this.worldObj, this.rand, dx, y, dz);
            }
        }
    }

    public void onPopulationHook(IChunkProvider gen, IChunkProvider loader, int x, int z) {
        this.terrainManager.generateChunk(this.worldObj, x, z, this.rand);
        this.runDecorators(x * 16, z * 16);
        this.generateExtraChromaOre(this.worldObj, gen, loader, x, z);
        ChunkCoordIntPair cp = new ChunkCoordIntPair(x, z);
        for (DimensionStructureGenerator.StructurePair s : structures) {
            s.generatedDimension = this.worldObj.field_73011_w.field_76574_g;
            s.generator.generateChunk(this.worldObj, cp);
        }
        monument.generateChunk(this.worldObj, cp);
    }

    private void generateExtraChromaOre(World world, IChunkProvider gen, IChunkProvider loader, int x, int z) {
        for (int i = 0; i < 6; ++i) {
            if (i < 3) {
                TieredWorldGenerator.instance.skipPlants = true;
            }
            TieredWorldGenerator.instance.generate(this.rand, x, z, world, gen, loader);
        }
    }

    public boolean func_73157_c() {
        return false;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate ips) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType type, int x, int y, int z) {
        return this.worldObj.func_72807_a(x, z).func_76747_a(type);
    }

    public ChunkPosition func_147416_a(World world, String type, int x, int y, int z) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
    }
}

