/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenAurorae;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenChromaMeteor;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenChunkloaderBlocks;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenCrystalPit;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenCrystalShrub;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenCrystalTree;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenFireJet;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenFissure;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenFloatstone;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenGlassCliffs;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenGlowCave;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenGlowingCracks;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenIslandArch;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenLightedShrub;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenLightedTree;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenMiasma;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenMiniAltar;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenMoonPool;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenTerrainBlob;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenTerrainCrystal;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenTreeCluster;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;

public enum DimensionGenerators {
    RIFT(WorldGenFissure.class, GeneratorType.TERRAIN, GeneratorTheme.ENERGY, Integer.MIN_VALUE),
    METEOR(WorldGenChromaMeteor.class, GeneratorType.FEATURE, GeneratorTheme.GEOHISTORICAL, Integer.MIN_VALUE),
    GEODE(WorldGenCrystalPit.class, GeneratorType.FEATURE, GeneratorTheme.CRYSTAL, -100),
    JETS(WorldGenFireJet.class, GeneratorType.TERRAIN, GeneratorTheme.ENERGY, 0),
    FLOATSTONE(WorldGenFloatstone.class, GeneratorType.TERRAIN, GeneratorTheme.SKYFEATURE, 100),
    MIASMA(WorldGenMiasma.class, GeneratorType.FEATURE, GeneratorTheme.SKYFEATURE, 0),
    TREES(WorldGenLightedTree.class, GeneratorType.FEATURE, GeneratorTheme.FOLIAGE, -50),
    FORESTS(WorldGenTreeCluster.class, GeneratorType.FEATURE, GeneratorTheme.FOLIAGE, -50),
    MOONPOOL(WorldGenMoonPool.class, GeneratorType.STRUCTURE, GeneratorTheme.OCEANIC, 0),
    TERRAINCRYSTAL(WorldGenTerrainCrystal.class, GeneratorType.TERRAIN, GeneratorTheme.SKYFEATURE, Integer.MAX_VALUE),
    ALTAR(WorldGenMiniAltar.class, GeneratorType.STRUCTURE, GeneratorTheme.PRECURSORS, -500),
    CRYSTALTREE(WorldGenCrystalTree.class, GeneratorType.FEATURE, GeneratorTheme.CRYSTAL, -100),
    GLOWBUSH(WorldGenLightedShrub.class, GeneratorType.FEATURE, GeneratorTheme.FOLIAGE, 500),
    CRYSBUSH(WorldGenCrystalShrub.class, GeneratorType.FEATURE, GeneratorTheme.FOLIAGE, 500),
    AURORA(WorldGenAurorae.class, GeneratorType.FEATURE, GeneratorTheme.SKYFEATURE, Integer.MAX_VALUE),
    ARCH(WorldGenIslandArch.class, GeneratorType.TERRAIN, GeneratorTheme.OCEANIC, Integer.MIN_VALUE),
    BLOBS(WorldGenTerrainBlob.class, GeneratorType.TERRAIN, GeneratorTheme.OCEANIC, Integer.MIN_VALUE),
    GLASSCLIFFS(WorldGenGlassCliffs.class, GeneratorType.FEATURE, GeneratorTheme.GEOHISTORICAL, Integer.MIN_VALUE),
    CRACKS(WorldGenGlowingCracks.class, GeneratorType.FEATURE, GeneratorTheme.ENERGY, Integer.MAX_VALUE),
    CHUNKLOADER(WorldGenChunkloaderBlocks.class, GeneratorType.FEATURE, GeneratorTheme.PRECURSORS, Integer.MAX_VALUE),
    GLOWCAVE(WorldGenGlowCave.class, GeneratorType.TERRAIN, GeneratorTheme.GEOHISTORICAL, Integer.MIN_VALUE);

    private final Class genClass;
    public final GeneratorType type;
    public final GeneratorTheme theme;
    public final int genTime;
    private ChromaWorldGenerator generator;
    public static final DimensionGenerators[] generators;
    private static final Comparator<DimensionGenerators> generationSorter;

    private DimensionGenerators(Class<? extends ChromaWorldGenerator> c, GeneratorType t, GeneratorTheme h, int p) {
        this.genClass = c;
        this.type = t;
        this.theme = h;
        this.genTime = p;
    }

    public ChromaWorldGenerator getGenerator(Random rand, long seed) {
        if (this.generator == null) {
            try {
                Constructor c = this.genClass.getConstructor(DimensionGenerators.class, Random.class, Long.TYPE);
                this.generator = (ChromaWorldGenerator)((Object)c.newInstance(new Object[]{this, rand, seed}));
            }
            catch (Exception e) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not create generator for dimension generator " + (Object)((Object)this), (Throwable)e);
            }
        }
        return this.generator;
    }

    public boolean generateIn(ChromaDimensionBiome b) {
        if (this == CHUNKLOADER) {
            return b.biomeType == ChromaDimensionManager.Biomes.STRUCTURE || b.biomeType == ChromaDimensionManager.Biomes.MONUMENT;
        }
        if (b.biomeType == ChromaDimensionManager.Biomes.STRUCTURE || b.biomeType == ChromaDimensionManager.Biomes.MONUMENT) {
            return ReikaRandomHelper.doWithChance((double)25.0) && this.generateIn(ChromaDimensionManager.Biomes.CENTER.getBiome()) && this.canGenerateInStructureBiome();
        }
        if (b.biomeType == ChromaDimensionManager.Biomes.CENTER) {
            return !this.isDedicatedBiomeOnly();
        }
        if (this.theme == GeneratorTheme.SKYFEATURE) {
            return b.biomeType == ChromaDimensionManager.Biomes.SKYLANDS;
        }
        if (this == FORESTS) {
            return b.biomeType == ChromaDimensionManager.Biomes.FOREST;
        }
        if (this == TREES || this == GLOWBUSH) {
            return b.biomeType == ChromaDimensionManager.Biomes.FOREST || b.biomeType == ChromaDimensionManager.Biomes.PLAINS || b.getExactType() == ChromaDimensionManager.Biomes.ISLANDS || b.biomeType == ChromaDimensionManager.Biomes.SPARKLE || b.biomeType == ChromaDimensionManager.Biomes.GLOWCRACKS;
        }
        switch (this) {
            case ALTAR: {
                return b.getExactType().isReasonablyFlat();
            }
            case CRYSBUSH: 
            case CRYSTALTREE: {
                return b == ChromaDimensionManager.SubBiomes.CRYSFOREST.getBiome();
            }
            case GEODE: {
                return b == ChromaDimensionManager.Biomes.PLAINS.getBiome();
            }
            case JETS: {
                return true;
            }
            case METEOR: {
                return !b.getExactType().isWaterBiome() && b.getExactType().isReasonablyFlat() && b.biomeType != ChromaDimensionManager.Biomes.GLOWCRACKS;
            }
            case MIASMA: {
                return b.biomeType == ChromaDimensionManager.Biomes.PLAINS;
            }
            case MOONPOOL: {
                return b.biomeType == ChromaDimensionManager.Biomes.ISLANDS;
            }
            case RIFT: {
                return b == ChromaDimensionManager.Biomes.PLAINS.getBiome() || b.biomeType == ChromaDimensionManager.Biomes.GLOWCRACKS;
            }
            case ARCH: {
                return b == ChromaDimensionManager.Biomes.ISLANDS.getBiome();
            }
            case BLOBS: {
                return b == ChromaDimensionManager.SubBiomes.DEEPOCEAN.getBiome();
            }
            case GLASSCLIFFS: {
                return b == ChromaDimensionManager.Biomes.PLAINS.getBiome();
            }
            case CRACKS: {
                return b.getExactType().isReasonablyFlat() && !b.getExactType().isWaterBiome();
            }
            case GLOWCAVE: {
                return b.biomeType == ChromaDimensionManager.Biomes.CENTER || b.biomeType == ChromaDimensionManager.Biomes.FOREST || b.getExactType() == ChromaDimensionManager.Biomes.PLAINS;
            }
        }
        return true;
    }

    private boolean canGenerateInStructureBiome() {
        return true;
    }

    private boolean isDedicatedBiomeOnly() {
        switch (this) {
            case CRYSBUSH: 
            case CRYSTALTREE: 
            case METEOR: 
            case MIASMA: 
            case MOONPOOL: 
            case ARCH: 
            case BLOBS: 
            case GLASSCLIFFS: 
            case AURORA: 
            case TERRAINCRYSTAL: 
            case GLOWBUSH: {
                return true;
            }
        }
        return false;
    }

    public static ArrayList<ChromaWorldGenerator> getSortedList(Random rand, long seed) {
        ArrayList<ChromaWorldGenerator> ret = new ArrayList<ChromaWorldGenerator>();
        ArrayList<DimensionGenerators> li = new ArrayList<DimensionGenerators>();
        for (int i = 0; i < generators.length; ++i) {
            DimensionGenerators gen = generators[i];
            li.add(gen);
        }
        Collections.sort(li, generationSorter);
        for (DimensionGenerators g : li) {
            ret.add(g.getGenerator(rand, seed));
        }
        return ret;
    }

    static {
        generators = DimensionGenerators.values();
        generationSorter = new GeneratorSorter();
    }

    private static class GeneratorSorter
    implements Comparator<DimensionGenerators> {
        private GeneratorSorter() {
        }

        @Override
        public int compare(DimensionGenerators o1, DimensionGenerators o2) {
            return Integer.compare(o1.genTime, o2.genTime);
        }
    }

    public static enum GeneratorTheme {
        SKYFEATURE,
        CRYSTAL,
        PRECURSORS,
        ENERGY,
        FOLIAGE,
        GEOHISTORICAL,
        OCEANIC;

    }

    public static enum GeneratorType {
        TERRAIN,
        STRUCTURE,
        FEATURE;

    }
}

