/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Auxiliary.ChromaTeleporter;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.World.Dimension.CheatingPreventionSystem;
import Reika.ChromatiCraft.World.Dimension.SkyRiverManager;
import Reika.ChromatiCraft.World.Dimension.StructureCalculator;
import Reika.DragonAPI.Auxiliary.Trackers.PlayerHandler;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class DimensionJoinHandler
implements PlayerHandler.PlayerTracker {
    public static final DimensionJoinHandler instance = new DimensionJoinHandler();

    private DimensionJoinHandler() {
    }

    public void onPlayerLogin(EntityPlayer ep) {
        this.clearAreaForPlayer(ep);
        SkyRiverManager.startSendingRiverPackets(ep);
        if (ep instanceof EntityPlayerMP) {
            StructureCalculator.sendSeed(ep);
        }
    }

    public void onPlayerLogout(EntityPlayer player) {
    }

    public void onPlayerChangedDimension(EntityPlayer player, int dimFrom, int dimTo) {
        if (dimTo == ExtraChromaIDs.DIMID.getValue()) {
            if (!ProgressStage.DIMENSION.playerHasPrerequisites(player)) {
                this.rejectPlayer(player);
            } else {
                CheatingPreventionSystem.instance.postJoin(player);
            }
        }
    }

    private void rejectPlayer(EntityPlayer player) {
        ReikaEntityHelper.transferEntityToDimension((Entity)player, (int)0, (Teleporter)new ChromaTeleporter(0));
        ChunkCoordinates cc = player.field_70170_p.func_72861_E();
        player.func_70634_a((double)cc.field_71574_a + 0.5, (double)cc.field_71572_b + 1.62, (double)cc.field_71573_c + 0.5);
        player.func_70097_a(DamageSource.field_76376_m, 1.0f);
        ReikaChatHelper.sendChatToPlayer((EntityPlayer)player, (String)"You do not understand the world's magic forces to safely venture here yet.");
    }

    public void onPlayerRespawn(EntityPlayer player) {
        this.clearAreaForPlayer(player);
    }

    private void clearAreaForPlayer(EntityPlayer ep) {
        if (ep.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            double r = 5.0;
            double rh = 3.5;
            int x = MathHelper.func_76128_c((double)ep.field_70165_t);
            int y = MathHelper.func_76128_c((double)ep.field_70163_u);
            int z = MathHelper.func_76128_c((double)ep.field_70161_v);
            for (double i = -r; i <= r; i += 1.0) {
                for (double j = -rh; j <= rh; j += 1.0) {
                    for (double k = -r; k <= r; k += 1.0) {
                        int dx = MathHelper.func_76128_c((double)((double)x + i));
                        int dy = MathHelper.func_76128_c((double)((double)y + j));
                        int dz = MathHelper.func_76128_c((double)((double)z + k));
                        if (!ReikaMathLibrary.isPointInsideEllipse((double)i, (double)j, (double)k, (double)r, (double)rh, (double)r) || !this.clear(ep.field_70170_p, dx, dy, dz)) continue;
                        if (ReikaMathLibrary.isPointInsideEllipse((double)i, (double)j, (double)k, (double)(r - 1.0), (double)(rh - 1.0), (double)(r - 1.0))) {
                            ep.field_70170_p.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                            continue;
                        }
                        ep.field_70170_p.func_147465_d(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata % 8, 3);
                    }
                }
            }
        }
    }

    private boolean clear(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (b instanceof BlockLiquid || b instanceof BlockFluidBase) {
            return false;
        }
        if (b instanceof BlockLeavesBase || b instanceof BlockLog) {
            return false;
        }
        if (b.func_149688_o() == Material.field_151585_k) {
            return false;
        }
        if (b.field_149782_v < 0.0f) {
            return false;
        }
        if (b instanceof SemiUnbreakable) {
            return !((SemiUnbreakable)b).isUnbreakable(world, x, y, z, world.func_72805_g(x, y, z));
        }
        return world.func_147438_o(x, y, z) == null;
    }
}

